/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.workflow;

import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetAppropriatePayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetAppropriateVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetAppropriateDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/BUDGET_APPROPRIATE/callBack"})
@Transactional
public class PmsBudgetAppropriateCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetAppropriateCallBackController.class);
    private final PmsBudgetAppropriateDAO pmsBudgetAppropriateDAO;
    private final PmsBudgetService pmsBudgetService;
    private final PmsBudgetDAO pmsBudgetDAO;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsBudgetAppropriatePayload appropriatePayload = new PmsBudgetAppropriatePayload();
        appropriatePayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        PmsBudgetAppropriateVO vo = this.pmsBudgetAppropriateDAO.queryByKey(Long.valueOf(businessKey));
        if (vo != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    appropriatePayload.setAppropriationStatus(ProjectStatusEnum.CREATE.getCode());
                    appropriatePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    appropriatePayload.setAppropriationStatus(ProjectStatusEnum.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    appropriatePayload.setAppropriationStatus(ProjectStatusEnum.TERMINATED.getCode());
                    appropriatePayload.setDeleteFlag(Integer.valueOf(1));
                    appropriatePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    appropriatePayload.setAppropriationStatus(ProjectStatusEnum.APPROVING_EJECTED.getCode());
                    appropriatePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    appropriatePayload.setAppropriationStatus(ProjectStatusEnum.APPROVED.getCode());
                    appropriatePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    appropriatePayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
            }
            this.pmsBudgetService.appropriateCallBack(vo, procInstStatus);
            PmsBudgetVO budgetVO = this.pmsBudgetDAO.queryByProjectId(vo.getProjectId());
            appropriatePayload.setAppropriationProportion(budgetVO.getAppropriationProportion());
            appropriatePayload.setTotalMoney(budgetVO.getTotalMoney());
            appropriatePayload.setUsedMoney(budgetVO.getUsedMoney());
            appropriatePayload.setPaidMoney(budgetVO.getPaidMoney());
            this.pmsBudgetAppropriateDAO.updateWorkFlow(appropriatePayload);
        }
    }

    public PmsBudgetAppropriateCallBackController(PmsBudgetAppropriateDAO pmsBudgetAppropriateDAO, PmsBudgetService pmsBudgetService, PmsBudgetDAO pmsBudgetDAO) {
        this.pmsBudgetAppropriateDAO = pmsBudgetAppropriateDAO;
        this.pmsBudgetService = pmsBudgetService;
        this.pmsBudgetDAO = pmsBudgetDAO;
    }
}

