/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectStakeholdersService;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PMS_PROJECT_CHANGE/callBack"})
@Transactional
public class PmsProjectChangeCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectChangeCallBackController.class);
    private final ComChangeService changeService;
    private final PmsProjectService pmsProjectService;
    private final PmsProjectStakeholdersService projectStakeholdersService;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsProjectPayload PmsProjectPayload2 = new PmsProjectPayload();
        PmsProjectPayload2.setId(Long.valueOf(Long.parseLong(businessKey)));
        ComChangeVO comChangeVO = this.changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            PmsProjectPayload projectPayload = new PmsProjectPayload();
            projectPayload.setId(Long.valueOf(comChangeVO.getChangeDocId()));
            projectPayload.setProjectStatus(ProjectStatusEnum.APPROVED.getCode());
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    projectPayload = (PmsProjectPayload)JSON.parseObject((String)comChangeVO.getChangeContent(), PmsProjectPayload.class);
                    projectPayload.setProjectStatus(ProjectStatusEnum.APPROVED.getCode());
                    projectPayload.setApprovedTime(LocalDateTime.now());
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    this.projectStakeholdersService.changeProjectLeader(projectPayload);
                    this.pmsProjectService.updateProject(projectPayload);
                    break;
                }
            }
            this.changeService.updateWorkFlow(changePayload);
        }
    }

    public PmsProjectChangeCallBackController(ComChangeService changeService, PmsProjectService pmsProjectService, PmsProjectStakeholdersService projectStakeholdersService) {
        this.changeService = changeService;
        this.pmsProjectService = pmsProjectService;
        this.projectStakeholdersService = projectStakeholdersService;
    }
}

