/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerExportVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerIdentityVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerTreeVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/crm/businessPartner"})
public class BusinessPartnerController {
    private static final Logger log = LoggerFactory.getLogger(BusinessPartnerController.class);
    private final BusinessPartnerService businessPartnerService;
    private final UdcUtil udcUtil;

    @PostMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u65b0\u589e")
    public TwOutputUtil<BusinessPartnerVO> insert(@RequestBody BusinessPartnerPayload payload) {
        return TwOutputUtil.ok((Object)this.businessPartnerService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u66f4\u65b0")
    public TwOutputUtil<BusinessPartnerVO> update(@RequestBody BusinessPartnerPayload payload) {
        return TwOutputUtil.ok((Object)this.businessPartnerService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<BusinessPartnerVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.businessPartnerService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5206\u9875")
    public TwOutputUtil<PagingVO<BusinessPartnerVO>> paging(BusinessPartnerQuery query) {
        return TwOutputUtil.ok((Object)this.businessPartnerService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<BusinessPartnerVO>> queryList(BusinessPartnerQuery query) {
        return TwOutputUtil.ok((Object)this.businessPartnerService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.businessPartnerService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/listSimple"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u67e5\u8be2\u6bcd\u516c\u53f8\u4e0b\u62c9\u5217\u8868")
    public TwOutputUtil<List<BusinessPartnerSimpleVO>> queryListSimple() {
        return TwOutputUtil.ok((Object)this.businessPartnerService.queryListSimple());
    }

    @GetMapping(value={"/judgePartnerName"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u4e1a\u52a1\u4f19\u4f34\u540d\u79f0\u91cd\u590d\u6027\u6821\u9a8c")
    public TwOutputUtil judgePartnerName(BusinessPartnerQuery query) {
        this.businessPartnerService.judgePartnerName(query.getPartnerName());
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/excelExport"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5bfc\u51fa")
    public void excelExport(BusinessPartnerQuery query, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sheetName = "\u4e1a\u52a1\u4f19\u4f34";
        List vos = query.getIds() != null && query.getIds().size() > 0 ? this.businessPartnerService.queryListByIds(query.getIds()) : this.businessPartnerService.queryListDynamic(query);
        List resultList = BusinessPartnerConvert.INSTANCE.voListVoExcelExport(vos);
        resultList = this.udcUtil.translateList(resultList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), BusinessPartnerExportVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper((ExcelWriterSheetBuilder)sheet, BusinessPartnerExportVO.class, null);
        sheet.doWrite(resultList);
    }

    @GetMapping(value={"/judgeIdentityDisplay"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5224\u65ad\u8eab\u4efd\u90e8\u5206\u6807\u7b7e\u662f\u5426\u5c55\u793a")
    public TwOutputUtil<BusinessPartnerIdentityVO> judgeIdentityDisplay(@RequestParam(name="partnerId") String partnerId) {
        return TwOutputUtil.ok((Object)this.businessPartnerService.judgeIdentityDisplay(Long.valueOf(partnerId)));
    }

    @GetMapping(value={"/listTree"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u7ec4\u7ec7\u6811")
    public TwOutputUtil<List<BusinessPartnerTreeVO>> listTree(BusinessPartnerQuery query) {
        return TwOutputUtil.ok((Object)this.businessPartnerService.listTree(query));
    }

    public BusinessPartnerController(BusinessPartnerService businessPartnerService, UdcUtil udcUtil) {
        this.businessPartnerService = businessPartnerService;
        this.udcUtil = udcUtil;
    }
}

