/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessModelIndexPayload;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessModelIndexSettingPayload;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessStrategyModelPayload;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessStrategyModelQuery;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessModelIndexService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessModelIndexSettingService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyModelService;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessModelIndexSettingVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyModelVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.partner.strategy.convert.BusinessStrategyModelConvert;
import com.elitesland.tw.tw5.server.partner.strategy.dao.BusinessStrategyModelDAO;
import com.elitesland.tw.tw5.server.partner.strategy.entity.BusinessStrategyModelDO;
import com.elitesland.tw.tw5.server.partner.strategy.repo.BusinessStrategyModelRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessModelDateEnum;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessSelectionEnum;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessStrategyIndexEnum;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessStrategyStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BusinessStrategyModelServiceImpl
extends BaseServiceImpl
implements BusinessStrategyModelService {
    private static final Logger log = LoggerFactory.getLogger(BusinessStrategyModelServiceImpl.class);
    private final BusinessStrategyModelRepo businessStrategyModelRepo;
    private final BusinessStrategyModelDAO businessStrategyModelDAO;
    private final BusinessModelIndexService businessModelIndexService;
    private final BusinessModelIndexSettingService businessModelIndexSettingService;
    private final CacheUtil cacheUtil;

    public PagingVO<BusinessStrategyModelVO> queryPaging(BusinessStrategyModelQuery query) {
        return this.businessStrategyModelDAO.queryPaging(query);
    }

    public List<BusinessStrategyModelVO> queryListDynamic(BusinessStrategyModelQuery query) {
        return this.businessStrategyModelDAO.queryListDynamic(query);
    }

    public BusinessStrategyModelVO queryByKey(Long key) {
        BusinessStrategyModelDO entity = this.businessStrategyModelRepo.findById(key).orElseGet(BusinessStrategyModelDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyModelVO vo = BusinessStrategyModelConvert.INSTANCE.toVo(entity);
        if (vo.getStandaryFlag().booleanValue()) {
            return vo;
        }
        BusinessModelIndexQuery businessModelIndexQuery = new BusinessModelIndexQuery();
        businessModelIndexQuery.setModelId(vo.getId());
        List businessModelIndexVOS = this.businessModelIndexService.queryListDynamic(businessModelIndexQuery);
        BusinessModelIndexSettingQuery businessModelIndexSettingQuery = new BusinessModelIndexSettingQuery();
        businessModelIndexVOS.stream().forEach(businessModelIndexVO -> {
            businessModelIndexSettingQuery.setIndexId(businessModelIndexVO.getId());
            businessModelIndexVO.setBusinessModelIndexSettingVOList(this.businessModelIndexSettingService.queryListDynamic(businessModelIndexSettingQuery));
        });
        vo.setBusinessModelIndexVOList(businessModelIndexVOS);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessStrategyModelVO save(BusinessStrategyModelPayload payload) {
        BusinessStrategyModelVO businessStrategyModelVO;
        if (payload.getId() != null) {
            Long modelId = payload.getId();
            businessStrategyModelVO = this.update(payload);
            if (payload.getStandaryFlag().booleanValue()) {
                if (businessStrategyModelVO.getStandaryModifyFlag().booleanValue()) {
                    this.businessModelIndexService.deleteSoftByModelId(modelId);
                    this.businessModelIndexSettingService.deleteSoftByModelId(modelId);
                }
                return businessStrategyModelVO;
            }
            if (!CollectionUtils.isEmpty((Collection)payload.getBusinessModelIndexPayloadList())) {
                Long indexId = 0L;
                this.businessModelIndexService.deleteSoftByModelId(payload.getId());
                ArrayList<BusinessModelIndexVO> businessModelIndexVOList = new ArrayList<BusinessModelIndexVO>();
                for (BusinessModelIndexPayload businessModelIndexPayload : payload.getBusinessModelIndexPayloadList()) {
                    businessModelIndexPayload.setModelId(modelId);
                    BusinessModelIndexVO businessModelIndexVO = this.businessModelIndexService.insert(businessModelIndexPayload);
                    String indexName = businessModelIndexVO.getModelIndexName();
                    String sourceField = businessModelIndexVO.getSourceField();
                    indexId = businessModelIndexVO.getId();
                    if (!CollectionUtils.isEmpty((Collection)businessModelIndexPayload.getBusinessModelIndexSettingPayloadList())) {
                        ArrayList<BusinessModelIndexSettingVO> businessIndexSettingVOList = new ArrayList<BusinessModelIndexSettingVO>();
                        this.businessModelIndexSettingService.deleteSoftByModelIndexId(indexId);
                        for (BusinessModelIndexSettingPayload businessModelIndexSettingPayload : businessModelIndexPayload.getBusinessModelIndexSettingPayloadList()) {
                            if (businessModelIndexSettingPayload.getOptionScore() == null) {
                                throw TwException.error((String)"", (String)("\u6307\u6807\u540d\u79f0\u4e3a:" + indexName + "\u7684\u5206\u6570\u672a\u7f16\u8f91"));
                            }
                            businessModelIndexSettingPayload.setModelId(modelId);
                            businessModelIndexSettingPayload.setIndexId(indexId);
                            businessModelIndexSettingPayload.setIndexName(indexName);
                            businessModelIndexSettingPayload.setSourceFiled(sourceField);
                            BusinessModelIndexSettingVO businessIndexSettingVO = this.businessModelIndexSettingService.insert(businessModelIndexSettingPayload);
                            businessIndexSettingVOList.add(businessIndexSettingVO);
                        }
                        businessModelIndexVO.setBusinessModelIndexSettingVOList(businessIndexSettingVOList);
                    }
                    businessModelIndexVOList.add(businessModelIndexVO);
                }
                businessStrategyModelVO.setBusinessModelIndexVOList(businessModelIndexVOList);
            }
        } else {
            BusinessStrategyModelDO entityDo = BusinessStrategyModelConvert.INSTANCE.toDo(payload);
            businessStrategyModelVO = BusinessStrategyModelConvert.INSTANCE.toVo((BusinessStrategyModelDO)this.businessStrategyModelRepo.save(entityDo));
            if (businessStrategyModelVO.getStandaryFlag().booleanValue()) {
                return businessStrategyModelVO;
            }
            Long modelId = businessStrategyModelVO.getId();
            if (!CollectionUtils.isEmpty((Collection)payload.getBusinessModelIndexPayloadList())) {
                Long indexId = 0L;
                ArrayList<BusinessModelIndexVO> businessModelIndexVOList = new ArrayList<BusinessModelIndexVO>();
                for (BusinessModelIndexPayload businessModelIndexPayload : payload.getBusinessModelIndexPayloadList()) {
                    businessModelIndexPayload.setModelId(modelId);
                    BusinessModelIndexVO businessModelIndexVO = this.businessModelIndexService.insert(businessModelIndexPayload);
                    indexId = businessModelIndexVO.getId();
                    String indexName = businessModelIndexVO.getModelIndexName();
                    String sourceField = businessModelIndexVO.getSourceField();
                    if (!CollectionUtils.isEmpty((Collection)businessModelIndexPayload.getBusinessModelIndexSettingPayloadList())) {
                        ArrayList<BusinessModelIndexSettingVO> businessIndexSettingVOList = new ArrayList<BusinessModelIndexSettingVO>();
                        for (BusinessModelIndexSettingPayload businessModelIndexSettingPayload : businessModelIndexPayload.getBusinessModelIndexSettingPayloadList()) {
                            if (businessModelIndexSettingPayload.getOptionScore() == null) {
                                throw TwException.error((String)"", (String)("\u6307\u6807\u540d\u79f0\u4e3a:" + indexName + "\u7684\u5206\u6570\u672a\u7f16\u8f91"));
                            }
                            businessModelIndexSettingPayload.setModelId(modelId);
                            businessModelIndexSettingPayload.setIndexId(indexId);
                            businessModelIndexSettingPayload.setIndexName(indexName);
                            businessModelIndexSettingPayload.setSourceFiled(sourceField);
                            BusinessModelIndexSettingVO businessIndexSettingVO = this.businessModelIndexSettingService.insert(businessModelIndexSettingPayload);
                            businessIndexSettingVOList.add(businessIndexSettingVO);
                        }
                        businessModelIndexVO.setBusinessModelIndexSettingVOList(businessIndexSettingVOList);
                    }
                    businessModelIndexVOList.add(businessModelIndexVO);
                }
                businessStrategyModelVO.setBusinessModelIndexVOList(businessModelIndexVOList);
            }
        }
        return businessStrategyModelVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessStrategyModelVO update(BusinessStrategyModelPayload payload) {
        BusinessStrategyModelDO entity = this.businessStrategyModelRepo.findById(payload.getId()).orElseGet(BusinessStrategyModelDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyModelDO entityDo = BusinessStrategyModelConvert.INSTANCE.toDo(payload);
        Boolean standaryModify = false;
        if (!entity.getStandaryFlag().equals(payload.getStandaryFlag())) {
            standaryModify = true;
        }
        entity.copy(entityDo);
        BusinessStrategyModelVO businessStrategyModelVO = BusinessStrategyModelConvert.INSTANCE.toVo((BusinessStrategyModelDO)this.businessStrategyModelRepo.save(entity));
        businessStrategyModelVO.setStandaryModifyFlag(standaryModify);
        return businessStrategyModelVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessStrategyModelPayload payload) {
        BusinessStrategyModelDO entity = this.businessStrategyModelRepo.findById(payload.getId()).orElseGet(BusinessStrategyModelDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessStrategyModelDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            Long count = this.queryStrategyByModelIdsAndStrategyStatus(keys, BusinessStrategyStatusEnum.OPEN.getCode());
            if (count > 0L) {
                throw TwException.error((String)"", (String)"\u6a21\u578b\u5df2\u88ab\u7b56\u7565\u5173\u8054\u4e14\u542f\u7528\uff0c\u4e0d\u53ef\u5220\u9664");
            }
            keys.stream().forEach(id -> {
                Optional optional = this.businessStrategyModelRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessStrategyModelDO entity = (BusinessStrategyModelDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessStrategyModelRepo.save(entity);
                }
            });
        }
    }

    public List<BusinessModelIndexVO> findRfmSettingByDate(String dateKey) {
        if (BusinessModelDateEnum.YEAR.getCode().equals(dateKey)) {
            return this.getData(BusinessSelectionEnum.YEAR_MONTH.getCode(), BusinessSelectionEnum.YEAR_FREQUENCY.getCode(), BusinessSelectionEnum.YEAR_AMOUNT.getCode());
        }
        return this.getData(BusinessSelectionEnum.HALFYEAR_MONTH.getCode(), BusinessSelectionEnum.HALFYEAR_FREQUENCY.getCode(), BusinessSelectionEnum.HALFYEAR_AMOUNT.getCode());
    }

    public List<BusinessModelIndexVO> getData(String monthKey, String frequencyKey, String amountKey) {
        ArrayList<BusinessModelIndexVO> businessModelIndexVOList = new ArrayList<BusinessModelIndexVO>();
        PrdSystemSelectionVO monthSelection = this.cacheUtil.getSystemSelection(monthKey);
        PrdSystemSelectionVO frequencySelection = this.cacheUtil.getSystemSelection(frequencyKey);
        PrdSystemSelectionVO amountSelection = this.cacheUtil.getSystemSelection(amountKey);
        List monthChildren = monthSelection.getChildren();
        List frequencyChildren = frequencySelection.getChildren();
        List amountChildren = amountSelection.getChildren();
        ArrayList monthIndexSettingVOList = new ArrayList();
        ArrayList frequencyIndexSettingVOList = new ArrayList();
        ArrayList amountIndexSettingVOList = new ArrayList();
        BusinessModelIndexVO monthModelIndexVO = new BusinessModelIndexVO();
        monthModelIndexVO.setModelIndexName(BusinessStrategyIndexEnum.R.getCode());
        monthModelIndexVO.setWeight(BigDecimal.ZERO);
        monthModelIndexVO.setSourceField(BusinessStrategyIndexEnum.R.getCode());
        monthChildren.stream().forEach(children -> {
            BusinessModelIndexSettingVO businessModelIndexSettingVO = new BusinessModelIndexSettingVO();
            businessModelIndexSettingVO.setIndexName(BusinessStrategyIndexEnum.R.getCode());
            businessModelIndexSettingVO.setSourceFiled(BusinessStrategyIndexEnum.R.getCode());
            businessModelIndexSettingVO.setSourceFiledOption(children.getSelectionValue());
            businessModelIndexSettingVO.setSourceFiledOptionDesc(children.getSelectionName());
            businessModelIndexSettingVO.setOptionScore(new BigDecimal(children.getExtString1()));
            businessModelIndexSettingVO.setExt2(children.getExtString2());
            businessModelIndexSettingVO.setExt3(children.getExtString3());
            monthIndexSettingVOList.add(businessModelIndexSettingVO);
        });
        monthModelIndexVO.setBusinessModelIndexSettingVOList(monthIndexSettingVOList);
        BusinessModelIndexVO frequencyModelIndexVO = new BusinessModelIndexVO();
        frequencyModelIndexVO.setModelIndexName(BusinessStrategyIndexEnum.F.getCode());
        frequencyModelIndexVO.setWeight(BigDecimal.ZERO);
        frequencyModelIndexVO.setSourceField(BusinessStrategyIndexEnum.F.getCode());
        frequencyChildren.stream().forEach(children -> {
            BusinessModelIndexSettingVO businessModelIndexSettingVO = new BusinessModelIndexSettingVO();
            businessModelIndexSettingVO.setIndexName(BusinessStrategyIndexEnum.F.getCode());
            businessModelIndexSettingVO.setSourceFiled(BusinessStrategyIndexEnum.F.getCode());
            businessModelIndexSettingVO.setSourceFiledOption(children.getSelectionValue());
            businessModelIndexSettingVO.setSourceFiledOptionDesc(children.getSelectionName());
            businessModelIndexSettingVO.setOptionScore(new BigDecimal(children.getExtString1()));
            businessModelIndexSettingVO.setExt2(children.getExtString2());
            businessModelIndexSettingVO.setExt3(children.getExtString3());
            frequencyIndexSettingVOList.add(businessModelIndexSettingVO);
        });
        frequencyModelIndexVO.setBusinessModelIndexSettingVOList(frequencyIndexSettingVOList);
        BusinessModelIndexVO amountModelIndexVO = new BusinessModelIndexVO();
        amountModelIndexVO.setModelIndexName(BusinessStrategyIndexEnum.M.getCode());
        amountModelIndexVO.setWeight(BigDecimal.ZERO);
        amountModelIndexVO.setSourceField(BusinessStrategyIndexEnum.M.getCode());
        amountChildren.stream().forEach(children -> {
            BusinessModelIndexSettingVO businessModelIndexSettingVO = new BusinessModelIndexSettingVO();
            businessModelIndexSettingVO.setIndexName(BusinessStrategyIndexEnum.M.getCode());
            businessModelIndexSettingVO.setSourceFiled(BusinessStrategyIndexEnum.M.getCode());
            businessModelIndexSettingVO.setSourceFiledOption(children.getSelectionValue());
            businessModelIndexSettingVO.setSourceFiledOptionDesc(children.getSelectionName());
            businessModelIndexSettingVO.setOptionScore(new BigDecimal(children.getExtString1()));
            businessModelIndexSettingVO.setExt2(children.getExtString2());
            businessModelIndexSettingVO.setExt3(children.getExtString3());
            amountIndexSettingVOList.add(businessModelIndexSettingVO);
        });
        amountModelIndexVO.setBusinessModelIndexSettingVOList(amountIndexSettingVOList);
        businessModelIndexVOList.add(monthModelIndexVO);
        businessModelIndexVOList.add(frequencyModelIndexVO);
        businessModelIndexVOList.add(amountModelIndexVO);
        return businessModelIndexVOList;
    }

    public Long queryStrategyByModelIdsAndStrategyStatus(List<Long> modelIdList, String strategyStatus) {
        return this.businessStrategyModelDAO.queryStrategyByModelIdsAndStrategyStatus(modelIdList, strategyStatus);
    }

    public Boolean checkAssociationStrategy(Long modelId) {
        Boolean checkFlag = false;
        ArrayList<Long> modelIdList = new ArrayList<Long>();
        modelIdList.add(modelId);
        Long count = this.queryStrategyByModelIdsAndStrategyStatus(modelIdList, BusinessStrategyStatusEnum.OPEN.getCode());
        if (count > 0L) {
            checkFlag = true;
        }
        return checkFlag;
    }

    public BusinessStrategyModelServiceImpl(BusinessStrategyModelRepo businessStrategyModelRepo, BusinessStrategyModelDAO businessStrategyModelDAO, BusinessModelIndexService businessModelIndexService, BusinessModelIndexSettingService businessModelIndexSettingService, CacheUtil cacheUtil) {
        this.businessStrategyModelRepo = businessStrategyModelRepo;
        this.businessStrategyModelDAO = businessStrategyModelDAO;
        this.businessModelIndexService = businessModelIndexService;
        this.businessModelIndexSettingService = businessModelIndexSettingService;
        this.cacheUtil = cacheUtil;
    }
}

