/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityAnalyzePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityAnalyzeService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityAnalyzeVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmOpportunityAnalyzeController {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityAnalyzeController.class);
    private final CrmOpportunityAnalyzeService service;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.account.operation}")
    private String account_operation;
    @Value(value="${tw4.account.del}")
    private String account_del;

    @PostMapping(value={"/oppo/analyze/insert"})
    public TwOutputUtil insert(CrmOpportunityAnalyzePayload payload) {
        CrmOpportunityAnalyzeVO vo = this.service.insert(payload);
        return TwOutputUtil.ok((Object)vo);
    }

    @PutMapping(value={"/oppo/analyze/update"})
    public TwOutputUtil update(CrmOpportunityAnalyzePayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/analyze/updateFromV4"})
    public TwOutputUtil updateFromV4(CrmOpportunityAnalyzePayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/analyze/queryList"})
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok((Object)this.service.queryList(oppoId));
    }

    @DeleteMapping(value={"/oppo/analyze/deleteSoft"})
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        this.service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public CrmOpportunityAnalyzeController(CrmOpportunityAnalyzeService service, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil) {
        this.service = service;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
    }
}

