/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedoc.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.server.common.util.JwtUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.dto.CreateFolderDTO;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class YeedocServiceImpl
implements YeedocService {
    private static final Logger log = LoggerFactory.getLogger(YeedocServiceImpl.class);
    private final ApiRequestLogService apiRequestLogService;
    private final YeedocProperties yeedocProperties;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    @Override
    public String createFolder(Map<String, Object> map) {
        String token = this.getToken();
        String externalToken = this.base64Encrypt(token);
        String createFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/createfoldernew?ExternalSource=" + this.yeedocProperties.getExternalSource() + "&ExternalToken=" + externalToken;
        log.debug("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-createFolderUrl:{}", (Object)createFolderUrl);
        return this.executePost(createFolderUrl, map);
    }

    @Override
    public String createFolder(CreateFolderDTO createFolderDTO) {
        String token = this.getToken();
        String externalToken = this.base64Encrypt(token);
        String createFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/createfoldernew?ExternalSource=" + this.yeedocProperties.getExternalSource() + "&ExternalToken=" + externalToken;
        log.debug("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-createFolderUrl:{}", (Object)createFolderUrl);
        return this.executePost(createFolderUrl, createFolderDTO);
    }

    @Override
    public String setPermission(String itemId, Integer permissionLevel) {
        String token = this.getToken();
        String externalToken = this.base64Encrypt(token);
        String setPermissionUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/setpermissionobject?ExternalSource=" + this.yeedocProperties.getExternalSource() + "&ExternalToken=" + externalToken + "&itemid=" + itemId + "&permissionlevel=" + permissionLevel;
        log.debug("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-setPermissionUrl:{}", (Object)setPermissionUrl);
        return this.executePost(setPermissionUrl, new HashMap<String, Object>());
    }

    @Override
    public String preViewItem(String itemId) {
        String token = this.getToken();
        String externalToken = this.base64Encrypt(token);
        String preViewItemUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/previewitem/" + itemId + "?ExternalSource=" + this.yeedocProperties.getExternalSource() + "&ExternalToken=" + externalToken;
        log.debug("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-preViewItemUrl:{}", (Object)preViewItemUrl);
        return this.executePost(preViewItemUrl, new HashMap<String, Object>(3));
    }

    @Override
    public String deleteItem(String itemId) {
        String token = this.getToken();
        String externalToken = this.base64Encrypt(token);
        String deleteItemUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/deletesingleitem/" + itemId + "?ExternalSource=" + this.yeedocProperties.getExternalSource() + "&ExternalToken=" + externalToken;
        log.debug("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-deleteItemUrl:{}", (Object)deleteItemUrl);
        return this.executePost(deleteItemUrl, new HashMap<String, Object>(3));
    }

    @Override
    public String getYeedocJwt(SysUserDTO loginUser) {
        String sercretKey = this.yeedocProperties.getSercretKey();
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("LoginName", loginUser.getUsername());
        userInfoMap.put("UserName", loginUser.getUsername());
        userInfoMap.put("UserMail", loginUser.getEmail());
        payloadMap.put("jwt", JSONUtil.toJsonStr(userInfoMap));
        payloadMap.put("exp", (String)DateUtil.offsetDay((Date)new Date(), (int)30));
        String token = JwtUtil.getToken(null, payloadMap, (String)sercretKey);
        return token;
    }

    private String getToken() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.prdOrgEmployeeDAO.queryByUserId(userId);
        Assert.notNull((Object)prdOrgEmployeeDO, (String)"\u5458\u5de5\u4fe1\u606f\u672a\u7ef4\u62a4", (Object[])new Object[0]);
        return prdOrgEmployeeDO.getPcLoginTicket();
    }

    private String base64Encrypt(String value) {
        String s = null;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        byte[] b = value.getBytes(StandardCharsets.UTF_8);
        if (b != null) {
            s = Base64.getEncoder().encodeToString(b);
        }
        return s;
    }

    private String executePost(String url, Map<String, Object> map) {
        String result;
        String param = JSONObject.toJSONString(map);
        String status = "200";
        long start = System.currentTimeMillis();
        try {
            result = ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, Long.valueOf(time));
        return result;
    }

    private String executePost(String url, Object object) {
        String result;
        String param = JSONObject.toJSONString((Object)object);
        String status = "200";
        long start = System.currentTimeMillis();
        try {
            result = ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, Long.valueOf(time));
        return result;
    }

    public YeedocServiceImpl(ApiRequestLogService apiRequestLogService, YeedocProperties yeedocProperties, PrdOrgEmployeeDAO prdOrgEmployeeDAO) {
        this.apiRequestLogService = apiRequestLogService;
        this.yeedocProperties = yeedocProperties;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
    }
}

