/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.team.entity.QBusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5crm.api.bid.payload.BidPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidQuery;
import com.elitesland.tw.tw5crm.api.bid.vo.BidVO;
import com.elitesland.tw.tw5crm.server.bid.entity.BidDO;
import com.elitesland.tw.tw5crm.server.bid.entity.QBidDO;
import com.elitesland.tw.tw5crm.server.bid.repo.BidRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BidDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BidRepo repo;
    private final CacheUtil cacheUtil;
    private final QBidDO qdo = QBidDO.bidDO;
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qPrjProjectDO = QPrjProjectDO.prjProjectDO;
    private final QBusinessTeamMemberDO qTeamMemberDO = QBusinessTeamMemberDO.businessTeamMemberDO;

    private JPAQuery<BidVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BidVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.bidProjectCode, this.qdo.opportunityId, this.qPrjProjectDO.projectName.as("opportunityName"), this.qCrmOpportunityDO.custBookName, this.qdo.bidProjectName, this.qdo.bidProjectProfile, this.qdo.customerContact, this.qdo.customerContactPhone, this.qdo.agency, this.qdo.proxyContact, this.qdo.proxyContactPhone, this.qdo.entryDeadline, this.qdo.earnestMoneyDeadline, this.qdo.bidDeadline, this.qdo.bidLocation, this.qdo.bidOpeningDate, this.qdo.bidOpeningLocation, this.qdo.rfpFee, this.qdo.bidSecurity, this.qdo.inviteBidFile, this.qdo.bidSchedule, this.qdo.bidUnit, this.qdo.bidAmount, this.qdo.bidderId, this.qdo.bidResult, this.qdo.reasonLoseBid, this.qdo.bidWinningAmount, this.qdo.bidWiningNotificationFile, this.qdo.bidStatus, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.submitTime, this.qdo.approvedTime})).from((EntityPath)this.qdo)).distinct()).leftJoin((EntityPath)this.qCrmOpportunityDO)).on((Predicate)this.qCrmOpportunityDO.id.longValue().eq(this.qdo.opportunityId))).leftJoin((EntityPath)this.qPrjProjectDO)).on((Predicate)this.qPrjProjectDO.id.longValue().eq(this.qCrmOpportunityDO.projectId))).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
    }

    private JPAQuery<BidVO> getJpaQueryWhere(BidQuery query) {
        JPAQuery<BidVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(BidQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)this.qdo.id.countDistinct()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmOpportunityDO)).on((Predicate)this.qCrmOpportunityDO.id.longValue().eq(this.qdo.opportunityId))).leftJoin((EntityPath)this.qPrjProjectDO)).on((Predicate)this.qPrjProjectDO.id.longValue().eq(this.qCrmOpportunityDO.projectId))).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where(this.where(query));
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue()) {
            ((JPAQuery)((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qTeamMemberDO)).on((Predicate)this.qTeamMemberDO.objectId.longValue().eq(this.qdo.id))).where((Predicate)this.qTeamMemberDO.userId.eq((Object)loginUserId).and((Predicate)this.qTeamMemberDO.deleteFlag.eq((Object)0)));
        }
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BidQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidProjectCode())) {
            list.add(this.qdo.bidProjectCode.like(SqlUtil.toSqlLikeString((String)query.getBidProjectCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOpportunityId())) {
            list.add(this.qdo.opportunityId.eq((Object)query.getOpportunityId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOpportunityName())) {
            list.add(this.qPrjProjectDO.projectName.like(SqlUtil.toSqlLikeString((String)query.getOpportunityName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidProjectName())) {
            list.add(this.qdo.bidProjectName.like(SqlUtil.toSqlLikeString((String)query.getBidProjectName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidProjectProfile())) {
            list.add(this.qdo.bidProjectProfile.like(SqlUtil.toSqlLikeString((String)query.getBidProjectProfile())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerContact())) {
            list.add(this.qdo.customerContact.like(SqlUtil.toSqlLikeString((String)query.getCustomerContact())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerContactPhone())) {
            list.add(this.qdo.customerContactPhone.like(SqlUtil.toSqlLikeString((String)query.getCustomerContactPhone())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAgency())) {
            list.add(this.qdo.agency.like(SqlUtil.toSqlLikeString((String)query.getAgency())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProxyContact())) {
            list.add(this.qdo.proxyContact.like(SqlUtil.toSqlLikeString((String)query.getProxyContact())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProxyContactPhone())) {
            list.add(this.qdo.proxyContactPhone.like(SqlUtil.toSqlLikeString((String)query.getProxyContactPhone())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEntryDeadline())) {
            list.add(this.qdo.entryDeadline.eq((Object)query.getEntryDeadline()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEarnestMoneyDeadline())) {
            list.add(this.qdo.earnestMoneyDeadline.eq((Object)query.getEarnestMoneyDeadline()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidDeadline())) {
            list.add(this.qdo.bidDeadline.eq((Object)query.getBidDeadline()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidLocation())) {
            list.add(this.qdo.bidLocation.eq((Object)query.getBidLocation()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidOpeningDate())) {
            list.add(this.qdo.bidOpeningDate.eq((Object)query.getBidOpeningDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidOpeningLocation())) {
            list.add(this.qdo.bidOpeningLocation.eq((Object)query.getBidOpeningLocation()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRfpFee())) {
            list.add(this.qdo.rfpFee.eq((Object)query.getRfpFee()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidSecurity())) {
            list.add(this.qdo.bidSecurity.eq((Object)query.getBidSecurity()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInviteBidFile())) {
            list.add(this.qdo.inviteBidFile.eq((Object)query.getInviteBidFile()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidSchedule())) {
            list.add(this.qdo.bidSchedule.eq((Object)query.getBidSchedule()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidUnit())) {
            list.add(this.qdo.bidUnit.eq((Object)query.getBidUnit()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidAmount())) {
            list.add(this.qdo.bidAmount.eq((Object)query.getBidAmount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidderId())) {
            list.add(this.qdo.bidderId.eq((Object)query.getBidderId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidResult())) {
            list.add(this.qdo.bidResult.eq((Object)query.getBidResult()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonLoseBid())) {
            list.add(this.qdo.reasonLoseBid.eq((Object)query.getReasonLoseBid()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidWinningAmount())) {
            list.add(this.qdo.bidWinningAmount.eq((Object)query.getBidWinningAmount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidWiningNotificationFile())) {
            list.add(this.qdo.bidWiningNotificationFile.eq((Object)query.getBidWiningNotificationFile()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidStatus())) {
            list.add(this.qdo.bidStatus.eq((Object)query.getBidStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstId())) {
            list.add(this.qdo.procInstId.eq((Object)query.getProcInstId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstStatus())) {
            list.add(this.qdo.procInstStatus.eq((Object)query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubmitTime())) {
            list.add(this.qdo.submitTime.eq((Object)query.getSubmitTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprovedTime())) {
            list.add(this.qdo.approvedTime.eq((Object)query.getApprovedTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustBookName())) {
            list.add(this.qCrmOpportunityDO.custBookName.like(SqlUtil.toSqlLikeString((String)query.getCustBookName())));
        }
        return ExpressionUtils.allOf(list);
    }

    public BidVO queryByKey(Long id) {
        JPAQuery<BidVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BidVO)jpaQuery.fetchFirst();
    }

    public List<BidVO> queryListDynamic(BidQuery query) {
        JPAQuery<BidVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BidVO> queryPaging(BidQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BidVO> jpaQuery = this.getJpaQueryWhere(query);
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue()) {
            ((JPAQuery)((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qTeamMemberDO)).on((Predicate)this.qTeamMemberDO.objectId.longValue().eq(this.qdo.id))).where((Predicate)this.qTeamMemberDO.userId.eq((Object)loginUserId).and((Predicate)this.qTeamMemberDO.deleteFlag.eq((Object)0)));
        }
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BidDO save(BidDO ado) {
        return (BidDO)this.repo.save(ado);
    }

    public List<BidDO> saveAll(List<BidDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BidPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBidProjectCode() != null) {
            update.set((Path)this.qdo.bidProjectCode, (Object)payload.getBidProjectCode());
        }
        if (payload.getOpportunityId() != null) {
            update.set(this.qdo.opportunityId, (Object)payload.getOpportunityId());
        }
        if (payload.getBidProjectName() != null) {
            update.set((Path)this.qdo.bidProjectName, (Object)payload.getBidProjectName());
        }
        if (payload.getBidProjectProfile() != null) {
            update.set((Path)this.qdo.bidProjectProfile, (Object)payload.getBidProjectProfile());
        }
        if (payload.getCustomerContact() != null) {
            update.set((Path)this.qdo.customerContact, (Object)payload.getCustomerContact());
        }
        if (payload.getCustomerContactPhone() != null) {
            update.set((Path)this.qdo.customerContactPhone, (Object)payload.getCustomerContactPhone());
        }
        if (payload.getAgency() != null) {
            update.set((Path)this.qdo.agency, (Object)payload.getAgency());
        }
        if (payload.getProxyContact() != null) {
            update.set((Path)this.qdo.proxyContact, (Object)payload.getProxyContact());
        }
        if (payload.getProxyContactPhone() != null) {
            update.set((Path)this.qdo.proxyContactPhone, (Object)payload.getProxyContactPhone());
        }
        if (payload.getEntryDeadline() != null) {
            update.set(this.qdo.entryDeadline, (Object)payload.getEntryDeadline());
        }
        if (payload.getEarnestMoneyDeadline() != null) {
            update.set(this.qdo.earnestMoneyDeadline, (Object)payload.getEarnestMoneyDeadline());
        }
        if (payload.getBidDeadline() != null) {
            update.set(this.qdo.bidDeadline, (Object)payload.getBidDeadline());
        }
        if (payload.getBidLocation() != null) {
            update.set((Path)this.qdo.bidLocation, (Object)payload.getBidLocation());
        }
        if (payload.getBidOpeningDate() != null) {
            update.set(this.qdo.bidOpeningDate, (Object)payload.getBidOpeningDate());
        }
        if (payload.getBidOpeningLocation() != null) {
            update.set((Path)this.qdo.bidOpeningLocation, (Object)payload.getBidOpeningLocation());
        }
        if (payload.getRfpFee() != null) {
            update.set(this.qdo.rfpFee, (Object)payload.getRfpFee());
        }
        if (payload.getBidSecurity() != null) {
            update.set(this.qdo.bidSecurity, (Object)payload.getBidSecurity());
        }
        if (payload.getInviteBidFile() != null) {
            update.set((Path)this.qdo.inviteBidFile, (Object)payload.getInviteBidFile());
        }
        if (payload.getBidSchedule() != null) {
            update.set((Path)this.qdo.bidSchedule, (Object)payload.getBidSchedule());
        }
        if (payload.getBidUnit() != null) {
            update.set((Path)this.qdo.bidUnit, (Object)payload.getBidUnit());
        }
        if (payload.getBidAmount() != null) {
            update.set(this.qdo.bidAmount, (Object)payload.getBidAmount());
        }
        if (payload.getBidderId() != null) {
            update.set(this.qdo.bidderId, (Object)payload.getBidderId());
        }
        if (payload.getBidResult() != null) {
            update.set((Path)this.qdo.bidResult, (Object)payload.getBidResult());
        }
        if (payload.getReasonLoseBid() != null) {
            update.set((Path)this.qdo.reasonLoseBid, (Object)payload.getReasonLoseBid());
        }
        if (payload.getBidWinningAmount() != null) {
            update.set(this.qdo.bidWinningAmount, (Object)payload.getBidWinningAmount());
        }
        if (payload.getBidWiningNotificationFile() != null) {
            update.set((Path)this.qdo.bidWiningNotificationFile, (Object)payload.getBidWiningNotificationFile());
        }
        if (payload.getBidStatus() != null) {
            update.set((Path)this.qdo.bidStatus, (Object)payload.getBidStatus());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set((Path)this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bidProjectCode")) {
                update.setNull((Path)this.qdo.bidProjectCode);
            }
            if (nullFields.contains("opportunityId")) {
                update.setNull(this.qdo.opportunityId);
            }
            if (nullFields.contains("bidProjectName")) {
                update.setNull((Path)this.qdo.bidProjectName);
            }
            if (nullFields.contains("bidProjectProfile")) {
                update.setNull((Path)this.qdo.bidProjectProfile);
            }
            if (nullFields.contains("customerContact")) {
                update.setNull((Path)this.qdo.customerContact);
            }
            if (nullFields.contains("customerContactPhone")) {
                update.setNull((Path)this.qdo.customerContactPhone);
            }
            if (nullFields.contains("agency")) {
                update.setNull((Path)this.qdo.agency);
            }
            if (nullFields.contains("proxyContact")) {
                update.setNull((Path)this.qdo.proxyContact);
            }
            if (nullFields.contains("proxyContactPhone")) {
                update.setNull((Path)this.qdo.proxyContactPhone);
            }
            if (nullFields.contains("entryDeadline")) {
                update.setNull(this.qdo.entryDeadline);
            }
            if (nullFields.contains("earnestMoneyDeadline")) {
                update.setNull(this.qdo.earnestMoneyDeadline);
            }
            if (nullFields.contains("bidDeadline")) {
                update.setNull(this.qdo.bidDeadline);
            }
            if (nullFields.contains("bidLocation")) {
                update.setNull((Path)this.qdo.bidLocation);
            }
            if (nullFields.contains("bidOpeningDate")) {
                update.setNull(this.qdo.bidOpeningDate);
            }
            if (nullFields.contains("bidOpeningLocation")) {
                update.setNull((Path)this.qdo.bidOpeningLocation);
            }
            if (nullFields.contains("rfpFee")) {
                update.setNull(this.qdo.rfpFee);
            }
            if (nullFields.contains("bidSecurity")) {
                update.setNull(this.qdo.bidSecurity);
            }
            if (nullFields.contains("inviteBidFile")) {
                update.setNull((Path)this.qdo.inviteBidFile);
            }
            if (nullFields.contains("bidSchedule")) {
                update.setNull((Path)this.qdo.bidSchedule);
            }
            if (nullFields.contains("bidUnit")) {
                update.setNull((Path)this.qdo.bidUnit);
            }
            if (nullFields.contains("bidAmount")) {
                update.setNull(this.qdo.bidAmount);
            }
            if (nullFields.contains("bidderId")) {
                update.setNull(this.qdo.bidderId);
            }
            if (nullFields.contains("bidResult")) {
                update.setNull((Path)this.qdo.bidResult);
            }
            if (nullFields.contains("reasonLoseBid")) {
                update.setNull((Path)this.qdo.reasonLoseBid);
            }
            if (nullFields.contains("bidWinningAmount")) {
                update.setNull(this.qdo.bidWinningAmount);
            }
            if (nullFields.contains("bidWiningNotificationFile")) {
                update.setNull((Path)this.qdo.bidWiningNotificationFile);
            }
            if (nullFields.contains("bidStatus")) {
                update.setNull((Path)this.qdo.bidStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull((Path)this.qdo.procInstStatus);
            }
            if (nullFields.contains("submitTime")) {
                update.setNull(this.qdo.submitTime);
            }
            if (nullFields.contains("approvedTime")) {
                update.setNull(this.qdo.approvedTime);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateBidStatus(Long key, String bidStatus, String bidResult) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.bidStatus, (Object)bidStatus).set((Path)this.qdo.bidResult, (Object)bidResult).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public BidVO queryByOppoKey(Long oppoKey) {
        JPAQuery<BidVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.opportunityId.longValue().eq((Object)oppoKey));
        return (BidVO)jpaQuery.fetchFirst();
    }

    public BidDAO(JPAQueryFactory jpaQueryFactory, BidRepo repo, CacheUtil cacheUtil) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.cacheUtil = cacheUtil;
    }
}

