/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.bid.payload.BidReviewRecordsPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidReviewRecordsQuery;
import com.elitesland.tw.tw5crm.api.bid.vo.BidReviewRecordsVO;
import com.elitesland.tw.tw5crm.server.bid.entity.BidReviewRecordsDO;
import com.elitesland.tw.tw5crm.server.bid.entity.QBidDO;
import com.elitesland.tw.tw5crm.server.bid.entity.QBidReviewRecordsDO;
import com.elitesland.tw.tw5crm.server.bid.repo.BidReviewRecordsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BidReviewRecordsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BidReviewRecordsRepo repo;
    private final QBidReviewRecordsDO qdo = QBidReviewRecordsDO.bidReviewRecordsDO;
    private final QBidDO qBidDO = QBidDO.bidDO;

    private JPAQuery<BidReviewRecordsVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BidReviewRecordsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bidId, this.qdo.version, this.qdo.reviewType, this.qdo.bidFile, this.qdo.reviewerId, this.qdo.reviewResult, this.qdo.reviewPropose, this.qdo.submitterId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBidDO)).on((Predicate)this.qBidDO.id.longValue().eq(this.qdo.bidId));
    }

    private JPAQuery<BidReviewRecordsVO> getJpaQueryWhere(BidReviewRecordsQuery query) {
        JPAQuery<BidReviewRecordsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(BidReviewRecordsQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BidReviewRecordsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidId())) {
            list.add(this.qdo.bidId.eq((Object)query.getBidId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVersion())) {
            list.add(this.qdo.version.eq((Object)query.getVersion()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReviewType())) {
            list.add(this.qdo.reviewType.eq((Object)query.getReviewType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidFile())) {
            list.add(this.qdo.bidFile.eq((Object)query.getBidFile()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReviewerId())) {
            list.add(this.qdo.reviewerId.eq((Object)query.getReviewerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReviewResult())) {
            list.add(this.qdo.reviewResult.eq((Object)query.getReviewResult()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReviewPropose())) {
            list.add(this.qdo.reviewPropose.eq((Object)query.getReviewPropose()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubmitterId())) {
            list.add(this.qdo.submitterId.eq((Object)query.getSubmitterId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BidReviewRecordsVO queryByKey(Long id) {
        JPAQuery<BidReviewRecordsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BidReviewRecordsVO)jpaQuery.fetchFirst();
    }

    public List<BidReviewRecordsVO> queryListDynamic(BidReviewRecordsQuery query) {
        JPAQuery<BidReviewRecordsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BidReviewRecordsVO> queryPaging(BidReviewRecordsQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BidReviewRecordsVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BidReviewRecordsDO save(BidReviewRecordsDO ado) {
        return (BidReviewRecordsDO)this.repo.save(ado);
    }

    public List<BidReviewRecordsDO> saveAll(List<BidReviewRecordsDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BidReviewRecordsPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBidId() != null) {
            update.set(this.qdo.bidId, (Object)payload.getBidId());
        }
        if (payload.getVersion() != null) {
            update.set((Path)this.qdo.version, (Object)payload.getVersion());
        }
        if (payload.getReviewType() != null) {
            update.set((Path)this.qdo.reviewType, (Object)payload.getReviewType());
        }
        if (payload.getBidFile() != null) {
            update.set((Path)this.qdo.bidFile, (Object)payload.getBidFile());
        }
        if (payload.getReviewerId() != null) {
            update.set(this.qdo.reviewerId, (Object)payload.getReviewerId());
        }
        if (payload.getReviewResult() != null) {
            update.set((Path)this.qdo.reviewResult, (Object)payload.getReviewResult());
        }
        if (payload.getReviewPropose() != null) {
            update.set((Path)this.qdo.reviewPropose, (Object)payload.getReviewPropose());
        }
        if (payload.getSubmitterId() != null) {
            update.set(this.qdo.submitterId, (Object)payload.getSubmitterId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bidId")) {
                update.setNull(this.qdo.bidId);
            }
            if (nullFields.contains("version")) {
                update.setNull((Path)this.qdo.version);
            }
            if (nullFields.contains("reviewType")) {
                update.setNull((Path)this.qdo.reviewType);
            }
            if (nullFields.contains("bidFile")) {
                update.setNull((Path)this.qdo.bidFile);
            }
            if (nullFields.contains("reviewerId")) {
                update.setNull(this.qdo.reviewerId);
            }
            if (nullFields.contains("reviewResult")) {
                update.setNull((Path)this.qdo.reviewResult);
            }
            if (nullFields.contains("reviewPropose")) {
                update.setNull((Path)this.qdo.reviewPropose);
            }
            if (nullFields.contains("submitterId")) {
                update.setNull(this.qdo.submitterId);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BidReviewRecordsVO> queryReviewRecordsByBidKey(Long bidKey) {
        JPAQuery<BidReviewRecordsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qBidDO.id.longValue().eq((Object)bidKey));
        return jpaQuery.fetch();
    }

    public BidReviewRecordsDAO(JPAQueryFactory jpaQueryFactory, BidReviewRecordsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

