/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.workflow;

import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractPayload;
import com.elitesland.tw.tw5crm.server.common.constants.ContractCollectionPlanStatus;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractCollectionPlanDAO;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.QContractDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/CONTRACT/callBack"})
@Transactional
public class ContractWorkflowController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(ContractWorkflowController.class);
    private final ContractDAO contractDAO;
    private final ContractCollectionPlanDAO contractCollectionPlanDAO;
    private final JPAQueryFactory jpaQueryFactory;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ContractPayload updatePayload = new ContractPayload();
        long id = Long.parseLong(businessKey);
        updatePayload.setId(Long.valueOf(id));
        QContractDO qContractDO = QContractDO.contractDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qContractDO).set(qContractDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qContractDO.id.eq((Object)id)});
        boolean deleteFlag = false;
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)qContractDO.contractStatus, (Object)WorkFlowStatusEnum.CREATE_WORK.getCode());
                updatePayload.setContractStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                updatePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qContractDO.contractStatus, (Object)WorkFlowStatusEnum.CREATE_WORK.getCode());
                updatePayload.setContractStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qContractDO.contractStatus, (Object)WorkFlowStatusEnum.INVALID.getCode());
                updatePayload.setContractStatus(WorkFlowStatusEnum.INVALID.getCode());
                updatePayload.setProcInstStatus(ProcInstStatus.INVALID);
                deleteFlag = true;
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qContractDO.contractStatus, (Object)WorkFlowStatusEnum.CREATE_WORK.getCode());
                updatePayload.setContractStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                updatePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                break;
            }
            case APPROVING: {
                updatePayload.setContractStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                jpaUpdateClause.set((Path)qContractDO.contractStatus, (Object)WorkFlowStatusEnum.APPROVING_WORK.getCode());
                break;
            }
            case APPROVED: {
                updatePayload.setContractStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                jpaUpdateClause.set((Path)qContractDO.contractStatus, (Object)WorkFlowStatusEnum.APPROVED_WORK.getCode());
                updatePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                updatePayload.setApprovedTime(LocalDateTime.now());
                this.contractCollectionPlanDAO.updateStatusByContractId(ContractCollectionPlanStatus.ACTIVE.getCode(), id);
            }
        }
        jpaUpdateClause.execute();
        if (deleteFlag) {
            this.contractDAO.deleteSoft(Arrays.asList(id));
        }
    }

    public ContractWorkflowController(ContractDAO contractDAO, ContractCollectionPlanDAO contractCollectionPlanDAO, JPAQueryFactory jpaQueryFactory) {
        this.contractDAO = contractDAO;
        this.contractCollectionPlanDAO = contractCollectionPlanDAO;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

