/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.partner.business.payload.BusinessCustomerOperationPlanDetailMemberListPayload;
import com.elitesland.tw.tw5crm.api.partner.business.payload.BusinessCustomerOperationPlanDetailMemberPayload;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationPlanDetailMemberQuery;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationPlanDetailMemberService;
import com.elitesland.tw.tw5crm.api.partner.business.vo.BusinessCustomerOperationPlanDetailMemberVO;
import com.elitesland.tw.tw5crm.server.partner.business.convert.BusinessCustomerOperationPlanDetailMemberConvert;
import com.elitesland.tw.tw5crm.server.partner.business.dao.BusinessCustomerOperationPlanDetailMemberDAO;
import com.elitesland.tw.tw5crm.server.partner.business.entity.BusinessCustomerOperationPlanDetailMemberDO;
import com.elitesland.tw.tw5crm.server.partner.business.repo.BusinessCustomerOperationPlanDetailMemberRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessCustomerOperationPlanDetailMemberServiceImpl
extends BaseServiceImpl
implements BusinessCustomerOperationPlanDetailMemberService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerOperationPlanDetailMemberServiceImpl.class);
    private final BusinessCustomerOperationPlanDetailMemberRepo businessCustomerOperationPlanDetailMemberRepo;
    private final BusinessCustomerOperationPlanDetailMemberDAO businessCustomerOperationPlanDetailMemberDAO;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    public PagingVO<BusinessCustomerOperationPlanDetailMemberVO> queryPaging(BusinessCustomerOperationPlanDetailMemberQuery query) {
        return this.businessCustomerOperationPlanDetailMemberDAO.queryPaging(query);
    }

    public List<BusinessCustomerOperationPlanDetailMemberVO> queryListDynamic(BusinessCustomerOperationPlanDetailMemberQuery query) {
        return this.businessCustomerOperationPlanDetailMemberDAO.queryListDynamic(query);
    }

    public BusinessCustomerOperationPlanDetailMemberVO queryByKey(Long key) {
        BusinessCustomerOperationPlanDetailMemberDO entity = this.businessCustomerOperationPlanDetailMemberRepo.findById(key).orElseGet(BusinessCustomerOperationPlanDetailMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationPlanDetailMemberVO vo = BusinessCustomerOperationPlanDetailMemberConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationPlanDetailMemberVO insert(BusinessCustomerOperationPlanDetailMemberPayload payload) {
        this.check(payload);
        this.initDefaultValue(payload);
        BusinessCustomerOperationPlanDetailMemberDO entityDo = BusinessCustomerOperationPlanDetailMemberConvert.INSTANCE.toDo(payload);
        BusinessCustomerOperationPlanDetailMemberDO save = (BusinessCustomerOperationPlanDetailMemberDO)this.businessCustomerOperationPlanDetailMemberRepo.save(entityDo);
        String createLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo, "\u6dfb\u52a0\u4e86");
        this.logService.saveNewLog(entityDo.getPlanDetailId(), PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), createLog);
        return BusinessCustomerOperationPlanDetailMemberConvert.INSTANCE.toVo(save);
    }

    private void initDefaultValue(BusinessCustomerOperationPlanDetailMemberPayload payload) {
        if (!StringUtils.hasText((String)payload.getUserName())) {
            String userName = this.cacheUtil.getUserName(payload.getUserId());
            payload.setUserName(userName);
        }
    }

    private void check(BusinessCustomerOperationPlanDetailMemberPayload payload) {
        if (null == payload.getPlanDetailId()) {
            throw TwException.error((String)"", (String)"planDetailId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationPlanDetailMemberVO update(BusinessCustomerOperationPlanDetailMemberPayload payload) {
        BusinessCustomerOperationPlanDetailMemberDO entity = this.businessCustomerOperationPlanDetailMemberRepo.findById(payload.getId()).orElseGet(BusinessCustomerOperationPlanDetailMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationPlanDetailMemberDO entityLog = new BusinessCustomerOperationPlanDetailMemberDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessCustomerOperationPlanDetailMemberDO entityDo = BusinessCustomerOperationPlanDetailMemberConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        BusinessCustomerOperationPlanDetailMemberDO save = (BusinessCustomerOperationPlanDetailMemberDO)this.businessCustomerOperationPlanDetailMemberRepo.save(entity);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getPlanDetailId(), PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), fieldsUpdateLog.toString());
        }
        return BusinessCustomerOperationPlanDetailMemberConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessCustomerOperationPlanDetailMemberRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessCustomerOperationPlanDetailMemberDO entity = (BusinessCustomerOperationPlanDetailMemberDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessCustomerOperationPlanDetailMemberRepo.save(entity);
                    this.logService.saveNewLog(entity.getPlanDetailId(), PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), "\u5220\u9664\u4e86\u53c2\u4e0e\u8005 " + entity.getUserName());
                }
            });
        }
    }

    public void deleteSoftByPlanDetailIds(List<Long> keys) {
        this.businessCustomerOperationPlanDetailMemberDAO.deleteSoftByPlanDetailIds(keys);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<BusinessCustomerOperationPlanDetailMemberVO> savaAll(BusinessCustomerOperationPlanDetailMemberListPayload payload) {
        List memberList = payload.getMemberList();
        ArrayList<BusinessCustomerOperationPlanDetailMemberVO> list = new ArrayList<BusinessCustomerOperationPlanDetailMemberVO>();
        if (!CollectionUtils.isEmpty((Collection)memberList)) {
            memberList.forEach(crmOperationPlanDetailMemberPayload -> list.add(this.insert((BusinessCustomerOperationPlanDetailMemberPayload)crmOperationPlanDetailMemberPayload)));
        }
        return list;
    }

    public BusinessCustomerOperationPlanDetailMemberServiceImpl(BusinessCustomerOperationPlanDetailMemberRepo businessCustomerOperationPlanDetailMemberRepo, BusinessCustomerOperationPlanDetailMemberDAO businessCustomerOperationPlanDetailMemberDAO, PrdSystemLogService logService, CacheUtil cacheUtil, ChangeFieldLogUtil changeFieldLogUtil) {
        this.businessCustomerOperationPlanDetailMemberRepo = businessCustomerOperationPlanDetailMemberRepo;
        this.businessCustomerOperationPlanDetailMemberDAO = businessCustomerOperationPlanDetailMemberDAO;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
    }
}

