/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPriceDetailPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductPriceDetailQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceDetailService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceDetailVO;
import com.elitesland.tw.tw5crm.server.product.convert.ProductPriceDetailConvert;
import com.elitesland.tw.tw5crm.server.product.dao.ProductPriceDetailDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceDetailDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductPriceDetailRepo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ProductPriceDetailServiceImpl
extends BaseServiceImpl
implements ProductPriceDetailService {
    private static final Logger log = LoggerFactory.getLogger(ProductPriceDetailServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final ProductPriceDetailRepo productPriceDetailRepo;
    private final ProductPriceDetailDAO productPriceDetailDAO;

    public PagingVO<ProductPriceDetailVO> paging(ProductPriceDetailQuery query) {
        Page page = this.productPriceDetailRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(ProductPriceDetailConvert.INSTANCE::toVo));
    }

    public PagingVO<ProductPriceDetailVO> queryPaging(ProductPriceDetailQuery query) {
        this.operPermissionFlag(query);
        PagingVO<ProductPriceDetailVO> productPriceDetailVOPagingVO = this.productPriceDetailDAO.queryPaging(query);
        List records = productPriceDetailVOPagingVO.getRecords();
        records.forEach(e -> {
            List systemSelectionChildren;
            PrdSystemSelectionVO prdSystemSelectionVO;
            PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("crm:product:spu_type");
            if (systemSelection != null && (prdSystemSelectionVO = (PrdSystemSelectionVO)(systemSelectionChildren = systemSelection.getChildren()).stream().filter(s -> s.getSelectionValue().equals(e.getSpuType())).findFirst().orElse(null)) != null) {
                String extString1 = prdSystemSelectionVO.getExtString1();
                e.setTaxRate(extString1);
            }
        });
        return productPriceDetailVOPagingVO;
    }

    void operPermissionFlag(ProductPriceDetailQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            List longs;
            Long userId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(GlobalUtil.getLoginUserId());
            List orgIdList = this.cacheUtil.getManagerOrgIdsByUserId(userId);
            HashSet orgIds = new HashSet();
            if (!ObjectUtils.isEmpty((Object)orgIdList)) {
                orgIds.addAll(orgIdList);
            }
            if (!ObjectUtils.isEmpty((Object)(longs = this.cacheUtil.getMyOrgIdsByUserId(userId)))) {
                orgIds.addAll(longs);
            }
            query.setOrgIdList(orgIds);
        }
    }

    public List<ProductPriceDetailVO> queryList(ProductPriceDetailQuery query) {
        return ProductPriceDetailConvert.INSTANCE.toVoList(this.productPriceDetailRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<ProductPriceDetailVO> queryListDynamic(ProductPriceDetailQuery query) {
        this.operPermissionFlag(query);
        return this.productPriceDetailDAO.queryListDynamic(query);
    }

    public ProductPriceDetailVO queryByKey(Long key) {
        ProductPriceDetailDO entity = this.productPriceDetailRepo.findById(key).orElseGet(ProductPriceDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductPriceDetailVO vo = ProductPriceDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductPriceDetailVO insert(ProductPriceDetailPayload payload) {
        ProductPriceDetailDO entityDo = ProductPriceDetailConvert.INSTANCE.toDo(payload);
        return ProductPriceDetailConvert.INSTANCE.toVo((ProductPriceDetailDO)this.productPriceDetailRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductPriceDetailVO update(ProductPriceDetailPayload payload) {
        ProductPriceDetailDO entity = this.productPriceDetailRepo.findById(payload.getId()).orElseGet(ProductPriceDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductPriceDetailDO entityDo = ProductPriceDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ProductPriceDetailConvert.INSTANCE.toVo((ProductPriceDetailDO)this.productPriceDetailRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.productPriceDetailRepo.findById(id);
                if (!optional.isEmpty()) {
                    ProductPriceDetailDO entity = (ProductPriceDetailDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.productPriceDetailRepo.save(entity);
                }
            });
        }
    }

    public List<ProductPriceDetailVO> queryListBySkuIds(List<Long> skuIds) {
        return ProductPriceDetailConvert.INSTANCE.toVoList(this.productPriceDetailDAO.queryBySkuIds(skuIds));
    }

    public ProductPriceDetailServiceImpl(CacheUtil cacheUtil, ProductPriceDetailRepo productPriceDetailRepo, ProductPriceDetailDAO productPriceDetailDAO) {
        this.cacheUtil = cacheUtil;
        this.productPriceDetailRepo = productPriceDetailRepo;
        this.productPriceDetailDAO = productPriceDetailDAO;
    }
}

