/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleTargetPayload;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetCustomerQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetUserOrgQuery;
import com.elitesland.tw.tw5crm.api.sale.service.SaleTargetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"sale"})
@RestController
@RequestMapping(value={"/api/crm/sale/target"})
public class SaleTargetController {
    private static final Logger log = LoggerFactory.getLogger(SaleTargetController.class);
    private final SaleTargetService saleTargetService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody SaleTargetPayload payload) {
        return TwOutputUtil.ok((Object)this.saleTargetService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody SaleTargetPayload payload) {
        return TwOutputUtil.ok((Object)this.saleTargetService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.saleTargetService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil paging(SaleTargetQuery query) {
        return TwOutputUtil.ok((Object)this.saleTargetService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(SaleTargetQuery query) {
        return TwOutputUtil.ok((Object)this.saleTargetService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.saleTargetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"countUserOrder"})
    @ApiOperation(value="\u4eba\u5458\u9500\u552e\u76ee\u6807\u6392\u884c\u699c")
    @UdcNameClass
    public TwOutputUtil countUserOrder(SaleTargetStatisticalQuery query) {
        return TwOutputUtil.ok((Object)this.saleTargetService.queryCountUserOrder(query));
    }

    @GetMapping(value={"countUserOrg"})
    @ApiOperation(value="\u4eba\u5458\u7ec4\u7ec7\u7ef4\u5ea6\u7edf\u8ba1")
    public TwOutputUtil countUserOrg(SaleTargetUserOrgQuery query) {
        return TwOutputUtil.ok((Object)this.saleTargetService.queryUserOrgCount(query));
    }

    @GetMapping(value={"countCustomer"})
    @ApiOperation(value="\u5ba2\u6237\u7ef4\u5ea6\u7edf\u8ba1")
    public TwOutputUtil countCustomer(SaleTargetCustomerQuery query) {
        return TwOutputUtil.ok((Object)this.saleTargetService.queryCustomerCount(query));
    }

    @GetMapping(value={"countCustomerOrder"})
    @ApiOperation(value="\u5ba2\u6237\u9500\u552e\u76ee\u6807\u6392\u884c\u699c")
    public TwOutputUtil countCustomerOrder(SaleTargetStatisticalQuery query) {
        return TwOutputUtil.ok((Object)this.saleTargetService.countCustomerOrder(query));
    }

    @GetMapping(value={"countProductOrder"})
    @ApiOperation(value="\u5ba2\u6237\u9500\u552e\u76ee\u6807\u6392\u884c\u699c")
    public TwOutputUtil countProductOrder(SaleTargetStatisticalQuery query) {
        return TwOutputUtil.ok((Object)this.saleTargetService.countProductOrder(query));
    }

    public SaleTargetController(SaleTargetService saleTargetService) {
        this.saleTargetService = saleTargetService;
    }
}

