/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsDataPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsSnapshotPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActPayPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsSnapshotQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectCalendarService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectWbsService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectWbsSnapshotService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectCalendarVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectWbsSnapshotVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActCostVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActPayVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComChangeTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectWbsTypeEnum;
import com.elitesland.tw.tw5pms.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectWbsConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsActCostConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsActPayConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsActCostDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsActPayDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectWbsDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActCostDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActPayDO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectWbsServiceImpl
extends BaseServiceImpl
implements PmsProjectWbsService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectWbsServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final PmsWbsActCostDAO pmsWbsActCostDAO;
    private final PmsWbsActPayDAO pmsWbsActPayDAO;
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectDAO pmsProjectDAO;
    private final ChangeFieldUtil changeFieldUtil;
    private final PmsProjectWbsSnapshotService planSnapshotService;
    private final PmsProjectCalendarService calendarService;

    void checkOperate(PmsProjectWbsDataPayload payload, List<PmsProjectWbsVO> wbsVOS, PmsProjectVO pmsProjectVO) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<Long> userIds = Arrays.asList(pmsProjectVO.getManagerUserId(), pmsProjectVO.getCreateUserId());
        if (!userIds.contains(loginUserId)) {
            if (!ObjectUtils.isEmpty((Object)payload.getDelWbsIds())) {
                List<PmsProjectWbsVO> projectWbsVOs = wbsVOS.stream().filter(wbsVO -> payload.getDelWbsIds().contains(wbsVO.getId())).collect(Collectors.toList());
                projectWbsVOs.forEach(projectWbsVO -> {
                    if (StringUtils.hasText((String)projectWbsVO.getParentWbsCode())) {
                        ArrayList<Long> parentUserIds = new ArrayList<Long>();
                        this.getParentUserIds(parentUserIds, projectWbsVO.getParentWbsCode(), wbsVOS);
                        if (!parentUserIds.contains(loginUserId)) {
                            throw TwException.error((String)"", (String)("\u65e0[" + projectWbsVO.getWbsName() + "]\u5220\u9664\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01"));
                        }
                    } else {
                        throw TwException.error((String)"", (String)("\u65e0[" + projectWbsVO.getWbsName() + "]\u5220\u9664\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01"));
                    }
                });
            }
            if (!ObjectUtils.isEmpty((Object)payload.getWbsPayloads())) {
                List collect0 = payload.getWbsPayloads().stream().map(PmsProjectWbsPayload::getWbsCode).distinct().collect(Collectors.toList());
                if (payload.getWbsPayloads().size() != collect0.size()) {
                    throw TwException.error((String)"", (String)"wbs\u7f16\u7801\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                payload.getWbsPayloads().forEach(wbsPayload -> {
                    if (ObjectUtils.isEmpty((Object)wbsPayload.getWbsCode())) {
                        throw TwException.error((String)"", (String)"\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (ObjectUtils.isEmpty((Object)wbsPayload.getWbsType())) {
                        throw TwException.error((String)"", (String)"\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (ObjectUtils.isEmpty((Object)wbsPayload.getParentWbsCode())) {
                        if (!wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()) && !wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.NET.getCode())) {
                            throw TwException.error((String)"", (String)"\u4e00\u7ea7\u8282\u70b9\u53ea\u53ef\u65b0\u5efa\u201cWBS\u5143\u7d20\u201d\u548c\u201c\u7f51\u7edc\u201d\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                    } else {
                        Optional<PmsProjectWbsPayload> first = payload.getWbsPayloads().stream().filter(wbsPayload0 -> wbsPayload0.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                        String parentWbsType = "";
                        if (first.isPresent()) {
                            PmsProjectWbsPayload parentWbsPayload = first.get();
                            parentWbsType = parentWbsPayload.getWbsType();
                            if (wbsPayload.getPreStartDate() != null && parentWbsPayload.getPreStartDate() != null && parentWbsPayload.getPreStartDate().isAfter(wbsPayload.getPreStartDate())) {
                                throw TwException.error((String)"", (String)("[" + wbsPayload.getWbsName() + "]\u5f00\u59cb\u65f6\u95f4\u4e0d\u5728\u4e0a\u7ea7\u8282\u70b9\u8303\u56f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01"));
                            }
                            if (wbsPayload.getPreEndDate() != null && parentWbsPayload.getPreEndDate() != null && parentWbsPayload.getPreEndDate().isBefore(wbsPayload.getPreEndDate())) {
                                throw TwException.error((String)"", (String)("[" + wbsPayload.getWbsName() + "]\u7ed3\u675f\u65f6\u95f4\u4e0d\u5728\u4e0a\u7ea7\u8282\u70b9\u8303\u56f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01"));
                            }
                        } else {
                            Optional<PmsProjectWbsVO> first0 = wbsVOS.stream().filter(wbsVO -> wbsVO.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                            if (first0.isPresent()) {
                                PmsProjectWbsVO parentWbsVO = first0.get();
                                parentWbsType = parentWbsVO.getWbsType();
                                if (wbsPayload.getPreStartDate() != null && parentWbsVO.getPreStartDate() != null && parentWbsVO.getPreStartDate().isAfter(wbsPayload.getPreStartDate())) {
                                    throw TwException.error((String)"", (String)("[" + wbsPayload.getWbsName() + "]\u5f00\u59cb\u65f6\u95f4\u4e0d\u5728\u4e0a\u7ea7\u8282\u70b9\u8303\u56f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01"));
                                }
                                if (wbsPayload.getPreEndDate() != null && parentWbsVO.getPreEndDate() != null && parentWbsVO.getPreEndDate().isBefore(wbsPayload.getPreEndDate())) {
                                    throw TwException.error((String)"", (String)("[" + wbsPayload.getWbsName() + "]\u7ed3\u675f\u65f6\u95f4\u4e0d\u5728\u4e0a\u7ea7\u8282\u70b9\u8303\u56f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01"));
                                }
                            } else {
                                throw TwException.error((String)"", (String)(wbsPayload.getParentWbsCode() + "\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01"));
                            }
                        }
                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()) && !parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode())) {
                            throw TwException.error((String)"", (String)"WBS\u5143\u7d20\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.NET.getCode()) && !parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode())) {
                            throw TwException.error((String)"", (String)"\u7f51\u7edc\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) && !parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode()) && !parentWbsType.equals(ProjectWbsTypeEnum.NET.getCode())) {
                            throw TwException.error((String)"", (String)"\u6d3b\u52a8\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\u6216\u7f51\u7edc\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode()) && !parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode())) {
                            throw TwException.error((String)"", (String)"\u91cc\u7a0b\u7891\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                    }
                    this.transferData((PmsProjectWbsPayload)wbsPayload);
                    if (!(ObjectUtils.isEmpty((Object)wbsPayload.getRelyType()) || "FS".equals(wbsPayload.getRelyType()) || "FF".equals(wbsPayload.getRelyType()) || "SS".equals(wbsPayload.getRelyType()))) {
                        throw TwException.error((String)"", (String)("\u975e\u6cd5\u524d\u7f6e\u4f9d\u8d56\u7c7b\u578b\u3010" + wbsPayload.getRelyType() + "\u3011\uff0c\u8bf7\u6838\u9a8c\uff01"));
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload.getPreStartDate()) && !ObjectUtils.isEmpty((Object)wbsPayload.getPreEndDate()) && wbsPayload.getPreStartDate().isAfter(wbsPayload.getPreEndDate())) {
                        throw TwException.error((String)"", (String)"\u7ed3\u675f\u65f6\u95f4\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload.getRelyIds())) {
                        String parentWbsCode = wbsPayload.getParentWbsCode();
                        if (!StringUtils.hasText((String)parentWbsCode)) {
                            throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u7f51\u7edc\u4e0b\u6d3b\u52a8\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        if (!ProjectWbsTypeEnum.ACT.getCode().equals(wbsPayload.getWbsType())) {
                            throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u6d3b\u52a8\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        if (ObjectUtils.isEmpty((Object)wbsPayload.getPreStartDate()) || ObjectUtils.isEmpty((Object)wbsPayload.getPreEndDate())) {
                            throw TwException.error((String)"", (String)"\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\u9700\u4fdd\u8bc1\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        List<PmsProjectWbsVO> relyVOs = wbsVOS.stream().filter(pmsProjectWbsVO -> wbsPayload.getRelyIds().indexOf("" + pmsProjectWbsVO.getId()) > 0).collect(Collectors.toList());
                        relyVOs.forEach(relyVO -> {
                            if (!ProjectWbsTypeEnum.ACT.getCode().equals(relyVO.getWbsType())) {
                                throw TwException.error((String)"", (String)"\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\u5fc5\u987b\u662f\u6d3b\u52a8\u7c7b\u578b\uff0c\u8bf7\u6838\u9a8c\uff01");
                            }
                            if (ObjectUtils.isEmpty((Object)relyVO.getPreStartDate()) || ObjectUtils.isEmpty((Object)relyVO.getPreEndDate())) {
                                throw TwException.error((String)"", (String)"\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\u6d3b\u52a8\u5fc5\u987b\u8bbe\u7f6e\u5f00\u59cb\u53ca\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u6838\u9a8c\uff01");
                            }
                            if (!relyVO.getParentWbsCode().equals(parentWbsCode)) {
                                throw TwException.error((String)"", (String)"\u4ec5\u80fd\u591f\u5728\u540c\u4e00\u4e2a\u7f51\u7edc\u4e0b\u7684\u6d3b\u52a8\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\uff0c\u8bf7\u6838\u9a8c\uff01");
                            }
                        });
                    }
                    if (StringUtils.hasText((String)wbsPayload.getParentWbsCode())) {
                        Boolean isCheck = true;
                        if (wbsPayload.getId() == null) {
                            isCheck = false;
                        } else {
                            Optional<PmsProjectWbsVO> first = wbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(wbsPayload.getId())).findFirst();
                            if (first.isPresent()) {
                                PmsProjectWbsVO pmsProjectWbsVO2 = first.get();
                                if (!pmsProjectWbsVO2.getParentWbsCode().equals(wbsPayload.getParentWbsCode())) {
                                    isCheck = false;
                                }
                                if (pmsProjectWbsVO2.getManagerUserId() == null && wbsPayload.getManagerUserId() != null || wbsPayload.getManagerUserId() == null && pmsProjectWbsVO2.getManagerUserId() != null) {
                                    isCheck = false;
                                }
                                if (pmsProjectWbsVO2.getManagerUserId() != null && wbsPayload.getManagerUserId() != null && !pmsProjectWbsVO2.getManagerUserId().equals(pmsProjectWbsVO2.getManagerUserId())) {
                                    isCheck = false;
                                }
                                if (isCheck.booleanValue() && (pmsProjectWbsVO2.getManagerUserId() == null || !pmsProjectWbsVO2.getManagerUserId().equals(loginUserId))) {
                                    isCheck = false;
                                }
                            } else {
                                throw TwException.error((String)"", (String)("[" + wbsPayload.getWbsName() + "]\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01"));
                            }
                        }
                        if (!isCheck.booleanValue()) {
                            ArrayList<Long> parentUserIds = new ArrayList<Long>();
                            this.getParentUserIds(parentUserIds, wbsPayload.getParentWbsCode(), wbsVOS);
                            if (!parentUserIds.contains(loginUserId)) {
                                throw TwException.error((String)"", (String)("\u65e0[" + wbsPayload.getWbsName() + "]\u8be5\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01"));
                            }
                        }
                    } else {
                        throw TwException.error((String)"", (String)("\u65e0[" + wbsPayload.getWbsName() + "]\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01"));
                    }
                });
            }
        }
    }

    void transferData(PmsProjectWbsPayload payload) {
        payload.setCostTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:ACT_COST:TYPE", payload.getCostType()));
        String wbsTypeName = payload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()) ? "WBS\u5143\u7d20" : (payload.getWbsType().equals(ProjectWbsTypeEnum.NET.getCode()) ? "\u7f51\u7edc" : (payload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) ? "\u6d3b\u52a8" : "\u91cc\u7a0b\u7891"));
        payload.setWbsTypeName(wbsTypeName);
        if (payload.getInvoiceAttr() != null) {
            payload.setInvoiceAttrName(payload.getInvoiceAttr() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
        if (payload.getCostPlan() != null) {
            payload.setCostPlanName(payload.getCostPlan() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
        if (payload.getSubjectDist() != null) {
            payload.setSubjectDistName(payload.getSubjectDist() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
    }

    void getParentUserIds(List<Long> parentUserIds, String parentWbsCode, List<PmsProjectWbsVO> projectWbsVOs) {
        PmsProjectWbsVO pmsProjectWbsVO;
        Optional<PmsProjectWbsVO> first = projectWbsVOs.stream().filter(wbsVO -> wbsVO.getWbsCode().equals(parentWbsCode)).findFirst();
        if (first.isPresent()) {
            pmsProjectWbsVO = first.get();
            if (!ObjectUtils.isEmpty((Object)pmsProjectWbsVO.getManagerUserId())) {
                parentUserIds.add(pmsProjectWbsVO.getManagerUserId());
            }
            if (!StringUtils.hasText((String)pmsProjectWbsVO.getParentWbsCode())) {
                return;
            }
        } else {
            return;
        }
        this.getParentUserIds(parentUserIds, pmsProjectWbsVO.getParentWbsCode(), projectWbsVOs);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsVO batchInsertOrUpdate(PmsProjectWbsDataPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error((String)"", (String)"\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List wbsPayloads = payload.getWbsPayloads();
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryByProjectId(payload.getProjectId());
        this.checkOperate(payload, pmsProjectWbsVOS, pmsProjectVO);
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        if (!ObjectUtils.isEmpty((Object)payload.getDelWbsIds())) {
            List<PmsProjectWbsVO> collect = pmsProjectWbsVOS.stream().filter(wbsVO -> payload.getDelWbsIds().contains(wbsVO.getId())).collect(Collectors.toList());
            this.createWbsDelLog(logPayloads, collect);
            this.pmsProjectWbsDAO.deleteSoft(payload.getDelWbsIds());
            this.pmsWbsActCostDAO.deleteSoftByWbsIds(payload.getDelWbsIds());
            this.pmsWbsActPayDAO.deleteSoftByWbsIds(payload.getDelWbsIds());
            pmsProjectWbsVOS.removeAll(collect);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getWbsPayloads())) {
            String lastFourDigits = String.format("%04d", System.currentTimeMillis() % 10000L);
            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setProjectId(payload.getProjectId());
                if (wbsPayload.getId() == null) {
                    Random random = new Random();
                    int s = random.nextInt(99) % 90 + 10;
                    wbsPayload.setNodeCode(pmsProjectVO.getProjectCode() + "-" + wbsPayload.getWbsType() + "-" + lastFourDigits + s);
                }
                if (StringUtils.hasText((String)wbsPayload.getParentWbsCode())) {
                    Optional<PmsProjectWbsPayload> payload1 = wbsPayloads.stream().filter(load -> load.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                    if (payload1.isPresent()) {
                        wbsPayload.setParentWbsName(payload1.get().getWbsName());
                    } else {
                        Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(vo -> vo.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                        if (vo1.isPresent()) {
                            wbsPayload.setParentWbsName(vo1.get().getWbsName());
                        }
                    }
                }
            });
            List<PmsProjectWbsPayload> updatePayloads = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getId() != null).collect(Collectors.toList());
            List<Long> updateIds = this.createWbsUpdateLog(logPayloads, pmsProjectWbsVOS, updatePayloads);
            List<PmsProjectWbsDO> entityDos = wbsPayloads.stream().map(e -> {
                PmsProjectWbsDO wbsDO = PmsProjectWbsConvert.INSTANCE.toDo((PmsProjectWbsPayload)e);
                e.setWbsDO((BaseModel)wbsDO);
                return wbsDO;
            }).collect(Collectors.toList());
            List<PmsProjectWbsDO> pmsProjectWbsDOS = this.pmsProjectWbsDAO.saveAll(entityDos);
            ArrayList<PmsProjectWbsPayload> addPayloads = new ArrayList<PmsProjectWbsPayload>();
            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setId(wbsPayload.getWbsDO().getId());
                if (!updateIds.contains(wbsPayload.getId())) {
                    addPayloads.add((PmsProjectWbsPayload)wbsPayload);
                }
            });
            this.operProjectCalendar(payload);
            this.createWbsAddLog(logPayloads, addPayloads);
            List<PmsProjectWbsPayload> act = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(act)) {
                List<Object> pmsWbsActCostVOS = this.pmsWbsActCostDAO.queryByProjectId(payload.getProjectId());
                List<Object> pmsWbsActPayVOS = this.pmsWbsActPayDAO.queryByProjectId(payload.getProjectId());
                ArrayList<Long> delActCostIds = new ArrayList<Long>();
                ArrayList<Long> delActPayIds = new ArrayList<Long>();
                for (PmsProjectWbsPayload wbsPayload2 : act) {
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActCostIds())) {
                        delActCostIds.addAll(wbsPayload2.getDelActCostIds());
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActPayIds())) {
                        delActPayIds.addAll(wbsPayload2.getDelActPayIds());
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActCostIds()) || !ObjectUtils.isEmpty((Object)wbsPayload2.getActCostPayloads())) {
                        this.operActCostLog(logPayloads, wbsPayload2, pmsWbsActCostVOS);
                    }
                    if (ObjectUtils.isEmpty((Object)wbsPayload2.getDelActPayIds()) && ObjectUtils.isEmpty((Object)wbsPayload2.getActPayPayloads())) continue;
                    this.operActPayLog(logPayloads, wbsPayload2, pmsWbsActPayVOS);
                }
                if (delActCostIds.size() > 0) {
                    this.pmsWbsActCostDAO.deleteSoft(delActCostIds);
                    pmsWbsActCostVOS = pmsWbsActCostVOS.stream().filter(costVO -> !delActCostIds.contains(costVO.getId())).collect(Collectors.toList());
                }
                if (delActPayIds.size() > 0) {
                    this.pmsWbsActPayDAO.deleteSoft(delActPayIds);
                    pmsWbsActPayVOS = pmsWbsActPayVOS.stream().filter(payVO -> !delActPayIds.contains(payVO.getId())).collect(Collectors.toList());
                }
                ArrayList<PmsWbsActCostPayload> actCostPayloads = new ArrayList<PmsWbsActCostPayload>();
                ArrayList<PmsWbsActPayPayload> actPayPayloads = new ArrayList<PmsWbsActPayPayload>();
                this.checkWbsAct(act, pmsProjectWbsDOS, actCostPayloads, actPayPayloads, payload.getProjectId(), pmsWbsActCostVOS, pmsWbsActPayVOS);
                if (actCostPayloads.size() > 0) {
                    List<PmsWbsActCostDO> pmsWbsActCostDOS = PmsWbsActCostConvert.INSTANCE.toDoList(actCostPayloads);
                    this.pmsWbsActCostDAO.saveAll(pmsWbsActCostDOS);
                }
                if (actPayPayloads.size() > 0) {
                    List<PmsWbsActPayDO> pmsWbsActPayDOS = PmsWbsActPayConvert.INSTANCE.toDoList(actPayPayloads);
                    this.pmsWbsActPayDAO.saveAll(pmsWbsActPayDOS);
                }
            }
        }
        if (logPayloads.size() > 0) {
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setChangeContent("\u9879\u76eewbs\u53d8\u66f4");
            changePayload.setChangeDocId("" + payload.getProjectId());
            changePayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_WBS.getCode());
            changePayload.setCreator(GlobalUtil.getLoginUserName());
            ComChangeVO insert = this.changeService.insert(changePayload);
            String vid = payload.getProjectId() + "-" + insert.getVersionNo();
            logPayloads.forEach(log -> log.setExtString1(vid));
            this.logService.insertBacth(logPayloads);
        }
        return null;
    }

    void operProjectCalendar(PmsProjectWbsDataPayload projectWbsDataPayload) {
        List wbsPayloads;
        if (!ObjectUtils.isEmpty((Object)projectWbsDataPayload.getDelWbsIds())) {
            this.calendarService.deleteSoftBySource(projectWbsDataPayload.getDelWbsIds(), ProjectWbsTypeEnum.WBS.getCode());
        }
        if (!ObjectUtils.isEmpty((Object)(wbsPayloads = projectWbsDataPayload.getWbsPayloads()))) {
            ArrayList pmsProjectCalendarPayloads = new ArrayList();
            wbsPayloads.forEach(wbsPayload -> {
                PmsProjectCalendarPayload pmsProjectCalendarPayload = wbsPayload.getPmsProjectCalendarPayload();
                if (!ObjectUtils.isEmpty((Object)pmsProjectCalendarPayload)) {
                    pmsProjectCalendarPayload.setSourceId(wbsPayload.getId());
                    pmsProjectCalendarPayload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
                    pmsProjectCalendarPayloads.add(pmsProjectCalendarPayload);
                }
            });
            this.calendarService.batchSave(pmsProjectCalendarPayloads);
        }
    }

    void operActCostLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActCostVO> pmsWbsActCostVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals("" + wbsPayload.getId())).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            logPayload.setObjectId("" + wbsPayload.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("\u6210\u672c\u4f30\u8ba1:");
        builder.append("\n");
        List<Object> dels = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)wbsPayload.getDelActCostIds())) {
            dels = pmsWbsActCostVOS.stream().filter(wbsVO -> wbsPayload.getDelActCostIds().contains(wbsVO.getId())).map(PmsWbsActCostVO::getCostName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("\u5220\u9664");
            for (int i = 0; i < dels.size(); ++i) {
                if (i == 0) {
                    builder.append("\u3010" + (String)dels.get(i) + "\u3011");
                    continue;
                }
                builder.append(",\u3010" + (String)dels.get(i) + "\u3011");
            }
        }
        List actCostPayloads = wbsPayload.getActCostPayloads();
        List<Object> adds = new ArrayList();
        List<Object> updates = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)actCostPayloads)) {
            adds = actCostPayloads.stream().filter(actCost -> actCost.getId() == null).collect(Collectors.toList());
            updates = actCostPayloads.stream().filter(actCost -> actCost.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("\u6210\u672c\u8981\u7d20-\u6210\u672c\u4f30\u8ba1 \u521b\u5efa\u4e3a");
            builder.append("\n");
            for (PmsWbsActCostPayload pmsWbsActCostPayload : adds) {
                builder.append(pmsWbsActCostPayload.getCostName() + "-" + pmsWbsActCostPayload.getCostEstimate());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("\u6210\u672c\u8981\u7d20-\u6210\u672c\u4f30\u8ba1");
            builder.append("\n");
            for (PmsWbsActCostPayload pmsWbsActCostPayload : updates) {
                PmsWbsActCostVO pmsWbsActCostVO;
                Optional<PmsWbsActCostVO> firstCost = pmsWbsActCostVOS.stream().filter(actCost -> actCost.getId().equals(up.getId())).findFirst();
                if (!firstCost.isPresent() || (pmsWbsActCostVO = firstCost.get()).getCostName().equals(pmsWbsActCostPayload.getCostName()) && pmsWbsActCostVO.getCostEstimate().equals(pmsWbsActCostPayload.getCostEstimate())) continue;
                String str = pmsWbsActCostVO.getCostName() + "-" + pmsWbsActCostVO.getCostEstimate() + "\u66f4\u65b0\u4e3a" + pmsWbsActCostPayload.getCostName() + "-" + pmsWbsActCostPayload.getCostEstimate();
                builder.append(str);
                builder.append("\n");
            }
        }
        logPayload.setLogContent(builder.toString());
    }

    void operActPayLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals("" + wbsPayload.getId())).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            logPayload.setObjectId("" + wbsPayload.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("\u4ea4\u4ed8\u7269:");
        builder.append("\n");
        List<Object> dels = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)wbsPayload.getDelActPayIds())) {
            dels = pmsWbsActPayVOS.stream().filter(wbsVO -> wbsPayload.getDelActPayIds().contains(wbsVO.getId())).map(PmsWbsActPayVO::getPayName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("\u5220\u9664");
            for (int i = 0; i < dels.size(); ++i) {
                if (i == 0) {
                    builder.append("\u3010" + (String)dels.get(i) + "\u3011");
                    continue;
                }
                builder.append(",\u3010" + (String)dels.get(i) + "\u3011");
            }
        }
        List actPayPayloads = wbsPayload.getActPayPayloads();
        List<Object> adds = new ArrayList();
        List<Object> updates = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)actPayPayloads)) {
            adds = actPayPayloads.stream().filter(actPay -> actPay.getId() == null).collect(Collectors.toList());
            updates = actPayPayloads.stream().filter(actPay -> actPay.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("\u4ea4\u4ed8\u7269\u540d\u79f0-\u4ea4\u4ed8\u7269\u7c7b\u578b \u521b\u5efa\u4e3a");
            builder.append("\n");
            for (PmsWbsActPayPayload pmsWbsActPayPayload : adds) {
                builder.append(pmsWbsActPayPayload.getPayName() + "-" + pmsWbsActPayPayload.getPayTypeName());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("\u4ea4\u4ed8\u7269\u540d\u79f0-\u4ea4\u4ed8\u7269\u7c7b\u578b");
            builder.append("\n");
            for (PmsWbsActPayPayload pmsWbsActPayPayload : updates) {
                PmsWbsActPayVO pmsWbsActPayVO;
                Optional<PmsWbsActPayVO> firstPay = pmsWbsActPayVOS.stream().filter(actPay -> actPay.getId().equals(up.getId())).findFirst();
                if (!firstPay.isPresent() || (pmsWbsActPayVO = firstPay.get()).getPayName().equals(pmsWbsActPayPayload.getPayName()) && pmsWbsActPayVO.getPayTypeName().equals(pmsWbsActPayPayload.getPayTypeName())) continue;
                String str = pmsWbsActPayVO.getPayName() + "-" + pmsWbsActPayVO.getPayTypeName() + "\u66f4\u65b0\u4e3a" + pmsWbsActPayPayload.getPayName() + "-" + pmsWbsActPayPayload.getPayTypeName();
                builder.append(str);
                builder.append("\n");
            }
        }
        logPayload.setLogContent(builder.toString());
    }

    void createWbsAddLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsPayload> wbsPayloads) {
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                String fieldsCreateLog = this.changeFieldUtil.getFieldsCreateLog(wbsPayload, null);
                ComLogPayload logPayload = new ComLogPayload();
                logPayload.setObjectId("" + wbsPayload.getId());
                logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
                logPayload.setExtString2(wbsPayload.getWbsType());
                logPayload.setExtString3("CREATE");
                logPayload.setLogContent(fieldsCreateLog);
                logPayloads.add(logPayload);
            });
        }
    }

    List<Long> createWbsUpdateLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> wbsVOS, List<PmsProjectWbsPayload> wbsPayloads) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                Optional<PmsProjectWbsVO> first;
                ids.add(wbsPayload.getId());
                if (!ObjectUtils.isEmpty((Object)wbsVOS) && (first = wbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(wbsPayload.getId())).findFirst()).isPresent()) {
                    PmsProjectWbsVO pmsProjectWbsVO = first.get();
                    PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                    this.transferData(pmsProjectWbsPayload);
                    String fieldsUpdateLog = this.changeFieldUtil.getFieldsUpdateLog(wbsPayload, pmsProjectWbsPayload);
                    if (StringUtils.hasText((String)fieldsUpdateLog)) {
                        ComLogPayload logPayload = new ComLogPayload();
                        logPayload.setObjectId("" + wbsPayload.getId());
                        logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
                        logPayload.setExtString2(wbsPayload.getWbsType());
                        logPayload.setExtString3("UPDATE");
                        logPayload.setLogContent(fieldsUpdateLog);
                        logPayloads.add(logPayload);
                    }
                }
            });
        }
        return ids;
    }

    void createWbsDelLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> collect) {
        collect.forEach(wbsVO -> {
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("" + wbsVO.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setLogContent("\u8282\u70b9\u3010" + wbsVO.getWbsName() + "\u3011\u88ab\u5220\u9664");
            logPayload.setExtString2(wbsVO.getWbsType());
            logPayload.setExtString3("DEL");
            logPayloads.add(logPayload);
        });
    }

    public List<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getProjectId())) {
            throw TwException.error((String)"", (String)"\u5f52\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> this.transferData((PmsProjectWbsVO)pmsProjectWbsVO));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        return pmsProjectWbsVOS;
    }

    public PmsProjectWbsVO queryByKey(Long key) {
        PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(key);
        this.operDurationDay(pmsProjectWbsVO);
        this.transferData(pmsProjectWbsVO);
        return pmsProjectWbsVO;
    }

    void operDurationDay(PmsProjectWbsVO pmsProjectWbsVO) {
        if (pmsProjectWbsVO.getPreStartDate() != null && pmsProjectWbsVO.getPreEndDate() != null) {
            PmsProjectCalendarPayload payload = new PmsProjectCalendarPayload();
            payload.setSourceId(pmsProjectWbsVO.getId());
            payload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
            payload.setStartDate(pmsProjectWbsVO.getPreStartDate());
            payload.setEndDate(pmsProjectWbsVO.getPreEndDate());
            PmsProjectCalendarVO bySource = this.calendarService.findBySource(payload);
            pmsProjectWbsVO.setPreDurationDay(BigDecimal.valueOf(bySource.getDurationDays()));
        }
    }

    void transferData(PmsProjectWbsVO vo) {
        vo.setCostTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:COST:TYPE", vo.getCostType()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        vo.setManagerUserName(this.cacheUtil.getUserName(vo.getManagerUserId()));
        vo.setWbsStatusName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:WBS:STATUS", vo.getWbsStatus()));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectWbsDAO.deleteSoft(keys);
            this.pmsWbsActCostDAO.deleteSoftByWbsIds(keys);
            this.pmsWbsActPayDAO.deleteSoftByWbsIds(keys);
        }
    }

    public List<ComLogVO> queryLogList(PmsProjectWbsLogQuery query) {
        if (query.getProjectId() != null && query.getVersionNo() != null || query.getWbsId() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logQuery.setLogContent(query.getLogContent());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            } else {
                logQuery.setObjectId("" + query.getWbsId());
            }
            if (StringUtils.hasText((String)query.getOperType())) {
                logQuery.setExtString3(query.getOperType());
            }
            if (StringUtils.hasText((String)query.getWbsType())) {
                logQuery.setExtString2(query.getWbsType());
            }
            return this.logService.queryList(logQuery);
        }
        throw TwException.error((String)"", (String)"\u67e5\u8be2\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsSnapshotVO insertSnapshot(PmsProjectWbsSnapshotPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error((String)"", (String)"\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.querySimpleByProjectId(payload.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
            throw TwException.error((String)"", (String)"\u57fa\u7ebf\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        String originalContent = JSONObject.toJSONString(pmsProjectWbsVOS);
        payload.setSnapContent(originalContent);
        PmsProjectWbsSnapshotVO insert = this.planSnapshotService.insert(payload);
        return insert;
    }

    public List<PmsProjectWbsSnapshotVO> querySnapshotList(PmsProjectWbsSnapshotQuery query) {
        List pmsProjectWbsSnapshotVOS = this.planSnapshotService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)pmsProjectWbsSnapshotVOS)) {
            pmsProjectWbsSnapshotVOS.forEach(snapshotVO -> {
                List pmsProjectPlanVOS = (List)JSON.parseObject((String)snapshotVO.getSnapContent(), List.class);
                snapshotVO.setProjectWbsSimpleVOS(pmsProjectPlanVOS);
            });
        }
        return pmsProjectWbsSnapshotVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftSnapshot(List<Long> snapshotKeys) {
        this.planSnapshotService.deleteSoft(snapshotKeys);
    }

    public List<PmsProjectWbsVO> queryStakeholdersList(PmsProjectWbsQuery query) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query);
        return pmsProjectWbsVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteManagerUserIds(Long projectId, List<Long> managerUserIds) {
        this.pmsProjectWbsDAO.upadateManagerUserId(projectId, managerUserIds, null);
    }

    void checkWbsAct(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsDO> pmsProjectWbsDOS, List<PmsWbsActCostPayload> actCostPayloads, List<PmsWbsActPayPayload> actPayPayloads, Long projectId, List<PmsWbsActCostVO> pmsWbsActCostVOS, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        for (PmsProjectWbsPayload wbsPayload : wbsPayloads) {
            List collect;
            List costPayloads = wbsPayload.getActCostPayloads();
            List payloads = wbsPayload.getActPayPayloads();
            if (ObjectUtils.isEmpty((Object)costPayloads) && ObjectUtils.isEmpty((Object)payloads)) continue;
            Optional<PmsProjectWbsDO> first = pmsProjectWbsDOS.stream().filter(wbsDO -> wbsDO.getWbsCode().equals(wbsPayload.getWbsCode())).findFirst();
            PmsProjectWbsDO pmsProjectWbsDO = first.get();
            if (!ObjectUtils.isEmpty((Object)costPayloads)) {
                collect = costPayloads.stream().map(PmsWbsActCostPayload::getCostName).distinct().collect(Collectors.toList());
                if (costPayloads.size() != collect.size()) {
                    throw TwException.error((String)"", (String)("\u3010" + pmsProjectWbsDO.getWbsName() + "\u3011\u6d3b\u52a8\u63cf\u8ff0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01"));
                }
                costPayloads.forEach(costPayload -> {
                    costPayload.setProjectId(projectId);
                    costPayload.setWbsId(pmsProjectWbsDO.getId());
                    costPayload.setWbsName(pmsProjectWbsDO.getWbsName());
                });
                actCostPayloads.addAll(costPayloads);
            }
            if (ObjectUtils.isEmpty((Object)payloads)) continue;
            collect = payloads.stream().map(PmsWbsActPayPayload::getPayName).distinct().collect(Collectors.toList());
            if (payloads.size() != collect.size()) {
                throw TwException.error((String)"", (String)("\u3010" + pmsProjectWbsDO.getWbsName() + "\u3011\u76ee\u6807\u4ea4\u4ed8\u7269\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01"));
            }
            payloads.forEach(payPayload -> {
                payPayload.setProjectId(projectId);
                payPayload.setWbsId(pmsProjectWbsDO.getId());
                payPayload.setWbsName(pmsProjectWbsDO.getWbsName());
            });
            actPayPayloads.addAll(payloads);
        }
    }

    public PmsProjectWbsServiceImpl(CacheUtil cacheUtil, PmsProjectWbsDAO pmsProjectWbsDAO, PmsWbsActCostDAO pmsWbsActCostDAO, PmsWbsActPayDAO pmsWbsActPayDAO, ComLogService logService, ComChangeService changeService, PmsProjectDAO pmsProjectDAO, ChangeFieldUtil changeFieldUtil, PmsProjectWbsSnapshotService planSnapshotService, PmsProjectCalendarService calendarService) {
        this.cacheUtil = cacheUtil;
        this.pmsProjectWbsDAO = pmsProjectWbsDAO;
        this.pmsWbsActCostDAO = pmsWbsActCostDAO;
        this.pmsWbsActPayDAO = pmsWbsActPayDAO;
        this.logService = logService;
        this.changeService = changeService;
        this.pmsProjectDAO = pmsProjectDAO;
        this.changeFieldUtil = changeFieldUtil;
        this.planSnapshotService = planSnapshotService;
        this.calendarService = calendarService;
    }
}

