/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.partner.common.payload.BookInvoicePayload;
import com.elitesland.tw.tw5.api.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.BookInvoiceDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBookInvoiceDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BookInvoiceRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BookInvoiceDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BookInvoiceRepo repo;
    private final QBookInvoiceDO qdo = QBookInvoiceDO.bookInvoiceDO;

    private JPAQuery<BookInvoiceVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BookInvoiceVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.bookId, this.qdo.invoiceMessage, this.qdo.invoiceTitle, this.qdo.taxRete, this.qdo.taxNo, this.qdo.invoiceType, this.qdo.invoiceAddress, this.qdo.invoicePhone, this.qdo.depositBank, this.qdo.invoiceAccount, this.qdo.currency, this.qdo.isDefault})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BookInvoiceVO> getJpaQueryWhere(BookInvoiceQuery query) {
        JPAQuery<BookInvoiceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        return jpaQuery;
    }

    public long count(BookInvoiceQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BookInvoiceQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookId())) {
            list.add(this.qdo.bookId.eq((Object)query.getBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceMessage())) {
            list.add(this.qdo.invoiceMessage.eq((Object)query.getInvoiceMessage()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceTitle())) {
            list.add(this.qdo.invoiceTitle.eq((Object)query.getInvoiceTitle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaxRete())) {
            list.add(this.qdo.taxRete.eq((Object)query.getTaxRete()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaxNo())) {
            list.add(this.qdo.taxNo.eq((Object)query.getTaxNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceType())) {
            list.add(this.qdo.invoiceType.eq((Object)query.getInvoiceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceAddress())) {
            list.add(this.qdo.invoiceAddress.eq((Object)query.getInvoiceAddress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoicePhone())) {
            list.add(this.qdo.invoicePhone.eq((Object)query.getInvoicePhone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDepositBank())) {
            list.add(this.qdo.depositBank.eq((Object)query.getDepositBank()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceAccount())) {
            list.add(this.qdo.invoiceAccount.eq((Object)query.getInvoiceAccount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrency())) {
            list.add(this.qdo.currency.eq((Object)query.getCurrency()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsDefault())) {
            list.add(this.qdo.isDefault.eq(query.getIsDefault()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BookInvoiceVO queryByKey(Long id) {
        JPAQuery<BookInvoiceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookInvoiceVO)jpaQuery.fetchFirst();
    }

    public BookInvoiceVO queryDefaultByBookId(Long bookId) {
        JPAQuery<BookInvoiceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.isDefault.eq(Boolean.TRUE));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookInvoiceVO)jpaQuery.fetchFirst();
    }

    public List<BookInvoiceVO> queryListDynamic(BookInvoiceQuery query) {
        JPAQuery<BookInvoiceVO> jpaQuery = this.getJpaQueryWhere(query);
        OrderItem sortNoOrderItem = OrderItem.desc((String)"isDefault");
        OrderItem createTimeOrderItem = OrderItem.desc((String)"createTime");
        ArrayList<OrderItem> OrderItemList = new ArrayList<OrderItem>();
        OrderItemList.add(sortNoOrderItem);
        OrderItemList.add(createTimeOrderItem);
        query.setOrders(OrderItemList);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery.fetch();
    }

    public PagingVO<BookInvoiceVO> queryPaging(BookInvoiceQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BookInvoiceVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BookInvoiceDO save(BookInvoiceDO ado) {
        return (BookInvoiceDO)this.repo.save(ado);
    }

    public List<BookInvoiceDO> saveAll(List<BookInvoiceDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BookInvoicePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getInvoiceMessage() != null) {
            update.set((Path)this.qdo.invoiceMessage, (Object)payload.getInvoiceMessage());
        }
        if (payload.getInvoiceTitle() != null) {
            update.set((Path)this.qdo.invoiceTitle, (Object)payload.getInvoiceTitle());
        }
        if (payload.getTaxRete() != null) {
            update.set((Path)this.qdo.taxRete, (Object)payload.getTaxRete());
        }
        if (payload.getTaxNo() != null) {
            update.set((Path)this.qdo.taxNo, (Object)payload.getTaxNo());
        }
        if (payload.getInvoiceType() != null) {
            update.set((Path)this.qdo.invoiceType, (Object)payload.getInvoiceType());
        }
        if (payload.getInvoiceAddress() != null) {
            update.set((Path)this.qdo.invoiceAddress, (Object)payload.getInvoiceAddress());
        }
        if (payload.getInvoicePhone() != null) {
            update.set((Path)this.qdo.invoicePhone, (Object)payload.getInvoicePhone());
        }
        if (payload.getDepositBank() != null) {
            update.set((Path)this.qdo.depositBank, (Object)payload.getDepositBank());
        }
        if (payload.getInvoiceAccount() != null) {
            update.set((Path)this.qdo.invoiceAccount, (Object)payload.getInvoiceAccount());
        }
        if (payload.getCurrency() != null) {
            update.set((Path)this.qdo.currency, (Object)payload.getCurrency());
        }
        if (payload.getIsDefault() != null) {
            update.set((Path)this.qdo.isDefault, (Object)payload.getIsDefault());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("invoiceMessage")) {
                update.setNull((Path)this.qdo.invoiceMessage);
            }
            if (nullFields.contains("invoiceTitle")) {
                update.setNull((Path)this.qdo.invoiceTitle);
            }
            if (nullFields.contains("taxRete")) {
                update.setNull((Path)this.qdo.taxRete);
            }
            if (nullFields.contains("taxNo")) {
                update.setNull((Path)this.qdo.taxNo);
            }
            if (nullFields.contains("invoiceType")) {
                update.setNull((Path)this.qdo.invoiceType);
            }
            if (nullFields.contains("invoiceAddress")) {
                update.setNull((Path)this.qdo.invoiceAddress);
            }
            if (nullFields.contains("invoicePhone")) {
                update.setNull((Path)this.qdo.invoicePhone);
            }
            if (nullFields.contains("depositBank")) {
                update.setNull((Path)this.qdo.depositBank);
            }
            if (nullFields.contains("invoiceAccount")) {
                update.setNull((Path)this.qdo.invoiceAccount);
            }
            if (nullFields.contains("currency")) {
                update.setNull((Path)this.qdo.currency);
            }
            if (nullFields.contains("isDefault")) {
                update.setNull((Path)this.qdo.isDefault);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BookInvoiceDO> queryByBookId(Long bookId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public BookInvoiceDAO(JPAQueryFactory jpaQueryFactory, BookInvoiceRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

