/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.partner.business.service.CrmBusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.payload.AddressBookPayload;
import com.elitesland.tw.tw5.api.partner.common.payload.BookAddressPayload;
import com.elitesland.tw.tw5.api.partner.common.payload.BookContactsPayload;
import com.elitesland.tw.tw5.api.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.partner.common.query.BookAddressQuery;
import com.elitesland.tw.tw5.api.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.partner.common.service.AddressBookService;
import com.elitesland.tw.tw5.api.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.vo.AddressBookVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerIdentityVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerTreeVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessDistributorInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessDistributorInfoService;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.BookAddressTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.common.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.common.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.common.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.CountryEnum;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.partner.common.dao.BusinessPartnerDAO;
import com.elitesland.tw.tw5.server.partner.common.entity.BusinessPartnerDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BusinessPartnerRepo;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessDistributorInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessCollaboratePartnerInfoRepo;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessDistributorInfoRepo;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessSupplierInfoRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationChanceQuery;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationPlanDetailQuery;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationChanceService;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationPlanDetailService;
import com.elitesland.tw.tw5crm.server.common.util.GeodesyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessPartnerServiceImpl
extends BaseServiceImpl
implements BusinessPartnerService {
    private static final Logger log = LoggerFactory.getLogger(BusinessPartnerServiceImpl.class);
    private final BusinessPartnerRepo businessPartnerRepo;
    private final BusinessPartnerDAO businessPartnerDAO;
    private final AddressBookService addressBookService;
    private final BookAddressService bookAddressService;
    private final BookContactsService bookContactsService;
    private final BookAccountService bookAccountService;
    private final BookInvoiceService bookInvoiceService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final GeodesyUtil geodesyUtil;
    private final BusinessTeamMemberService businessTeamMemberService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final BusinessSupplierInfoService businessSupplierInfoService;
    private final BusinessCollaboratePartnerInfoService businessCollaboratePartnerInfoService;
    private final BusinessDistributorInfoService businessDistributorInfoService;
    private final CacheUtil cacheUtil;
    private final BusinessCustomerOperationPlanDetailService businessCustomerOperationPlanDetailService;
    private final BusinessCustomerOperationChanceService businessCustomerOperationChanceService;
    private final BusinessCustomerInfoRepo businessCustomerInfoRepo;
    private final BusinessSupplierInfoRepo businessSupplierInfoRepo;
    private final BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo;
    private final BusinessDistributorInfoRepo businessDistributorInfoRepo;
    @Resource
    private CrmBusinessPartnerService crmBusinessPartnerService;

    public PagingVO<BusinessPartnerVO> queryPaging(BusinessPartnerQuery query) {
        PagingVO<BusinessPartnerVO> businessPartnerVOPagingVO = this.businessPartnerDAO.queryPaging(query);
        businessPartnerVOPagingVO.stream().forEach(businessPartnerVO -> this.translate((BusinessPartnerVO)businessPartnerVO));
        return businessPartnerVOPagingVO;
    }

    public long count(BusinessPartnerQuery query) {
        return this.businessPartnerDAO.count(query);
    }

    public List<BusinessPartnerVO> queryListDynamic(BusinessPartnerQuery query) {
        List<BusinessPartnerVO> businessPartnerVOList = this.businessPartnerDAO.queryListDynamic(query);
        businessPartnerVOList.stream().forEach(businessPartnerVO -> this.translate((BusinessPartnerVO)businessPartnerVO));
        return businessPartnerVOList;
    }

    public void judgePartnerName(String partnerName) {
        Long total = this.businessPartnerDAO.judgePartnerName(partnerName);
        if (total > 0L) {
            throw TwException.error((String)"", (String)"\u4e1a\u52a1\u4f19\u4f34\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
    }

    public List<BusinessPartnerVO> queryListByIds(List<Long> ids) {
        List<BusinessPartnerVO> vos = this.businessPartnerDAO.findByIds(ids);
        vos.stream().forEach(vo -> this.translate((BusinessPartnerVO)vo));
        return vos;
    }

    public BusinessPartnerIdentityVO judgeIdentityDisplay(Long partnerId) {
        BusinessPartnerIdentityVO.IdentityVO identityVO;
        BusinessPartnerDO entityDo = this.businessPartnerRepo.findById(partnerId).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entityDo.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerIdentityVO businessPartnerIdentityVO = new BusinessPartnerIdentityVO();
        ArrayList<BusinessPartnerIdentityVO.IdentityVO> IdentityVOList = new ArrayList<BusinessPartnerIdentityVO.IdentityVO>();
        Long bookId = entityDo.getBookId();
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(bookId);
        businessPartnerIdentityVO.setAccountCount(this.bookAccountService.count(bookAccountQuery));
        BookAddressQuery bookAddressQuery = new BookAddressQuery();
        bookAddressQuery.setBookId(bookId);
        businessPartnerIdentityVO.setAddressCount(this.bookAddressService.count(bookAddressQuery));
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(bookId);
        businessPartnerIdentityVO.setInvoiceCount(this.bookInvoiceService.count(bookInvoiceQuery));
        BookContactsQuery bookContactsQuery = new BookContactsQuery();
        bookContactsQuery.setBookId(bookId);
        businessPartnerIdentityVO.setContactCount(this.bookContactsService.count(bookContactsQuery));
        BusinessTeamMemberQuery businessTeamMemberQuery = new BusinessTeamMemberQuery();
        businessTeamMemberQuery.setObjectId(entityDo.getId());
        businessPartnerIdentityVO.setTeamCount(this.businessTeamMemberService.count(businessTeamMemberQuery));
        if (entityDo.getCustomerFlag().booleanValue() || this.businessCustomerInfoRepo.findByPartnerId(partnerId) != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u5ba2\u6237");
            identityVO.setValue("customer");
            if (entityDo.getCustomerFlag().booleanValue()) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
            long countBusiness = this.crmBusinessPartnerService.countBusiness(partnerId);
            businessPartnerIdentityVO.setBusinessCount(Long.valueOf(countBusiness));
            long countFollowList = this.crmBusinessPartnerService.countFollowList(partnerId);
            businessPartnerIdentityVO.setOperationCount(Long.valueOf(countFollowList));
            BusinessCustomerOperationPlanDetailQuery planQuery = new BusinessCustomerOperationPlanDetailQuery();
            planQuery.setPartnerId(partnerId);
            businessPartnerIdentityVO.setOperationPlanCount(this.businessCustomerOperationPlanDetailService.count(planQuery));
            BusinessCustomerOperationChanceQuery chanceQuery = new BusinessCustomerOperationChanceQuery();
            chanceQuery.setPartnerId(partnerId);
            businessPartnerIdentityVO.setOperationChanceCount(this.businessCustomerOperationChanceService.count(chanceQuery));
        }
        if (entityDo.getSupplierFlag().booleanValue() || this.businessSupplierInfoRepo.findByPartnerId(partnerId) != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u4f9b\u5e94\u5546");
            identityVO.setValue("supply");
            if (entityDo.getSupplierFlag().booleanValue()) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
        }
        if (entityDo.getDistributorFlag().booleanValue() || this.businessDistributorInfoRepo.findByPartnerId(partnerId) != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u7ecf\u9500\u5546");
            identityVO.setValue("dealer");
            if (entityDo.getDistributorFlag().booleanValue()) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
        }
        if (entityDo.getCollaborateFlag().booleanValue() || this.businessCollaboratePartnerInfoRepo.findByPartnerId(partnerId) != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u5408\u4f5c\u4f19\u4f34");
            identityVO.setValue("partner");
            if (entityDo.getCollaborateFlag().booleanValue()) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
        }
        businessPartnerIdentityVO.setOperation(IdentityVOList);
        return businessPartnerIdentityVO;
    }

    public List<BusinessPartnerTreeVO> listTree(BusinessPartnerQuery query) {
        List<BusinessPartnerVO> businessPartnerVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
            List businessPartnerTreeVOS = BusinessPartnerConvert.INSTANCE.voListVoTreeList(businessPartnerVOS);
            List<BusinessPartnerTreeVO> collection = this.treeDataSearch(businessPartnerTreeVOS);
            if (!CollectionUtils.isEmpty(collection)) {
                businessPartnerTreeVOS.addAll(collection);
            }
            businessPartnerTreeVOS = businessPartnerTreeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BusinessPartnerTreeVO>(Comparator.comparing(BusinessPartnerTreeVO::getId))), ArrayList::new));
            return businessPartnerTreeVOS;
        }
        return Collections.EMPTY_LIST;
    }

    private List<BusinessPartnerTreeVO> treeDataSearch(List<BusinessPartnerTreeVO> vos) {
        ArrayList<BusinessPartnerTreeVO> result = new ArrayList<BusinessPartnerTreeVO>();
        if (!CollectionUtils.isEmpty(vos)) {
            vos.forEach(crmCustomerOperationVO -> {
                Long parentId = crmCustomerOperationVO.getParentId();
                if (parentId != null) {
                    BusinessPartnerVO vo = this.queryByKey(parentId);
                    BusinessPartnerTreeVO treeVO = new BusinessPartnerTreeVO();
                    result.add(BusinessPartnerConvert.INSTANCE.voToTree(vo));
                }
            });
            if (!CollectionUtils.isEmpty(this.treeDataSearch(result))) {
                result.addAll(this.treeDataSearch(result));
            }
        }
        return result;
    }

    public List<BusinessPartnerSimpleVO> queryListSimple() {
        return this.businessPartnerDAO.queryListSimple();
    }

    public BusinessPartnerVO queryByKey(Long key) {
        BusinessPartnerDO entity = this.businessPartnerRepo.findById(key).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerVO vo = BusinessPartnerConvert.INSTANCE.toVo(entity);
        if (entity.getParentId() != null) {
            BusinessPartnerDO partnerDO = this.businessPartnerRepo.findById(entity.getParentId()).orElseGet(BusinessPartnerDO::new);
            vo.setParentIdDesc(partnerDO.getPartnerName());
        }
        this.translate(vo);
        return vo;
    }

    public BusinessPartnerSimpleVO queryByPartnerName(String partnerName) {
        return this.businessPartnerDAO.queryByPartnerName(partnerName);
    }

    public BusinessPartnerVO queryByKeySimple(Long key) {
        BusinessPartnerDO entity = this.businessPartnerRepo.findById(key).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerVO vo = BusinessPartnerConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO insert(BusinessPartnerPayload payload) {
        return this.insertPro(payload, true, true, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO insertPro(BusinessPartnerPayload payload, boolean checkPartnerNameFlag, boolean qixinFlag, boolean operationLogRecordFlag) {
        boolean qxbDataInitFlag;
        if (checkPartnerNameFlag) {
            this.judgePartnerName(payload.getPartnerName());
        }
        AddressBookVO addressBookVO = this.addressBookService.insert(new AddressBookPayload());
        payload.setBookId(addressBookVO.getId());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getBusinessPartnerNo())) {
            payload.setBusinessPartnerNo(this.generateSeqNum("BUSINESS_PARTNER", new String[0]));
        }
        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        Object identityDescLog = "";
        String[] identityArray = payload.getPartnerIdentity().split(",");
        List<String> identityList = Arrays.asList(identityArray);
        if (operationLogRecordFlag) {
            String identityDesc = this.translateIdentity(payload.getPartnerIdentity());
            identityDescLog = "\u8eab\u4efd \u521b\u5efa\u4e3a " + identityDesc + "\n";
        }
        entityDo.setCustomerFlag(false);
        entityDo.setSupplierFlag(false);
        entityDo.setCollaborateFlag(false);
        entityDo.setDistributorFlag(false);
        if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
            entityDo.setCustomerFlag(true);
        }
        if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
            entityDo.setSupplierFlag(true);
        }
        if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
            entityDo.setCollaborateFlag(true);
        }
        if (identityList.contains(BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode())) {
            entityDo.setDistributorFlag(true);
        }
        BusinessPartnerDO save = (BusinessPartnerDO)this.businessPartnerRepo.save(entityDo);
        Long id = save.getId();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getProvince()) || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getDetailAddress())) {
            BookAddressPayload bookAddressPayload = new BookAddressPayload();
            bookAddressPayload.setBookId(addressBookVO.getId());
            bookAddressPayload.setDetailAddress(payload.getDetailAddress());
            bookAddressPayload.setCountry(payload.getCountry());
            bookAddressPayload.setProvince(payload.getProvince());
            bookAddressPayload.setProvinceName(payload.getProvinceName());
            bookAddressPayload.setCity(payload.getCity());
            bookAddressPayload.setCityName(payload.getCityName());
            bookAddressPayload.setDistrict(payload.getDistrict());
            bookAddressPayload.setDistrictName(payload.getDistrictName());
            bookAddressPayload.setIsDefault(Boolean.valueOf(true));
            bookAddressPayload.setAddressType(BookAddressTypeEnum.company_addr.getCode());
            bookAddressPayload.setCountry(CountryEnum.CHINA.getCode());
            bookAddressPayload.setPartnerId(id);
            bookAddressPayload.setLongitudeLatitude(payload.getLongitudeLatitude());
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getDetailAddress()) && ObjectUtils.isEmpty((Object)payload.getLongitudeLatitude())) {
                String longitudeAndLatitude = this.geodesyUtil.getLongitudeAndLatitudeByAddress(payload.getDetailAddress());
                bookAddressPayload.setLongitudeLatitude(longitudeAndLatitude);
            }
            this.bookAddressService.insert(bookAddressPayload, Boolean.valueOf(true));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getContactsName()) || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getContactsPhone())) {
            BookContactsPayload bookContactsPayload = new BookContactsPayload();
            bookContactsPayload.setBookId(addressBookVO.getId());
            bookContactsPayload.setContactsName(payload.getContactsName());
            bookContactsPayload.setContactsPhone(payload.getContactsPhone());
            bookContactsPayload.setContactsPosition(payload.getContactsPosition());
            bookContactsPayload.setContactsDepartment(payload.getContactsDepartment());
            bookContactsPayload.setIsDefault(Boolean.valueOf(true));
            this.bookContactsService.insert(bookContactsPayload, Boolean.valueOf(true));
        }
        Long createUserId = null != payload.getCreateUserId() ? payload.getCreateUserId() : GlobalUtil.getLoginUserId();
        String userName = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getCreator()) ? payload.getCreator() : GlobalUtil.getLoginUser().getUsername();
        Long orgId = this.cacheUtil.getDefaultOrgIdByUserId(createUserId);
        BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
        businessTeamMemberPayload.setUserId(createUserId);
        businessTeamMemberPayload.setMemberName(userName);
        businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.BASE.getCode());
        businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.BASE.getDesc());
        businessTeamMemberPayload.setObjectId(id);
        businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
        businessTeamMemberPayload.setIsCreator(Boolean.valueOf(true));
        businessTeamMemberPayload.setSortNo(Integer.valueOf(1));
        businessTeamMemberPayload.setOrgId(orgId);
        this.businessTeamMemberService.save(businessTeamMemberPayload);
        Long formCustomerId = null;
        if (entityDo.getCustomerFlag().booleanValue()) {
            BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
            businessCustomerInfoPayload.setPartnerId(id);
            String customerStatus = BusinessPartnerStatusEnum.CREATE.getCode();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getCustomerStatus())) {
                customerStatus = payload.getCustomerStatus();
            }
            businessCustomerInfoPayload.setCustomerStatus(customerStatus);
            businessCustomerInfoPayload.setCustomerGradle(payload.getCustomerGradle());
            businessCustomerInfoPayload.setCustomerRegion(payload.getCustomerRegion());
            businessCustomerInfoPayload.setIsOperate(Boolean.valueOf(false));
            businessCustomerInfoPayload.setArea(payload.getArea());
            businessCustomerInfoPayload.setBranchCode(payload.getBranchCode());
            BusinessCustomerInfoVO businessCustomerInfoVO = this.businessCustomerInfoService.insert(businessCustomerInfoPayload);
            formCustomerId = businessCustomerInfoVO.getId();
        }
        if (entityDo.getSupplierFlag().booleanValue()) {
            BusinessSupplierInfoPayload businessSupplierInfoPayload = new BusinessSupplierInfoPayload();
            businessSupplierInfoPayload.setPartnerId(id);
            businessSupplierInfoPayload.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
            this.businessSupplierInfoService.insert(businessSupplierInfoPayload);
        }
        if (entityDo.getDistributorFlag().booleanValue()) {
            BusinessDistributorInfoPayload businessDistributorInfoPayload = new BusinessDistributorInfoPayload();
            businessDistributorInfoPayload.setDealerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
            businessDistributorInfoPayload.setPartnerId(id);
            this.businessDistributorInfoService.insert(businessDistributorInfoPayload);
        }
        if (entityDo.getCollaborateFlag().booleanValue()) {
            BusinessCollaboratePartnerInfoPayload businessCollaboratePartnerInfoPayload = new BusinessCollaboratePartnerInfoPayload();
            businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
            businessCollaboratePartnerInfoPayload.setPartnerId(id);
            this.businessCollaboratePartnerInfoService.insert(businessCollaboratePartnerInfoPayload);
        }
        if (operationLogRecordFlag) {
            String fieldsCreateLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo);
            this.logService.saveNewLog(id, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), (String)identityDescLog + fieldsCreateLog);
        }
        if (qixinFlag && (qxbDataInitFlag = this.crmBusinessPartnerService.fillQxbInfo(save.getPartnerName(), save.getId().longValue(), save.getBookId()))) {
            save.setQxbDataInitFlag(true);
        }
        BusinessPartnerVO businessPartnerVO = BusinessPartnerConvert.INSTANCE.toVo(save);
        if (formCustomerId != null) {
            businessPartnerVO.setFormalCustomerId(formCustomerId);
        }
        return businessPartnerVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO update(BusinessPartnerPayload payload) {
        boolean qxbDataInitFlag;
        boolean qxbDataInitFlagDb;
        BusinessPartnerDO entity = this.businessPartnerRepo.findById(payload.getId()).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerDO entityLog = new BusinessPartnerDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payload.getPartnerIdentity())) {
            String[] identityArray = payload.getPartnerIdentity().split(",");
            List<String> identityList = Arrays.asList(identityArray);
            entityDo.setCustomerFlag(false);
            entityDo.setSupplierFlag(false);
            entityDo.setCollaborateFlag(false);
            entityDo.setDistributorFlag(false);
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                entityDo.setCustomerFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                entityDo.setSupplierFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                entityDo.setCollaborateFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode())) {
                entityDo.setDistributorFlag(true);
            }
            Long id = entityDo.getId();
            BusinessCustomerInfoDO BusinessCustomerInfoDO2 = this.businessCustomerInfoRepo.findByPartnerId(id);
            if (entityDo.getCustomerFlag().booleanValue()) {
                if (BusinessCustomerInfoDO2 != null) {
                    BusinessCustomerInfoDO2.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessCustomerInfoRepo.save(BusinessCustomerInfoDO2);
                } else {
                    BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                    businessCustomerInfoPayload.setPartnerId(id);
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCustomerInfoPayload.setIsOperate(Boolean.valueOf(false));
                    businessCustomerInfoPayload.setCustomerGradle(payload.getCustomerGradle());
                    businessCustomerInfoPayload.setCustomerRegion(payload.getCustomerRegion());
                    businessCustomerInfoPayload.setArea(payload.getArea());
                    businessCustomerInfoPayload.setBranchCode(payload.getBranchCode());
                    this.businessCustomerInfoService.insert(businessCustomerInfoPayload);
                }
            } else {
                if (BusinessCustomerInfoDO2 != null) {
                    BusinessCustomerInfoDO2.setCustomerStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    this.businessCustomerInfoRepo.save(BusinessCustomerInfoDO2);
                }
                if (entity.getCustomerFlag().booleanValue()) {
                    this.businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                }
            }
            BusinessSupplierInfoDO supplierInfoDO = this.businessSupplierInfoRepo.findByPartnerId(id);
            if (entityDo.getSupplierFlag().booleanValue()) {
                if (supplierInfoDO != null) {
                    supplierInfoDO.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessSupplierInfoRepo.save(supplierInfoDO);
                } else {
                    BusinessSupplierInfoPayload businessSupplierInfoPayload = new BusinessSupplierInfoPayload();
                    businessSupplierInfoPayload.setPartnerId(id);
                    businessSupplierInfoPayload.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessSupplierInfoService.insert(businessSupplierInfoPayload);
                }
            } else {
                if (supplierInfoDO != null) {
                    supplierInfoDO.setSupplierStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    this.businessSupplierInfoRepo.save(supplierInfoDO);
                }
                if (entity.getSupplierFlag().booleanValue()) {
                    this.businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.SUPPLIER.getCode());
                }
            }
            BusinessDistributorInfoDO distributorInfoDO = this.businessDistributorInfoRepo.findByPartnerId(id);
            if (entityDo.getDistributorFlag().booleanValue()) {
                if (distributorInfoDO != null) {
                    distributorInfoDO.setDealerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessDistributorInfoRepo.save(distributorInfoDO);
                } else {
                    BusinessDistributorInfoPayload businessDistributorInfoPayload = new BusinessDistributorInfoPayload();
                    businessDistributorInfoPayload.setDealerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessDistributorInfoPayload.setPartnerId(id);
                    this.businessDistributorInfoService.insert(businessDistributorInfoPayload);
                }
            } else {
                if (distributorInfoDO != null) {
                    distributorInfoDO.setDealerStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    this.businessDistributorInfoRepo.save(distributorInfoDO);
                }
                if (entity.getDistributorFlag().booleanValue() && !entityDo.getCollaborateFlag().booleanValue()) {
                    this.businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode());
                }
            }
            BusinessCollaboratePartnerInfoDO collaboratePartnerInfoDO = this.businessCollaboratePartnerInfoRepo.findByPartnerId(id);
            if (entityDo.getCollaborateFlag().booleanValue()) {
                if (collaboratePartnerInfoDO != null) {
                    collaboratePartnerInfoDO.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessCollaboratePartnerInfoRepo.save(collaboratePartnerInfoDO);
                } else {
                    BusinessCollaboratePartnerInfoPayload businessCollaboratePartnerInfoPayload = new BusinessCollaboratePartnerInfoPayload();
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCollaboratePartnerInfoPayload.setPartnerId(id);
                    this.businessCollaboratePartnerInfoService.insert(businessCollaboratePartnerInfoPayload);
                }
            } else {
                if (collaboratePartnerInfoDO != null) {
                    collaboratePartnerInfoDO.setCollaborateStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    this.businessCollaboratePartnerInfoRepo.save(collaboratePartnerInfoDO);
                }
                if (entity.getCollaborateFlag().booleanValue() && entityDo.getDistributorFlag().booleanValue()) {
                    this.businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.COLLABORATE.getCode());
                }
            }
        }
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        BusinessPartnerDO save = (BusinessPartnerDO)this.businessPartnerRepo.save(entity);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
        }
        boolean bl = qxbDataInitFlagDb = null == entity.getQxbDataInitFlag() || null != entity.getQxbDataInitFlag() && entity.getQxbDataInitFlag() == false;
        if (StringUtils.hasText((String)payload.getPartnerName()) && qxbDataInitFlagDb && (qxbDataInitFlag = this.crmBusinessPartnerService.fillQxbInfo(save.getPartnerName(), save.getId().longValue(), save.getBookId()))) {
            save.setQxbDataInitFlag(true);
        }
        return BusinessPartnerConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessPartnerRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessPartnerDO entity = (BusinessPartnerDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessPartnerRepo.save(entity);
                }
            });
        }
    }

    private void translate(BusinessPartnerVO businessPartnerVO) {
        List businessTeamMemberVOS;
        String identity = businessPartnerVO.getPartnerIdentity();
        businessPartnerVO.setPartnerIdentityDesc(this.translateIdentity(identity));
        StringBuilder str = new StringBuilder();
        if (businessPartnerVO.getProvinceName() != null) {
            str.append(businessPartnerVO.getProvinceName() + "/");
        }
        if (businessPartnerVO.getCityName() != null) {
            str.append(businessPartnerVO.getCityName() + "/");
        }
        if (businessPartnerVO.getDistrictName() != null) {
            str.append(businessPartnerVO.getDistrictName());
        }
        businessPartnerVO.setAddress(str.toString());
        if (identity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode()) && (businessTeamMemberVOS = this.businessTeamMemberService.queryByObjectIdAndRole(businessPartnerVO.getId(), BusinessTeamRoleEnum.SALE_MANAGER.getCode())) != null && businessTeamMemberVOS.size() > 0) {
            StringBuilder saleDutyIdStr = new StringBuilder();
            StringBuilder saleDutyIdDescStr = new StringBuilder();
            for (int i = 0; i < businessTeamMemberVOS.size(); ++i) {
                if (i == businessTeamMemberVOS.size() - 1) {
                    saleDutyIdStr.append(((BusinessTeamMemberVO)businessTeamMemberVOS.get(i)).getUserId());
                    saleDutyIdDescStr.append(this.cacheUtil.getUserName(((BusinessTeamMemberVO)businessTeamMemberVOS.get(i)).getUserId()));
                    continue;
                }
                saleDutyIdStr.append(((BusinessTeamMemberVO)businessTeamMemberVOS.get(i)).getUserId() + ",");
                saleDutyIdDescStr.append(this.cacheUtil.getUserName(((BusinessTeamMemberVO)businessTeamMemberVOS.get(i)).getUserId()) + ",");
            }
            businessPartnerVO.setSaleDutyId(saleDutyIdStr.toString());
            businessPartnerVO.setSaleDutyIdDesc(saleDutyIdDescStr.toString());
        }
    }

    private String translateIdentity(String identity) {
        String[] identityArray = identity.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < identityArray.length; ++i) {
            if (i == identityArray.length - 1) {
                stringBuilder.append(BusinessPartnerIdentityEnum.valueOf((String)identityArray[i]).getDesc());
                continue;
            }
            stringBuilder.append(BusinessPartnerIdentityEnum.valueOf((String)identityArray[i]).getDesc() + ",");
        }
        return stringBuilder.toString();
    }

    public long saleCount(BusinessPartnerQuery query) {
        return this.businessPartnerDAO.saleCount(query);
    }

    public List<BusinessPartnerVO> listForDm(List<String> partnerNameList) {
        List<BusinessPartnerVO> list = this.businessPartnerDAO.listForDm(partnerNameList);
        return list;
    }

    public BusinessPartnerServiceImpl(BusinessPartnerRepo businessPartnerRepo, BusinessPartnerDAO businessPartnerDAO, AddressBookService addressBookService, BookAddressService bookAddressService, BookContactsService bookContactsService, BookAccountService bookAccountService, BookInvoiceService bookInvoiceService, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, GeodesyUtil geodesyUtil, BusinessTeamMemberService businessTeamMemberService, BusinessCustomerInfoService businessCustomerInfoService, BusinessSupplierInfoService businessSupplierInfoService, BusinessCollaboratePartnerInfoService businessCollaboratePartnerInfoService, BusinessDistributorInfoService businessDistributorInfoService, CacheUtil cacheUtil, BusinessCustomerOperationPlanDetailService businessCustomerOperationPlanDetailService, BusinessCustomerOperationChanceService businessCustomerOperationChanceService, BusinessCustomerInfoRepo businessCustomerInfoRepo, BusinessSupplierInfoRepo businessSupplierInfoRepo, BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo, BusinessDistributorInfoRepo businessDistributorInfoRepo) {
        this.businessPartnerRepo = businessPartnerRepo;
        this.businessPartnerDAO = businessPartnerDAO;
        this.addressBookService = addressBookService;
        this.bookAddressService = bookAddressService;
        this.bookContactsService = bookContactsService;
        this.bookAccountService = bookAccountService;
        this.bookInvoiceService = bookInvoiceService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.geodesyUtil = geodesyUtil;
        this.businessTeamMemberService = businessTeamMemberService;
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.businessSupplierInfoService = businessSupplierInfoService;
        this.businessCollaboratePartnerInfoService = businessCollaboratePartnerInfoService;
        this.businessDistributorInfoService = businessDistributorInfoService;
        this.cacheUtil = cacheUtil;
        this.businessCustomerOperationPlanDetailService = businessCustomerOperationPlanDetailService;
        this.businessCustomerOperationChanceService = businessCustomerOperationChanceService;
        this.businessCustomerInfoRepo = businessCustomerInfoRepo;
        this.businessSupplierInfoRepo = businessSupplierInfoRepo;
        this.businessCollaboratePartnerInfoRepo = businessCollaboratePartnerInfoRepo;
        this.businessDistributorInfoRepo = businessDistributorInfoRepo;
    }
}

