/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActReportVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActDynamicDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActReportDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActDynamicDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActReportDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActActivityRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActDynamicRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActReportRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectMemberDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmActActivityDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmActActivityRepo repo;
    private final CrmActDynamicRepo repoDyn;
    private final CrmActReportRepo repoReport;
    private final QCrmActActivityDO qdo = QCrmActActivityDO.crmActActivityDO;
    private final QCrmActDynamicDO qdoDyn = QCrmActDynamicDO.crmActDynamicDO;
    private final QCrmOpportunityDO qdoOppo = QCrmOpportunityDO.crmOpportunityDO;
    private final QCrmActReportDO qdoReport = QCrmActReportDO.crmActReportDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QCrmActPlanDO qdoPlan = QCrmActPlanDO.crmActPlanDO;
    private final QCrmActPlanDetailDO qdoDetail = QCrmActPlanDetailDO.crmActPlanDetailDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrjProjectMemberDO qdoMember = QPrjProjectMemberDO.prjProjectMemberDO;

    public CrmActActivityDO save(CrmActActivityDO ado) {
        return (CrmActActivityDO)this.repo.save(ado);
    }

    public void updataReleaseByIds(List<Long> ids, Integer isRelease) {
        this.repo.updataReleaseByIds(ids, isRelease);
    }

    public CrmActDynamicDO saveDynamic(CrmActDynamicDO ado) {
        return (CrmActDynamicDO)((Object)this.repoDyn.save((Object)ado));
    }

    public CrmActReportDO saveReport(CrmActReportDO ado) {
        return (CrmActReportDO)((Object)this.repoReport.save((Object)ado));
    }

    @Transactional
    public long updateReportyKeyDynamic(CrmActReportPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoReport).where(new Predicate[]{this.qdoReport.id.eq((Object)payload.getId())});
        if (payload.getReportStatus() != null) {
            update.set((Path)this.qdoReport.reportStatus, (Object)payload.getReportStatus());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdoReport.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdoReport.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdoReport.approvedTime, (Object)payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(this.qdoReport.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdoReport.procInstId, (Object)payload.getProcInstId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdoReport.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdoReport.procInstId);
            }
        }
        return update.execute();
    }

    public List<CrmActActivityDO> queryActivityByDetailId(Long detailId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.detailId.eq((Object)detailId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<CrmActActivityVO> findActivityUnReleases() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActActivityVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdoProject.projectNo, this.qdoProject.projectName, this.qdoProject.createUserId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdo.projectId.eq((Expression)this.qdoProject.id));
        ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdoProject.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.procInstStatus.eq((Object)ProcInstStatus.APPROVED));
        ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdo.isRelease.eq((Object)0))).where((Predicate)this.qdo.approvedTime.loe((Comparable)LocalDateTime.now().minusDays(3L)))).where((Predicate)this.qdo.isEmailRemind.isNull().or((Predicate)this.qdo.isEmailRemind.eq((Object)0)));
        return jpaQuery.fetch();
    }

    public QueryResults<CrmActActivityDO> findActivityReleaseByUserId(Long userId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)userId))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.procInstStatus.eq((Object)ProcInstStatus.APPROVED));
        ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdo.isRelease.eq((Object)0))).orderBy(this.qdo.approvedTime.asc())).limit(1L);
        return jpaQuery.fetchResults();
    }

    public CrmActActivityDO queryActivityByKey(Long key) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        return (CrmActActivityDO)jpaQuery.fetchFirst();
    }

    public long updatePlanDetail(Long detailId, BigDecimal expenditure) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoDetail).set(this.qdoDetail.expenditure, (Object)expenditure).where(new Predicate[]{this.qdoDetail.id.eq((Object)detailId)});
        return update.execute();
    }

    public long updateEmailRemind(List<Long> ids) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.isEmailRemind, (Object)1).where(new Predicate[]{this.qdo.id.in(ids)});
        return update.execute();
    }

    @Transactional
    public long updateProjectByKeyDynamic(CrmActActivityPayload payload, Long projectId) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoProject).where(new Predicate[]{this.qdoProject.id.eq((Object)projectId)});
        if (payload.getProjectName() != null) {
            update.set((Path)this.qdoProject.projectName, (Object)payload.getProjectName());
        }
        if (payload.getStartTime() != null) {
            update.set((Path)this.qdoProject.startTime, (Object)payload.getStartTime());
        }
        if (payload.getEndTime() != null) {
            update.set((Path)this.qdoProject.endTime, (Object)payload.getEndTime());
        }
        if (payload.getManageUserId() != null) {
            update.set((Path)this.qdoProject.manageUserId, (Object)payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set((Path)this.qdoProject.orgId, (Object)payload.getOrgId());
        }
        if (payload.getCompanyId() != null) {
            update.set((Path)this.qdoProject.companyId, (Object)payload.getCompanyId());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdoProject.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getCloseReason() != null) {
            update.set((Path)this.qdoProject.closeReason, (Object)payload.getCloseReason());
        }
        if (payload.getClsoeRemark() != null) {
            update.set((Path)this.qdoProject.clsoeRemark, (Object)payload.getClsoeRemark());
        }
        if (payload.getProjectStatus() != null) {
            update.set((Path)this.qdoProject.projectStatus, (Object)payload.getProjectStatus());
        }
        if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
            // empty if block
        }
        return update.execute();
    }

    public long updateDynamic(CrmActDynamicPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoDyn).where(new Predicate[]{this.qdoDyn.id.eq((Object)payload.getId())});
        if (payload.getDynamicContent() != null) {
            update.set((Path)this.qdoDyn.dynamicContent, (Object)payload.getDynamicContent());
        }
        if (payload.getDynamicType() != null) {
            update.set((Path)this.qdoDyn.dynamicType, (Object)payload.getDynamicType());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdoDyn.fileCodes, (Object)payload.getFileCodes());
        }
        return update.execute();
    }

    @Transactional
    public long updateActivityByKeyDynamic(CrmActActivityPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getPlanId() != null) {
            update.set(this.qdo.planId, (Object)payload.getPlanId());
        }
        if (payload.getDetailId() != null) {
            update.set(this.qdo.detailId, (Object)payload.getDetailId());
        }
        if (payload.getActivityScale() != null) {
            update.set((Path)this.qdo.activityScale, (Object)payload.getActivityScale());
        }
        if (payload.getActivityAddr() != null) {
            update.set((Path)this.qdo.activityAddr, (Object)payload.getActivityAddr());
        }
        if (payload.getActivityTarget() != null) {
            update.set((Path)this.qdo.activityTarget, (Object)payload.getActivityTarget());
        }
        if (payload.getPersonNum() != null) {
            update.set(this.qdo.personNum, (Object)payload.getPersonNum());
        }
        if (payload.getPersonMoney() != null) {
            update.set(this.qdo.personMoney, (Object)payload.getPersonMoney());
        }
        if (payload.getPersonSource() != null) {
            update.set((Path)this.qdo.personSource, (Object)payload.getPersonSource());
        }
        if (payload.getClaimMoney() != null) {
            update.set(this.qdo.claimMoney, (Object)payload.getClaimMoney());
        }
        if (payload.getPurchaseMoney() != null) {
            update.set(this.qdo.purchaseMoney, (Object)payload.getPurchaseMoney());
        }
        if (payload.getSundryMoney() != null) {
            update.set(this.qdo.sundryMoney, (Object)payload.getSundryMoney());
        }
        if (payload.getBudgetMoney() != null) {
            update.set(this.qdo.budgetMoney, (Object)payload.getBudgetMoney());
        }
        if (payload.getTotalMoney() != null) {
            update.set(this.qdo.totalMoney, (Object)payload.getTotalMoney());
        }
        if (payload.getPotentialCustomer() != null) {
            update.set(this.qdo.potentialCustomer, (Object)payload.getPotentialCustomer());
        }
        if (payload.getLeadNum() != null) {
            update.set(this.qdo.leadNum, (Object)payload.getLeadNum());
        }
        if (payload.getBusOps() != null) {
            update.set(this.qdo.busOps, (Object)payload.getBusOps());
        }
        if (payload.getPipeline() != null) {
            update.set(this.qdo.pipeline, (Object)payload.getPipeline());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcDefKey() != null) {
            update.set((Path)this.qdo.procDefKey, (Object)payload.getProcDefKey());
        }
        if (payload.getIsRelease() != null) {
            update.set(this.qdo.isRelease, (Object)payload.getIsRelease());
        }
        if (payload.getActivityType() != null) {
            update.set((Path)this.qdo.activityType, (Object)payload.getActivityType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("planId")) {
                update.setNull(this.qdo.planId).setNull(this.qdo.detailId);
            }
            if (nullFields.contains("activityType")) {
                update.setNull((Path)this.qdo.activityType);
            }
        }
        return update.execute();
    }

    private JPAQuery<CrmActReportVO> getJpaQuerySelectReport() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActReportVO.class, (Expression[])new Expression[]{this.qdoReport.id, this.qdoReport.actId, this.qdoReport.personNum, this.qdoReport.personMoney, this.qdoReport.claimMoney, this.qdoReport.purchaseMoney, this.qdoReport.sundryMoney, this.qdoReport.totalMoney, this.qdoReport.potentialCustomer, this.qdoReport.leadNum, this.qdoReport.busOps, this.qdoReport.pipeline, this.qdoReport.reportContent, this.qdoReport.reportNo, this.qdo.projectId, this.qdoProject.projectName, this.qdoProject.startTime, this.qdoProject.endTime, this.qdoProject.projectNo, this.qdoProject.projectStatus, this.qdo.personNum.as("budPersonNum"), this.qdo.personMoney.as("budPersonMoney"), this.qdo.claimMoney.as("budClaimMoney"), this.qdo.purchaseMoney.as("budPurchaseMoney"), this.qdo.sundryMoney.as("budSundryMoney"), this.qdo.totalMoney.as("budTotalMoney"), this.qdo.potentialCustomer.as("budPotentialCustomer"), this.qdo.leadNum.as("budLeadNum"), this.qdo.busOps.as("budBusOps"), this.qdo.pipeline.as("budPipeline"), this.qdoEmployee.employeeName, this.qdoReport.createUserId, this.qdoReport.creator, this.qdoReport.createTime, this.qdoReport.createTime, this.qdoReport.procInstId, this.qdoReport.procInstStatus, this.qdoReport.submitTime, this.qdoReport.approvedTime, this.qdoReport.reportStatus})).from((EntityPath)this.qdoReport)).leftJoin((EntityPath)this.qdo)).on((Predicate)this.qdo.id.longValue().eq((Expression)this.qdoReport.actId.longValue()))).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()))).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoReport.createUserId.eq((Expression)this.qdoEmployee.userId));
        return jpaQuery;
    }

    public List<CrmActReportVO> queryActReportList(Long actId, Integer reportType) {
        JPAQuery<CrmActReportVO> jpaQuery = this.getJpaQuerySelectReport();
        jpaQuery.where((Predicate)this.qdoReport.actId.eq((Object)actId));
        jpaQuery.where((Predicate)this.qdoReport.reportType.eq((Object)reportType));
        jpaQuery.orderBy(this.qdoReport.createTime.desc());
        return jpaQuery.fetch();
    }

    public CrmActReportVO queryActReportDetail(Long key) {
        JPAQuery<CrmActReportVO> jpaQuery = this.getJpaQuerySelectReport();
        jpaQuery.where((Predicate)this.qdoReport.id.eq((Object)key));
        return (CrmActReportVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<CrmActReportVO> getJpaQuerySelectData() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActReportVO.class, (Expression[])new Expression[]{this.qdo.id.as("actId"), this.qdo.projectId, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.startTime, this.qdoProject.endTime, this.qdoProject.projectStatus, this.qdo.personNum.as("budPersonNum"), this.qdo.personMoney.as("budPersonMoney"), this.qdo.claimMoney.as("budClaimMoney"), this.qdo.purchaseMoney.as("budPurchaseMoney"), this.qdo.sundryMoney.as("budSundryMoney"), this.qdo.totalMoney.as("budTotalMoney"), this.qdo.potentialCustomer.as("budPotentialCustomer"), this.qdo.leadNum.as("budLeadNum"), this.qdo.busOps.as("budBusOps"), this.qdo.pipeline.as("budPipeline")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()));
        return jpaQuery;
    }

    public CrmActReportVO queryActReportData(Long key) {
        JPAQuery<CrmActReportVO> jpaQuery = this.getJpaQuerySelectData();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmActReportVO)jpaQuery.fetchFirst();
    }

    public long queryOppoCount(Long key) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoOppo).from((EntityPath)this.qdoOppo);
        jpaQuery.where((Predicate)this.qdoOppo.actId.eq((Object)key));
        jpaQuery.where((Predicate)this.qdoOppo.deleteFlag.eq((Object)0));
        return jpaQuery.fetchCount();
    }

    private JPAQuery<CrmActActivityVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActActivityVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectId, this.qdo.planId, this.qdoPlan.planName, this.qdo.detailId, this.qdoDetail.detailType, this.qdo.activityType, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.startTime, this.qdoProject.endTime, this.qdoProject.orgId, this.qdoOrg.orgName, this.qdoProject.manageUserId, this.qdoProject.companyId, this.qdoProject.fileCodes, this.qdoProject.projectStatus, this.qdoProject.closeReason, this.qdoProject.clsoeRemark, this.qdo.activityScale, this.qdo.activityAddr, this.qdoDetail.totalMoney.as("planDetailTotalMoney"), this.qdoDetail.expenditure, this.qdo.activityTarget, this.qdo.personNum, this.qdo.personMoney, this.qdo.personSource, this.qdo.claimMoney, this.qdo.purchaseMoney, this.qdo.sundryMoney, this.qdo.budgetMoney, this.qdo.totalMoney, this.qdo.potentialCustomer, this.qdo.leadNum, this.qdo.busOps, this.qdo.pipeline, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.createTime, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.procDefKey, this.qdo.submitTime, this.qdo.approvedTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()))).leftJoin((EntityPath)this.qdoPlan)).on((Predicate)this.qdoPlan.id.longValue().eq((Expression)this.qdo.planId.longValue()))).leftJoin((EntityPath)this.qdoDetail)).on((Predicate)this.qdoDetail.id.longValue().eq((Expression)this.qdo.detailId.longValue()))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoProject.orgId.longValue()))).leftJoin((EntityPath)this.qdoMember)).on((Predicate)this.qdoMember.projectId.longValue().eq((Expression)this.qdoProject.id.longValue()));
        return jpaQuery;
    }

    public CrmActActivityVO queryBykey(Long key) {
        JPAQuery<CrmActActivityVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmActActivityVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<CrmActProjectVO> getJpaQuerySelectProject() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActProjectVO.class, (Expression[])new Expression[]{this.qdoProject.id, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.manageUserId, this.qdoProject.projectStatus, this.qdoProject.closeReason, this.qdoEmployee.employeeName.as("manageUserName"), this.qdo.detailId, this.qdo.totalMoney, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()))).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoEmployee.userId.longValue().eq((Expression)this.qdoProject.manageUserId.longValue()));
        return jpaQuery;
    }

    public CrmActProjectVO queryProjectBykey(Long key) {
        JPAQuery<CrmActProjectVO> jpaQuery = this.getJpaQuerySelectProject();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        return (CrmActProjectVO)jpaQuery.fetchFirst();
    }

    public List<CrmActProjectVO> queryList(Long planId) {
        JPAQuery<CrmActProjectVO> jpaQuery = this.getJpaQuerySelectProject();
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        if (planId != null) {
            jpaQuery.where((Predicate)this.qdo.planId.eq((Object)planId));
        } else {
            jpaQuery.where((Predicate)this.qdoProject.projectStatus.eq((Object)WorkFlowStatusEnum.APPROVED_WORK.getCode()).or((Predicate)this.qdoProject.projectStatus.eq((Object)WorkFlowStatusEnum.CLOSED_WORK.getCode())));
        }
        return jpaQuery.fetch();
    }

    private JPAQuery<CrmActActivityVO> getJpaQueryWhere(CrmActActivityQuery query, List<Long> actUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmActActivityVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object[])query.getActivityIds())) {
            jpaQuery.where((Predicate)this.qdo.id.in((Object[])query.getActivityIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanId())) {
            jpaQuery.where((Predicate)this.qdo.planId.eq((Object)query.getPlanId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDetailId())) {
            jpaQuery.where((Predicate)this.qdo.detailId.eq((Object)query.getDetailId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectName())) {
            jpaQuery.where((Predicate)this.qdoProject.projectName.like(SqlUtil.toSqlLikeString((String)query.getProjectName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoProject.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectNo())) {
            jpaQuery.where((Predicate)this.qdoProject.projectNo.eq((Object)query.getProjectNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectTime())) {
            jpaQuery.where((Predicate)this.qdoProject.startTime.loe((Comparable)query.getProjectTime()));
            jpaQuery.where((Predicate)this.qdoProject.endTime.goe((Comparable)query.getProjectTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageUserId())) {
            jpaQuery.where((Predicate)this.qdoProject.manageUserId.eq((Object)query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectStatus())) {
            jpaQuery.where((Predicate)this.qdoProject.projectStatus.eq((Object)query.getProjectStatus()));
        }
        if (actUserIds != null && !actUserIds.isEmpty()) {
            jpaQuery.where((Predicate)this.qdoMember.userId.in(actUserIds).or((Predicate)this.qdoProject.orgId.in(orgManageIds)));
            jpaQuery.where((Predicate)this.qdoMember.deleteFlag.eq((Object)0));
        }
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        jpaQuery.groupBy((Expression)this.qdoProject.id);
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public PagingVO<CrmActActivityVO> queryPagingUnReleased(CrmActActivityQuery query) {
        JPAQuery<CrmActActivityVO> jpaQuery = this.getJpaQuerySelect();
        ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId()))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.procInstStatus.eq((Object)ProcInstStatus.APPROVED));
        jpaQuery.where((Predicate)this.qdo.isRelease.eq((Object)0));
        QueryResults result = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.groupBy(this.qdo.id)).offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public PagingVO<CrmActActivityVO> queryPaging(CrmActActivityQuery query, List<Long> actUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmActActivityVO> jpaQuery = this.getJpaQueryWhere(query, actUserIds, orgManageIds);
        QueryResults result = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.groupBy(this.qdo.id)).offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<PrjProjectMemberVO> getJpaQuerySelectProjectMember() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrjProjectMemberVO.class, (Expression[])new Expression[]{this.qdoMember.id, this.qdoMember.projectId, this.qdoMember.userId, this.qdoMember.employeeName, this.qdoMember.createUserId, this.qdoMember.creator, this.qdoMember.createTime})).from((EntityPath)this.qdoMember);
        return jpaQuery;
    }

    public List<PrjProjectMemberVO> queryProjectMember(Long projectId) {
        JPAQuery<PrjProjectMemberVO> jpaQuery = this.getJpaQuerySelectProjectMember();
        jpaQuery.where((Predicate)this.qdoMember.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdoMember.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<CrmActDynamicVO> getJpaQuerySelectActDynamic() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActDynamicVO.class, (Expression[])new Expression[]{this.qdoDyn.id, this.qdoDyn.actId, this.qdoDyn.dynamicType, this.qdoDyn.dynamicContent, this.qdoEmployee.employeeName, this.qdoDyn.fileCodes, this.qdoDyn.createUserId, this.qdoDyn.creator, this.qdoDyn.createTime})).from((EntityPath)this.qdoDyn)).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoDyn.createUserId.eq((Expression)this.qdoEmployee.userId));
        return jpaQuery;
    }

    public List<CrmActDynamicVO> queryActDynamic(Long actId) {
        JPAQuery<CrmActDynamicVO> jpaQuery = this.getJpaQuerySelectActDynamic();
        jpaQuery.where((Predicate)this.qdoDyn.actId.eq((Object)actId));
        jpaQuery.where((Predicate)this.qdoDyn.deleteFlag.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdoDyn, null));
        return jpaQuery.fetch();
    }

    public List<CrmActDynamicVO> queryActDynamicByPrjIds(List<Long> actIds) {
        JPAQuery<CrmActDynamicVO> jpaQuery = this.getJpaQuerySelectActDynamic();
        jpaQuery.where((Predicate)this.qdoDyn.actId.in(actIds));
        jpaQuery.where((Predicate)this.qdoDyn.deleteFlag.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdoDyn, null));
        return jpaQuery.fetch();
    }

    public CrmActDynamicVO queryActDynamicDetail(Long key) {
        JPAQuery<CrmActDynamicVO> jpaQuery = this.getJpaQuerySelectActDynamic();
        jpaQuery.where((Predicate)this.qdoDyn.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdoDyn.deleteFlag.eq((Object)0));
        return (CrmActDynamicVO)jpaQuery.fetchFirst();
    }

    public List<PrdOrgEmployeeVO> queryEmployee(List<Long> userIds) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = this.getJpaQuerySelectEmployee();
        jpaQuery.where((Predicate)this.qdoEmployee.userId.in(userIds));
        jpaQuery.where((Predicate)this.qdoEmployee.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdOrgEmployeeVO> getJpaQuerySelectEmployee() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgEmployeeVO.class, (Expression[])new Expression[]{this.qdoEmployee.id, this.qdoEmployee.userId, this.qdoEmployee.personId, this.qdoEmployee.employeeName})).from((EntityPath)this.qdoEmployee);
    }

    public long updateStatus(Long key, String projectStatus, String procInstId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoProject).set((Path)this.qdoProject.projectStatus, (Object)projectStatus);
        if (!procInstId.equals("")) {
            update.set((Path)this.qdoProject.procInstId, (Object)procInstId);
        }
        update.where(new Predicate[]{this.qdoProject.id.eq((Object)key)});
        return update.execute();
    }

    public Long queryByReportId(Long key) {
        CrmActReportDO crmActReportDO = this.repoReport.findById(key).orElse(null);
        if (crmActReportDO != null) {
            return crmActReportDO.getActId();
        }
        return -1L;
    }

    public List<Long> queryByLeadsIds(List<Long> leadIds) {
        return this.repo.queryByLeadsIds(leadIds);
    }

    public List<Long> queryByIds(List<Long> activiyProjIds) {
        return this.repo.queryByIds(activiyProjIds);
    }

    public CrmActActivityDAO(JPAQueryFactory jpaQueryFactory, CrmActActivityRepo repo, CrmActDynamicRepo repoDyn, CrmActReportRepo repoReport) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoDyn = repoDyn;
        this.repoReport = repoReport;
    }
}

