/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsOffshoreRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmLeadsOffshoreDAO {
    private final CrmLeadsOffshoreRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QCrmLeadsOffshoreDO qdo = QCrmLeadsOffshoreDO.crmLeadsOffshoreDO;
    private final PrdOrgEmployeeDAO employeeDAO;

    public Specification<CrmLeadsOffshoreDO> getSpec(CrmLeadsOffshoreQuery query) {
        Specification & Serializable querySpecifi = (Specification & Serializable)(root, criteriaQuery, cb) -> {
            String[] split;
            CriteriaBuilder.In in;
            Path path;
            ArrayList<javax.persistence.criteria.Predicate> predicates = new ArrayList<javax.persistence.criteria.Predicate>();
            Join offshoreJoin = root.join("offshore", JoinType.LEFT);
            Join offshoreRuleJoin = offshoreJoin.join("offshoreRule", JoinType.LEFT);
            Join offshoreMembersJoin = offshoreJoin.join("offshoreMembers", JoinType.LEFT);
            Join offshoreAdminJoin = offshoreJoin.join("offshoreAdmins", JoinType.LEFT);
            Join leadsJoin = root.join("leads", JoinType.LEFT);
            Join marketJoin = leadsJoin.join("market", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStatusList())) {
                path = leadsJoin.get("leadsStatus");
                in = cb.in((Expression)path);
                for (String status : query.getLeadsStatusList()) {
                    in.value((Object)status);
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in}));
            }
            if (!ObjectUtils.isEmpty((Object)query.getSaleOrCreateUserId())) {
                javax.persistence.criteria.Predicate pred1 = cb.equal((Expression)leadsJoin.get("saleUserId"), (Object)query.getSaleOrCreateUserId());
                javax.persistence.criteria.Predicate pred2 = cb.equal((Expression)leadsJoin.get("createUserId"), (Object)query.getSaleOrCreateUserId());
                predicates.add(cb.or((Expression)pred1, (Expression)pred2));
            }
            if (!ObjectUtils.isEmpty((Object)query.getNotDistributeLeadsRemindTimeNotNull()) && query.getNotDistributeLeadsRemindTimeNotNull().booleanValue()) {
                predicates.add(cb.isNotNull(root.get("notDistributeLeadsRemindTime").as(Long.class)));
            }
            if (!ObjectUtils.isEmpty((Object[])query.getLeadsIds())) {
                path = leadsJoin.get("id");
                in = cb.in((Expression)path);
                for (Long id : query.getLeadsIds()) {
                    in.value((Object)id);
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in}));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsIdsForFollow())) {
                path = leadsJoin.get("id");
                in = cb.in((Expression)path);
                for (Long id : query.getLeadsIdsForFollow()) {
                    in.value((Object)id);
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in}));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsIdsStr())) {
                split = query.getLeadsIdsStr().split(",");
                Path path2 = leadsJoin.get("id");
                CriteriaBuilder.In in2 = cb.in((Expression)path2);
                for (String id : split) {
                    in2.value((Object)Long.valueOf(id));
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in2}));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getLeadsTagIds())) {
                split = query.getLeadsTagIds().split(",");
                javax.persistence.criteria.Predicate[] predicatesArray = new javax.persistence.criteria.Predicate[split.length];
                for (int i = 0; i < split.length; ++i) {
                    predicatesArray[i] = cb.like(leadsJoin.get("leadsTagIds").as(String.class), SqlUtil.toSqlLikeString((String)split[i]));
                }
                predicates.add(cb.or(predicatesArray));
            }
            if (!ObjectUtils.isEmpty((Object)query.getMarketChannel())) {
                predicates.add(cb.like(leadsJoin.get("marketChannel").as(String.class), SqlUtil.toSqlLikeString((String)query.getMarketChannel())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getFilterLeadsOffshore()) && query.getFilterLeadsOffshore().booleanValue()) {
                predicates.add(cb.equal((Expression)leadsJoin.get("offshoreId"), (Expression)offshoreJoin.get("id")));
            }
            if (!ObjectUtils.isEmpty((Object)query.getFilterOffshore()) && query.getFilterOffshore().booleanValue()) {
                predicates.add(cb.isNotNull(leadsJoin.get("offshoreId").as(Long.class)));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsId())) {
                predicates.add(cb.equal(leadsJoin.get("id").as(Long.class), (Object)query.getLeadsId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getSaleUserId())) {
                predicates.add(cb.equal(leadsJoin.get("saleUserId").as(Long.class), (Object)query.getSaleUserId()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getLeadsNo())) {
                predicates.add(cb.like(leadsJoin.get("leadNo").as(String.class), SqlUtil.toSqlLikeString((String)query.getLeadsNo())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsName())) {
                predicates.add(cb.like(leadsJoin.get("leadsName").as(String.class), SqlUtil.toSqlLikeString((String)query.getLeadsName())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getAnnualTurnover())) {
                predicates.add(cb.equal(leadsJoin.get("annualTurnover").as(String.class), (Object)query.getAnnualTurnover()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getArea())) {
                predicates.add(cb.like(leadsJoin.get("area").as(String.class), SqlUtil.toSqlLikeString((String)query.getArea())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStatus())) {
                predicates.add(cb.equal(leadsJoin.get("leadsStatus").as(String.class), (Object)query.getLeadsStatus()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getDemandProduct())) {
                predicates.add(cb.equal(leadsJoin.get("demandProduct").as(String.class), (Object)query.getDemandProduct()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getDemandProductOrg())) {
                predicates.add(cb.equal(leadsJoin.get("demandProductOrg").as(Long.class), (Object)query.getDemandProductOrg()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStage())) {
                predicates.add(cb.equal(leadsJoin.get("leadsStage").as(String.class), (Object)query.getLeadsStage()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStageNotEqual())) {
                predicates.add(cb.notEqual(leadsJoin.get("leadsStage").as(String.class), (Object)query.getLeadsStageNotEqual()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateUserIdNotEqual())) {
                predicates.add(cb.notEqual(leadsJoin.get("createUserId").as(String.class), (Object)query.getCreateUserIdNotEqual()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getDemandProduct())) {
                predicates.add(cb.equal(leadsJoin.get("demandProduct").as(String.class), (Object)query.getDemandProduct()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getSaleUserId())) {
                predicates.add(cb.equal(leadsJoin.get("saleUserId").as(String.class), (Object)query.getSaleUserId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStageNotIn())) {
                List leadsStageNotIn = query.getLeadsStageNotIn();
                for (String s : leadsStageNotIn) {
                    predicates.add(cb.notEqual(leadsJoin.get("leadsStage").as(String.class), (Object)s));
                }
            }
            if (!ObjectUtils.isEmpty((Object)query.getExpireDays())) {
                predicates.add(cb.isNotNull((Expression)leadsJoin.get("distributeDate")));
                predicates.add(cb.equal(leadsJoin.get("distributeDate").as(String.class), (Object)LocalDate.now().minusDays(query.getExpireDays().intValue()).toString()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
                predicates.add(cb.equal(leadsJoin.get("sourceType").as(String.class), (Object)query.getSourceType()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getMarketId())) {
                predicates.add(cb.equal(marketJoin.get("id").as(Long.class), (Object)query.getMarketId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
                predicates.add(cb.greaterThanOrEqualTo(leadsJoin.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeStart()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
                predicates.add(cb.lessThanOrEqualTo(leadsJoin.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeEnd()));
            }
            Join customerJoin = leadsJoin.join("customer", JoinType.LEFT);
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerContacts())) {
                predicates.add(cb.like(customerJoin.get("customerContacts").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerContacts())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getContactsPhone())) {
                predicates.add(cb.like(customerJoin.get("contactsPhone").as(String.class), SqlUtil.toSqlLikeString((String)query.getContactsPhone())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getContactsEmail())) {
                predicates.add(cb.like(customerJoin.get("contactsEmail").as(String.class), SqlUtil.toSqlLikeString((String)query.getContactsEmail())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
                predicates.add(cb.like(customerJoin.get("customerName").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerName())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustomerNameEqual())) {
                predicates.add(cb.equal(customerJoin.get("customerName").as(String.class), (Object)query.getCustomerNameEqual()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustomerIndustry())) {
                predicates.add(cb.equal(customerJoin.get("customerIndustry").as(String.class), (Object)query.getCustomerIndustry()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustomerGrade())) {
                predicates.add(cb.equal(customerJoin.get("customerGrade").as(String.class), (Object)query.getCustomerGrade()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustRegion())) {
                predicates.add(cb.equal(customerJoin.get("custRegion").as(String.class), (Object)query.getCustRegion()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getOffshoreId()) && query.getOffshoreId() != 0L) {
                predicates.add(cb.equal(offshoreJoin.get("id").as(String.class), (Object)query.getOffshoreId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getOffshoreIds())) {
                String[] split2 = query.getOffshoreIds().split(",");
                Path path3 = offshoreJoin.get("id");
                CriteriaBuilder.In in3 = cb.in((Expression)path3);
                for (String id : split2) {
                    in3.value((Object)Long.valueOf(id));
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in3}));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getOffshoreName())) {
                predicates.add(cb.like(offshoreJoin.get("offshoreName").as(String.class), SqlUtil.toSqlLikeString((String)query.getOffshoreName())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getOffshoreAdminId())) {
                predicates.add(cb.equal(offshoreAdminJoin.get("userId").as(Long.class), (Object)query.getOffshoreAdminId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getDistributeReceiveRule())) {
                predicates.add(cb.equal(offshoreRuleJoin.get("distributeReceiveRule").as(String.class), (Object)query.getDistributeReceiveRule()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getMemberId())) {
                predicates.add(cb.equal(offshoreMembersJoin.get("userId").as(Long.class), (Object)query.getMemberId()));
            }
            predicates.add(cb.equal((Expression)offshoreJoin.get("deleteFlag"), (Object)0));
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new javax.persistence.criteria.Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public Page<CrmLeadsOffshoreDO> findAll(Specification<CrmLeadsOffshoreDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort((Pageable)pageable);
        return this.repo.findAll(spec, pageable);
    }

    public List<CrmLeadsOffshoreDO> findAll(Specification<CrmLeadsOffshoreDO> spec) {
        return this.repo.findAll(spec);
    }

    public CrmLeadsOffshoreDO save(CrmLeadsOffshoreDO leadsOffshore) {
        return (CrmLeadsOffshoreDO)((Object)this.repo.save((Object)leadsOffshore));
    }

    public void setLeadsOffshoresOrder(Long id, int index) {
        this.repo.saveIndex(id, index);
    }

    public Long countBySpec(Specification<CrmLeadsOffshoreDO> spec) {
        return this.repo.count(spec);
    }

    public void deleteSoft(Long id) {
        this.repo.deleteById(id);
    }

    public void updateByKeyDynamic(CrmLeadsOffshorePayload payload) {
        CrmLeadsOffshoreDO crmLeadsOffshoreDO = this.repo.findById(payload.getId()).orElse(null);
        if (crmLeadsOffshoreDO != null) {
            List nullFields;
            if (payload.getRemark() != null) {
                crmLeadsOffshoreDO.setRemark(payload.getRemark());
            }
            if (payload.getNotDistributeLeadsRemindTime() != null) {
                crmLeadsOffshoreDO.setNotDistributeLeadsRemindTime(payload.getNotDistributeLeadsRemindTime());
            }
            if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("notDistributeLeadsRemindTime")) {
                crmLeadsOffshoreDO.setNotDistributeLeadsRemindTime(null);
            }
            this.repo.save((Object)crmLeadsOffshoreDO);
        }
    }

    public long deleteSoftByLeadsIds(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.leads.id.in(keys)});
        return update.execute();
    }

    public int getExist(Long leadsId, Long offshoreId) {
        return this.repo.getExistNum(leadsId, offshoreId);
    }

    public CrmLeadsOffshoreDAO(CrmLeadsOffshoreRepo repo, JPAQueryFactory jpaQueryFactory, PrdOrgEmployeeDAO employeeDAO) {
        this.repo = repo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.employeeDAO = employeeDAO;
    }
}

