/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmFollowConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class CrmFollowServiceImpl
implements CrmFollowService {
    private static final Logger log = LoggerFactory.getLogger(CrmFollowServiceImpl.class);
    private final CrmFollowDAO followDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;

    public List<CrmFollowVO> toListVo(CrmFollowObjectEnum followObjectEnum, List<CrmFollowDO> followDOS) {
        List<CrmFollowVO> collect = followDOS.stream().map(e -> {
            CrmFollowVO vo = CrmFollowConvert.INSTANCE.toVo((CrmFollowDO)((Object)e));
            vo.setFollowObjectDesc(followObjectEnum.getDesc());
            vo.setFollowTypeDesc(this.cacheUtil.transferSystemSelection(followObjectEnum.getTypeEnum().getCode(), vo.getFollowType()));
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }

    public List<CrmFollowVO> queryFollowList(Long objectId, String followObjectType) {
        CrmFollowObjectEnum crmFollowObjectEnum = CrmFollowObjectEnum.valueOf((String)followObjectType);
        List<CrmFollowDO> followDOS = this.followDAO.queryByObjectIdAndObjectType(objectId, crmFollowObjectEnum.getCode());
        List<CrmFollowVO> collect = followDOS.stream().map(e -> {
            CrmFollowVO vo = CrmFollowConvert.INSTANCE.toVo((CrmFollowDO)((Object)e));
            vo.setFollowObjectDesc(crmFollowObjectEnum.getDesc());
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }

    public PagingVO<CrmFollowVO> listPage(CrmFollowQuery query) {
        CrmFollowObjectEnum crmFollowObjectEnum = CrmFollowObjectEnum.valueOf((String)query.getFollowObject());
        PagingVO<CrmFollowVO> followVOPagingVO = this.followDAO.listPage(query);
        FunctionSelectionEnum typeEnum = crmFollowObjectEnum.getTypeEnum();
        followVOPagingVO.getRecords().forEach(e -> {
            e.setFollowObjectDesc(crmFollowObjectEnum.getDesc());
            e.setFollowTypeDesc(this.cacheUtil.transferSystemSelection(typeEnum.getCode(), e.getFollowType()));
            if (!ObjectUtils.isEmpty((Object)e.getCreateUserId())) {
                e.setCreateUserName(this.cacheUtil.getUserName(e.getCreateUserId()));
            }
            e.setFileDatas(this.fileUtil.getFileDatas(e.getFileCodes()));
        });
        return followVOPagingVO;
    }

    public List<CrmFollowVO> list(CrmFollowQuery query) {
        List<CrmFollowVO> list = this.followDAO.list(query);
        return list;
    }

    @Transactional
    public void addFollow(CrmFollowPayload payload) {
        CrmFollowDO ado = CrmFollowConvert.INSTANCE.toDo(payload);
        this.followDAO.save(ado);
    }

    @Transactional
    public void updateFollow(CrmFollowPayload payload) {
        this.followDAO.updateByKeyDynamic(payload);
    }

    public CrmFollowServiceImpl(CrmFollowDAO followDAO, CacheUtil cacheUtil, FileUtil fileUtil) {
        this.followDAO = followDAO;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
    }
}

