/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.param.SysPasswordUpdate;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.app.vo.PrdUserDataForAppVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserCompositeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwRecentWorkVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.SpelUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RemindTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationChanceDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.qixin.config.QiXinProperties;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskEvalStatusEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitTaskDAO;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskApplyService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskAuthorizeService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskService;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdUserServiceImpl
implements PrdUserService {
    private static final Logger log = LoggerFactory.getLogger(PrdUserServiceImpl.class);
    private final PrdUserDAO dao;
    private final CrmCustomerOperationChanceDAO customerOperationChanceDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PrdSystemProblemFeedbackService prdSystemProblemFeedbackService;
    private final CrmActActivityService activityservice;
    private final CrmLeadsService crmLeadsService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final VisitTaskDAO visitTaskDAO;
    @Autowired
    private SysUserRpcService sysUserService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final QiXinProperties qiXinProperties;
    private final PmsTaskService pmsTaskService;
    private final PmsTaskApplyService pmsTaskApplyService;
    private final PmsTaskAuthorizeService pmsTaskAuthorizeService;

    public List<PrdUserCompositeVO> queryUserComposite(Long userId) {
        List prdUserCompositeVOS = this.dao.queryUserComposite(userId);
        prdUserCompositeVOS.forEach(compositeVO -> {
            compositeVO.setManageLevelName(this.cacheUtil.transferSystemSelection("org:employee:manage", compositeVO.getManageLevel()));
            compositeVO.setWorkTypeName(this.cacheUtil.transferSystemSelection("org:employee:worktype", compositeVO.getWorkType()));
            PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj("org:employee:specialtylevel", compositeVO.getSpecialtyLevel());
            if (prdSystemSelectionVO != null) {
                compositeVO.setSpecialtyLevelName(prdSystemSelectionVO.getSelectionName());
                compositeVO.setEqvaRatio(BigDecimal.valueOf(100L));
                if (StringUtils.hasText((String)prdSystemSelectionVO.getExtString1())) {
                    compositeVO.setEqvaRatio(new BigDecimal(String.valueOf(prdSystemSelectionVO.getExtString1())));
                }
            }
        });
        return prdUserCompositeVOS;
    }

    @Transactional
    public PrdUserDataVO queryUserDetail() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = this.dao.queryUserDetail(userId);
        vo.setHeadDatas(this.fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setOrgRoles(this.dao.queryRolesById("" + userId));
        vo.setSystemRoles(this.cacheUtil.getSystemRoleCodes(userId));
        List shortcutVOs = this.dao.queryShortcutList();
        if (!CollectionUtils.isEmpty((Collection)shortcutVOs)) {
            if (StringUtils.hasText((String)vo.getShortcutIds())) {
                shortcutVOs.forEach(shortcutVO -> {
                    if (vo.getShortcutIds().contains("" + shortcutVO.getId())) {
                        shortcutVO.setIsMy(Integer.valueOf(0));
                    }
                });
            }
            vo.setShortcutVOs(shortcutVOs);
        }
        String ticket = UUID.randomUUID().toString();
        vo.setTicket(new String(Base64.encodeBase64((byte[])ticket.getBytes())));
        this.transferSystemSelection(vo);
        this.dao.updateTicket(vo.getId(), ticket);
        vo.setWorkflowEnabled(this.workflow_enabled);
        vo.setQxBEnabled(this.qiXinProperties.getEnabled());
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdUserDataVO getUserInfoBase() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = this.dao.queryUserDetail(userId);
        vo.setOrgRoles(this.dao.queryRolesById("" + userId));
        vo.setSystemRoles(this.cacheUtil.getSystemRoleCodes(userId));
        this.transferSystemSelection(vo);
        vo.setWorkflowEnabled(this.workflow_enabled);
        vo.setQxBEnabled(this.qiXinProperties.getEnabled());
        return vo;
    }

    public PrdUserDataForAppVO queryDetailForMobile() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataForAppVO vo = this.dao.queryUserDetailForApp(userId);
        vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
        vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
        vo.setWorkflowEnabled(this.workflow_enabled);
        return vo;
    }

    @Transactional
    public Long updateShortcut(String shortcutIds) {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.updateShortcut(userId, shortcutIds);
    }

    public void updatePassword(String oldPassword, String newPassword) {
        if (!StringUtils.hasText((String)oldPassword) || !StringUtils.hasText((String)newPassword)) {
            throw TwException.error((String)"", (String)"\u65e0\u6548\u7684\u5bc6\u7801");
        }
        Long userId = GlobalUtil.getLoginUserId();
        SysPasswordUpdate passwordUpdate = new SysPasswordUpdate();
        passwordUpdate.setUserId(userId);
        passwordUpdate.setCurrentPassword(new String(Base64.encodeBase64((byte[])oldPassword.getBytes())));
        passwordUpdate.setNewPassword(new String(Base64.encodeBase64((byte[])newPassword.getBytes())));
        this.sysUserService.updatePassword(passwordUpdate);
    }

    public List<TwRecentWorkVO> findMyWork() {
        Long userId = GlobalUtil.getLoginUserId();
        ArrayList<TwRecentWorkVO> recentWorkVOList = new ArrayList<TwRecentWorkVO>();
        this.customerOperationChance(recentWorkVOList, userId);
        this.activityRelease(recentWorkVOList, userId);
        this.problemFeedback(recentWorkVOList, userId);
        this.leadsToReceive(recentWorkVOList, userId);
        this.leadsToDistribute(recentWorkVOList, userId);
        this.operationPlanDetail(recentWorkVOList, userId);
        this.visitTask(recentWorkVOList, userId);
        this.visitTaskEval(recentWorkVOList, userId);
        return recentWorkVOList;
    }

    public List<PrdUserRemindVO> findMyRemind() {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        ArrayList<PrdUserRemindVO> resRemindVOS = new ArrayList<PrdUserRemindVO>();
        List remindVOS = this.dao.queryReminds(userId);
        for (PrdUserRemindVO remindVO : remindVOS) {
            Map objectMap;
            Long num;
            String remindContent;
            HashMap<String, Long> map;
            long num2;
            if (remindVO.getNoRemindDate() != null && remindVO.getNoRemindDate().equals(newDate)) continue;
            String remindType = remindVO.getRemindType();
            if (remindType.equals(RemindTypeEnum.RECEIVED_LEAD.getCode()) && (num2 = this.crmLeadsService.countNotReceivedLeadsByUserId(userId.longValue())) > 0L) {
                map = new HashMap<String, Long>();
                map.put("num", num2);
                remindContent = SpelUtil.parseStringExpression((String)remindVO.getRemindContent(), map);
                remindVO.setRemindContent(remindContent);
                resRemindVOS.add(remindVO);
            }
            if (!remindType.equals(RemindTypeEnum.ACTIVITY_UNRELEASE.getCode()) || (num = (Long)(objectMap = this.activityservice.findActivityUnReleaseByUserId(userId.longValue())).get("num")) <= 0L) continue;
            map = new HashMap();
            map.put("num", num);
            remindContent = SpelUtil.parseStringExpression((String)remindVO.getRemindContent(), map);
            remindVO.setRemindContent(remindContent);
            remindVO.setSurplusTime("" + objectMap.get("time"));
            resRemindVOS.add(remindVO);
        }
        return resRemindVOS;
    }

    @Transactional
    public Boolean updateMyRemind(String remindType) {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        PrdUserRemindDO userRemindDO = this.dao.queryUserRemind(userId, remindType);
        if (userRemindDO == null) {
            userRemindDO = new PrdUserRemindDO();
            userRemindDO.setRemindType(remindType);
            userRemindDO.setUserId(userId);
        }
        userRemindDO.setNoRemindDate(newDate);
        this.dao.saveUserRemind(userRemindDO);
        return true;
    }

    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("ticket");
        if (ticket != null && !ticket.isEmpty()) {
            ticket = new String(Base64.decodeBase64((byte[])ticket.getBytes()));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        JSONObject jsonObject = null;
        HttpSession session = request.getSession();
        PrdUserDataVO info = this.dao.queryUserByTicket(ticket);
        try {
            if (info == null) {
                paramMap.put("el-result-cod", "NG_UNSUPPORTED");
                paramMap.put("statusCode", "401");
                jsonObject = new JSONObject(paramMap);
                response.setStatus(401);
                session.setAttribute("paramMap", paramMap);
            }
            paramMap.put("app_login_type", "SSO");
            paramMap.put("app_login_id", info.getId());
            paramMap.put("app_login_email", info.getEmail());
            paramMap.put("app_login_ticket", ticket);
            paramMap.put("el-result-cod", "OK");
            paramMap.put("statusCode", "200");
            jsonObject = new JSONObject(paramMap);
            response.setStatus(200);
            session.setAttribute("paramMap", paramMap);
            response.getWriter().print(jsonObject);
        }
        catch (NullPointerException e) {
            try {
                response.getWriter().print(jsonObject);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<PrdOrgDataRefVO> queryOrgList() {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.queryOrgListByKey(userId);
    }

    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId) {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.queryLowListByKey(orgId, userId);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<PrdSystemMenuVO> queryMenus() {
        List menuVOS = this.dao.queryUsableList();
        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
        if (loginGeneralUser.isSystemAdmin()) {
            return menuVOS;
        }
        if (loginGeneralUser.isTenantAdmin()) {
            return menuVOS.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        List userMenuIds = this.dao.queryUserMenuIds(loginGeneralUser.getUserId());
        return menuVOS.stream().filter(menuVO -> userMenuIds.indexOf(menuVO.getId()) >= 0).collect(Collectors.toList());
    }

    public List<PrdUserDataVO> queryPrdUserDataByOrgIdAndSystemRole(Long orgId, String systemRole) {
        return this.dao.queryPrdUserDataByOrgIdAndSystemRole(orgId, systemRole);
    }

    public List<PrdSystemRoleVO> querySystemRoleByUserId(Long userId) {
        return this.dao.querySystemRoleByUserId(userId);
    }

    private void customerOperationChance(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        CrmCustomerOperationChanceQuery query = new CrmCustomerOperationChanceQuery();
        query.setTrackerUserId(Long.valueOf(userId));
        query.setIsRead(Integer.valueOf(0));
        query.setNoPermissionFlag(Boolean.valueOf(true));
        PagingVO<CrmCustomerOperationChanceVO> paging = this.customerOperationChanceDAO.paging(query);
        Long total = paging.getTotal();
        if (total.compareTo(0L) != 0) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u7ecf\u8425\u673a\u4f1a\u70b9\u5f85\u8ddf\u8e2a", (Long)total, (String)TwRecentWorkVO.RecentWorkType.OPERATION_CHANCE_DETAIL.getCode()));
        }
    }

    private void activityRelease(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        Map objectMap = this.activityservice.findActivityUnReleaseByUserId(userId);
        long num = (Long)objectMap.get("num");
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u6d3b\u52a8\u5f85\u53d1\u5e03", (Long)num, (String)TwRecentWorkVO.RecentWorkType.ACTIVITY_RELEASE.getCode()));
        }
    }

    private void problemFeedback(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        long num = this.prdSystemProblemFeedbackService.findWorkProblemFeedbackByUserId(Long.valueOf(userId));
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u95ee\u9898\u53cd\u9988", (Long)num, (String)TwRecentWorkVO.RecentWorkType.FEED_BACK.getCode()));
        }
    }

    private void leadsToReceive(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        long num = this.crmLeadsService.countNotReceivedLeads(userId);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u5f85\u9886\u53d6\u7ebf\u7d22", (Long)num, (String)TwRecentWorkVO.RecentWorkType.LEADS_TO_RECEIVE.getCode()));
        }
    }

    private void leadsToDistribute(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        long num = this.crmLeadsService.countNotDistributedLeadsByUserId(userId);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u7ebf\u7d22\u5f85\u5206\u914d", (Long)num, (String)TwRecentWorkVO.RecentWorkType.LEADS_TO_DISTRIBUTE.getCode(), (String)"/leadsManager/offshore"));
        }
    }

    private void operationPlanDetail(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        CrmOperationPlanDetailQuery planDetailQuery = new CrmOperationPlanDetailQuery();
        planDetailQuery.setPerformerId(userId);
        planDetailQuery.setReadFlag(Integer.valueOf(0));
        long count = this.crmOperationPlanDetailService.count(planDetailQuery);
        if (count > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.OPERATION_PLAN_DETAIL.getDesc(), (Long)count, (String)TwRecentWorkVO.RecentWorkType.OPERATION_PLAN_DETAIL.getCode(), (String)"/leadsManager/offshore"));
        }
    }

    private void visitTask(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setVisitMemberId(userId);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(VisitTaskStatusEnum.NEW.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
        long count = this.visitTaskDAO.done(taskQuery);
        if (count > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.VISIT_TASK.getDesc(), (Long)count, (String)TwRecentWorkVO.RecentWorkType.VISIT_TASK.getCode(), (String)"/visit/task"));
        }
    }

    private void visitTaskEval(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        Set subordinatesIdsByUserId = this.prdOrgEmployeeService.queryOneSubordinatesIdsByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)subordinatesIdsByUserId)) {
            return;
        }
        taskQuery.setEvalSubordinatesIds(subordinatesIdsByUserId);
        taskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        taskQuery.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
        long count = this.visitTaskDAO.count(taskQuery);
        if (count > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getDesc(), (Long)count, (String)TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getCode(), (String)"/visit/task?eval=true"));
        }
    }

    void transferSystemSelection(PrdUserDataVO vo) {
        vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
    }

    public PrdUserServiceImpl(PrdUserDAO dao, CrmCustomerOperationChanceDAO customerOperationChanceDAO, CacheUtil cacheUtil, FileUtil fileUtil, PrdSystemProblemFeedbackService prdSystemProblemFeedbackService, CrmActActivityService activityservice, CrmLeadsService crmLeadsService, CrmOperationPlanDetailService crmOperationPlanDetailService, VisitTaskDAO visitTaskDAO, PrdOrgEmployeeService prdOrgEmployeeService, QiXinProperties qiXinProperties, PmsTaskService pmsTaskService, PmsTaskApplyService pmsTaskApplyService, PmsTaskAuthorizeService pmsTaskAuthorizeService) {
        this.dao = dao;
        this.customerOperationChanceDAO = customerOperationChanceDAO;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.prdSystemProblemFeedbackService = prdSystemProblemFeedbackService;
        this.activityservice = activityservice;
        this.crmLeadsService = crmLeadsService;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.visitTaskDAO = visitTaskDAO;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.qiXinProperties = qiXinProperties;
        this.pmsTaskService = pmsTaskService;
        this.pmsTaskApplyService = pmsTaskApplyService;
        this.pmsTaskAuthorizeService = pmsTaskAuthorizeService;
    }
}

