/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveAccountPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveDetailsPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveAccountQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveDetailsQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractReceiveAccountService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractAccountNameVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveAccountVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveDetailsVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractCollectionPlanPlanStatus;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractReceiveDetailsConvert;
import com.elitesland.tw.tw5crm.server.contract.convert.CrmContractReceiveAccountConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractReceiveDetailsDAO;
import com.elitesland.tw.tw5crm.server.contract.dao.CrmContractReceiveAccountDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractCollectionPlanDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractReceiveDetailsDO;
import com.elitesland.tw.tw5crm.server.contract.entity.CrmContractReceiveAccountDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractCollectionPlanRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractReceiveDetailsRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.CrmContractReceiveAccountRepo;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractReceiveAccountServiceImpl
extends BaseServiceImpl
implements ContractReceiveAccountService {
    private static final Logger log = LoggerFactory.getLogger(ContractReceiveAccountServiceImpl.class);
    private final CrmContractReceiveAccountRepo crmContractReceiveAccountRepo;
    private final CrmContractReceiveAccountDAO crmContractReceiveAccountDAO;
    private final ContractReceiveDetailsRepo contractReceiveDetailsRepo;
    private final ContractCollectionPlanRepo collectionPlanRepo;
    private final ContractReceiveDetailsDAO contractReceiveDetailsDAO;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    public final ContractRepo contractRepo;

    public PagingVO<ContractReceiveAccountVO> queryPaging(ContractReceiveAccountQuery query) {
        this.dataPermissionFlag(query);
        PagingVO<ContractReceiveAccountVO> PagingVO2 = this.crmContractReceiveAccountDAO.queryPaging(query);
        return PagingVO2;
    }

    private void dataPermissionFlag(ContractReceiveAccountQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CONTRACT_ADMIN.getCode()));
        query.setDataPermissionFlag(Boolean.valueOf(rolePermission == false));
    }

    public List<ContractReceiveAccountVO> queryListDynamic(ContractReceiveAccountQuery query) {
        this.dataPermissionFlag(query);
        return this.crmContractReceiveAccountDAO.queryListDynamic(query);
    }

    public ContractReceiveAccountVO queryByKey(Long key) {
        CrmContractReceiveAccountDO entity = this.crmContractReceiveAccountRepo.findById(key).orElseGet(CrmContractReceiveAccountDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5230\u6b3e\u6536\u5165\u4e0d\u5b58\u5728");
        ContractReceiveAccountVO vo = CrmContractReceiveAccountConvert.INSTANCE.toVo(entity);
        this.translation(vo);
        ContractReceiveDetailsQuery detailsQuery = new ContractReceiveDetailsQuery();
        detailsQuery.setReceiveAccountId(vo.getId());
        List<ContractReceiveDetailsVO> contractReceiveDetailsVOS = this.contractReceiveDetailsDAO.queryListDynamic(detailsQuery);
        vo.setContractReceiveDetailsVO(contractReceiveDetailsVOS);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractReceiveAccountVO insert(ContractReceiveAccountPayload payload) {
        List contractReceiveDetailsPayloadList = payload.getContractReceiveDetailsPayload();
        String code = this.generateSeqNum("CRM_RECEIVE_ACCOUNT", new String[0]);
        payload.setReceiveAccountNo(code);
        CrmContractReceiveAccountDO entityDo = CrmContractReceiveAccountConvert.INSTANCE.toDo(payload);
        CrmContractReceiveAccountDO save = (CrmContractReceiveAccountDO)this.crmContractReceiveAccountRepo.save(entityDo);
        HashMap<Long, BigDecimal> collectionAmountMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, ContractCollectionPlanDO> contractCollectionPlanDOMap = new HashMap<Long, ContractCollectionPlanDO>();
        for (ContractReceiveDetailsPayload e : contractReceiveDetailsPayloadList) {
            ContractDO contractDO = this.contractRepo.findById(e.getContractId()).orElseGet(ContractDO::new);
            e.setContractName(contractDO.getContractName());
            e.setSaleDutyId(contractDO.getSaleDutyId());
            e.setSaleDutyName(this.cacheUtil.getUserName(contractDO.getSaleDutyId()));
            ContractCollectionPlanDO contractCollectionPlanDO = this.collectionPlanRepo.findById(e.getPlanId()).orElseGet(ContractCollectionPlanDO::new);
            if (collectionAmountMap.containsKey(contractCollectionPlanDO.getId())) {
                collectionAmountMap.put(contractCollectionPlanDO.getId(), ((BigDecimal)collectionAmountMap.get(contractCollectionPlanDO.getId())).add(e.getReceiveMoney()));
            } else if (contractCollectionPlanDO.getCollectionAmount() != null && e.getReceiveMoney() != null) {
                BigDecimal totalReceivedMoney = this.contractReceiveDetailsDAO.queryTotalReceiveMoneyByPlanId(contractCollectionPlanDO.getId());
                collectionAmountMap.put(contractCollectionPlanDO.getId(), e.getReceiveMoney().add(totalReceivedMoney));
                contractCollectionPlanDOMap.put(contractCollectionPlanDO.getId(), contractCollectionPlanDO);
            }
            String phase = contractCollectionPlanDO.getPhase();
            e.setPhase(phase);
            ContractReceiveDetailsDO contractReceiveDetailsDO = ContractReceiveDetailsConvert.INSTANCE.toDo(e);
            contractReceiveDetailsDO.setReceiveAccountId(save.getId());
            this.contractReceiveDetailsRepo.save(contractReceiveDetailsDO);
        }
        contractCollectionPlanDOMap.forEach((planId, value) -> {
            if (((BigDecimal)collectionAmountMap.get(planId)).compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            int count = value.getCollectionAmount().subtract((BigDecimal)collectionAmountMap.get(planId)).compareTo(BigDecimal.ZERO);
            if (count <= 0) {
                value.setStatus(ContractCollectionPlanPlanStatus.OK.getCode());
            } else {
                value.setStatus(ContractCollectionPlanPlanStatus.PART.getCode());
            }
            this.collectionPlanRepo.save(value);
        });
        return CrmContractReceiveAccountConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractReceiveAccountVO update(ContractReceiveAccountPayload payload) {
        CrmContractReceiveAccountDO entity = this.crmContractReceiveAccountRepo.findById(payload.getId()).orElseGet(CrmContractReceiveAccountDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5230\u6b3e\u5f55\u5165\u4e0d\u5b58\u5728");
        CrmContractReceiveAccountDO entityDo = CrmContractReceiveAccountConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmContractReceiveAccountConvert.INSTANCE.toVo((CrmContractReceiveAccountDO)this.crmContractReceiveAccountRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.crmContractReceiveAccountRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmContractReceiveAccountDO entity = (CrmContractReceiveAccountDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.crmContractReceiveAccountRepo.save(entity);
                }
            });
        }
    }

    private void translation(ContractReceiveAccountVO vo) {
        vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    public List<ContractAccountNameVO> listSimple() {
        List<ContractAccountNameVO> resultList = this.crmContractReceiveAccountDAO.listSimple();
        return resultList;
    }

    public ContractReceiveAccountServiceImpl(CrmContractReceiveAccountRepo crmContractReceiveAccountRepo, CrmContractReceiveAccountDAO crmContractReceiveAccountDAO, ContractReceiveDetailsRepo contractReceiveDetailsRepo, ContractCollectionPlanRepo collectionPlanRepo, ContractReceiveDetailsDAO contractReceiveDetailsDAO, FileUtil fileUtil, CacheUtil cacheUtil, ContractRepo contractRepo) {
        this.crmContractReceiveAccountRepo = crmContractReceiveAccountRepo;
        this.crmContractReceiveAccountDAO = crmContractReceiveAccountDAO;
        this.contractReceiveDetailsRepo = contractReceiveDetailsRepo;
        this.collectionPlanRepo = collectionPlanRepo;
        this.contractReceiveDetailsDAO = contractReceiveDetailsDAO;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
        this.contractRepo = contractRepo;
    }
}

