/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.funConfig.controller;

import com.elitesland.tw.tw5.api.common.funConfig.dto.BusinessPageJsonDTO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessPageService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.PrdUserDataForFunConfigVO;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessPartnerCustomerVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.funConfig.util.BusinessPageJsonUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9875\u9762\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/api/crm/funConfig/businessPage"})
public class CrmBusinessPageController {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessPageController.class);
    private final BusinessPageService businessPageService;
    private final PrdUserService prdUserService;
    private final CacheUtil cacheUtil;
    private final BusinessPartnerService businessPartnerService;
    private final BusinessCustomerInfoService businessCustomerInfoService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="crm\u9875\u9762\u914d\u7f6e-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(Long partnerId, String taskType, BusinessPageQuery query) {
        ArrayList resultList = new ArrayList();
        List list = this.businessPageService.queryListDynamic(query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return TwOutputUtil.ok(resultList);
        }
        if (ObjectUtils.isEmpty((Object)taskType)) {
            return TwOutputUtil.error((String)"taskType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != partnerId) {
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(partnerId);
            BusinessPartnerCustomerVO partnerCustomerVO = new BusinessPartnerCustomerVO();
            BeanUtils.copyProperties((Object)businessPartnerVO, (Object)partnerCustomerVO);
            partnerCustomerVO.setId(businessPartnerVO.getId().toString());
            partnerCustomerVO.setBookId(businessPartnerVO.getBookId() != null ? businessPartnerVO.getBookId().toString() : "");
            BusinessCustomerInfoQuery customerInfoQuery = new BusinessCustomerInfoQuery();
            customerInfoQuery.setPartnerId(partnerId);
            List businessCustomerInfoVOS = this.businessCustomerInfoService.queryListDynamic(customerInfoQuery);
            if (CollectionUtils.isEmpty((Collection)businessCustomerInfoVOS)) {
                return TwOutputUtil.error((String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            }
            BusinessCustomerInfoVO customerInfo = (BusinessCustomerInfoVO)businessCustomerInfoVOS.get(0);
            partnerCustomerVO.setCustomerInfo(customerInfo);
            param.put("partner", partnerCustomerVO);
        }
        PrdUserDataVO userInfoBase = this.prdUserService.getUserInfoBase();
        PrdUserDataForFunConfigVO userDataForFunConfigVO = new PrdUserDataForFunConfigVO();
        BeanUtils.copyProperties((Object)userInfoBase, (Object)userDataForFunConfigVO);
        userDataForFunConfigVO.setUserId(null != userInfoBase.getUserId() ? userInfoBase.getUserId().toString() : "");
        userDataForFunConfigVO.setCompanyId(null != userInfoBase.getCompanyId() ? userInfoBase.getCompanyId().toString() : "");
        userDataForFunConfigVO.setOrgId(null != userInfoBase.getOrgId() ? userInfoBase.getOrgId().toString() : "");
        param.put("twUser", userDataForFunConfigVO);
        HashMap<String, String> visitTask = new HashMap<String, String>();
        visitTask.put("taskType", taskType);
        param.put("visitTask", visitTask);
        list.forEach(businessPageVO -> {
            BusinessPageJsonDTO jsonDto = businessPageVO.getJsonDto();
            List pageJsonDTOList = BusinessPageJsonUtil.jsonToList((BusinessPageJsonDTO)jsonDto);
            BusinessPageJsonUtil.parseExpression((List)pageJsonDTOList, (Map)param);
            if (!CollectionUtils.isEmpty((Collection)pageJsonDTOList)) {
                pageJsonDTOList.forEach(pageJsonDTO -> {
                    String showStr;
                    Object show = pageJsonDTO.getShow();
                    boolean flag = false;
                    if (show instanceof Boolean) {
                        flag = (Boolean)show;
                    } else if (show instanceof String && (showStr = show.toString()).equals("true")) {
                        flag = true;
                    }
                    if (flag) {
                        HashMap<String, String> result1 = new HashMap<String, String>();
                        result1.put("id", pageJsonDTO.getId());
                        result1.put("title", pageJsonDTO.getTitle());
                        resultList.add(result1);
                    }
                });
            }
        });
        return TwOutputUtil.ok(resultList);
    }

    public CrmBusinessPageController(BusinessPageService businessPageService, PrdUserService prdUserService, CacheUtil cacheUtil, BusinessPartnerService businessPartnerService, BusinessCustomerInfoService businessCustomerInfoService) {
        this.businessPageService = businessPageService;
        this.prdUserService = prdUserService;
        this.cacheUtil = cacheUtil;
        this.businessPartnerService = businessPartnerService;
        this.businessCustomerInfoService = businessCustomerInfoService;
    }
}

