/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitesland.tw.tw5crm.api.partner.business.payload.BusinessCustomerOperationChancePayload;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationChanceQuery;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationChanceService;
import com.elitesland.tw.tw5crm.api.partner.business.vo.BusinessCustomerOperationChanceVO;
import com.elitesland.tw.tw5crm.server.partner.business.convert.BusinessCustomerOperationChanceConvert;
import com.elitesland.tw.tw5crm.server.partner.business.dao.BusinessCustomerOperationChanceDAO;
import com.elitesland.tw.tw5crm.server.partner.business.entity.BusinessCustomerOperationChanceDO;
import com.elitesland.tw.tw5crm.server.partner.business.repo.BusinessCustomerOperationChanceRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class BusinessCustomerOperationChanceServiceImpl
extends BaseServiceImpl
implements BusinessCustomerOperationChanceService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerOperationChanceServiceImpl.class);
    private final BusinessCustomerOperationChanceRepo businessCustomerOperationChanceRepo;
    private final BusinessCustomerOperationChanceDAO businessCustomerOperationChanceDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;

    public PagingVO<BusinessCustomerOperationChanceVO> queryPaging(BusinessCustomerOperationChanceQuery query) {
        PagingVO<BusinessCustomerOperationChanceVO> paging = this.businessCustomerOperationChanceDAO.queryPaging(query);
        paging.getRecords().forEach(operationChanceVO -> {
            this.transferData((BusinessCustomerOperationChanceVO)operationChanceVO);
            operationChanceVO.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.BUSINESS_OPER_CHANCE.getCode(), operationChanceVO.getId())));
            operationChanceVO.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.BUSINESS_OPER_CHANCE.getCode(), operationChanceVO.getId())));
        });
        return paging;
    }

    public List<BusinessCustomerOperationChanceVO> queryListDynamic(BusinessCustomerOperationChanceQuery query) {
        return this.businessCustomerOperationChanceDAO.queryListDynamic(query);
    }

    public BusinessCustomerOperationChanceVO queryByKey(Long key) {
        BusinessCustomerOperationChanceDO entity = this.businessCustomerOperationChanceRepo.findById(key).orElseGet(BusinessCustomerOperationChanceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationChanceVO vo = BusinessCustomerOperationChanceConvert.INSTANCE.toVo(entity);
        this.transferData(vo);
        if (vo.getTrackerUserId() != null && GlobalUtil.getLoginUserId().compareTo(vo.getTrackerUserId()) == 0 && vo.getIsRead() == 0) {
            this.businessCustomerOperationChanceRepo.updateIsRead(GlobalUtil.getLoginUserId(), List.of(vo.getId()));
        }
        return vo;
    }

    public BusinessCustomerOperationChanceVO insertOrUpdate(BusinessCustomerOperationChancePayload payload) {
        this.check(payload);
        BusinessCustomerOperationChanceDO entityDo = BusinessCustomerOperationChanceConvert.INSTANCE.toDo(payload);
        String firstName = GlobalUtil.getLoginUser().getLastName();
        if (!StringUtils.hasText((String)firstName)) {
            firstName = GlobalUtil.getLoginUserName();
        }
        String name = PrdSystemLogEnum.CREATE.getDesc();
        if (payload.getId() == null) {
            entityDo.setIsRead(0);
            entityDo = (BusinessCustomerOperationChanceDO)this.businessCustomerOperationChanceRepo.save(entityDo);
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_CHANCE.getCode(), "(" + firstName + ")" + name + PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_CHANCE.getDesc());
        } else {
            name = PrdSystemLogEnum.UPDATE.getDesc();
            Optional chanceDO = this.businessCustomerOperationChanceRepo.findById(payload.getId());
            if (chanceDO.isPresent()) {
                BusinessCustomerOperationChanceDO crmCustomerOperationChanceDO = (BusinessCustomerOperationChanceDO)chanceDO.get();
                entityDo.setInvolvedUserIds(crmCustomerOperationChanceDO.getInvolvedUserIds());
                if (crmCustomerOperationChanceDO.getTrackerUserId() == null) {
                    entityDo.setIsRead(0);
                } else if (entityDo.getTrackerUserId() != null && !entityDo.getTrackerUserId().equals(crmCustomerOperationChanceDO.getTrackerUserId())) {
                    entityDo.setIsRead(0);
                }
                BusinessCustomerOperationChanceDO entityLog = new BusinessCustomerOperationChanceDO();
                BeanUtils.copyProperties((Object)crmCustomerOperationChanceDO, (Object)entityLog);
                crmCustomerOperationChanceDO.copy(entityDo);
                StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, crmCustomerOperationChanceDO);
                this.businessCustomerOperationChanceRepo.save(crmCustomerOperationChanceDO);
                fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
                if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                    this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_CHANCE.getCode(), fieldsUpdateLog.toString());
                }
            } else {
                throw TwException.error((String)"", (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
        this.logService.saveNewLog(entityDo.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), name + PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_CHANCE.getDesc());
        return BusinessCustomerOperationChanceConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationChanceVO insert(BusinessCustomerOperationChancePayload payload) {
        BusinessCustomerOperationChanceDO entityDo = BusinessCustomerOperationChanceConvert.INSTANCE.toDo(payload);
        return BusinessCustomerOperationChanceConvert.INSTANCE.toVo((BusinessCustomerOperationChanceDO)this.businessCustomerOperationChanceRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationChanceVO update(BusinessCustomerOperationChancePayload payload) {
        BusinessCustomerOperationChanceDO entity = this.businessCustomerOperationChanceRepo.findById(payload.getId()).orElseGet(BusinessCustomerOperationChanceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationChanceDO entityDo = BusinessCustomerOperationChanceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessCustomerOperationChanceConvert.INSTANCE.toVo((BusinessCustomerOperationChanceDO)this.businessCustomerOperationChanceRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessCustomerOperationChanceRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessCustomerOperationChanceDO entity = (BusinessCustomerOperationChanceDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessCustomerOperationChanceRepo.save(entity);
                }
            });
        }
    }

    private void check(BusinessCustomerOperationChancePayload payload) {
        if (null == payload.getPartnerId()) {
            throw TwException.error((String)"", (String)"partnerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == payload.getTitle()) {
            throw TwException.error((String)"", (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    void transferData(BusinessCustomerOperationChanceVO vo) {
        vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
        if (vo.getTrackerUserId() != null) {
            vo.setTrackerUserName(this.cacheUtil.getUserName(vo.getTrackerUserId()));
        }
        ArrayList involvedUsers = new ArrayList();
        if (StringUtils.hasText((String)vo.getInvolvedUserIds())) {
            String[] split = vo.getInvolvedUserIds().split(",");
            for (int i = 0; i < split.length; ++i) {
                Long userId = Long.valueOf(split[i]);
                String userName = this.cacheUtil.getUserName(userId);
                HashMap<String, Object> user = new HashMap<String, Object>();
                user.put("userId", userId);
                user.put("userName", userName);
                involvedUsers.add(user);
            }
        }
        vo.setInvolvedUsers(involvedUsers);
        ArrayList informUsers = new ArrayList();
        if (StringUtils.hasText((String)vo.getInformUserIds())) {
            for (String str : vo.getInformUserIds().split(",")) {
                Long informUserId = Long.parseLong(str);
                String userName = this.cacheUtil.getUserName(informUserId);
                HashMap<String, Object> user = new HashMap<String, Object>();
                user.put("userId", informUserId);
                user.put("userName", userName);
                informUsers.add(user);
            }
        }
        vo.setInformUsers(informUsers);
        if (StringUtils.hasText((String)vo.getTags())) {
            String[] tags;
            ArrayList tagsDesc = new ArrayList();
            for (String tag : tags = vo.getTags().split(",")) {
                List systemTags = this.cacheUtil.getSystemTag(Long.valueOf(Long.parseLong(tag)));
                tagsDesc.addAll(systemTags);
            }
            vo.setTagsDesc(tagsDesc);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateIsRead(List<Long> keys) {
        this.businessCustomerOperationChanceRepo.updateIsRead(GlobalUtil.getLoginUserId(), keys);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateInvolvedUser(Long key, List<Long> userIds) {
        BusinessCustomerOperationChanceVO crmCustomerOperationChanceVO = this.businessCustomerOperationChanceDAO.queryByKey(key);
        String involvedUserIds = crmCustomerOperationChanceVO.getInvolvedUserIds();
        BusinessCustomerOperationChancePayload payload = new BusinessCustomerOperationChancePayload();
        payload.setId(crmCustomerOperationChanceVO.getId());
        Object name = "\u6dfb\u52a0\u4e86\u53c2\u4e0e\u8005\uff08";
        if (StringUtils.hasText((String)involvedUserIds)) {
            String[] split = involvedUserIds.split(",");
            Set oldUserIds = Arrays.asList(split).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toSet());
            boolean b = oldUserIds.containsAll(userIds);
            if (b) {
                name = "\u5220\u9664\u4e86\u53c2\u4e0e\u8005\uff08";
                oldUserIds.removeAll(userIds);
            } else {
                oldUserIds.addAll(userIds);
            }
            if (oldUserIds.size() > 0) {
                involvedUserIds = oldUserIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            } else {
                involvedUserIds = null;
                payload.setNullFields(List.of("involvedUserIds"));
            }
        } else {
            involvedUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        for (Long userId : userIds) {
            String userName = this.cacheUtil.getUserName(userId);
            name = (String)name + userName + ",";
        }
        name = ((String)name).substring(0, ((String)name).length() - 1) + "\uff09";
        payload.setInvolvedUserIds(involvedUserIds);
        this.businessCustomerOperationChanceDAO.updateByKeyDynamic(payload);
        String firstName = GlobalUtil.getLoginUser().getLastName();
        if (!StringUtils.hasText((String)firstName)) {
            firstName = GlobalUtil.getLoginUserName();
        }
        this.logService.saveNewLog(key, PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_CHANCE.getCode(), "(" + firstName + ")" + (String)name);
    }

    public Long count(BusinessCustomerOperationChanceQuery query) {
        return this.businessCustomerOperationChanceDAO.count(query);
    }

    public BusinessCustomerOperationChanceServiceImpl(BusinessCustomerOperationChanceRepo businessCustomerOperationChanceRepo, BusinessCustomerOperationChanceDAO businessCustomerOperationChanceDAO, CacheUtil cacheUtil, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil, PrdCommentService prdCommentService, PrdFsmFileRefService prdFsmFileRefService) {
        this.businessCustomerOperationChanceRepo = businessCustomerOperationChanceRepo;
        this.businessCustomerOperationChanceDAO = businessCustomerOperationChanceDAO;
        this.cacheUtil = cacheUtil;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.prdCommentService = prdCommentService;
        this.prdFsmFileRefService = prdFsmFileRefService;
    }
}

