/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.partner.team.entity.QBusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleGoalPayload;
import com.elitesland.tw.tw5crm.api.sale.query.SaleGoalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleGoalVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetDualVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetVO;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetStatisticalEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserCustomerFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserLeadsFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserOppoFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserVisitFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SearchScopeEnum;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleGoalRepo;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitPlanDetailDO;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitTaskDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class SaleGoalDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final SaleGoalRepo repo;
    private final QSaleGoalDO qdo = QSaleGoalDO.saleGoalDO;
    private final QSaleTargetDO qSaleTargetDO = QSaleTargetDO.saleTargetDO;
    private final QVisitTaskDO qVisitTaskDO = QVisitTaskDO.visitTaskDO;
    private final QVisitPlanDetailDO qVisitPlanDetailDO = QVisitPlanDetailDO.visitPlanDetailDO;
    private final QPrdOrgEmployeeDO qEmp = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QPrjProjectDO qPrjProjectDO = QPrjProjectDO.prjProjectDO;
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;
    private final QBusinessPartnerDO qbusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;
    private final QBusinessTeamMemberDO qTeamMemberDo = QBusinessTeamMemberDO.businessTeamMemberDO;
    private final QBookAddressDO qBookAddressDO = QBookAddressDO.bookAddressDO;

    private JPAQuery<SaleGoalVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleGoalVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createUserId, this.qdo.goalName, this.qdo.fiscalYear, this.qdo.dutyId, this.qdo.dutyName, this.qdo.goalType, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.targetCount, this.qdo.examTarget})).from((EntityPath)this.qdo);
    }

    private JPAQuery<SaleGoalVO> getJpaQueryWhere(SaleGoalQuery query) {
        JPAQuery<SaleGoalVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(SaleGoalQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(SaleGoalQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoalName())) {
            list.add(this.qdo.goalName.like(SqlUtil.toSqlLikeString((String)query.getGoalName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFiscalYear())) {
            list.add(this.qdo.fiscalYear.eq((Object)query.getFiscalYear()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDutyId())) {
            list.add(this.qdo.dutyId.eq((Object)query.getDutyId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDutyName())) {
            list.add(this.qdo.dutyName.eq((Object)query.getDutyName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoalType())) {
            list.add(this.qdo.goalType.eq((Object)query.getGoalType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExamTarget())) {
            list.add(this.qdo.examTarget.eq((Object)query.getExamTarget()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            BooleanExpression jpaQueryOr = this.qdo.createUserId.eq((Object)query.getLoginUserId());
            list.add(jpaQueryOr);
        }
        return ExpressionUtils.allOf(list);
    }

    public SaleGoalVO queryByKey(Long id) {
        JPAQuery<SaleGoalVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (SaleGoalVO)jpaQuery.fetchFirst();
    }

    public List<SaleGoalVO> queryListDynamic(SaleGoalQuery query) {
        JPAQuery<SaleGoalVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<SaleGoalVO> queryPaging(SaleGoalQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<SaleGoalVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public SaleGoalDO save(SaleGoalDO ado) {
        return (SaleGoalDO)this.repo.save(ado);
    }

    public List<SaleGoalDO> saveAll(List<SaleGoalDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(SaleGoalPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getGoalName() != null) {
            update.set((Path)this.qdo.goalName, (Object)payload.getGoalName());
        }
        if (payload.getFiscalYear() != null) {
            update.set(this.qdo.fiscalYear, (Object)payload.getFiscalYear());
        }
        if (payload.getDutyId() != null) {
            update.set(this.qdo.dutyId, (Object)payload.getDutyId());
        }
        if (payload.getDutyName() != null) {
            update.set((Path)this.qdo.dutyName, (Object)payload.getDutyName());
        }
        if (payload.getGoalType() != null) {
            update.set((Path)this.qdo.goalType, (Object)payload.getGoalType());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("goalName")) {
                update.setNull((Path)this.qdo.goalName);
            }
            if (nullFields.contains("fiscalYear")) {
                update.setNull(this.qdo.fiscalYear);
            }
            if (nullFields.contains("dutyId")) {
                update.setNull(this.qdo.dutyId);
            }
            if (nullFields.contains("dutyName")) {
                update.setNull((Path)this.qdo.dutyName);
            }
            if (nullFields.contains("goalType")) {
                update.setNull((Path)this.qdo.goalType);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long countVisitByExamInformation(Collection<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        this.visitExamWhere(list, userIds, null, examInformationVOS);
        if (null != startTime) {
            list.add((Predicate)this.qVisitTaskDO.modifyTime.goe((Comparable)startTime));
        }
        if (null != endTime) {
            list.add((Predicate)this.qVisitTaskDO.modifyTime.loe((Comparable)endTime));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        long total = (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qVisitTaskDO.count()).from((EntityPath)this.qVisitTaskDO)).leftJoin((EntityPath)this.qbusinessPartnerDO)).on((Predicate)this.qVisitTaskDO.partnerId.eq(this.qbusinessPartnerDO.id))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qBusinessCustomerInfoDO.partnerId.eq(this.qbusinessPartnerDO.id))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qbusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0))))).where(predicate)).fetchOne();
        return total;
    }

    public List<SaleTargetDualVO> countVisitTaskByExamInformation(SaleTargetStatisticalQuery query) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Collection userIds = query.getUserIds();
        Long userId = query.getUserId();
        List examInformationVOList = query.getExamInformationVOList();
        this.visitExamWhere(list, userIds, userId, examInformationVOList);
        if (null != query.getOrgId()) {
            list.add((Predicate)this.qdoOrg.id.eq((Object)query.getOrgId()));
        }
        if (null != userId) {
            list.add((Predicate)this.qVisitTaskDO.visitMemberId.eq((Object)userId));
        }
        if (null != query.getStartTime()) {
            list.add((Predicate)this.qVisitTaskDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add((Predicate)this.qVisitTaskDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        if (null != query.getCustomerId()) {
            list.add((Predicate)this.qVisitTaskDO.partnerId.eq((Object)query.getCustomerId()));
        }
        if (null != query.getCustomerGrade()) {
            list.add((Predicate)this.qBusinessCustomerInfoDO.customerGradle.eq((Object)query.getCustomerGrade()));
        }
        if (null != query.getCustIndustry()) {
            list.add((Predicate)this.qbusinessPartnerDO.partnerIndustry.eq((Object)query.getCustIndustry()));
        }
        if (null != query.getCustRegion()) {
            // empty if block
        }
        list.add((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qdoRef.isCopy.eq((Object)0));
        list.add((Predicate)this.qdoRef.isDefault.eq((Object)0));
        list.add((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        Predicate predicate = ExpressionUtils.allOf(list);
        StringTemplate searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qVisitTaskDO.modifyTime});
        StringTemplate searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qVisitTaskDO.modifyTime});
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qVisitTaskDO.modifyTime});
            searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qVisitTaskDO.modifyTime});
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTimePro = searchTime = Expressions.stringTemplate((String)"CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", (Object[])new Object[]{this.qVisitTaskDO.modifyTime});
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetDualVO.class, (Expression[])new Expression[]{searchTime.as("time"), searchTimePro.as("timePro"), this.qVisitTaskDO.count().as("valueLong")})).from((EntityPath)this.qVisitTaskDO)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq(this.qVisitTaskDO.visitMemberId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).leftJoin((EntityPath)this.qbusinessPartnerDO)).on((Predicate)this.qVisitTaskDO.partnerId.eq(this.qbusinessPartnerDO.id))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qbusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0))))).where(predicate)).groupBy((Expression)searchTime);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    private void visitExamWhere(List<Predicate> list, Collection<Long> userIds, Long userId, List<ExamInformationVO> examInformationVOList) {
        examInformationVOList.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)userIds)) {
                            if (null != userId) {
                                list.add((Predicate)this.qVisitTaskDO.visitMemberId.eq((Object)userId));
                            } else {
                                list.add((Predicate)this.qVisitTaskDO.visitMemberId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        // empty if block
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qVisitTaskDO.status.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {
                    list.add((Predicate)this.qbusinessPartnerDO.partnerRegion.eq((Object)searchCondition));
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerGradle.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerGradle.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qbusinessPartnerDO.partnerIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qbusinessPartnerDO.partnerIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
    }

    public List<SaleTargetVO> countSaleTarget(Long goalId, String ext1, Long orgId, Long userId, String custIndustry, String customerGrade) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != goalId) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)goalId));
        }
        if (!ObjectUtils.isEmpty((Object)ext1)) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)ext1));
        }
        if (null != orgId) {
            list.add(this.qdoOrg.id.eq((Object)orgId));
        }
        if (null != userId) {
            list.add(this.qSaleTargetDO.dutyId.eq((Object)userId));
        }
        if (!ObjectUtils.isEmpty((Object)customerGrade)) {
            list.add(this.qBusinessCustomerInfoDO.customerGradle.eq((Object)customerGrade));
        }
        if (!ObjectUtils.isEmpty((Object)custIndustry)) {
            list.add(this.qbusinessPartnerDO.partnerIndustry.eq((Object)custIndustry));
        }
        list.add(this.qdoRef.deleteFlag.eq((Object)0));
        list.add(this.qdoRef.isCopy.eq((Object)0));
        list.add(this.qdoRef.isDefault.eq((Object)0));
        list.add(this.qdoOrg.deleteFlag.eq((Object)0));
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.id, this.qSaleTargetDO.goalId, this.qSaleTargetDO.parentId, this.qSaleTargetDO.goalName, this.qSaleTargetDO.fiscalYear, this.qSaleTargetDO.firstQuarter, this.qSaleTargetDO.secondQuarter, this.qSaleTargetDO.thirdQuarter, this.qSaleTargetDO.forthQuarter, this.qSaleTargetDO.january, this.qSaleTargetDO.february, this.qSaleTargetDO.march, this.qSaleTargetDO.april, this.qSaleTargetDO.may, this.qSaleTargetDO.june, this.qSaleTargetDO.july, this.qSaleTargetDO.august, this.qSaleTargetDO.september, this.qSaleTargetDO.october, this.qSaleTargetDO.november, this.qSaleTargetDO.december, this.qSaleTargetDO.targetCount, this.qSaleTargetDO.goalType, this.qSaleTargetDO.dutyId, this.qSaleTargetDO.dutyName, this.qSaleTargetDO.skuId, this.qSaleTargetDO.skuName, this.qSaleTargetDO.customerId, this.qSaleTargetDO.customerName, this.qSaleTargetDO.objId, this.qSaleTargetDO.objName, this.qSaleTargetDO.ext1, this.qSaleTargetDO.ext2, this.qSaleTargetDO.ext3, this.qSaleTargetDO.ext4, this.qSaleTargetDO.ext5})).from((EntityPath)this.qSaleTargetDO)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq(this.qSaleTargetDO.dutyId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).leftJoin((EntityPath)this.qbusinessPartnerDO)).on((Predicate)this.qSaleTargetDO.customerId.eq(this.qbusinessPartnerDO.id))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qbusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0))))).where(predicate);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public List<SaleTargetDualVO> countLeadsByExamInformation(SaleTargetStatisticalQuery query) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        List examInformationVOList = query.getExamInformationVOList();
        this.leadsExamWhere(query.getUserIds(), query.getUserId(), list, examInformationVOList);
        if (null != query.getOrgId()) {
            list.add((Predicate)this.qdoOrg.id.eq((Object)query.getOrgId()));
        }
        if (null != query.getUserId()) {
            list.add((Predicate)this.qdoLeads.sourceUserId.eq((Object)query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add((Predicate)this.qdoLeads.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add((Predicate)this.qdoLeads.modifyTime.loe((Comparable)query.getEndTime()));
        }
        list.add((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qdoRef.isCopy.eq((Object)0));
        list.add((Predicate)this.qdoRef.isDefault.eq((Object)0));
        list.add((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        Predicate predicate = ExpressionUtils.allOf(list);
        StringTemplate searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qdoLeads.modifyTime});
        StringTemplate searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qdoLeads.modifyTime});
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qdoLeads.modifyTime});
            searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qdoLeads.modifyTime});
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTimePro = searchTime = Expressions.stringTemplate((String)"CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", (Object[])new Object[]{this.qdoLeads.modifyTime});
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetDualVO.class, (Expression[])new Expression[]{searchTime.as("time"), searchTimePro.as("timePro"), this.qdoLeads.count().as("valueLong")})).from((EntityPath)this.qdoLeads)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq(this.qdoLeads.sourceUserId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).leftJoin((EntityPath)this.qbusinessPartnerDO)).on((Predicate)this.qdoLeads.partnerId.eq(this.qbusinessPartnerDO.id))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qbusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0))))).where(predicate)).groupBy((Expression)searchTime);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public long countLeadsByExamInformationForPaging(Set<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        this.leadsExamWhere(userIds, null, list, examInformationVOS);
        list.add((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qdoRef.isCopy.eq((Object)0));
        list.add((Predicate)this.qdoRef.isDefault.eq((Object)0));
        list.add((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        if (null != startTime) {
            list.add((Predicate)this.qdoLeads.modifyTime.goe((Comparable)startTime));
        }
        if (null != endTime) {
            list.add((Predicate)this.qdoLeads.modifyTime.loe((Comparable)endTime));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        Long count = (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoLeads.count()).from((EntityPath)this.qdoLeads)).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq(this.qdoLeads.sourceUserId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).leftJoin((EntityPath)this.qbusinessPartnerDO)).on((Predicate)this.qdoLeads.partnerId.eq(this.qbusinessPartnerDO.id))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qbusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0))))).where(predicate)).fetchOne();
        return count;
    }

    private void leadsExamWhere(Collection<Long> userIds, Long userId, List<Predicate> list, List<ExamInformationVO> examInformationVOList) {
        examInformationVOList.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.SOURCE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)userIds)) {
                            if (null != userId) {
                                list.add((Predicate)this.qdoLeads.sourceUserId.eq((Object)userId));
                            } else {
                                list.add((Predicate)this.qdoLeads.sourceUserId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qdoLeads.sourceUserId.eq((Object)userId));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qdoLeads.leadsStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qdoLeads.leadsStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qdoLeads.leadsStage.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qdoLeads.leadsStage.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_GRADE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerGradle.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerGradle.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qbusinessPartnerDO.partnerIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qbusinessPartnerDO.partnerIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
    }

    public BigDecimal countOppoByExamInformationForPaging(Set<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        this.oppoExamWhere(list, examInformationVOS, null, userIds);
        list.add((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qPrjProjectDO.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qdoRef.isCopy.eq((Object)0));
        list.add((Predicate)this.qdoRef.isDefault.eq((Object)0));
        list.add((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        if (null != startTime) {
            list.add((Predicate)this.qCrmOpportunityDO.modifyTime.goe((Comparable)startTime));
        }
        if (null != endTime) {
            list.add((Predicate)this.qCrmOpportunityDO.modifyTime.loe((Comparable)endTime));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        return (BigDecimal)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmOpportunityDO.forecastAmount.sum()).from((EntityPath)this.qCrmOpportunityDO)).leftJoin((EntityPath)this.qPrjProjectDO)).on((Predicate)this.qPrjProjectDO.id.eq(this.qCrmOpportunityDO.projectId))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq((Expression)this.qPrjProjectDO.manageUserId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).where(predicate)).fetchOne();
    }

    public List<SaleTargetDualVO> countOppoByExamInformation(SaleTargetStatisticalQuery query) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        List examInformationVOList = query.getExamInformationVOList();
        Long userId = query.getUserId();
        Collection userIds = query.getUserIds();
        this.oppoExamWhere(list, examInformationVOList, userId, userIds);
        if (null != query.getOrgId()) {
            list.add((Predicate)this.qdoOrg.id.eq((Object)query.getOrgId()));
        }
        if (null != userId) {
            list.add((Predicate)this.qPrjProjectDO.manageUserId.eq((Object)userId));
        }
        if (null != query.getStartTime()) {
            list.add((Predicate)this.qCrmOpportunityDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add((Predicate)this.qCrmOpportunityDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        list.add((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qPrjProjectDO.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qdoRef.isCopy.eq((Object)0));
        list.add((Predicate)this.qdoRef.isDefault.eq((Object)0));
        list.add((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        Predicate predicate = ExpressionUtils.allOf(list);
        StringTemplate searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qCrmOpportunityDO.modifyTime});
        StringTemplate searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qCrmOpportunityDO.modifyTime});
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qCrmOpportunityDO.modifyTime});
            searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qCrmOpportunityDO.modifyTime});
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTimePro = searchTime = Expressions.stringTemplate((String)"CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", (Object[])new Object[]{this.qCrmOpportunityDO.modifyTime});
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetDualVO.class, (Expression[])new Expression[]{searchTime.as("time"), searchTimePro.as("timePro"), this.qCrmOpportunityDO.forecastAmount.sum().as("value")})).from((EntityPath)this.qCrmOpportunityDO)).leftJoin((EntityPath)this.qPrjProjectDO)).on((Predicate)this.qPrjProjectDO.id.eq(this.qCrmOpportunityDO.projectId))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq((Expression)this.qPrjProjectDO.manageUserId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).where(predicate)).groupBy((Expression)searchTime);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    private void oppoExamWhere(List<Predicate> list, List<ExamInformationVO> examInformationVOList, Long userId, Collection<Long> userIds) {
        examInformationVOList.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)userIds)) {
                            if (null != userId) {
                                list.add((Predicate)this.qPrjProjectDO.manageUserId.eq((Object)userId));
                            } else {
                                list.add((Predicate)this.qPrjProjectDO.manageUserId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qPrjProjectDO.manageUserId.eq((Object)userId));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROJECT_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qPrjProjectDO.projectStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qPrjProjectDO.projectStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.OPPO_LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qCrmOpportunityDO.oppoLevel.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qCrmOpportunityDO.oppoLevel.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.SALE_PHASE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qCrmOpportunityDO.salePhase.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qCrmOpportunityDO.salePhase.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROBABILITY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qCrmOpportunityDO.probability.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qCrmOpportunityDO.probability.eq((Object)searchCondition));
                    }
                }
            }
        });
    }

    public List<SaleTargetDualVO> countCustomerByExamInformation(SaleTargetStatisticalQuery query) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Collection userIds = query.getUserIds();
        Long userId = query.getUserId();
        List examInformationVOList = query.getExamInformationVOList();
        this.customerExamWhere(list, userIds, userId, examInformationVOList);
        if (null != query.getOrgId()) {
            list.add((Predicate)this.qdoOrg.id.eq((Object)query.getOrgId()));
        }
        if (null != userId) {
            list.add((Predicate)this.qTeamMemberDo.userId.eq((Object)userId));
        }
        if (null != query.getStartTime()) {
            list.add((Predicate)this.qbusinessPartnerDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add((Predicate)this.qbusinessPartnerDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        list.add((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qdoRef.isCopy.eq((Object)0));
        list.add((Predicate)this.qdoRef.isDefault.eq((Object)0));
        list.add((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qbusinessPartnerDO.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qTeamMemberDo.userId.isNotNull());
        Predicate predicate = ExpressionUtils.allOf(list);
        StringTemplate searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qbusinessPartnerDO.modifyTime});
        StringTemplate searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qbusinessPartnerDO.modifyTime});
        if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
            searchTimePro = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%y\u5e74%m\u6708')", (Object[])new Object[]{this.qbusinessPartnerDO.modifyTime});
            searchTime = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%m\u6708')", (Object[])new Object[]{this.qbusinessPartnerDO.modifyTime});
        } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
            searchTimePro = searchTime = Expressions.stringTemplate((String)"CONCAT((FLOOR((DATE_FORMAT({0}, '%m') - 1) / 3) + 1),'')", (Object[])new Object[]{this.qbusinessPartnerDO.modifyTime});
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetDualVO.class, (Expression[])new Expression[]{searchTime.as("time"), searchTimePro.as("timePro"), this.qbusinessPartnerDO.count().as("valueLong")})).from((EntityPath)this.qbusinessPartnerDO)).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qTeamMemberDo)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qTeamMemberDo.objectId))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq(this.qTeamMemberDo.userId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qbusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0))))).where(predicate)).groupBy((Expression)searchTime);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    private void customerExamWhere(List<Predicate> list, Collection<Long> userIds, Long userId, List<ExamInformationVO> examInformationVOList) {
        examInformationVOList.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)userIds)) {
                            if (null != userId) {
                                list.add((Predicate)this.qTeamMemberDo.userId.eq((Object)userId));
                            } else {
                                list.add((Predicate)this.qTeamMemberDo.userId.in(userIds));
                            }
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qTeamMemberDo.userId.eq((Object)userId));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.CUSTOMER_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.AREA.getCode())) {
                    list.add((Predicate)this.qbusinessPartnerDO.partnerRegion.eq((Object)searchCondition));
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerGradle.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qBusinessCustomerInfoDO.customerGradle.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add((Predicate)this.qbusinessPartnerDO.partnerIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add((Predicate)this.qbusinessPartnerDO.partnerIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
    }

    public long countCustomerByExamInformationForPaging(Set<Long> userIds, List<ExamInformationVO> examInformationVOS, LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        this.customerExamWhere(list, userIds, null, examInformationVOS);
        if (null != startTime) {
            list.add((Predicate)this.qbusinessPartnerDO.modifyTime.goe((Comparable)startTime));
        }
        if (null != endTime) {
            list.add((Predicate)this.qbusinessPartnerDO.modifyTime.loe((Comparable)endTime));
        }
        list.add((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qdoRef.isCopy.eq((Object)0));
        list.add((Predicate)this.qdoRef.isDefault.eq((Object)0));
        list.add((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qbusinessPartnerDO.deleteFlag.eq((Object)0));
        list.add((Predicate)this.qTeamMemberDo.userId.isNotNull());
        Predicate predicate = ExpressionUtils.allOf(list);
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qbusinessPartnerDO.count()).from((EntityPath)this.qbusinessPartnerDO)).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qTeamMemberDo)).on((Predicate)this.qbusinessPartnerDO.id.eq(this.qTeamMemberDo.objectId))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdoRef.userId.eq(this.qTeamMemberDo.userId))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.eq((Expression)this.qdoRef.orgId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qbusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0))))).where(predicate)).fetchOne();
    }

    public SaleGoalDAO(JPAQueryFactory jpaQueryFactory, SaleGoalRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

