/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sample.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5crm.api.sample.payload.SamplePayload;
import com.elitesland.tw.tw5crm.api.sample.query.SampleQuery;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleReturnProVO;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleVO;
import com.elitesland.tw.tw5crm.server.common.constants.SampleEnum;
import com.elitesland.tw.tw5crm.server.product.entity.QProductSkuDO;
import com.elitesland.tw.tw5crm.server.sample.entity.QSampleDO;
import com.elitesland.tw.tw5crm.server.sample.entity.QSampleDetailsDO;
import com.elitesland.tw.tw5crm.server.sample.entity.QSampleReturnRecordDO;
import com.elitesland.tw.tw5crm.server.sample.entity.SampleDO;
import com.elitesland.tw.tw5crm.server.sample.repo.SampleRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class SampleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final SampleRepo repo;
    private final QSampleDO qdo = QSampleDO.sampleDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QSampleDetailsDO qSampleDetailsDO = QSampleDetailsDO.sampleDetailsDO;
    private final QSampleReturnRecordDO qSampleReturnRecordDO = QSampleReturnRecordDO.sampleReturnRecordDO;
    private final QProductSkuDO qProductSkuDO = QProductSkuDO.productSkuDO;
    private final QBookAddressDO qBookAddressDO = QBookAddressDO.bookAddressDO;

    private JPAQuery<SampleVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SampleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.sampleCode, this.qdo.partnerId, this.qBusinessPartnerDO.partnerName, this.qdo.contactsName, this.qdo.contactsPhone, this.qdo.partnerIndustry, this.qdo.directorId, this.qdo.consignee, this.qdo.consigneePhone, this.qdo.probationStart, this.qdo.probationEnd, this.qdo.bookAddressId, this.qBookAddressDO.detailAddress, this.qdo.sampleStatus, this.qdo.returnStatus, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.submitTime, this.qdo.approvedTime, this.qBookAddressDO.provinceName, this.qBookAddressDO.cityName, this.qBookAddressDO.districtName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookAddressId.eq(this.qBookAddressDO.id));
    }

    private JPAQuery<SampleVO> getJpaQueryWhere(SampleQuery query) {
        JPAQuery<SampleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(SampleQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(SampleQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSampleCode())) {
            list.add(this.qdo.sampleCode.eq((Object)query.getSampleCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            list.add(this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsName())) {
            list.add(this.qdo.contactsName.eq((Object)query.getContactsName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsPhone())) {
            list.add(this.qdo.contactsPhone.eq((Object)query.getContactsPhone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerIndustry())) {
            list.add(this.qdo.partnerIndustry.eq((Object)query.getPartnerIndustry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDirectorId())) {
            list.add(this.qdo.directorId.eq((Object)query.getDirectorId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getConsignee())) {
            list.add(this.qdo.consignee.eq((Object)query.getConsignee()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getConsigneePhone())) {
            list.add(this.qdo.consigneePhone.eq((Object)query.getConsigneePhone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProbationStart())) {
            list.add(this.qdo.probationStart.eq((Object)query.getProbationStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProbationEnd())) {
            list.add(this.qdo.probationEnd.eq((Object)query.getProbationEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookAddressId())) {
            list.add(this.qdo.bookAddressId.eq((Object)query.getBookAddressId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSampleStatus())) {
            list.add(this.qdo.sampleStatus.eq((Object)query.getSampleStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReturnStatus())) {
            list.add(this.qdo.returnStatus.eq((Object)query.getReturnStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstId())) {
            list.add(this.qdo.procInstId.eq((Object)query.getProcInstId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstStatus())) {
            list.add(this.qdo.procInstStatus.eq((Object)query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubmitTime())) {
            list.add(this.qdo.submitTime.eq((Object)query.getSubmitTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprovedTime())) {
            list.add(this.qdo.approvedTime.eq((Object)query.getApprovedTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerName())) {
            list.add(this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString((String)query.getPartnerName())));
        }
        return ExpressionUtils.allOf(list);
    }

    public SampleVO queryByKey(Long id) {
        JPAQuery<SampleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (SampleVO)jpaQuery.fetchFirst();
    }

    public List<SampleVO> queryListDynamic(SampleQuery query) {
        JPAQuery<SampleVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<SampleVO> queryPaging(SampleQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<SampleVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public SampleDO save(SampleDO ado) {
        return (SampleDO)this.repo.save(ado);
    }

    public List<SampleDO> saveAll(List<SampleDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(SamplePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getSampleCode() != null) {
            update.set((Path)this.qdo.sampleCode, (Object)payload.getSampleCode());
        }
        if (payload.getPartnerId() != null) {
            update.set(this.qdo.partnerId, (Object)payload.getPartnerId());
        }
        if (payload.getContactsName() != null) {
            update.set((Path)this.qdo.contactsName, (Object)payload.getContactsName());
        }
        if (payload.getContactsPhone() != null) {
            update.set((Path)this.qdo.contactsPhone, (Object)payload.getContactsPhone());
        }
        if (payload.getPartnerIndustry() != null) {
            update.set((Path)this.qdo.partnerIndustry, (Object)payload.getPartnerIndustry());
        }
        if (payload.getDirectorId() != null) {
            update.set(this.qdo.directorId, (Object)payload.getDirectorId());
        }
        if (payload.getConsignee() != null) {
            update.set((Path)this.qdo.consignee, (Object)payload.getConsignee());
        }
        if (payload.getConsigneePhone() != null) {
            update.set((Path)this.qdo.consigneePhone, (Object)payload.getConsigneePhone());
        }
        if (payload.getProbationStart() != null) {
            update.set(this.qdo.probationStart, (Object)payload.getProbationStart());
        }
        if (payload.getProbationEnd() != null) {
            update.set(this.qdo.probationEnd, (Object)payload.getProbationEnd());
        }
        if (payload.getBookAddressId() != null) {
            update.set(this.qdo.bookAddressId, (Object)payload.getBookAddressId());
        }
        if (payload.getSampleStatus() != null) {
            update.set((Path)this.qdo.sampleStatus, (Object)payload.getSampleStatus());
        }
        if (payload.getReturnStatus() != null) {
            update.set((Path)this.qdo.returnStatus, (Object)payload.getReturnStatus());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("sampleCode")) {
                update.setNull((Path)this.qdo.sampleCode);
            }
            if (nullFields.contains("partnerId")) {
                update.setNull(this.qdo.partnerId);
            }
            if (nullFields.contains("contactsName")) {
                update.setNull((Path)this.qdo.contactsName);
            }
            if (nullFields.contains("contactsPhone")) {
                update.setNull((Path)this.qdo.contactsPhone);
            }
            if (nullFields.contains("partnerIndustry")) {
                update.setNull((Path)this.qdo.partnerIndustry);
            }
            if (nullFields.contains("directorId")) {
                update.setNull(this.qdo.directorId);
            }
            if (nullFields.contains("consignee")) {
                update.setNull((Path)this.qdo.consignee);
            }
            if (nullFields.contains("consigneePhone")) {
                update.setNull((Path)this.qdo.consigneePhone);
            }
            if (nullFields.contains("probationStart")) {
                update.setNull(this.qdo.probationStart);
            }
            if (nullFields.contains("probationEnd")) {
                update.setNull(this.qdo.probationEnd);
            }
            if (nullFields.contains("bookAddress")) {
                update.setNull(this.qdo.bookAddressId);
            }
            if (nullFields.contains("sampleStatus")) {
                update.setNull((Path)this.qdo.sampleStatus);
            }
            if (nullFields.contains("returnStatus")) {
                update.setNull((Path)this.qdo.returnStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdo.procInstStatus);
            }
            if (nullFields.contains("submitTime")) {
                update.setNull(this.qdo.submitTime);
            }
            if (nullFields.contains("approvedTime")) {
                update.setNull(this.qdo.approvedTime);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PagingVO<SampleVO> queryReturnPaging(SampleQuery query) {
        JPAQuery<SampleVO> jpaQuery = this.getJpaQueryWhere(query);
        jpaQuery.where((Predicate)this.qdo.id.in((SubQueryExpression)((JPQLQuery)JPAExpressions.select(this.qSampleDetailsDO.sampleId).from(new EntityPath[]{this.qSampleDetailsDO}).where(new Predicate[]{this.qSampleDetailsDO.returnDemand.eq((Object)SampleEnum.NEED.getCode()).and((Predicate)this.qdo.sampleStatus.eq((Object)SampleEnum.ACTIVE.getCode()))})).groupBy(new Expression[]{this.qSampleDetailsDO.sampleId})));
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(jpaQuery.fetchCount()).build();
    }

    public Map<Long, Integer> getReturnedTotal(List<Long> sampleIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qSampleReturnRecordDO.returnNumber.sum().as("returnedTotal"), this.qSampleDetailsDO.sampleId.as("id")}).from((EntityPath)this.qSampleReturnRecordDO)).leftJoin((EntityPath)this.qSampleDetailsDO)).on((Predicate)this.qSampleReturnRecordDO.sampleDetailsId.eq(this.qSampleDetailsDO.id))).where((Predicate)this.qSampleDetailsDO.sampleId.in(sampleIds))).groupBy(this.qSampleDetailsDO.sampleId);
        List fetch = jpaQuery.fetch();
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(fetch.size());
        fetch.forEach(tuple -> resultMap.put((Long)tuple.get(1, Long.class), (Integer)tuple.get(0, Integer.class)));
        return resultMap;
    }

    public List<SampleReturnProVO> queryReturnProListBySampleId(Long sampleId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SampleReturnProVO.class, (Expression[])new Expression[]{this.qSampleDetailsDO.id.as("sampleDetailsId"), this.qProductSkuDO.skuName})).from((EntityPath)this.qSampleDetailsDO)).leftJoin((EntityPath)this.qProductSkuDO)).on((Predicate)this.qSampleDetailsDO.productSkuId.eq(this.qProductSkuDO.id))).where((Predicate)this.qSampleDetailsDO.sampleId.eq((Object)sampleId).and((Predicate)this.qSampleDetailsDO.returnDemand.eq((Object)SampleEnum.NEED.getCode())));
        return jpaQuery.fetch();
    }

    public long updateReturnStatus(SamplePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.returnStatus, (Object)payload.getReturnStatus()).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        return update.execute();
    }

    public long updateSampleStatus(List<Long> asList) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.sampleStatus, (Object)SampleEnum.ACTIVE.getCode()).where(new Predicate[]{this.qdo.id.in(asList)});
        return update.execute();
    }

    public long updateWorkFlow(SamplePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        } else {
            update.setNull((Path)this.qdo.procInstId);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstStatus())) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        } else {
            update.setNull(this.qdo.procInstStatus);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSampleStatus())) {
            update.set((Path)this.qdo.sampleStatus, (Object)payload.getSampleStatus());
        } else {
            update.setNull((Path)this.qdo.sampleStatus);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSubmitTime())) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApprovedTime())) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public SampleDAO(JPAQueryFactory jpaQueryFactory, SampleRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

