/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sample.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.sample.payload.SampleDetailsPayload;
import com.elitesland.tw.tw5crm.api.sample.query.SampleDetailsQuery;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleDetailsVO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductSkuDO;
import com.elitesland.tw.tw5crm.server.sample.entity.QSampleDetailsDO;
import com.elitesland.tw.tw5crm.server.sample.entity.SampleDetailsDO;
import com.elitesland.tw.tw5crm.server.sample.repo.SampleDetailsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class SampleDetailsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final SampleDetailsRepo repo;
    private final QSampleDetailsDO qdo = QSampleDetailsDO.sampleDetailsDO;
    private final QProductSkuDO qProductSkuDO = QProductSkuDO.productSkuDO;

    private JPAQuery<SampleDetailsVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SampleDetailsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.sampleId, this.qdo.productSkuId, this.qProductSkuDO.skuName, this.qdo.number, this.qdo.returnDemand, this.qProductSkuDO.attributeStr, this.qProductSkuDO.standardPrice})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qProductSkuDO)).on((Predicate)this.qdo.productSkuId.eq(this.qProductSkuDO.id));
    }

    private JPAQuery<SampleDetailsVO> getJpaQueryWhere(SampleDetailsQuery query) {
        JPAQuery<SampleDetailsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(SampleDetailsQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(SampleDetailsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSampleId())) {
            list.add(this.qdo.sampleId.eq((Object)query.getSampleId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProductSkuId())) {
            list.add(this.qdo.productSkuId.eq((Object)query.getProductSkuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSkuName())) {
            list.add(this.qdo.skuName.eq((Object)query.getSkuName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNumber())) {
            list.add(this.qdo.number.eq((Object)query.getNumber()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReturnDemand())) {
            list.add(this.qdo.returnDemand.eq((Object)query.getReturnDemand()));
        }
        return ExpressionUtils.allOf(list);
    }

    public SampleDetailsVO queryByKey(Long id) {
        JPAQuery<SampleDetailsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (SampleDetailsVO)jpaQuery.fetchFirst();
    }

    public List<SampleDetailsVO> queryListDynamic(SampleDetailsQuery query) {
        JPAQuery<SampleDetailsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<SampleDetailsVO> queryPaging(SampleDetailsQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<SampleDetailsVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public SampleDetailsDO save(SampleDetailsDO ado) {
        return (SampleDetailsDO)this.repo.save(ado);
    }

    public List<SampleDetailsDO> saveAll(List<SampleDetailsDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(SampleDetailsPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getSampleId() != null) {
            update.set(this.qdo.sampleId, (Object)payload.getSampleId());
        }
        if (payload.getProductSkuId() != null) {
            update.set(this.qdo.productSkuId, (Object)payload.getProductSkuId());
        }
        if (payload.getSkuName() != null) {
            update.set((Path)this.qdo.skuName, (Object)payload.getSkuName());
        }
        if (payload.getNumber() != null) {
            update.set(this.qdo.number, (Object)payload.getNumber());
        }
        if (payload.getReturnDemand() != null) {
            update.set((Path)this.qdo.returnDemand, (Object)payload.getReturnDemand());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("sampleId")) {
                update.setNull(this.qdo.sampleId);
            }
            if (nullFields.contains("productSkuId")) {
                update.setNull(this.qdo.productSkuId);
            }
            if (nullFields.contains("skuName")) {
                update.setNull((Path)this.qdo.skuName);
            }
            if (nullFields.contains("number")) {
                update.setNull(this.qdo.number);
            }
            if (nullFields.contains("returnDemand")) {
                update.setNull((Path)this.qdo.returnDemand);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<SampleDetailsVO> queryListBySampleId(Long sampleId) {
        JPAQuery jpaQuery = (JPAQuery)this.getJpaQuerySelect().where((Predicate)this.qdo.sampleId.eq((Object)sampleId).and((Predicate)this.qdo.deleteFlag.eq((Object)0)));
        return jpaQuery.fetch();
    }

    public List<SampleDetailsVO> queryListBySampleIds(List<Long> sampleIds) {
        JPAQuery jpaQuery = (JPAQuery)this.getJpaQuerySelect().where((Predicate)this.qdo.sampleId.in(sampleIds).and((Predicate)this.qdo.deleteFlag.eq((Object)0)));
        return jpaQuery.fetch();
    }

    public SampleDetailsDAO(JPAQueryFactory jpaQueryFactory, SampleDetailsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

