/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsClosurePayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectEvaluationPayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsClosureService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9879\u76ee\u7ed3\u9879"})
@RestController
@RequestMapping(value={"/api/pms/closure"})
public class PmsClosureController {
    private static final Logger log = LoggerFactory.getLogger(PmsClosureController.class);
    private final PmsClosureService closureService;

    @GetMapping(value={"/queryByProjectId"})
    @ApiOperation(value="\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2")
    public TwOutputUtil queryByProjectId(Long projectId) {
        return TwOutputUtil.ok((Object)this.closureService.queryByProjectId(projectId));
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody PmsClosurePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return TwOutputUtil.ok((Object)this.closureService.save(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody PmsClosurePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            throw TwException.error((String)"", (String)"\u9879\u76ee\u7ed3\u9879id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return TwOutputUtil.ok((Object)this.closureService.save(payload));
    }

    @PostMapping(value={"/appraise"})
    @ApiOperation(value="\u9879\u76ee-\u8bc4\u4ef7")
    public TwOutputUtil appraise(@RequestBody PmsProjectEvaluationPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getUserId())) {
            throw TwException.error((String)"", (String)"\u88ab\u8bc4\u4ef7\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getAppraiseType())) {
            throw TwException.error((String)"", (String)"\u8bc4\u4ef7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.closureService.appraise(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/appraiseInfo"})
    @ApiOperation(value="\u67e5\u770b\u67d0\u4eba\u7684\u9879\u76ee\u8bc4\u4ef7")
    public TwOutputUtil appraiseInfo(Long projectId, Long userId) {
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw TwException.error((String)"", (String)"\u88ab\u8bc4\u4ef7\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return TwOutputUtil.ok((Object)this.closureService.appraiseInfo(projectId, userId));
    }

    @PostMapping(value={"/getCarryoverInformation"})
    @ApiOperation(value="\u67e5\u770b\u7ed3\u8f6c\u4fe1\u606f")
    public TwOutputUtil getCarryoverInformation(@RequestBody PmsClosurePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getRoleCode())) {
            throw TwException.error((String)"", (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return TwOutputUtil.ok((Object)this.closureService.getCarryoverInformation(payload));
    }

    public PmsClosureController(PmsClosureService closureService) {
        this.closureService = closureService;
    }
}

