/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.query.PmsClosureInspectionItemsQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsClosureInspectionItemsVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsClosureInspectionItemsDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsClosureInspectionItemsDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsClosureInspectionItemsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsClosureInspectionItemsDao {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsClosureInspectionItemsRepo repo;
    private final QPmsClosureInspectionItemsDO qdo = QPmsClosureInspectionItemsDO.pmsClosureInspectionItemsDO;

    private JPAQuery<PmsClosureInspectionItemsVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsClosureInspectionItemsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.projectId, this.qdo.roleCode, this.qdo.method, this.qdo.item, this.qdo.specification, this.qdo.status})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsClosureInspectionItemsVO> getJpaQueryWhere(PmsClosureInspectionItemsQuery query) {
        JPAQuery<PmsClosureInspectionItemsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(PmsClosureInspectionItemsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRoleCode())) {
            list.add(this.qdo.roleCode.eq((Object)query.getRoleCode()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsClosureInspectionItemsVO queryByKey(Long id) {
        JPAQuery<PmsClosureInspectionItemsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsClosureInspectionItemsVO)jpaQuery.fetchFirst();
    }

    public List<PmsClosureInspectionItemsVO> queryByProjectIdAndRoleCode(Long projectId, List<String> roleCodes) {
        JPAQuery<PmsClosureInspectionItemsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.roleCode.in(roleCodes));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsClosureInspectionItemsVO> queryListDynamic(PmsClosureInspectionItemsQuery query) {
        JPAQuery<PmsClosureInspectionItemsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PmsClosureInspectionItemsDO save(PmsClosureInspectionItemsDO ado) {
        return (PmsClosureInspectionItemsDO)this.repo.save(ado);
    }

    public List<PmsClosureInspectionItemsDO> saveAll(List<PmsClosureInspectionItemsDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PagingVO<PmsClosureInspectionItemsVO> queryPaging(PmsClosureInspectionItemsQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsClosureInspectionItemsVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public long count(PmsClosureInspectionItemsQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    public long deleteByProjecId(Long projectId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.projectId.eq((Object)projectId)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsClosureInspectionItemsDao(JPAQueryFactory jpaQueryFactory, PmsClosureInspectionItemsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

