/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5pms.api.project.payload.PmsClosureInspectionItemsPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsClosurePayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsClosureInspectionItemsService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsClosureInspectionItemsVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsClosureTemplateVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ClosureEnum;
import com.elitesland.tw.tw5pms.server.project.convert.PmsClosureInspectionItemsConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsClosureInspectionItemsDao;
import com.elitesland.tw.tw5pms.server.project.dao.PmsClosureTemplateDao;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsClosureInspectionItemsServiceImpl
extends BaseServiceImpl
implements PmsClosureInspectionItemsService {
    private static final Logger log = LoggerFactory.getLogger(PmsClosureInspectionItemsServiceImpl.class);
    private final PmsClosureInspectionItemsDao inspectionItemsDao;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PmsProjectDAO projectDAO;
    private final PmsClosureTemplateDao closureTemplateDao;

    public Map<String, List<PmsClosureInspectionItemsVO>> queryinspectionItemsList(Long projectId, List<String> roleCodes) {
        List<PmsClosureInspectionItemsVO> inspectionItemsList = this.queryList(projectId, roleCodes);
        for (PmsClosureInspectionItemsVO inspectionItemsVO : inspectionItemsList) {
            if (!ClosureEnum.INSPECTION_METHOD_SYSTEM.getCode().equals(inspectionItemsVO.getMethod())) continue;
            inspectionItemsVO.setStatus(ClosureEnum.COMPLETION_STATUS.getCode());
        }
        return inspectionItemsList.stream().collect(Collectors.groupingBy(PmsClosureInspectionItemsVO::getRoleCode));
    }

    public List<PmsClosureInspectionItemsVO> queryList(Long projectId, List<String> roleCodes) {
        if (!ObjectUtil.isEmpty(roleCodes)) {
            List<PmsClosureInspectionItemsVO> result = this.inspectionItemsDao.queryByProjectIdAndRoleCode(projectId, roleCodes);
            if (ObjectUtils.isEmpty(result)) {
                List<PmsClosureTemplateVO> templateVOS = this.closureTemplateDao.queryByRoleCode(roleCodes);
                result = this.transferData(templateVOS, projectId);
            }
            if (!ObjectUtils.isEmpty(result)) {
                result.stream().forEach(vo -> vo.setMethodName("0".equals(vo.getMethod()) ? ClosureEnum.INSPECTION_METHOD_SYSTEM.getDesc() : ClosureEnum.INSPECTION_METHOD_ARTIFICIAL.getDesc()));
            }
            return result;
        }
        return new ArrayList<PmsClosureInspectionItemsVO>();
    }

    public PmsClosurePayload refreshInspectionItems(PmsClosurePayload payload) {
        List inspectionItemsList = payload.getInspectionItemsList();
        for (PmsClosureInspectionItemsPayload inspectionItems : inspectionItemsList) {
            if (!ClosureEnum.INSPECTION_METHOD_SYSTEM.getCode().equals(inspectionItems.getMethod())) continue;
            inspectionItems.setStatus(ClosureEnum.COMPLETION_STATUS.getCode());
        }
        return payload;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<PmsClosureInspectionItemsVO> batchInsertOrUpdate(PmsClosurePayload payload) {
        List inspectionItemsList = payload.getInspectionItemsList();
        for (PmsClosureInspectionItemsPayload inspectionItems : inspectionItemsList) {
            this.inspectionItemsDao.save(PmsClosureInspectionItemsConvert.INSTANCE.toDo(inspectionItems));
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByProjecId(Long projectId) {
        this.inspectionItemsDao.deleteByProjecId(projectId);
    }

    private List<PmsClosureInspectionItemsVO> transferData(List<PmsClosureTemplateVO> templateVOS, Long projectId) {
        ArrayList<PmsClosureInspectionItemsVO> list = new ArrayList<PmsClosureInspectionItemsVO>();
        for (PmsClosureTemplateVO templateVO : templateVOS) {
            PmsClosureInspectionItemsVO inspectionItemsVO = new PmsClosureInspectionItemsVO();
            inspectionItemsVO.setProjectId(projectId);
            inspectionItemsVO.setRoleCode(templateVO.getRoleCode());
            inspectionItemsVO.setItem(templateVO.getItem());
            inspectionItemsVO.setMethod(templateVO.getMethod());
            inspectionItemsVO.setSpecification(templateVO.getSpecification());
            if (ClosureEnum.INSPECTION_METHOD_SYSTEM.getCode().equals(templateVO.getMethod())) {
                inspectionItemsVO.setStatus(ClosureEnum.COMPLETION_STATUS.getCode());
            }
            list.add(inspectionItemsVO);
        }
        return list;
    }

    public PmsClosureInspectionItemsServiceImpl(PmsClosureInspectionItemsDao inspectionItemsDao, PrdSystemRoleDAO systemRoleDAO, PmsProjectDAO projectDAO, PmsClosureTemplateDao closureTemplateDao) {
        this.inspectionItemsDao = inspectionItemsDao;
        this.systemRoleDAO = systemRoleDAO;
        this.projectDAO = projectDAO;
        this.closureTemplateDao = closureTemplateDao;
    }
}

