/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.company.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.company.payload.CompanyPayload;
import com.elitesland.tw.tw5.api.company.query.CompanyQuery;
import com.elitesland.tw.tw5.api.company.service.CompanyService;
import com.elitesland.tw.tw5.api.company.vo.CompanySimpleVO;
import com.elitesland.tw.tw5.api.company.vo.CompanyVO;
import com.elitesland.tw.tw5.api.partner.common.payload.AddressBookPayload;
import com.elitesland.tw.tw5.api.partner.common.service.AddressBookService;
import com.elitesland.tw.tw5.api.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.partner.common.service.BookLicenseService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.CompanyStatusEnum;
import com.elitesland.tw.tw5.server.company.convert.CompanyConvert;
import com.elitesland.tw.tw5.server.company.dao.CompanyDAO;
import com.elitesland.tw.tw5.server.company.entity.CompanyDO;
import com.elitesland.tw.tw5.server.company.repo.CompanyRepo;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class CompanyServiceImpl
extends BaseServiceImpl
implements CompanyService {
    private static final Logger log = LoggerFactory.getLogger(CompanyServiceImpl.class);
    private final CompanyRepo companyRepo;
    private final CompanyDAO companyDAO;
    private final AddressBookService addressBookService;
    private final BookAddressService bookAddressService;
    private final BookAccountService bookAccountService;
    private final BookLicenseService bookLicenseService;

    public PagingVO<CompanyVO> queryPaging(CompanyQuery query) {
        return this.companyDAO.queryPaging(query);
    }

    public List<CompanyVO> queryListDynamic(CompanyQuery query) {
        return this.companyDAO.queryListDynamic(query);
    }

    public CompanyVO queryByKey(Long key) {
        CompanyDO entity = this.companyRepo.findById(key).orElseGet(CompanyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CompanyVO vo = CompanyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CompanyVO save(CompanyPayload payload) {
        List keys;
        Long bookId;
        this.judgeCompanyName(payload.getCompanyName(), payload.getId());
        Long l = bookId = payload.getBookId() == null ? this.addressBookService.insert(new AddressBookPayload()).getId() : payload.getBookId();
        if (payload.getBookAddressPayload() != null && payload.getBookAddressPayload().size() > 0) {
            payload.getBookAddressPayload().stream().forEach(addressPayload -> {
                if (addressPayload.getId() != null) {
                    this.bookAddressService.update(addressPayload, Boolean.valueOf(false));
                } else {
                    addressPayload.setBookId(bookId);
                    this.bookAddressService.insert(addressPayload, Boolean.valueOf(false));
                }
            });
        }
        if (StringUtils.hasText((String)payload.getAddressDeleteKeys())) {
            keys = Arrays.stream(payload.getAddressDeleteKeys().split(",")).map(p -> Long.valueOf(p)).collect(Collectors.toList());
            this.bookAddressService.deleteSoft(keys, bookId, null, Boolean.valueOf(false));
        }
        if (payload.getBookAccountPayload() != null && payload.getBookAccountPayload().size() > 0) {
            payload.getBookAccountPayload().stream().forEach(accountPayload -> {
                if (accountPayload.getId() != null) {
                    this.bookAccountService.update(accountPayload, Boolean.valueOf(false));
                } else {
                    accountPayload.setBookId(bookId);
                    this.bookAccountService.insert(accountPayload, Boolean.valueOf(false));
                }
            });
        }
        if (StringUtils.hasText((String)payload.getAccountDeleteKeys())) {
            keys = Arrays.stream(payload.getAccountDeleteKeys().split(",")).map(p -> Long.valueOf(p)).collect(Collectors.toList());
            this.bookAccountService.deleteSoft(keys, bookId, null, Boolean.valueOf(false));
        }
        if (payload.getBookLicensePayload() != null && payload.getBookLicensePayload().size() > 0) {
            payload.getBookLicensePayload().stream().forEach(licensePayload -> {
                if (licensePayload.getId() != null) {
                    this.bookLicenseService.update(licensePayload);
                } else {
                    licensePayload.setBookId(bookId);
                    this.bookLicenseService.insert(licensePayload);
                }
            });
        }
        if (StringUtils.hasText((String)payload.getLicenseDeleteKeys())) {
            keys = Arrays.stream(payload.getLicenseDeleteKeys().split(",")).map(p -> Long.valueOf(p)).collect(Collectors.toList());
            this.bookLicenseService.deleteSoft(keys);
        }
        if (payload.getId() != null) {
            return this.update(payload);
        }
        payload.setBookId(bookId);
        payload.setCompanyNo(this.generateSeqNum("COMPANY", new String[0]));
        payload.setCompanyStatus(CompanyStatusEnum.ACTIVE.getCode());
        CompanyDO entityDo = CompanyConvert.INSTANCE.toDo(payload);
        return CompanyConvert.INSTANCE.toVo((CompanyDO)this.companyRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public CompanyVO update(CompanyPayload payload) {
        CompanyDO entity = this.companyRepo.findById(payload.getId()).orElseGet(CompanyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CompanyDO entityDo = CompanyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CompanyConvert.INSTANCE.toVo((CompanyDO)this.companyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.companyRepo.findById(id);
                if (!optional.isEmpty()) {
                    CompanyDO entity = (CompanyDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.companyRepo.save(entity);
                }
            });
        }
    }

    public void updateSoft(List<Long> keys, String status) {
        keys.stream().forEach(id -> {
            Optional optional = this.companyRepo.findById(id);
            if (!optional.isEmpty()) {
                CompanyDO entity = (CompanyDO)optional.get();
                entity.setCompanyStatus(status);
                this.companyRepo.save(entity);
            }
        });
    }

    public List<CompanySimpleVO> listSimple() {
        return this.companyDAO.querylistSimple();
    }

    public void judgeCompanyName(String companyName, Long id) {
        List<Long> ids = this.companyDAO.judgeCompanyName(companyName);
        if (ids != null && ids.size() > 0) {
            if (ids.size() > 2) {
                throw TwException.error((String)"", (String)"\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (!ids.get(0).equals(id)) {
                throw TwException.error((String)"", (String)"\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
    }

    public CompanyServiceImpl(CompanyRepo companyRepo, CompanyDAO companyDAO, AddressBookService addressBookService, BookAddressService bookAddressService, BookAccountService bookAccountService, BookLicenseService bookLicenseService) {
        this.companyRepo = companyRepo;
        this.companyDAO = companyDAO;
        this.addressBookService = addressBookService;
        this.bookAddressService = bookAddressService;
        this.bookAccountService = bookAccountService;
        this.bookLicenseService = bookLicenseService;
    }
}

