/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.query.BusinessCollaboratePartnerInfoQuery;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.identity.convert.BusinessCollaboratePartnerInfoConvert;
import com.elitesland.tw.tw5.server.partner.identity.dao.BusinessCollaboratePartnerInfoDAO;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessCollaboratePartnerInfoRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class BusinessCollaboratePartnerInfoServiceImpl
extends BaseServiceImpl
implements BusinessCollaboratePartnerInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCollaboratePartnerInfoServiceImpl.class);
    private final BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo;
    private final BusinessCollaboratePartnerInfoDAO businessCollaboratePartnerInfoDAO;
    private final FileUtil fileUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;

    public PagingVO<BusinessCollaboratePartnerInfoVO> queryPaging(BusinessCollaboratePartnerInfoQuery query) {
        return this.businessCollaboratePartnerInfoDAO.queryPaging(query);
    }

    public List<BusinessCollaboratePartnerInfoVO> queryListDynamic(BusinessCollaboratePartnerInfoQuery query) {
        List<BusinessCollaboratePartnerInfoVO> businessCollaboratePartnerInfoVOS = this.businessCollaboratePartnerInfoDAO.queryListDynamic(query);
        businessCollaboratePartnerInfoVOS.stream().forEach(vo -> {
            vo.setFileDatas1(this.fileUtil.getFileDatas(vo.getFileCodes1()));
            vo.setFileDatas2(this.fileUtil.getFileDatas(vo.getFileCodes2()));
        });
        return businessCollaboratePartnerInfoVOS;
    }

    public BusinessCollaboratePartnerInfoVO queryByKey(Long key) {
        BusinessCollaboratePartnerInfoDO entity = this.businessCollaboratePartnerInfoRepo.findById(key).orElseGet(BusinessCollaboratePartnerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCollaboratePartnerInfoVO vo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo(entity);
        vo.setFileDatas1(this.fileUtil.getFileDatas(vo.getFileCodes1()));
        vo.setFileDatas2(this.fileUtil.getFileDatas(vo.getFileCodes2()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCollaboratePartnerInfoVO insert(BusinessCollaboratePartnerInfoPayload payload) {
        BusinessCollaboratePartnerInfoDO entityDo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toDo(payload);
        return BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo((BusinessCollaboratePartnerInfoDO)this.businessCollaboratePartnerInfoRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCollaboratePartnerInfoVO update(BusinessCollaboratePartnerInfoPayload payload) {
        BusinessCollaboratePartnerInfoDO entity = this.businessCollaboratePartnerInfoRepo.findById(payload.getId()).orElseGet(BusinessCollaboratePartnerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCollaboratePartnerInfoDO entityLog = new BusinessCollaboratePartnerInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessCollaboratePartnerInfoDO entityDo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        return BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo((BusinessCollaboratePartnerInfoDO)this.businessCollaboratePartnerInfoRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessCollaboratePartnerInfoRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessCollaboratePartnerInfoDO entity = (BusinessCollaboratePartnerInfoDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessCollaboratePartnerInfoRepo.save(entity);
                }
            });
        }
    }

    public BusinessCollaboratePartnerInfoServiceImpl(BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo, BusinessCollaboratePartnerInfoDAO businessCollaboratePartnerInfoDAO, FileUtil fileUtil, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService) {
        this.businessCollaboratePartnerInfoRepo = businessCollaboratePartnerInfoRepo;
        this.businessCollaboratePartnerInfoDAO = businessCollaboratePartnerInfoDAO;
        this.fileUtil = fileUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
    }
}

