/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.identity.convert.BusinessSupplierInfoConvert;
import com.elitesland.tw.tw5.server.partner.identity.dao.BusinessSupplierInfoDAO;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessSupplierInfoRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class BusinessSupplierInfoServiceImpl
extends BaseServiceImpl
implements BusinessSupplierInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessSupplierInfoServiceImpl.class);
    private final BusinessSupplierInfoRepo businessSupplierInfoRepo;
    private final BusinessSupplierInfoDAO businessSupplierInfoDAO;
    private final FileUtil fileUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;

    public PagingVO<BusinessSupplierInfoVO> queryPaging(BusinessSupplierInfoQuery query) {
        return this.businessSupplierInfoDAO.queryPaging(query);
    }

    public List<BusinessSupplierInfoVO> queryListDynamic(BusinessSupplierInfoQuery query) {
        List<BusinessSupplierInfoVO> businessSupplierInfoVOS = this.businessSupplierInfoDAO.queryListDynamic(query);
        businessSupplierInfoVOS.stream().forEach(vo -> vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes())));
        return businessSupplierInfoVOS;
    }

    public BusinessSupplierInfoVO queryByKey(Long key) {
        BusinessSupplierInfoDO entity = this.businessSupplierInfoRepo.findById(key).orElseGet(BusinessSupplierInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessSupplierInfoVO vo = BusinessSupplierInfoConvert.INSTANCE.toVo(entity);
        vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessSupplierInfoVO insert(BusinessSupplierInfoPayload payload) {
        BusinessSupplierInfoDO entityDo = BusinessSupplierInfoConvert.INSTANCE.toDo(payload);
        return BusinessSupplierInfoConvert.INSTANCE.toVo((BusinessSupplierInfoDO)this.businessSupplierInfoRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessSupplierInfoVO update(BusinessSupplierInfoPayload payload) {
        BusinessSupplierInfoDO entity = this.businessSupplierInfoRepo.findById(payload.getId()).orElseGet(BusinessSupplierInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessSupplierInfoDO entityLog = new BusinessSupplierInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessSupplierInfoDO entityDo = BusinessSupplierInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        return BusinessSupplierInfoConvert.INSTANCE.toVo((BusinessSupplierInfoDO)this.businessSupplierInfoRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessSupplierInfoRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessSupplierInfoDO entity = (BusinessSupplierInfoDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessSupplierInfoRepo.save(entity);
                }
            });
        }
    }

    public BusinessSupplierInfoServiceImpl(BusinessSupplierInfoRepo businessSupplierInfoRepo, BusinessSupplierInfoDAO businessSupplierInfoDAO, FileUtil fileUtil, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService) {
        this.businessSupplierInfoRepo = businessSupplierInfoRepo;
        this.businessSupplierInfoDAO = businessSupplierInfoDAO;
        this.fileUtil = fileUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
    }
}

