/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmCustomerDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmCustomerRepo repo;
    private final QCrmCustomerDO qdo = QCrmCustomerDO.crmCustomerDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QCrmLeadsDO qdoLeads1 = new QCrmLeadsDO("qdoLeads1");
    private final QCrmOpportunityDO qdoOpportunity = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;

    private JPAQuery<CrmCustomerVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.customerStatus, this.qdo.customerName, this.qdo.customerGrade, this.qdo.customerSource, this.qdo.serviceUserId, this.qdo.businessUserId, this.qdo.careUserId, this.qdo.operationUserId, this.qdoCompany.companyIndustry, this.qdoCompany.companyPhone, this.qdoCompany.companyEmail, this.qdoCompany.companyFax, this.qdoCompany.province, this.qdoCompany.provinceName, this.qdoCompany.city, this.qdoCompany.cityName, this.qdoCompany.district, this.qdoCompany.districtName, this.qdoCompany.companyAddress, this.qdoCompany.companyWebsite, this.qdoCompany.companyScale, this.qdoCompany.taxNo, this.qdoCompany.currency, this.qdoCompany.language, this.qdoCompany.companyNature, this.qdoCompany.taxNo, this.qdoCompany.longitudeLatitude, this.qdoAb.bookNo, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.longValue().eq((Expression)this.qdo.bookId.longValue()))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.longValue().eq((Expression)this.qdoCompany.bookId.longValue()))).leftJoin((EntityPath)this.qdoLeads)).on((Predicate)this.qdoLeads.formalCustomerId.longValue().eq((Expression)this.qdo.id.longValue()))).leftJoin((EntityPath)this.qdoOpportunity)).on((Predicate)this.qdoOpportunity.formalCustomerId.longValue().eq((Expression)this.qdo.id.longValue()));
        return jpaQuery;
    }

    private JPAQuery<CrmCustomerVO> getJpaQueryWhere(CrmCustomerQuery query) {
        JPAQuery<CrmCustomerVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getCustomerStatus())) {
            jpaQuery.where((Predicate)this.qdo.customerStatus.eq((Object)query.getCustomerStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            jpaQuery.where((Predicate)this.qdo.customerName.like(SqlUtil.toSqlLikeString((String)query.getCustomerName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerSource())) {
            jpaQuery.where((Predicate)this.qdo.customerSource.eq((Object)query.getCustomerSource()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGrade())) {
            jpaQuery.where((Predicate)this.qdo.customerGrade.eq((Object)query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyIndustry())) {
            jpaQuery.where((Predicate)this.qdoCompany.companyIndustry.eq((Object)query.getCompanyIndustry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserIds())) {
            jpaQuery.where((Predicate)this.qdo.createUserId.in((Collection)query.getCreateUserIds()));
        }
        if (!ObjectUtils.isEmpty((Object[])query.getCustomerIds())) {
            jpaQuery.where((Predicate)this.qdo.id.in((Object[])query.getCustomerIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGrades())) {
            jpaQuery.where((Predicate)this.qdo.customerGrade.in((Collection)query.getCustomerGrades()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFilterType())) {
            if (query.getFilterType().equals("sales")) {
                jpaQuery.where((Predicate)this.qdoOpportunity.leadsId.isNull().or((Predicate)this.qdoLeads.sourceType.eq((Object)"personal")).or((Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId())));
            } else if (query.getFilterType().equals("market")) {
                jpaQuery.where((Predicate)this.qdoLeads.sourceType.eq((Object)"market").or((Predicate)this.qdoOpportunity.sourceType.eq((Object)"EXTERNAL")).or((Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId())));
            }
        } else if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return (JPAQuery)jpaQuery.distinct();
    }

    public PagingVO<CrmCustomerVO> queryPaging(CrmCustomerQuery query) {
        JPAQuery<CrmCustomerVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<CrmCustomerVO> queryList(CrmCustomerQuery query) {
        JPAQuery<CrmCustomerVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<CrmCustomerDataVO> queryList() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerDataVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.customerName, this.qdoCompany.companyIndustry})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoCompany.bookId.longValue().eq((Expression)this.qdo.bookId.longValue()))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdoCompany.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public CrmCustomerVO queryDetail(Long key) {
        JPAQuery<CrmCustomerVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdoAb.deleteFlag.eq((Object)0));
        return (CrmCustomerVO)jpaQuery.fetchFirst();
    }

    public CrmCustomerVO queryDetailByBookId(Long bookId) {
        JPAQuery<CrmCustomerVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdoAb.deleteFlag.eq((Object)0));
        return (CrmCustomerVO)jpaQuery.fetchFirst();
    }

    public CrmCustomerDO save(CrmCustomerDO ado) {
        return (CrmCustomerDO)((Object)this.repo.save((Object)ado));
    }

    public List<CrmCustomerDO> saveAll(List<CrmCustomerDO> dos) {
        return this.repo.saveAll(dos);
    }

    public PrdAbVO queryAbVOBykey(Long key) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdAbVO.class, (Expression[])new Expression[]{this.qdoAb.id, this.qdoAb.bookIdV4, this.qdoAb.bookName, this.qdoAb.bookNo, this.qdoAb.bookType})).from((EntityPath)this.qdoAb)).leftJoin((EntityPath)this.qdo)).on((Predicate)this.qdoAb.id.longValue().eq((Expression)this.qdo.bookId.longValue()));
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdoAb.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdAbVO)jpaQuery.fetchFirst();
    }

    public Long queryCompany(Long bookId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoCompany.id).from((EntityPath)this.qdoCompany);
        jpaQuery.where((Predicate)this.qdoCompany.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdoCompany.deleteFlag.eq((Object)0));
        return (Long)jpaQuery.fetchFirst();
    }

    public List<PrdOrgCompanyVO> queryCompanys() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgCompanyVO.class, (Expression[])new Expression[]{this.qdoCompany.id, this.qdoCompany.companyAddress})).from((EntityPath)this.qdoCompany);
        ((JPAQuery)jpaQuery.where((Predicate)this.qdoCompany.deleteFlag.eq((Object)0))).where((Predicate)this.qdoCompany.companyAddress.isNotNull().and((Predicate)this.qdoCompany.companyAddress.isNotEmpty()));
        jpaQuery.where((Predicate)this.qdoCompany.longitudeLatitude.isNull().or((Predicate)this.qdoCompany.longitudeLatitude.isEmpty()));
        return jpaQuery.fetch();
    }

    public long updateCompany(Long key, String longitudeLatitude) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoCompany).where(new Predicate[]{this.qdoCompany.id.eq((Object)key)});
        update.set((Path)this.qdoCompany.longitudeLatitude, (Object)longitudeLatitude);
        return update.execute();
    }

    public long updateByKeyDynamic(CrmCustomerPayload payload) {
        boolean isUp = false;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getCustomerStatus() != null) {
            isUp = true;
            update.set((Path)this.qdo.customerStatus, (Object)payload.getCustomerStatus());
        }
        if (payload.getCustomerName() != null) {
            isUp = true;
            update.set((Path)this.qdo.customerName, (Object)payload.getCustomerName());
        }
        if (payload.getCustomerGrade() != null) {
            isUp = true;
            update.set((Path)this.qdo.customerGrade, (Object)payload.getCustomerGrade());
        }
        if (payload.getCustomerSource() != null) {
            isUp = true;
            update.set((Path)this.qdo.customerSource, (Object)payload.getCustomerSource());
        }
        if (payload.getServiceUserId() != null) {
            isUp = true;
            update.set(this.qdo.serviceUserId, (Object)payload.getServiceUserId());
        }
        if (payload.getBusinessUserId() != null) {
            isUp = true;
            update.set(this.qdo.businessUserId, (Object)payload.getBusinessUserId());
        }
        if (payload.getCareUserId() != null) {
            isUp = true;
            update.set(this.qdo.careUserId, (Object)payload.getCareUserId());
        }
        if (payload.getOperationUserId() != null) {
            isUp = true;
            update.set(this.qdo.operationUserId, (Object)payload.getOperationUserId());
        }
        if (payload.getRemark() != null) {
            isUp = true;
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if (!isUp) {
            return 0L;
        }
        return update.execute();
    }

    public long updateStatus(Long key, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        update.set((Path)this.qdo.customerStatus, (Object)status);
        return update.execute();
    }

    public long updateCustomerGrade(Long key, String grade) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        update.set((Path)this.qdo.customerGrade, (Object)grade);
        return update.execute();
    }

    public List<Map<String, Object>> queryEmployees(List<Long> userIds) {
        return this.repo.queryEmployees(userIds);
    }

    public int countByName(String customerName) {
        return this.repo.countByCustomerNameAndDeleteFlag(customerName, 0);
    }

    public List<CrmCustomerDO> findByName(String customerName) {
        return this.repo.findByCustomerNameAndDeleteFlag(customerName, 0);
    }

    public Long queryIdByBookId(Long bookId) {
        return this.repo.findIdByBookId(bookId);
    }

    public CrmCustomerDAO(JPAQueryFactory jpaQueryFactory, CrmCustomerRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

