/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.bid.payload.BidPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidQuery;
import com.elitesland.tw.tw5crm.api.bid.service.BidService;
import com.elitesland.tw.tw5crm.api.bid.vo.BidOppoVO;
import com.elitesland.tw.tw5crm.api.bid.vo.BidVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6295\u6807\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/crm/bid"})
public class BidController {
    private static final Logger log = LoggerFactory.getLogger(BidController.class);
    private final BidService bidService;

    @PostMapping
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u65b0\u589e")
    public TwOutputUtil<BidVO> insert(@RequestBody BidPayload payload) {
        return TwOutputUtil.ok((Object)this.bidService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u66f4\u65b0")
    public TwOutputUtil<BidVO> update(@RequestBody BidPayload payload) {
        return TwOutputUtil.ok((Object)this.bidService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<BidVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.bidService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u5206\u9875")
    public TwOutputUtil<PagingVO<BidVO>> paging(BidQuery query) {
        return TwOutputUtil.ok((Object)this.bidService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<BidVO>> queryList(BidQuery query) {
        return TwOutputUtil.ok((Object)this.bidService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.bidService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/reviewRecords/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u6295\u6807\u81ea\u5ba1-\u67e5\u8be2\u8bc4\u5ba1\u8bb0\u5f55\u5217\u8868")
    public TwOutputUtil<BidVO> queryReviewRecordsByBidKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.bidService.queryReviewRecordsByBidKey(key));
    }

    @GetMapping(value={"/openingDetails/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u5f00\u6807\u767b\u8bb0-\u67e5\u8be2\u5f00\u6807\u660e\u7ec6\u5217\u8868")
    public TwOutputUtil<BidVO> queryOpeningDetailsByBidKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.bidService.queryOpeningDetailsByBidKey(key));
    }

    @GetMapping(value={"/costRecords/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u5f00\u6807\u767b\u8bb0-\u67e5\u8be2\u8d39\u7528\u8bb0\u5f55\u5217\u8868")
    public TwOutputUtil<BidVO> queryCostRecordsByBidKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.bidService.queryCostRecordsByBidKey(key));
    }

    @PutMapping(value={"/updateBidStatus"})
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u6fc0\u6d3b\u5173\u95ed")
    public TwOutputUtil updateBidStatus(Long key, String bidStatus, String bidResult) {
        this.bidService.updateBidStatus(key, bidStatus, bidResult);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryOppoListSimple"})
    public TwOutputUtil<List<BidOppoVO>> queryOppoListSimple() {
        List oppoListSimple = this.bidService.queryOppoListSimple();
        return TwOutputUtil.ok((Object)oppoListSimple);
    }

    @GetMapping(value={"/oppo/{oppoKey}"})
    @UdcNameClass
    @ApiOperation(value="\u6295\u6807\u7ba1\u7406-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<BidVO> queryByOppoKey(@PathVariable Long oppoKey) {
        return TwOutputUtil.ok((Object)this.bidService.queryByOppoKey(oppoKey));
    }

    public BidController(BidService bidService) {
        this.bidService = bidService;
    }
}

