/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingApplyPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractInvoicePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractInvoiceService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractInvoiceVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractInvoiceConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractInvoiceDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractInvoiceDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractInvoiceRepo;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractInvoiceServiceImpl
extends BaseServiceImpl
implements ContractInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(ContractInvoiceServiceImpl.class);
    private final ContractInvoiceRepo contractInvoiceRepo;
    private final ContractInvoiceDAO contractInvoiceDAO;
    private final FileUtil fileUtil;
    private final UdcUtil udcUtil;

    public PagingVO<ContractInvoiceVO> queryPaging(ContractInvoiceQuery query) {
        return this.contractInvoiceDAO.queryPaging(query);
    }

    public List<ContractInvoiceVO> queryListDynamic(ContractInvoiceQuery query) {
        return this.contractInvoiceDAO.queryListDynamic(query);
    }

    public ContractInvoiceVO queryByKey(Long key) {
        ContractInvoiceDO entity = this.contractInvoiceRepo.findById(key).orElseGet(ContractInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractInvoiceVO vo = ContractInvoiceConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractInvoiceVO insert(ContractInvoicePayload payload) {
        ContractInvoiceDO entityDo = ContractInvoiceConvert.INSTANCE.toDo(payload);
        return ContractInvoiceConvert.INSTANCE.toVo((ContractInvoiceDO)this.contractInvoiceRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractInvoiceVO update(ContractInvoicePayload payload) {
        ContractInvoiceDO entity = this.contractInvoiceRepo.findById(payload.getId()).orElseGet(ContractInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ContractInvoiceDO entityDo = ContractInvoiceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractInvoiceConvert.INSTANCE.toVo((ContractInvoiceDO)this.contractInvoiceRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractInvoiceRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractInvoiceDO entity = (ContractInvoiceDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractInvoiceRepo.save(entity);
                }
            });
        }
    }

    public ContractInvoiceVO queryInvoicetByBillingId(Long billingId) {
        ContractInvoiceVO contractInvoiceVO = this.contractInvoiceDAO.queryInvoicetByBillingId(billingId);
        ContractInvoiceVO contractInvoiceVOTranslate = (ContractInvoiceVO)this.udcUtil.translate((Object)contractInvoiceVO);
        contractInvoiceVOTranslate.setFileDatas(this.fileUtil.getFileDatas(contractInvoiceVO.getFileCodes1()));
        return contractInvoiceVOTranslate;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateInvoiceEntry(ContractBillingApplyPayload payload) {
        ContractInvoiceVO entity = this.contractInvoiceDAO.queryByBillingId(payload.getId());
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        entity.setInvoiceTaxNum(payload.getInvoiceTaxNum());
        entity.setInvoiceDate(LocalDate.now());
        entity.setFileCodes1(payload.getFileCodes());
        ContractInvoiceDO contractInvoiceDO = (ContractInvoiceDO)ContractInvoiceConvert.INSTANCE.toEntity(entity);
        this.contractInvoiceRepo.save(contractInvoiceDO);
    }

    public ContractInvoiceServiceImpl(ContractInvoiceRepo contractInvoiceRepo, ContractInvoiceDAO contractInvoiceDAO, FileUtil fileUtil, UdcUtil udcUtil) {
        this.contractInvoiceRepo = contractInvoiceRepo;
        this.contractInvoiceDAO = contractInvoiceDAO;
        this.fileUtil = fileUtil;
        this.udcUtil = udcUtil;
    }
}

