/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPricePayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductPriceQuery;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceVO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceDO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductPriceDO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductPriceOrgDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductPriceRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ProductPriceDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ProductPriceRepo repo;
    private final QProductPriceDO qdo = QProductPriceDO.productPriceDO;
    private final QProductPriceOrgDO qdoOrg = QProductPriceOrgDO.productPriceOrgDO;

    private JPAQuery<ProductPriceVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ProductPriceVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.submitTime, this.qdo.approvedTime, this.qdo.priceCode, this.qdo.priceName, this.qdo.manageUserId, this.qdo.orgId, this.qdo.startTime, this.qdo.endTime, this.qdo.currCode, this.qdo.priceStatus, this.qdo.saleOrgType, this.qdo.saleOrgIds, this.qdo.saleCustType, this.qdo.saleCustIds})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdo.id.eq(this.qdoOrg.priceId));
    }

    private JPAQuery<ProductPriceVO> getJpaQueryWhere(ProductPriceQuery query) {
        JPAQuery<ProductPriceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(ProductPriceQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ProductPriceQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPriceCode())) {
            list.add(this.qdo.priceCode.like(SqlUtil.toSqlLikeString((String)query.getPriceCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPriceName())) {
            list.add(this.qdo.priceName.like(SqlUtil.toSqlLikeString((String)query.getPriceName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getKeyWords())) {
            list.add(this.qdo.priceName.like(SqlUtil.toSqlLikeString((String)query.getKeyWords())).or((Predicate)this.qdo.priceCode.like(SqlUtil.toSqlLikeString((String)query.getKeyWords()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageUserId())) {
            list.add(this.qdo.manageUserId.eq((Object)query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            list.add(this.qdo.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgIdListStr())) {
            String[] orgIds = query.getOrgIdListStr().split(",");
            ArrayList<Long> orgList = new ArrayList<Long>();
            for (String s : orgIds) {
                Long orgId = Long.valueOf(s);
                orgList.add(orgId);
            }
            list.add(this.qdo.orgId.in(orgList));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrCode())) {
            list.add(this.qdo.currCode.eq((Object)query.getCurrCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPriceStatus())) {
            list.add(this.qdo.priceStatus.eq((Object)query.getPriceStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleOrgType())) {
            list.add(this.qdo.saleOrgType.eq((Object)query.getSaleOrgType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleOrgIds())) {
            list.add(this.qdo.saleOrgIds.eq((Object)query.getSaleOrgIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleCustType())) {
            list.add(this.qdo.saleCustType.eq((Object)query.getSaleCustType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleCustIds())) {
            list.add(this.qdo.saleCustIds.eq((Object)query.getSaleCustIds()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            BooleanExpression jpaQueryOr = this.qdo.createUserId.eq((Object)query.getLoginUserId()).or((Predicate)this.qdo.manageUserId.eq((Object)query.getLoginUserId())).or((Predicate)this.qdoOrg.userId.eq((Object)query.getLoginUserId())).or((Predicate)this.qdo.saleOrgType.eq((Object)"all"));
            if (!ObjectUtils.isEmpty((Object)query.getOrgIdList())) {
                jpaQueryOr = jpaQueryOr.or((Predicate)this.qdo.orgId.in((Collection)query.getOrgIdList())).or((Predicate)this.qdoOrg.orgId.in((Collection)query.getOrgIdList()));
            }
            list.add(jpaQueryOr);
        }
        return ExpressionUtils.allOf(list);
    }

    public ProductPriceVO queryByKey(Long id) {
        JPAQuery<ProductPriceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ProductPriceVO)jpaQuery.fetchFirst();
    }

    public List<ProductPriceVO> queryByKeys(List<Long> ids) {
        JPAQuery<ProductPriceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<ProductPriceVO> queryByDateAndStatus(LocalDate now, String status) {
        JPAQuery<ProductPriceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.endTime.loe((Comparable)now));
        jpaQuery.where((Predicate)this.qdo.priceStatus.eq((Object)status));
        return jpaQuery.fetch();
    }

    public List<ProductPriceVO> queryListDynamic(ProductPriceQuery query) {
        JPAQuery<ProductPriceVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ProductPriceVO> queryPaging(ProductPriceQuery query) {
        JPAQuery<ProductPriceVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults results = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.groupBy(this.qdo.id)).offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(results.getResults()).total(results.getTotal()).build();
    }

    public ProductPriceDO save(ProductPriceDO ado) {
        return (ProductPriceDO)this.repo.save(ado);
    }

    public List<ProductPriceDO> saveAll(List<ProductPriceDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ProductPricePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getPriceCode() != null) {
            update.set((Path)this.qdo.priceCode, (Object)payload.getPriceCode());
        }
        if (payload.getPriceName() != null) {
            update.set((Path)this.qdo.priceName, (Object)payload.getPriceName());
        }
        if (payload.getManageUserId() != null) {
            update.set(this.qdo.manageUserId, (Object)payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(this.qdo.orgId, (Object)payload.getOrgId());
        }
        if (payload.getCurrCode() != null) {
            update.set((Path)this.qdo.currCode, (Object)payload.getCurrCode());
        }
        if (payload.getPriceStatus() != null) {
            update.set((Path)this.qdo.priceStatus, (Object)payload.getPriceStatus());
        }
        if (payload.getSaleOrgType() != null) {
            update.set((Path)this.qdo.saleOrgType, (Object)payload.getSaleOrgType());
        }
        if (payload.getSaleCustType() != null) {
            update.set((Path)this.qdo.saleCustType, (Object)payload.getSaleCustType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("priceCode")) {
                update.setNull((Path)this.qdo.priceCode);
            }
            if (nullFields.contains("priceName")) {
                update.setNull((Path)this.qdo.priceName);
            }
            if (nullFields.contains("manageUserId")) {
                update.setNull(this.qdo.manageUserId);
            }
            if (nullFields.contains("orgId")) {
                update.setNull(this.qdo.orgId);
            }
            if (nullFields.contains("currCode")) {
                update.setNull((Path)this.qdo.currCode);
            }
            if (nullFields.contains("priceStatus")) {
                update.setNull((Path)this.qdo.priceStatus);
            }
            if (nullFields.contains("saleOrgType")) {
                update.setNull((Path)this.qdo.saleOrgType);
            }
            if (nullFields.contains("saleOrgIds")) {
                update.setNull((Path)this.qdo.saleOrgIds);
            }
            if (nullFields.contains("saleCustType")) {
                update.setNull((Path)this.qdo.saleCustType);
            }
            if (nullFields.contains("saleCustIds")) {
                update.setNull((Path)this.qdo.saleCustIds);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateWorkFlow(ProductPricePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        } else {
            update.setNull((Path)this.qdo.procInstId);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstStatus())) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        } else {
            update.setNull(this.qdo.procInstStatus);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getPriceStatus())) {
            update.set((Path)this.qdo.priceStatus, (Object)payload.getPriceStatus());
        } else {
            update.setNull((Path)this.qdo.priceStatus);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSubmitTime())) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApprovedTime())) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDeleteFlag())) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateStatus(List<Long> keys, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.priceStatus, (Object)status).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateStatusForXxxJob(List<Long> keys, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.priceStatus, (Object)status).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public ProductPriceDAO(JPAQueryFactory jpaQueryFactory, ProductPriceRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

