/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSelectionPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessTableColumnsPayload;
import com.elitesland.tw.tw5crm.api.product.payload.CrmSelectChild;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessTableColumnsQuery;
import com.elitesland.tw.tw5crm.api.product.service.CrmBusinessTableColumnsService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.server.product.convert.CrmBusinessTableColumnsConvert;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessTableColumnsDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessTableDAO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessTableColumnsDO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class CrmBusinessTableColumnsServiceImpl
implements CrmBusinessTableColumnsService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessTableColumnsServiceImpl.class);
    private final CrmBusinessTableColumnsDAO columnsDAO;
    private final CrmBusinessTableDAO tableDAO;
    private final PrdSystemSelectionService systemSelectionService;
    private final CacheUtil cacheUtil;
    private static final String TABLE_NAME = "crm_business_table_columns";
    private static final String ATTRIBUTE_TYPE_CUSTOM = "CUSTOM";
    private static final String ATTRIBUTE_TYPE_STANDARD = "STANDARD";
    private static final String CUSTOM_PREFIX = "custom_column";
    private static final String CUSTOM_DESC_PREFIX = "\u81ea\u5b9a\u4e49\u5c5e\u6027";
    private static final String SELECTION_SUFFIX = "\u9009\u62e9\u9879";
    private static final String SELECTION_KEY_PREFIX = "crm:";
    private static final String SELECTION_PARENTID = "34318493798105090";
    private static final String SELECTION_FUNCTIONID = "1";

    @Transactional
    public CrmBusinessTableColumnsVO insert(CrmBusinessTableColumnsPayload payload) {
        CrmBusinessTableColumnsVO maxSortVo = this.columnsDAO.geMaxSortByTableNameAndAttributeType(TABLE_NAME, ATTRIBUTE_TYPE_CUSTOM);
        int countNo = 0;
        Long tenantId = -1L;
        if (maxSortVo != null && maxSortVo.getCountNo() != null) {
            countNo = maxSortVo.getCountNo();
            tenantId = maxSortVo.getTenantId();
        }
        Integer countByTableNameAndAttributeType = countNo + 1;
        List selectChildren = payload.getSelectChildren();
        if (selectChildren != null && selectChildren.size() > 0) {
            String pSelectionName = CUSTOM_DESC_PREFIX + countByTableNameAndAttributeType + SELECTION_SUFFIX;
            String pSelectionKey = "crm:crm_business_table_columns:custom_column:" + tenantId + countByTableNameAndAttributeType;
            String pSelectionValue = CUSTOM_PREFIX + countByTableNameAndAttributeType;
            PrdSystemSelectionVO pSystemSelectionVO = this.insertSelection(pSelectionName, pSelectionKey, pSelectionValue, Long.valueOf(SELECTION_PARENTID));
            Long pid = pSystemSelectionVO.getId();
            for (int i = 0; i < selectChildren.size(); ++i) {
                String selectionName = ((CrmSelectChild)selectChildren.get(i)).getName();
                String key = i > 9 ? "" + i : "0" + i;
                String selectionKey = pSelectionKey + ":" + key;
                String selectionValue = key;
                this.insertSelection(selectionName, selectionKey, selectionValue, pid);
            }
            payload.setSelectionCode(pSelectionKey);
            String attributeScope = payload.getSelectChildren().stream().map(CrmSelectChild::getName).collect(Collectors.joining(";"));
            payload.setAttributeScope(attributeScope);
        }
        CrmBusinessTableColumnsDO customColumn = new CrmBusinessTableColumnsDO();
        customColumn.setTableName(TABLE_NAME);
        customColumn.setAttributeType(ATTRIBUTE_TYPE_CUSTOM);
        customColumn.setStatus(1);
        customColumn.setAttributeDesc(payload.getAttributeDesc());
        customColumn.setComponentType(payload.getComponentType());
        customColumn.setIsMultiple(payload.getIsMultiple());
        customColumn.setSelectionCode(payload.getSelectionCode());
        customColumn.setAttributeScope(payload.getAttributeScope());
        customColumn.setColumnName(CUSTOM_PREFIX + countByTableNameAndAttributeType);
        customColumn.setColumnDesc(CUSTOM_DESC_PREFIX + countByTableNameAndAttributeType);
        customColumn.setCountNo(countByTableNameAndAttributeType);
        CrmBusinessTableColumnsDO save = this.columnsDAO.save(customColumn);
        CrmBusinessTableColumnsVO crmBusinessTableColumnsVO = CrmBusinessTableColumnsConvert.INSTANCE.toVo(save);
        return crmBusinessTableColumnsVO;
    }

    public CrmBusinessTableColumnsVO findByKey(Long key) {
        CrmBusinessTableColumnsVO vo = this.columnsDAO.findByKey(key);
        if (StringUtils.hasLength((String)vo.getSelectionCode())) {
            PrdSystemSelectionVO view = this.cacheUtil.getSystemSelection(vo.getSelectionCode());
            List children = view.getChildren();
            List<CrmSelectChild> selectChildren = children.stream().map(e -> CrmSelectChild.builder().id(e.getId()).name(e.getSelectionName()).build()).toList();
            vo.setSelectChildren(selectChildren);
        }
        return vo;
    }

    @Transactional
    public void update(CrmBusinessTableColumnsPayload payload) {
        if (payload.getSelectChildren() != null && payload.getSelectChildren().size() > 0) {
            String attributeScope = payload.getSelectChildren().stream().map(CrmSelectChild::getName).collect(Collectors.joining(";"));
            payload.setAttributeScope(attributeScope);
        }
        long update = this.columnsDAO.update(payload);
        if (payload.getStatus() == null && payload.getSelectionCode() != null) {
            String selectionCode = payload.getSelectionCode();
            PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection(selectionCode);
            Long pid = systemSelection.getId();
            int childrenSize = systemSelection.getChildren().size();
            if (payload.getSelectChildren() != null && payload.getSelectChildren().size() > 0) {
                List selectChildren = payload.getSelectChildren();
                List<Long> selectChildrenIds = selectChildren.stream().filter(e -> e.getId() != null && e.getId() > 0L).map(CrmSelectChild::getId).toList();
                List<Long> systemSelectionChildrenIds = systemSelection.getChildren().stream().map(BaseViewModel::getId).toList();
                List<Long> deleteSystemSelectionChildrenIds = systemSelectionChildrenIds.stream().filter(e -> !selectChildrenIds.contains(e)).toList();
                this.systemSelectionService.deleteSoft(deleteSystemSelectionChildrenIds);
                for (CrmSelectChild selectChild : selectChildren) {
                    if (selectChild.getId() != null && selectChild.getId() > 0L) {
                        this.updateSelection(selectChild.getName(), selectChild.getId());
                        continue;
                    }
                    String selectionName = selectChild.getName();
                    String key = childrenSize > 9 ? "" + childrenSize : "0" + childrenSize;
                    String selectionKey = selectionCode + ":" + key;
                    String selectionValue = key;
                    this.insertSelection(selectionName, selectionKey, selectionValue, pid);
                    ++childrenSize;
                }
            } else {
                List<Long> systemSelectionChildrenIds = systemSelection.getChildren().stream().map(BaseViewModel::getId).toList();
                this.systemSelectionService.deleteSoft(systemSelectionChildrenIds);
            }
        }
    }

    public PagingVO<CrmBusinessTableColumnsVO> paging(CrmBusinessTableColumnsQuery query) {
        query.setTableName(TABLE_NAME);
        PagingVO<CrmBusinessTableColumnsVO> crmBusinessTableColumnsVOPagingVO = this.columnsDAO.queryPaging(query);
        List records = crmBusinessTableColumnsVOPagingVO.getRecords();
        records.forEach(e -> {
            String attributeTypeDesc = Objects.equals(e.getAttributeType(), ATTRIBUTE_TYPE_CUSTOM) ? "\u81ea\u5b9a\u4e49" : "\u6807\u51c6";
            String componentTypeDesc = this.cacheUtil.transferSystemSelection("attribute:componentType", e.getComponentType());
            e.setAttributeTypeDesc(attributeTypeDesc);
            e.setComponentTypeDesc(componentTypeDesc);
        });
        return crmBusinessTableColumnsVOPagingVO;
    }

    private PrdSystemSelectionVO insertSelection(String pSelectionName, String pSelectionKey, String pSelectionValue, Long parentId) {
        PrdSystemSelectionPayload selectionPayload = new PrdSystemSelectionPayload();
        selectionPayload.setSelectionName(pSelectionName);
        selectionPayload.setSelectionKey(pSelectionKey);
        selectionPayload.setSelectionValue(pSelectionValue);
        selectionPayload.setParentId(parentId);
        selectionPayload.setRemark("\u4ea7\u54c1\u5c5e\u6027\u81ea\u52a8\u751f\u6210\uff0c\u8bf7\u52ff\u64cd\u4f5c");
        selectionPayload.setFunctionId(Long.valueOf(SELECTION_FUNCTIONID));
        return this.systemSelectionService.insert(selectionPayload);
    }

    private Long updateSelection(String pSelectionName, Long id) {
        PrdSystemSelectionVO prdSystemSelectionVO = this.systemSelectionService.queryByKey(id);
        PrdSystemSelectionPayload payload = new PrdSystemSelectionPayload();
        payload.setSelectionName(pSelectionName);
        payload.setSelectionKey(prdSystemSelectionVO.getSelectionKey());
        payload.setSelectionValue(prdSystemSelectionVO.getSelectionValue());
        payload.setParentId(prdSystemSelectionVO.getParentId());
        payload.setFunctionId(prdSystemSelectionVO.getFunctionId());
        payload.setId(id);
        return this.systemSelectionService.update(payload);
    }

    public CrmBusinessTableColumnsServiceImpl(CrmBusinessTableColumnsDAO columnsDAO, CrmBusinessTableDAO tableDAO, PrdSystemSelectionService systemSelectionService, CacheUtil cacheUtil) {
        this.columnsDAO = columnsDAO;
        this.tableDAO = tableDAO;
        this.systemSelectionService = systemSelectionService;
        this.cacheUtil = cacheUtil;
    }
}

