/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.visit.service;

import cn.hutool.core.lang.Validator;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import com.elitesland.tw.tw5.api.partner.common.payload.BusinessPartnerForVisitTaskPayload;
import com.elitesland.tw.tw5.api.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRefService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdFsmFileRefQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.sms.config.TwSmsProperties;
import com.elitesland.tw.tw5.server.prd.sms.service.TwSmsService;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdFsmRefObjTypeEnum;
import com.elitesland.tw.tw5crm.api.open.payload.VisitTaskOpenPayload;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5crm.api.visit.query.VisitPlanDetailQuery;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitPlanDetailVO;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitPlanVO;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitTaskVO;
import com.elitesland.tw.tw5crm.server.common.constants.VisitSignTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskEvalStatusEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanPersonTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5crm.server.visit.convert.VisitTaskConvert;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitPlanDAO;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitPlanDetailDAO;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitSignRecordDAO;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitTaskDAO;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitSignRecordDO;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitTaskDO;
import com.elitesland.tw.tw5crm.server.visit.repo.VisitTaskRepo;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class VisitTaskServiceImpl
extends BaseServiceImpl
implements VisitTaskService {
    private static final Logger log = LoggerFactory.getLogger(VisitTaskServiceImpl.class);
    private final VisitTaskRepo visitTaskRepo;
    private final VisitTaskDAO visitTaskDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final VisitPlanDAO visitPlanDAO;
    private final VisitPlanDetailDAO visitPlanDetailDAO;
    private final VisitSignRecordDAO visitSignRecordDAO;
    private final FileUtil fileUtil;
    private final TwSmsService twSmsService;
    private final TwSmsProperties twSmsProperties;
    @Resource
    private BusinessPartnerService businessPartnerService;
    private final BookAddressService bookAddressService;
    private final BookContactsService bookContactsService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final ShortUrlRefService shortUrlRefService;

    public PagingVO<VisitTaskVO> paging(VisitTaskQuery query) {
        Page page = this.visitTaskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(VisitTaskConvert.INSTANCE::toVo));
    }

    public PagingVO<VisitTaskVO> queryPaging(VisitTaskQuery query) {
        this.dataPermissionFlag(query);
        PagingVO<VisitTaskVO> pagingVO = this.visitTaskDAO.queryPaging(query);
        pagingVO.getRecords().forEach(visitTaskVO -> this.translation((VisitTaskVO)visitTaskVO, false));
        return pagingVO;
    }

    public PagingVO<VisitTaskVO> myQueryPaging(VisitTaskQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setVisitMemberId(loginUserId);
        PagingVO<VisitTaskVO> pagingVO = this.visitTaskDAO.queryPaging(query);
        pagingVO.getRecords().forEach(visitTaskVO -> this.translation((VisitTaskVO)visitTaskVO, false));
        return pagingVO;
    }

    void dataPermissionFlag(VisitTaskQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long userId = GlobalUtil.getLoginUserId();
            query.setCreateUserIdPro(userId);
            Set subordinatesIdsByUserId = this.prdOrgEmployeeService.queryOneSubordinatesIdsByUserId(userId);
            query.setSubordinatesIds(subordinatesIdsByUserId);
        }
    }

    public List<VisitTaskVO> queryListDynamic(VisitTaskQuery query) {
        this.dataPermissionFlag(query);
        return this.visitTaskDAO.queryListDynamic(query);
    }

    public List<VisitTaskVO> queryListDynamicWithoutPermission(VisitTaskQuery query) {
        return this.visitTaskDAO.queryListDynamic(query);
    }

    public VisitTaskVO queryByKey(Long key) {
        VisitTaskDO entity = this.visitTaskRepo.findById(key).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        VisitTaskVO vo = VisitTaskConvert.INSTANCE.toVo(entity);
        this.translation(vo, true);
        return vo;
    }

    private void translation(VisitTaskVO vo, boolean translationFileFlag) {
        PrdOrgDataRefVO defaultOrgInfo;
        String teamMemberIds = vo.getTeamMemberIds();
        if (StringUtils.hasText((String)teamMemberIds)) {
            String[] teamMemberIdArr = teamMemberIds.split(",");
            ArrayList<String> teamMemberNameList = new ArrayList<String>();
            for (int i = 0; i < teamMemberIdArr.length; ++i) {
                String userName = this.cacheUtil.getUserName(Long.valueOf(teamMemberIdArr[i]));
                teamMemberNameList.add(userName);
            }
            String teamMemberNames = teamMemberNameList.stream().collect(Collectors.joining(","));
            vo.setTeamMemberNames(teamMemberNames);
        }
        vo.setVisitMemberParentIdPro((defaultOrgInfo = this.cacheUtil.getDefaultOrgInfoByUserId(vo.getVisitMemberId())) != null ? defaultOrgInfo.getParentId() : null);
        if (translationFileFlag) {
            PrdFsmFileRefQuery prdFsmFileRefQuery = new PrdFsmFileRefQuery();
            prdFsmFileRefQuery.setObjId(vo.getId());
            prdFsmFileRefQuery.setObjType(PrdFsmRefObjTypeEnum.VISIT_TASK_RECORDING.getCode());
            List prdFsmFileRefVOS = this.prdFsmFileRefService.queryList(prdFsmFileRefQuery);
            ArrayList fileObjRespVOList = new ArrayList();
            prdFsmFileRefVOS.stream().forEach(prdFsmFileRefVO -> {
                List fileData = (List)prdFsmFileRefVO.getFileData();
                if (!CollectionUtils.isEmpty((Collection)fileData)) {
                    fileData.forEach(fileObjRespVO -> {
                        if (StringUtils.hasText((String)prdFsmFileRefVO.getFileName())) {
                            fileObjRespVO.setOriginalName(prdFsmFileRefVO.getFileName());
                        }
                    });
                    fileObjRespVOList.addAll(fileData);
                }
            });
            vo.setFileDatas(fileObjRespVOList);
            vo.setSignFileDatas(this.fileUtil.getFileDatas(vo.getSignFileCodes()));
            vo.setSignOutFileDatas(this.fileUtil.getFileDatas(vo.getSignOutFileCodes()));
            if (null == vo.getPartnerId()) {
                log.warn("\u9500\u552e\u62dc\u8bbf\u8ba1\u5212\u672a\u5173\u8054\u5ba2\u6237\uff1b\u9500\u552e\u62dc\u8bbf\u8ba1\u5212\uff1a{}", (Object)vo);
                return;
            }
            BusinessPartnerVO simpleVO = this.businessPartnerService.queryByKeySimple(vo.getPartnerId());
            if (null != simpleVO) {
                BookContactsVO bookContactsVO;
                Long bookId = simpleVO.getBookId();
                if (null == bookId) {
                    log.warn("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff1b\u627e\u4e0d\u5230bookId;  partnerId:{}", (Object)vo.getPartnerId());
                    return;
                }
                BookAddressVO bookAddressVO = this.bookAddressService.queryDefaultByBookId(bookId);
                if (bookAddressVO != null) {
                    vo.setBookId(bookId);
                    vo.setCompanyAddress(bookAddressVO.getDetailAddress());
                    vo.setLongitudeLatitude(bookAddressVO.getLongitudeLatitude());
                }
                if (null != (bookContactsVO = this.bookContactsService.queryDefaultByBookId(bookId))) {
                    vo.setContactsName(bookContactsVO.getContactsName());
                    vo.setContactsPhone(bookContactsVO.getContactsPhone());
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public VisitTaskVO insert(VisitTaskPayload payload) {
        this.check(payload);
        this.dataProcess(payload);
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        VisitTaskDO save = (VisitTaskDO)this.visitTaskRepo.save(entityDo);
        this.signDataProcess(payload, save);
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public VisitTaskVO update(VisitTaskPayload payload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            throw TwException.error((String)"", (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VisitTaskDO entity = this.visitTaskRepo.findById(payload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u62dc\u8bbf\u4efb\u52a1\u4e0d\u5b58\u5728");
        this.checkUpdate(payload, entity);
        if (ObjectUtils.isEmpty((Object)payload.getPlanId())) {
            payload.setPlanId(entity.getPlanId());
        }
        this.dataProcess(payload);
        if (!ObjectUtils.isEmpty((Object)payload.getStatus()) && payload.getStatus().equals(VisitTaskStatusEnum.OK.getCode())) {
            if (!loginUserId.equals(entity.getVisitMemberId()) && !rolePermission.booleanValue()) {
                throw TwException.error((String)"", (String)"\u6743\u9650\u4e0d\u8db3");
            }
            payload.setSubmitTime(LocalDateTime.now());
            payload.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
            Long partnerId = entity.getPartnerId();
            if (payload.getPlanType() != null) {
                boolean sendSmsFlag;
                if ((payload.getPlanType().equals(VisitTaskPlanTypeEnum.general_plan.getCode()) || payload.getPlanType().equals(VisitTaskPlanTypeEnum.periodic_plan.getCode())) && (sendSmsFlag = this.sendSms(entity.getId(), entity.getSendFlag(), partnerId))) {
                    entity.setSendFlag(1);
                }
                if (payload.getPlanType().equals(VisitTaskPlanTypeEnum.sell_visit_plan.getCode()) && (sendSmsFlag = this.sendSms(entity.getId(), entity.getSendFlag(), payload.getPartnerId()))) {
                    entity.setSendFlag(1);
                }
            }
        }
        if (StringUtils.hasText((String)payload.getCustomerDesc()) || StringUtils.hasText((String)payload.getResult()) || null != payload.getNextVisitTime() || StringUtils.hasText((String)payload.getSignLocations()) || StringUtils.hasText((String)payload.getSignOutLocations())) {
            if (!loginUserId.equals(entity.getVisitMemberId()) && !rolePermission.booleanValue()) {
                throw TwException.error((String)"", (String)"\u6743\u9650\u4e0d\u8db3");
            }
            if (ObjectUtils.isEmpty((Object)payload.getStatus())) {
                payload.setStatus(VisitTaskStatusEnum.READY.getCode());
            }
        }
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        VisitTaskDO save = (VisitTaskDO)this.visitTaskRepo.save(entity);
        Long planId = save.getPlanId();
        this.signDataProcess(payload, save);
        if (planId != null) {
            this.updatePlanStatus(planId);
        }
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean sendSms(Long taskId, Integer sendFlag, Long partnerId) {
        BusinessPartnerVO simpleVO;
        if (null != partnerId && null != (simpleVO = this.businessPartnerService.queryByKeySimple(partnerId))) {
            Long bookId = simpleVO.getBookId();
            if (null == bookId) {
                log.warn("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff1b\u627e\u4e0d\u5230bookId;  partnerId:{}", (Object)partnerId);
                return false;
            }
            BookContactsVO bookContactsVO = this.bookContactsService.queryDefaultByBookId(bookId);
            if (null != bookContactsVO) {
                String contactsPhone = bookContactsVO.getContactsPhone();
                String contactsName = bookContactsVO.getContactsName();
                if (!StringUtils.hasText((String)contactsName)) {
                    contactsName = "\u5ba2\u6237";
                }
                if (sendFlag == null || sendFlag != null && sendFlag == 0) {
                    TemplateSmsDTO smsDTO = new TemplateSmsDTO();
                    HashSet<String> mobile = new HashSet<String>();
                    mobile.add(contactsPhone);
                    String smsTemplateCode = this.twSmsProperties.getSmsTemplateCodeVisitTaskEval();
                    smsDTO.setTemplateCode(smsTemplateCode);
                    smsDTO.setSignName("\u57c3\u6797\u54f2CRM");
                    smsDTO.setMobiles(mobile);
                    smsDTO.setSubject("Elitesland");
                    smsDTO.setBusinessType("CRM-TESTSEND");
                    boolean isMobile = Validator.isMobile((CharSequence)contactsPhone);
                    if (isMobile) {
                        ShortUrlRefVO shortUrlRefVO = this.shortUrlRefService.saveRedirect(this.twSmsProperties.getVisitTaskEvalRedirectUri() + "?taskId=" + taskId);
                        String code = shortUrlRefVO.getCode();
                        String shortUrlRelative = shortUrlRefVO.getShortUrlRelative();
                        if (!StringUtils.hasText((String)shortUrlRelative)) {
                            shortUrlRelative = "/tw-server5-crm/s/r/";
                        }
                        String jumpuri = shortUrlRelative + code;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("name", contactsName);
                        map.put("jumpuri", jumpuri);
                        map.put("templateCode", smsTemplateCode);
                        smsDTO.setTemplateParams(map);
                        ApiResult booleanApiResult = this.twSmsService.sendTemplateMsg(smsDTO);
                        if (booleanApiResult.isSuccess()) {
                            return true;
                        }
                        log.error("\u53d1\u9001\u5ba2\u6237\u8bc4\u4ef7\u5f02\u5e38\uff1a", (Object)booleanApiResult.getErrorMsg());
                    } else {
                        log.error("\u9500\u552e\u62dc\u8bbf\u4efb\u52a1\u76f8\u5173\u5ba2\u6237\u3010{}\u3011,\u7684\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u914d\u7f6e\u9519\u8bef\uff1a\u3010{}\u3011", (Object)"test", mobile);
                    }
                }
            } else {
                log.error("\u53d1\u9001\u5ba2\u6237\u8bc4\u4ef7\u5f02\u5e38\uff1a", (Object)"\u672a\u5339\u914d\u5230\u5ba2\u6237\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
        }
        return false;
    }

    private void signDataProcess(VisitTaskPayload payload, VisitTaskDO save) {
        VisitSignRecordDO signRecordDO;
        LocalDateTime now = LocalDateTime.now();
        if (!ObjectUtils.isEmpty((Object)payload.getSignLocations())) {
            signRecordDO = new VisitSignRecordDO();
            signRecordDO.setTaskId(save.getId());
            signRecordDO.setPlanId(save.getPlanId());
            signRecordDO.setType(VisitSignTypeEnum.IN.getCode());
            signRecordDO.setTaskName(save.getTaskName());
            signRecordDO.setFileCodes(payload.getSignFileCodes());
            signRecordDO.setSignTime(now);
            signRecordDO.setLocations(payload.getSignLocations());
            signRecordDO.setAddress(payload.getSignAddress());
            this.visitSignRecordDAO.save(signRecordDO);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSignOutLocations())) {
            signRecordDO = new VisitSignRecordDO();
            signRecordDO.setTaskId(save.getId());
            signRecordDO.setPlanId(save.getPlanId());
            signRecordDO.setType(VisitSignTypeEnum.OUT.getCode());
            signRecordDO.setTaskName(save.getTaskName());
            signRecordDO.setFileCodes(payload.getSignOutFileCodes());
            signRecordDO.setSignTime(now);
            signRecordDO.setLocations(payload.getSignOutLocations());
            signRecordDO.setAddress(payload.getSignOutAddress());
            this.visitSignRecordDAO.save(signRecordDO);
        }
    }

    public List<VisitTaskVO> generateTaskByPlanId(Long planId) {
        ArrayList<VisitTaskDO> taskDOList = new ArrayList<VisitTaskDO>();
        if (null != planId) {
            VisitPlanVO visitPlanVO = this.visitPlanDAO.queryByKey(planId);
            Assert.notNull((Object)visitPlanVO, (String)"\u62dc\u8bbf\u8ba1\u5212\u4e0d\u5b58\u5728");
            String visitPlanType = visitPlanVO.getVisitPlanType();
            int visitTimesInt = 1;
            if (!VisitTaskPlanTypeEnum.general_plan.getCode().equals(visitPlanType)) {
                String visitTimes = visitPlanVO.getVisitTimes();
                if (ObjectUtils.isEmpty((Object)visitTimes)) {
                    throw TwException.error((String)"", (String)"\u62dc\u8bbf\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                visitTimesInt = Integer.valueOf(visitTimes);
            }
            Long partnerId = visitPlanVO.getPartnerId();
            String customerName = "";
            if (!ObjectUtils.isEmpty((Object)partnerId)) {
                BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(partnerId);
                Assert.notNull((Object)businessPartnerVO, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
                customerName = businessPartnerVO.getPartnerName();
            }
            this.deleteSoftByPlanId(planId);
            VisitPlanDetailQuery planDetailQuery = new VisitPlanDetailQuery();
            planDetailQuery.setVisitPlanId(planId);
            List<Object> planDetailVOList = this.visitPlanDetailDAO.queryListDynamic(planDetailQuery);
            if (!CollectionUtils.isEmpty(planDetailVOList)) {
                planDetailVOList = planDetailVOList.stream().filter(visitPlanDetailVO -> visitPlanDetailVO.getVisitPersonType().equals(VisitTaskPlanPersonTypeEnum.visit_person.getCode())).distinct().collect(Collectors.toList());
                int i = 1;
                for (VisitPlanDetailVO visitPlanDetailVO2 : planDetailVOList) {
                    for (int j = 0; j < visitTimesInt; ++j) {
                        VisitTaskDO taskDO = new VisitTaskDO();
                        String visitPlanName = visitPlanVO.getVisitPlanName();
                        taskDO.setPlanId(planId);
                        taskDO.setPlanName(visitPlanName);
                        taskDO.setPlanType(visitPlanType);
                        taskDO.setObjId(visitPlanVO.getObjId());
                        taskDO.setObjName(visitPlanVO.getObjName());
                        taskDO.setObjType(visitPlanVO.getObjType());
                        taskDO.setStartTime(visitPlanVO.getVisitDateFrom());
                        taskDO.setEndTime(visitPlanVO.getVisitDateTo());
                        taskDO.setPlanCreateUserId(visitPlanVO.getCreateUserId());
                        taskDO.setStatus(VisitTaskStatusEnum.NEW.getCode());
                        taskDO.setPartnerId(partnerId);
                        taskDO.setCustomerName(customerName);
                        taskDO.setTeamMemberIds(visitPlanVO.getExtString2());
                        Long visitPersonId = visitPlanDetailVO2.getVisitPersonId();
                        taskDO.setVisitMemberId(visitPersonId);
                        String userName = this.cacheUtil.getUserName(visitPersonId);
                        taskDO.setVisitMemberName(userName);
                        PrdOrgDataRefVO defaultOrgInfo = this.cacheUtil.getDefaultOrgInfoByUserId(visitPersonId);
                        taskDO.setVisitMemberParentId(defaultOrgInfo != null ? defaultOrgInfo.getParentId() : null);
                        taskDO.setTaskName(visitPlanName + "-" + userName + "-" + i);
                        if ("sell_visit_plan".equals(visitPlanVO.getVisitPlanType())) {
                            taskDO.setTaskType("sell_visit_task");
                        } else if ("periodic_plan".equals(visitPlanVO.getVisitPlanType())) {
                            taskDO.setTaskType("periodic_task");
                        } else if ("general_plan".equals(visitPlanVO.getVisitPlanType())) {
                            taskDO.setTaskType("general_task");
                        }
                        ++i;
                        taskDOList.add(taskDO);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(taskDOList)) {
            this.visitTaskDAO.saveAll(taskDOList);
        }
        return VisitTaskConvert.INSTANCE.toVoList(taskDOList);
    }

    private void updatePlanStatus(Long planId) {
        VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
        visitTaskQuery.setPlanId(planId);
        visitTaskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        long count = this.visitTaskDAO.count(visitTaskQuery);
        VisitTaskQuery visitTaskQueryAll = new VisitTaskQuery();
        visitTaskQueryAll.setPlanId(planId);
        long countAll = this.visitTaskDAO.count(visitTaskQueryAll);
        if (count == countAll) {
            this.visitPlanDAO.completeVisitPlan(planId);
        }
    }

    private void dataProcess(VisitTaskPayload payload) {
        Long partnerId = payload.getPartnerId();
        if (payload.getPlanId() != null) {
            VisitPlanVO visitPlanVO = this.visitPlanDAO.queryByKey(payload.getPlanId());
            Assert.notNull((Object)visitPlanVO, (String)"\u62dc\u8bbf\u8ba1\u5212\u4e0d\u5b58\u5728");
            payload.setPlanName(visitPlanVO.getVisitPlanName());
            payload.setPlanType(visitPlanVO.getVisitPlanType());
            payload.setObjId(null != payload.getObjId() ? payload.getObjId() : visitPlanVO.getObjId());
            payload.setObjName(StringUtils.hasText((String)payload.getObjName()) ? payload.getObjName() : visitPlanVO.getObjName());
            payload.setObjType(StringUtils.hasText((String)payload.getObjType()) ? payload.getObjType() : visitPlanVO.getObjType());
            payload.setStartTime(null != payload.getStartTime() ? payload.getStartTime() : visitPlanVO.getVisitDateFrom());
            payload.setEndTime(null != payload.getEndTime() ? payload.getEndTime() : visitPlanVO.getVisitDateTo());
            payload.setCustomAdress(StringUtils.hasText((String)payload.getCustomAdress()) ? payload.getCustomAdress() : visitPlanVO.getCustomAdress());
            payload.setLongitudeLatitude(StringUtils.hasText((String)payload.getLongitudeLatitude()) ? payload.getLongitudeLatitude() : visitPlanVO.getLongitudeLatitude());
            payload.setPlanCreateUserId(visitPlanVO.getCreateUserId());
            if (ObjectUtils.isEmpty((Object)partnerId)) {
                partnerId = visitPlanVO.getPartnerId();
            }
        }
        if (ObjectUtils.isEmpty((Object)partnerId)) {
            payload.setPartnerId(partnerId);
        }
        if (!ObjectUtils.isEmpty((Object)partnerId)) {
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(partnerId);
            Assert.notNull((Object)businessPartnerVO, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            payload.setCustomerName(businessPartnerVO.getPartnerName());
        }
        if (ObjectUtils.isEmpty((Object)payload.getStatus()) && null == payload.getId()) {
            payload.setStatus(VisitTaskStatusEnum.NEW.getCode());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSignLocations()) && null == payload.getSignTime()) {
            payload.setSignTime(LocalDateTime.now());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSignOutLocations()) && null == payload.getSignOutTime()) {
            payload.setSignOutTime(LocalDateTime.now());
        }
    }

    private void check(VisitTaskPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getPlanId())) {
            throw TwException.error((String)"", (String)"planId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkUpdate(VisitTaskPayload payload, VisitTaskDO entity) {
        if (entity.getStatus().equals(VisitTaskStatusEnum.OK.getCode())) {
            throw TwException.error((String)"", (String)"\u5df2\u63d0\u4ea4\u7684\u4efb\u52a1\u4e0d\u53ef\u53d8\u66f4");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.visitTaskRepo.findById(id);
                if (!optional.isEmpty()) {
                    VisitTaskDO entity = (VisitTaskDO)optional.get();
                    if (null != entity.getPlanCreateUserId() && entity.getPlanCreateUserId().equals(loginUserId) || entity.getVisitMemberId().equals(loginUserId) || rolePermission.booleanValue()) {
                        if (!entity.getStatus().equals(VisitTaskStatusEnum.NEW.getCode())) {
                            throw TwException.error((String)"", (String)("[" + entity.getTaskName() + "]\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664"));
                        }
                        entity.setDeleteFlag(1);
                        this.visitTaskRepo.save(entity);
                    } else {
                        throw TwException.error((String)"", (String)("[" + entity.getTaskName() + "]\u65e0\u6743\u9650\u5220\u9664"));
                    }
                }
            });
        }
    }

    public void deleteSoftByPlanId(Long planId) {
        if (null != planId) {
            long count = this.countByPlanId(planId);
            if (count > 0L) {
                throw TwException.error((String)"", (String)"\u4efb\u52a1\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            this.visitTaskDAO.deleteSoftByPlanId(planId);
        }
    }

    public long countByPlanId(Long planId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setPlanId(planId);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(VisitTaskStatusEnum.OK.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
        return this.visitTaskDAO.count(taskQuery);
    }

    public VisitTaskOpenPayload customerEval(VisitTaskOpenPayload openPayload) {
        VisitTaskDO entity = this.visitTaskRepo.findById(openPayload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u62dc\u8bbf\u4e0d\u5b58\u5728");
        VisitTaskPayload payload = new VisitTaskPayload();
        payload.setId(openPayload.getId());
        payload.setCustomerGradle(openPayload.getCustomerGradle());
        payload.setCustomerAdvise(openPayload.getCustomerAdvise());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        this.visitTaskRepo.save(entity);
        return openPayload;
    }

    public VisitTaskVO leaderEval(VisitTaskPayload payload) {
        VisitTaskDO entity = this.visitTaskRepo.findById(payload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u62dc\u8bbf\u4e0d\u5b58\u5728");
        VisitTaskPayload update = new VisitTaskPayload();
        update.setId(payload.getId());
        update.setLeaderGradle(payload.getLeaderGradle());
        update.setEvalStatus(VisitTaskEvalStatusEnum.OK.getCode());
        update.setNextPlan(payload.getNextPlan());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(update);
        entity.copy(entityDo);
        VisitTaskDO save = (VisitTaskDO)this.visitTaskRepo.save(entity);
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    public long count(VisitTaskQuery query) {
        return this.visitTaskDAO.count(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO businessPartnerInsert(BusinessPartnerForVisitTaskPayload payload) {
        Long visitTaskId = payload.getVisitTaskId();
        if (ObjectUtils.isEmpty((Object)visitTaskId)) {
            throw TwException.error((String)"", (String)"visitTaskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VisitTaskDO entity = this.visitTaskRepo.findById(visitTaskId).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u62dc\u8bbf\u4efb\u52a1\u4e0d\u5b58\u5728");
        BusinessPartnerPayload businessPartnerPayload = BusinessPartnerConvert.INSTANCE.taskPayLoadToPayLoad(payload);
        BusinessPartnerVO insert = this.businessPartnerService.insert(businessPartnerPayload);
        VisitTaskPayload visitTaskPayload = new VisitTaskPayload();
        visitTaskPayload.setId(visitTaskId);
        visitTaskPayload.setStatus(VisitTaskStatusEnum.OK.getCode());
        visitTaskPayload.setPartnerId(insert.getId());
        visitTaskPayload.setSubmitTime(LocalDateTime.now());
        visitTaskPayload.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
        visitTaskPayload.setCustomerName(insert.getPartnerName());
        visitTaskPayload.setCustomAdress(insert.getDetailAddress());
        visitTaskPayload.setLongitudeLatitude(insert.getLongitudeLatitude());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(visitTaskPayload);
        entity.copy(entityDo);
        this.visitTaskRepo.save(entity);
        return insert;
    }

    public VisitTaskVO insertTask(VisitTaskPayload payload) {
        LocalDate currentDate = LocalDate.now();
        Long loginUserId = GlobalUtil.getLoginUserId();
        Long partnerId = payload.getPartnerId();
        Object taskName = "";
        if (!ObjectUtils.isEmpty((Object)partnerId)) {
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(partnerId);
            Assert.notNull((Object)businessPartnerVO, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            payload.setCustomerName(businessPartnerVO.getPartnerName());
        }
        taskName = payload.getCustomerName() == null ? currentDate + "-" + GlobalUtil.getLoginUserName() : currentDate + "-" + payload.getCustomerName() + "-" + GlobalUtil.getLoginUserName();
        payload.setStartTime(currentDate);
        payload.setEndTime(currentDate);
        payload.setTaskName((String)taskName);
        payload.setVisitMemberId(loginUserId);
        payload.setVisitMemberName(GlobalUtil.getLoginUserName());
        payload.setStatus(VisitTaskEvalStatusEnum.NEW.getCode());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        return VisitTaskConvert.INSTANCE.toVo((VisitTaskDO)this.visitTaskRepo.save(entityDo));
    }

    public VisitTaskServiceImpl(VisitTaskRepo visitTaskRepo, VisitTaskDAO visitTaskDAO, CacheUtil cacheUtil, PrdOrgEmployeeService prdOrgEmployeeService, VisitPlanDAO visitPlanDAO, VisitPlanDetailDAO visitPlanDetailDAO, VisitSignRecordDAO visitSignRecordDAO, FileUtil fileUtil, TwSmsService twSmsService, TwSmsProperties twSmsProperties, BookAddressService bookAddressService, BookContactsService bookContactsService, PrdFsmFileRefService prdFsmFileRefService, ShortUrlRefService shortUrlRefService) {
        this.visitTaskRepo = visitTaskRepo;
        this.visitTaskDAO = visitTaskDAO;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.visitPlanDAO = visitPlanDAO;
        this.visitPlanDetailDAO = visitPlanDetailDAO;
        this.visitSignRecordDAO = visitSignRecordDAO;
        this.fileUtil = fileUtil;
        this.twSmsService = twSmsService;
        this.twSmsProperties = twSmsProperties;
        this.bookAddressService = bookAddressService;
        this.bookContactsService = bookContactsService;
        this.prdFsmFileRefService = prdFsmFileRefService;
        this.shortUrlRefService = shortUrlRefService;
    }
}

