/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.common.util.criticalPath;

import com.elitesland.tw.tw5pms.server.common.util.criticalPath.AoeNode;
import com.elitesland.tw.tw5pms.server.common.util.criticalPath.ArcAoeNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class CriticalPath {
    List<AoeNode> aoeNodes;
    List<ArcAoeNode> arcAoeNodes;
    int[] ve;
    int[] vl;
    int[] ee;
    int[] el;
    Stack<Integer> viewStack = new Stack();

    public CriticalPath(List<AoeNode> aoeNodes) {
        this.aoeNodes = aoeNodes;
        this.ve = new int[aoeNodes.size()];
        this.vl = new int[aoeNodes.size()];
        this.getAllArc();
        this.ee = new int[this.arcAoeNodes.size()];
        this.el = new int[this.arcAoeNodes.size()];
    }

    public void getAllArc() {
        this.arcAoeNodes = new ArrayList<ArcAoeNode>();
        for (AoeNode aoeNode : this.aoeNodes) {
            ArcAoeNode arcAoeNode = aoeNode.firstArc;
            while (arcAoeNode != null) {
                this.arcAoeNodes.add(arcAoeNode);
                arcAoeNode = arcAoeNode.nextArc;
            }
        }
    }

    public int getin(int nodeIndex) {
        int countIn = 0;
        for (AoeNode aoe : this.aoeNodes) {
            ArcAoeNode arcAoeNode = aoe.firstArc;
            while (arcAoeNode != null) {
                if (arcAoeNode.nextNode == nodeIndex) {
                    ++countIn;
                }
                arcAoeNode = arcAoeNode.nextArc;
            }
        }
        return countIn;
    }

    public boolean topologic() {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        int[] book = new int[this.aoeNodes.size()];
        for (int i = 0; i < this.aoeNodes.size(); ++i) {
            book[i] = this.getin(i);
            if (book[i] != 0) continue;
            queue.offer(i);
        }
        int visitLen = 0;
        while (!queue.isEmpty()) {
            int poll = (Integer)queue.poll();
            this.viewStack.push(poll);
            ++visitLen;
            ArcAoeNode arcAoeNode = this.aoeNodes.get((int)poll).firstArc;
            while (arcAoeNode != null) {
                int node = arcAoeNode.nextNode;
                this.ve[node] = Math.max(this.ve[node], this.ve[poll] + arcAoeNode.weight);
                int n = node;
                book[n] = book[n] - 1;
                if (book[node] == 0) {
                    queue.offer(node);
                }
                arcAoeNode = arcAoeNode.nextArc;
            }
        }
        return visitLen == this.aoeNodes.size();
    }

    public void criticalPath() {
        int i;
        if (!this.topologic()) {
            System.out.println("\u662f\u4e2a\u73af\u88c5\u56fe\uff0c\u6ca1\u6709\u5173\u952e\u8def\u5f84");
            return;
        }
        for (int i2 = 0; i2 < this.ve.length; ++i2) {
            this.vl[i2] = this.ve[this.ve.length - 1];
        }
        while (!this.viewStack.isEmpty()) {
            int popValue = this.viewStack.pop();
            ArcAoeNode arcAoeNode = this.aoeNodes.get((int)popValue).firstArc;
            while (arcAoeNode != null) {
                int nextNode = arcAoeNode.nextNode;
                this.vl[popValue] = Math.min(this.vl[popValue], this.vl[nextNode] - arcAoeNode.weight);
                arcAoeNode = arcAoeNode.nextArc;
            }
        }
        int arcCount = 0;
        for (i = 0; i < this.aoeNodes.size(); ++i) {
            ArcAoeNode arcAoeNode = this.aoeNodes.get((int)i).firstArc;
            while (arcAoeNode != null) {
                int nextNode = arcAoeNode.nextNode;
                this.ee[arcCount] = this.ve[i];
                this.el[arcCount] = this.vl[nextNode] - arcAoeNode.weight;
                ++arcCount;
                arcAoeNode = arcAoeNode.nextArc;
            }
        }
        System.out.println("\u5173\u952e\u4e8b\u4ef6");
        for (i = 0; i < this.aoeNodes.size(); ++i) {
            if (this.vl[i] != this.ve[i]) continue;
            System.out.println(this.aoeNodes.get((int)i).name);
        }
        System.out.println("\u5173\u952e\u6d3b\u52a8");
        for (i = 0; i < this.ee.length; ++i) {
            if (this.ee[i] != this.el[i]) continue;
            System.out.println(this.arcAoeNodes.get((int)i).name);
        }
    }
}

