/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.my.service;

import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.my.service.PmsTaskPendingService;
import com.elitesland.tw.tw5pms.api.my.vo.PmsTaskPendingVO;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskApplyQuery;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskAuthorizeQuery;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskQuery;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskApplyService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskAuthorizeService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskService;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskAuthorizeStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PmsTaskPendingServiceImpl
implements PmsTaskPendingService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskPendingServiceImpl.class);
    private final PmsTaskService pmsTaskService;
    private final PmsTaskApplyService pmsTaskApplyService;
    private final PmsTaskAuthorizeService pmsTaskAuthorizeService;

    public List<PmsTaskPendingVO> findMyTask() {
        Long userId = GlobalUtil.getLoginUserId();
        ArrayList<PmsTaskPendingVO> recentTaskVOList = new ArrayList<PmsTaskPendingVO>();
        this.taskReceive(recentTaskVOList, userId);
        this.taskSettle(recentTaskVOList, userId);
        this.taskApply(recentTaskVOList, userId);
        this.taskAuthorize(recentTaskVOList, userId);
        return recentTaskVOList;
    }

    private void taskAuthorize(List<PmsTaskPendingVO> recentTaskVOList, Long userId) {
        PmsTaskAuthorizeQuery query = new PmsTaskAuthorizeQuery();
        query.setReceiverUserId(userId);
        query.setAuthorizeStatus(TaskAuthorizeStatusEnum.APPROVING.getCode());
        List pmsTaskAuthorizeVOS = this.pmsTaskAuthorizeService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)pmsTaskAuthorizeVOS)) {
            pmsTaskAuthorizeVOS.forEach(pmsTaskAuthorizeVO -> {
                String title = "\u4efb\u52a1\u6388\u6743-" + pmsTaskAuthorizeVO.getAuthorizeName();
                recentTaskVOList.add(PmsTaskPendingVO.of((String)title, (String)PmsTaskPendingVO.RecentTaskType.PMS_TASK_AUTHORIZE.getCode(), (Object)pmsTaskAuthorizeVO));
            });
        }
    }

    private void taskApply(List<PmsTaskPendingVO> recentTaskVOList, Long userId) {
        PmsTaskApplyQuery query = new PmsTaskApplyQuery();
        query.setDisterUserId(userId);
        query.setApplyStatus("1");
        List pmsTaskApplyVOS = this.pmsTaskApplyService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)pmsTaskApplyVOS)) {
            pmsTaskApplyVOS.forEach(pmsTaskVO -> {
                String title = "\u4efb\u52a1\u5305\u7533\u8bf7-" + pmsTaskVO.getReceiverUserName();
                recentTaskVOList.add(PmsTaskPendingVO.of((String)title, (String)PmsTaskPendingVO.RecentTaskType.PMS_TASK_APPLY.getCode(), (Object)pmsTaskVO));
            });
        }
    }

    private void taskSettle(List<PmsTaskPendingVO> recentTaskVOList, Long userId) {
        PmsTaskQuery query = new PmsTaskQuery();
        query.setDisterUserId(userId);
        query.setTaskStatus(TaskStatusEnum.APPROVED.getCode());
        query.setApplySettledEqva(BigDecimal.ZERO);
        List pmsTaskVOS = this.pmsTaskService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)pmsTaskVOS)) {
            pmsTaskVOS.forEach(pmsTaskVO -> {
                String title = pmsTaskVO.getPackageName() + "-" + pmsTaskVO.getTaskName() + "-\u7533\u8bf7\u7ed3\u7b97\uff08" + pmsTaskVO.getDisterUserName() + "-" + pmsTaskVO.getReceiverUserName() + "\uff09";
                recentTaskVOList.add(PmsTaskPendingVO.of((String)title, (String)PmsTaskPendingVO.RecentTaskType.PMS_TASK_SETTLE.getCode(), (Object)pmsTaskVO));
            });
        }
    }

    private void taskReceive(List<PmsTaskPendingVO> recentTaskVOList, Long userId) {
        PmsTaskQuery query = new PmsTaskQuery();
        query.setReceiverUserId(userId);
        query.setTaskStatus(TaskStatusEnum.DISTRIBUTING.getCode());
        List pmsTaskVOS = this.pmsTaskService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)pmsTaskVOS)) {
            pmsTaskVOS.forEach(pmsTaskVO -> {
                String title = pmsTaskVO.getPackageName() + "-" + pmsTaskVO.getTaskName() + "-\u6d3e\u53d1\uff08" + pmsTaskVO.getDisterUserName() + "-" + pmsTaskVO.getReceiverUserName() + "\uff09";
                recentTaskVOList.add(PmsTaskPendingVO.of((String)title, (String)PmsTaskPendingVO.RecentTaskType.PMS_TASK_RECEIVE.getCode(), (Object)pmsTaskVO));
            });
        }
    }

    public PmsTaskPendingServiceImpl(PmsTaskService pmsTaskService, PmsTaskApplyService pmsTaskApplyService, PmsTaskAuthorizeService pmsTaskAuthorizeService) {
        this.pmsTaskService = pmsTaskService;
        this.pmsTaskApplyService = pmsTaskApplyService;
        this.pmsTaskAuthorizeService = pmsTaskAuthorizeService;
    }
}

