/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.company.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.company.payload.CompanyPayload;
import com.elitesland.tw.tw5.api.company.payload.CompanyUpdateStatusPayload;
import com.elitesland.tw.tw5.api.company.query.CompanyQuery;
import com.elitesland.tw.tw5.api.company.service.CompanyService;
import com.elitesland.tw.tw5.api.company.vo.CompanySimpleVO;
import com.elitesland.tw.tw5.api.company.vo.CompanyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u516c\u53f8\u4e3b\u4f53"})
@RestController
@RequestMapping(value={"/api/crm/company"})
public class CompanyController {
    private static final Logger log = LoggerFactory.getLogger(CompanyController.class);
    private final CompanyService companyService;

    @PostMapping
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u4fdd\u5b58")
    public TwOutputUtil save(@RequestBody CompanyPayload payload) {
        return TwOutputUtil.ok((Object)this.companyService.save(payload));
    }

    @PutMapping
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody CompanyPayload payload) {
        return TwOutputUtil.ok((Object)this.companyService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<CompanyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.companyService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u5206\u9875")
    public TwOutputUtil<PagingVO<CompanyVO>> paging(CompanyQuery query) {
        return TwOutputUtil.ok((Object)this.companyService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<CompanyVO>> queryList(CompanyQuery query) {
        return TwOutputUtil.ok((Object)this.companyService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.companyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/updateSoft"})
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u66f4\u65b0\u72b6\u6001")
    public TwOutputUtil updateSoft(@RequestBody CompanyUpdateStatusPayload payload) {
        if (payload != null && payload.getKeys() != null) {
            List collect = Arrays.stream(payload.getKeys().split(",")).map(p -> Long.valueOf(p)).collect(Collectors.toList());
            this.companyService.updateSoft(collect, payload.getStatus());
        }
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/listSimple"})
    @ApiOperation(value="\u516c\u53f8\u4e3b\u4f53-\u67e5\u8be2\u6240\u6709\u516c\u53f8\u4e3b\u4f53")
    public TwOutputUtil<List<CompanySimpleVO>> listSimple() {
        return TwOutputUtil.ok((Object)this.companyService.listSimple());
    }

    @GetMapping(value={"/judgeCompanyName"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u4e1a\u52a1\u4f19\u4f34\u540d\u79f0\u91cd\u590d\u6027\u6821\u9a8c")
    public TwOutputUtil judgeCompanyName(CompanyQuery query) {
        this.companyService.judgeCompanyName(query.getCompanyName(), null);
        return TwOutputUtil.ok();
    }

    public CompanyController(CompanyService companyService) {
        this.companyService = companyService;
    }
}

