/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.server.common.constants.BookAddressTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.BusinessPartnerDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BusinessPartnerRepo;
import com.elitesland.tw.tw5.server.partner.team.entity.QBusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BusinessPartnerDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessPartnerRepo repo;
    private final QBusinessPartnerDO qdo = QBusinessPartnerDO.businessPartnerDO;
    private final QBookAddressDO qBookAddressDO = QBookAddressDO.bookAddressDO;
    private final CacheUtil cacheUtil;
    private final QBusinessTeamMemberDO qTeamMemberDO = QBusinessTeamMemberDO.businessTeamMemberDO;

    private JPAQuery<BusinessPartnerVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.creator, this.qdo.createTime, this.qdo.bookId, this.qdo.businessPartnerNo, this.qdo.partnerType, this.qdo.partnerName, this.qdo.partnerIdentity, this.qdo.partnerIndustry, this.qdo.partnerNature, this.qdo.organizationScale, this.qdo.partnerWebsite, this.qdo.partnerEmail, this.qdo.partnerFax, this.qdo.partnerPhone, this.qdo.partnerRegion, this.qdo.currency, this.qdo.language, this.qdo.partnerSex, this.qdo.partnerBirthday, this.qdo.partnerTelephone, this.qdo.partnerWeChat, this.qdo.fileCodes, this.qdo.sortNo, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.parentId, this.qBookAddressDO.country, this.qBookAddressDO.province, this.qBookAddressDO.city, this.qBookAddressDO.district, this.qBookAddressDO.provinceName, this.qBookAddressDO.cityName, this.qBookAddressDO.districtName, this.qBookAddressDO.detailAddress})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.addressType.eq((Object)BookAddressTypeEnum.company_addr.getCode())).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)));
    }

    private JPAQuery<BusinessPartnerVO> getJpaQueryWhere(BusinessPartnerQuery query) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQuerySelect();
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue()) {
            ((JPAQuery)((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qTeamMemberDO)).on((Predicate)this.qTeamMemberDO.objectId.longValue().eq(this.qdo.id))).where((Predicate)this.qTeamMemberDO.userId.eq((Object)loginUserId).and((Predicate)this.qTeamMemberDO.deleteFlag.eq((Object)0)));
        }
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.groupBy(this.qdo.id);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(BusinessPartnerQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.addressType.eq((Object)BookAddressTypeEnum.company_addr.getCode())).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)));
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue()) {
            ((JPAQuery)((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qTeamMemberDO)).on((Predicate)this.qTeamMemberDO.objectId.longValue().eq(this.qdo.id))).where((Predicate)this.qTeamMemberDO.userId.eq((Object)loginUserId).and((Predicate)this.qTeamMemberDO.deleteFlag.eq((Object)0)));
        }
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.groupBy(this.qdo.id);
        List fetch = jpaQuery.fetch();
        if (fetch == null) {
            return 0L;
        }
        return fetch.size();
    }

    public long saleCount(BusinessPartnerQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        if (query.getUserIdList() != null && query.getUserIdList().size() > 0) {
            jpaQuery.where((Predicate)this.qdo.createUserId.in((Collection)query.getUserIdList()));
        }
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        return (Long)jpaQuery.fetchOne();
    }

    private Predicate where(BusinessPartnerQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getPartnerName())) {
            list.add(this.qdo.partnerName.like(SqlUtil.toSqlLikeString((String)query.getPartnerName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerIdentity())) {
            String[] identityArray = query.getPartnerIdentity().split(",");
            List<String> identityList = Arrays.asList(identityArray);
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                list.add(this.qdo.customerFlag.eq(Boolean.valueOf(true)));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                list.add(this.qdo.supplierFlag.eq(Boolean.valueOf(true)));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                list.add(this.qdo.collaborateFlag.eq(Boolean.valueOf(true)));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode())) {
                list.add(this.qdo.distributorFlag.eq(Boolean.valueOf(true)));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            list.add(this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (query.getUserIdList() != null && query.getUserIdList().size() > 0) {
            list.add(this.qdo.createUserId.in((Collection)query.getUserIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerIndustry())) {
            List collect = Arrays.stream(query.getPartnerIndustry().split(",")).collect(Collectors.toList());
            list.add(this.qdo.partnerIndustry.in(collect));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvince())) {
            list.add(this.qBookAddressDO.province.eq((Object)query.getProvince()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCity())) {
            list.add(this.qBookAddressDO.city.eq((Object)query.getCity()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistrict())) {
            list.add(this.qBookAddressDO.district.eq((Object)query.getDistrict()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvinceName())) {
            list.add(this.qBookAddressDO.provinceName.eq((Object)query.getProvinceName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCityName())) {
            list.add(this.qBookAddressDO.cityName.eq((Object)query.getCityName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistrictName())) {
            list.add(this.qBookAddressDO.districtName.eq((Object)query.getDistrictName()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BusinessPartnerVO queryByKey(Long id) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BusinessPartnerVO)jpaQuery.fetchFirst();
    }

    public BusinessPartnerDO queryById(Long id) {
        return (BusinessPartnerDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo)).where((Predicate)this.qdo.id.eq((Object)id))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public List<BusinessPartnerVO> queryListDynamic(BusinessPartnerQuery query) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<BusinessPartnerSimpleVO> queryListSimple() {
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerSimpleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.partnerName})).from((EntityPath)this.qdo)).fetch();
    }

    public Long judgePartnerName(String partnerName) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.eq((Object)partnerName))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetchOne();
    }

    public PagingVO<BusinessPartnerVO> queryPaging(BusinessPartnerQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BusinessPartnerDO save(BusinessPartnerDO ado) {
        return (BusinessPartnerDO)this.repo.save(ado);
    }

    public List<BusinessPartnerDO> saveAll(List<BusinessPartnerDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BusinessPartnerPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getBusinessPartnerNo() != null) {
            update.set((Path)this.qdo.businessPartnerNo, (Object)payload.getBusinessPartnerNo());
        }
        if (payload.getPartnerType() != null) {
            update.set((Path)this.qdo.partnerType, (Object)payload.getPartnerType());
        }
        if (payload.getPartnerName() != null) {
            update.set((Path)this.qdo.partnerName, (Object)payload.getPartnerName());
        }
        if (payload.getPartnerIdentity() != null) {
            update.set((Path)this.qdo.partnerIdentity, (Object)payload.getPartnerIdentity());
        }
        if (payload.getPartnerIndustry() != null) {
            update.set((Path)this.qdo.partnerIndustry, (Object)payload.getPartnerIndustry());
        }
        if (payload.getPartnerNature() != null) {
            update.set((Path)this.qdo.partnerNature, (Object)payload.getPartnerNature());
        }
        if (payload.getOrganizationScale() != null) {
            update.set((Path)this.qdo.organizationScale, (Object)payload.getOrganizationScale());
        }
        if (payload.getCustomerFlag() != null) {
            update.set((Path)this.qdo.customerFlag, (Object)payload.getCustomerFlag());
        }
        if (payload.getPartnerWebsite() != null) {
            update.set((Path)this.qdo.partnerWebsite, (Object)payload.getPartnerWebsite());
        }
        if (payload.getPartnerEmail() != null) {
            update.set((Path)this.qdo.partnerEmail, (Object)payload.getPartnerEmail());
        }
        if (payload.getPartnerFax() != null) {
            update.set((Path)this.qdo.partnerFax, (Object)payload.getPartnerFax());
        }
        if (payload.getPartnerPhone() != null) {
            update.set((Path)this.qdo.partnerPhone, (Object)payload.getPartnerPhone());
        }
        if (payload.getPartnerRegion() != null) {
            update.set((Path)this.qdo.partnerRegion, (Object)payload.getPartnerRegion());
        }
        if (payload.getCurrency() != null) {
            update.set((Path)this.qdo.currency, (Object)payload.getCurrency());
        }
        if (payload.getLanguage() != null) {
            update.set((Path)this.qdo.language, (Object)payload.getLanguage());
        }
        if (payload.getPartnerSex() != null) {
            update.set((Path)this.qdo.partnerSex, (Object)payload.getPartnerSex());
        }
        if (payload.getPartnerBirthday() != null) {
            update.set((Path)this.qdo.partnerBirthday, (Object)payload.getPartnerBirthday());
        }
        if (payload.getPartnerTelephone() != null) {
            update.set((Path)this.qdo.partnerTelephone, (Object)payload.getPartnerTelephone());
        }
        if (payload.getPartnerWeChat() != null) {
            update.set((Path)this.qdo.partnerWeChat, (Object)payload.getPartnerWeChat());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdo.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("businessPartnerNo")) {
                update.setNull((Path)this.qdo.businessPartnerNo);
            }
            if (nullFields.contains("partnerType")) {
                update.setNull((Path)this.qdo.partnerType);
            }
            if (nullFields.contains("partnerName")) {
                update.setNull((Path)this.qdo.partnerName);
            }
            if (nullFields.contains("partnerIdentity")) {
                update.setNull((Path)this.qdo.partnerIdentity);
            }
            if (nullFields.contains("partnerIndustry")) {
                update.setNull((Path)this.qdo.partnerIndustry);
            }
            if (nullFields.contains("partnerNature")) {
                update.setNull((Path)this.qdo.partnerNature);
            }
            if (nullFields.contains("organizationScale")) {
                update.setNull((Path)this.qdo.organizationScale);
            }
            if (nullFields.contains("partnerWebsite")) {
                update.setNull((Path)this.qdo.partnerWebsite);
            }
            if (nullFields.contains("partnerEmail")) {
                update.setNull((Path)this.qdo.partnerEmail);
            }
            if (nullFields.contains("partnerFax")) {
                update.setNull((Path)this.qdo.partnerFax);
            }
            if (nullFields.contains("partnerPhone")) {
                update.setNull((Path)this.qdo.partnerPhone);
            }
            if (nullFields.contains("partnerRegion")) {
                update.setNull((Path)this.qdo.partnerRegion);
            }
            if (nullFields.contains("currency")) {
                update.setNull((Path)this.qdo.currency);
            }
            if (nullFields.contains("language")) {
                update.setNull((Path)this.qdo.language);
            }
            if (nullFields.contains("partnerSex")) {
                update.setNull((Path)this.qdo.partnerSex);
            }
            if (nullFields.contains("partnerBirthday")) {
                update.setNull((Path)this.qdo.partnerBirthday);
            }
            if (nullFields.contains("partnerTelephone")) {
                update.setNull((Path)this.qdo.partnerTelephone);
            }
            if (nullFields.contains("partnerWeChat")) {
                update.setNull((Path)this.qdo.partnerWeChat);
            }
            if (nullFields.contains("fileCodes")) {
                update.setNull((Path)this.qdo.fileCodes);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
            if (nullFields.contains("parentId")) {
                update.setNull(this.qdo.parentId);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BusinessPartnerVO> findByIds(List<Long> ids) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.groupBy(this.qdo.id);
        List businessPartnerVOList = jpaQuery.fetch();
        return businessPartnerVOList;
    }

    public BusinessPartnerSimpleVO queryByPartnerName(String partnerName) {
        return (BusinessPartnerSimpleVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerSimpleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.customerFlag, this.qdo.partnerIdentity, this.qdo.partnerName, this.qdo.parentId})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.eq((Object)partnerName))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public List<BusinessPartnerDO> findByPartnerName(String partnerName) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.eq((Object)partnerName))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetch();
    }

    public List<BusinessPartnerVO> listForDm(List<String> partnerNameList) {
        List partnerDoList = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.partnerName})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.in(partnerNameList))).where((Predicate)this.qdo.ext5.isNull())).fetch();
        return partnerDoList;
    }

    public BusinessPartnerDAO(JPAQueryFactory jpaQueryFactory, BusinessPartnerRepo repo, CacheUtil cacheUtil) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.cacheUtil = cacheUtil;
    }
}

