/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.payload.BookAccountPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.common.convert.BookAccountConvert;
import com.elitesland.tw.tw5.server.partner.common.dao.BookAccountDAO;
import com.elitesland.tw.tw5.server.partner.common.entity.BookAccountDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BookAccountRepo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BookAccountServiceImpl
extends BaseServiceImpl
implements BookAccountService {
    private static final Logger log = LoggerFactory.getLogger(BookAccountServiceImpl.class);
    private final BookAccountRepo bookAccountRepo;
    private final BookAccountDAO bookAccountDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    public PagingVO<BookAccountVO> queryPaging(BookAccountQuery query) {
        return this.bookAccountDAO.queryPaging(query);
    }

    public List<BookAccountVO> queryListDynamic(BookAccountQuery query) {
        return this.bookAccountDAO.queryListDynamic(query);
    }

    public BookAccountVO queryByKey(Long key) {
        BookAccountDO entity = this.bookAccountRepo.findById(key).orElseGet(BookAccountDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BookAccountVO vo = BookAccountConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public BookAccountVO queryDefaultByBookId(Long bookId) {
        return this.bookAccountDAO.queryDefaultByBookId(bookId);
    }

    @Transactional(rollbackFor={Exception.class})
    public BookAccountVO insert(BookAccountPayload payload, Boolean logFlag) {
        BookAccountDO defaultDO = this.bookAccountRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && defaultDO != null) {
            defaultDO.setIsDefault(false);
            this.bookAccountRepo.save(defaultDO);
        }
        if (defaultDO == null) {
            payload.setIsDefault(Boolean.valueOf(true));
        }
        BookAccountDO entityDo = BookAccountConvert.INSTANCE.toDo(payload);
        if (logFlag.booleanValue() && payload.getPartnerId() != null) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u65b0\u589e\u4e86\u4e00\u6761\u8d26\u6237\u4fe1\u606f");
        }
        return BookAccountConvert.INSTANCE.toVo((BookAccountDO)this.bookAccountRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BookAccountVO update(BookAccountPayload payload, Boolean logFlag) {
        BookAccountDO defaultDO;
        BookAccountDO entity = this.bookAccountRepo.findById(payload.getId()).orElseGet(BookAccountDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && (defaultDO = this.bookAccountRepo.findByBookIdAndIsDefault(payload.getBookId(), true)) != null && !defaultDO.getId().equals(payload.getId())) {
            defaultDO.setIsDefault(false);
            this.bookAccountRepo.save(defaultDO);
        }
        BookAccountDO entityDo = BookAccountConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        BookAccountDO save = (BookAccountDO)this.bookAccountRepo.save(entity);
        if (logFlag.booleanValue() && null != payload.getPartnerId()) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u4e00\u6761\u8d26\u6237\u4fe1\u606f");
        }
        return BookAccountConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long bookId, Long partnerId, Boolean logFlag) {
        if (!keys.isEmpty()) {
            for (int i = 0; i < keys.size(); ++i) {
                Optional optional = this.bookAccountRepo.findById(keys.get(i));
                if (optional.isEmpty()) continue;
                BookAccountDO entity = (BookAccountDO)optional.get();
                entity.setDeleteFlag(1);
                this.bookAccountRepo.save(entity);
            }
            List<BookAccountDO> bookAccountDOS = this.bookAccountDAO.queryByBookId(bookId);
            if (bookAccountDOS != null && bookAccountDOS.size() == 1) {
                BookAccountDO bookAccountDO = bookAccountDOS.get(0);
                bookAccountDO.setIsDefault(true);
                this.bookAccountRepo.save(bookAccountDO);
            }
            if (logFlag.booleanValue()) {
                this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u8d26\u6237\u4fe1\u606f");
            }
        }
    }

    public Long count(BookAccountQuery query) {
        return this.bookAccountDAO.count(query);
    }

    public BookAccountServiceImpl(BookAccountRepo bookAccountRepo, BookAccountDAO bookAccountDAO, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil) {
        this.bookAccountRepo = bookAccountRepo;
        this.bookAccountDAO = bookAccountDAO;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
    }
}

