/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.payload.BookInvoicePayload;
import com.elitesland.tw.tw5.api.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.common.convert.BookInvoiceConvert;
import com.elitesland.tw.tw5.server.partner.common.dao.BookInvoiceDAO;
import com.elitesland.tw.tw5.server.partner.common.entity.BookInvoiceDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BookInvoiceRepo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BookInvoiceServiceImpl
extends BaseServiceImpl
implements BookInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BookInvoiceServiceImpl.class);
    private final BookInvoiceRepo bookInvoiceRepo;
    private final BookInvoiceDAO bookInvoiceDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    public PagingVO<BookInvoiceVO> queryPaging(BookInvoiceQuery query) {
        return this.bookInvoiceDAO.queryPaging(query);
    }

    public List<BookInvoiceVO> queryListDynamic(BookInvoiceQuery query) {
        return this.bookInvoiceDAO.queryListDynamic(query);
    }

    public BookInvoiceVO queryByKey(Long key) {
        BookInvoiceDO entity = this.bookInvoiceRepo.findById(key).orElseGet(BookInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BookInvoiceVO vo = BookInvoiceConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public BookInvoiceVO queryDefaultByBookId(Long bookId) {
        return this.bookInvoiceDAO.queryDefaultByBookId(bookId);
    }

    @Transactional(rollbackFor={Exception.class})
    public BookInvoiceVO insert(BookInvoicePayload payload, Boolean logFlag) {
        BookInvoiceDO defaultDO = this.bookInvoiceRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && defaultDO != null) {
            defaultDO.setIsDefault(false);
            this.bookInvoiceRepo.save(defaultDO);
        }
        if (defaultDO == null) {
            payload.setIsDefault(Boolean.valueOf(true));
        }
        BookInvoiceDO entityDo = BookInvoiceConvert.INSTANCE.toDo(payload);
        if (logFlag.booleanValue() && payload.getPartnerId() != null) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u65b0\u589e\u4e86\u4e00\u6761\u5f00\u7968\u4fe1\u606f");
        }
        return BookInvoiceConvert.INSTANCE.toVo((BookInvoiceDO)this.bookInvoiceRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BookInvoiceVO update(BookInvoicePayload payload, Boolean logFlag) {
        BookInvoiceDO defaultDO;
        BookInvoiceDO entity = this.bookInvoiceRepo.findById(payload.getId()).orElseGet(BookInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (payload != null && payload.getIsDefault().booleanValue() && (defaultDO = this.bookInvoiceRepo.findByBookIdAndIsDefault(payload.getBookId(), true)) != null && !defaultDO.getId().equals(payload.getId())) {
            defaultDO.setIsDefault(false);
            this.bookInvoiceRepo.save(defaultDO);
        }
        BookInvoiceDO entityDo = BookInvoiceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (logFlag.booleanValue() && null != payload.getPartnerId()) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u4e00\u6761\u5f00\u7968\u4fe1\u606f");
        }
        return BookInvoiceConvert.INSTANCE.toVo((BookInvoiceDO)this.bookInvoiceRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long bookId, Long partnerId, Boolean logFlag) {
        if (!keys.isEmpty()) {
            Long boookId = 0L;
            for (int i = 0; i < keys.size(); ++i) {
                Optional optional = this.bookInvoiceRepo.findById(keys.get(i));
                if (optional.isEmpty()) continue;
                BookInvoiceDO entity = (BookInvoiceDO)optional.get();
                entity.setDeleteFlag(1);
                this.bookInvoiceRepo.save(entity);
                boookId = entity.getBookId();
            }
            List<BookInvoiceDO> dos = this.bookInvoiceDAO.queryByBookId(boookId);
            if (dos != null && dos.size() == 1) {
                BookInvoiceDO bookInvoiceDO = dos.get(0);
                bookInvoiceDO.setIsDefault(true);
                this.bookInvoiceRepo.save(bookInvoiceDO);
            }
            if (logFlag.booleanValue()) {
                this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u5f00\u7968\u4fe1\u606f");
            }
        }
    }

    public Long count(BookInvoiceQuery query) {
        return this.bookInvoiceDAO.count(query);
    }

    public BookInvoiceServiceImpl(BookInvoiceRepo bookInvoiceRepo, BookInvoiceDAO bookInvoiceDAO, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil) {
        this.bookInvoiceRepo = bookInvoiceRepo;
        this.bookInvoiceDAO = bookInvoiceDAO;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
    }
}

