/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessStrategyPayload;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessStrategyQuery;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.strategy.entity.BusinessStrategyDO;
import com.elitesland.tw.tw5.server.partner.strategy.entity.QBusinessStrategyDO;
import com.elitesland.tw.tw5.server.partner.strategy.repo.BusinessStrategyRepo;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessStrategyStatusEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BusinessStrategyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyRepo repo;
    private final QBusinessStrategyDO qdo = QBusinessStrategyDO.businessStrategyDO;

    private JPAQuery<BusinessStrategyVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessStrategyVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.strategyNo, this.qdo.strategyName, this.qdo.strategyIdentity, this.qdo.strategyStatus, this.qdo.strategyPriority, this.qdo.strategyRange, this.qdo.sortNo, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.strategyRangeDetail})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BusinessStrategyVO> getJpaQueryWhere(BusinessStrategyQuery query) {
        JPAQuery<BusinessStrategyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(BusinessStrategyQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BusinessStrategyQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyNo())) {
            list.add(this.qdo.strategyNo.eq((Object)query.getStrategyNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyName())) {
            list.add(this.qdo.strategyName.like(SqlUtil.toSqlLikeString((String)query.getStrategyName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyIdentity())) {
            list.add(this.qdo.strategyIdentity.eq((Object)query.getStrategyIdentity()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyStatus())) {
            list.add(this.qdo.strategyStatus.eq((Object)query.getStrategyStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyPriority())) {
            list.add(this.qdo.strategyPriority.eq((Object)query.getStrategyPriority()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyRange())) {
            list.add(this.qdo.strategyRange.eq((Object)query.getStrategyRange()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyRangeDetail())) {
            list.add(this.qdo.strategyRangeDetail.eq((Object)query.getStrategyRangeDetail()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BusinessStrategyVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BusinessStrategyVO)jpaQuery.fetchFirst();
    }

    public List<BusinessStrategyVO> queryListDynamic(BusinessStrategyQuery query) {
        JPAQuery<BusinessStrategyVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BusinessStrategyVO> queryPaging(BusinessStrategyQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BusinessStrategyDO save(BusinessStrategyDO ado) {
        return (BusinessStrategyDO)this.repo.save(ado);
    }

    public List<BusinessStrategyDO> saveAll(List<BusinessStrategyDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BusinessStrategyPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getStrategyNo() != null) {
            update.set((Path)this.qdo.strategyNo, (Object)payload.getStrategyNo());
        }
        if (payload.getStrategyName() != null) {
            update.set((Path)this.qdo.strategyName, (Object)payload.getStrategyName());
        }
        if (payload.getStrategyIdentity() != null) {
            update.set((Path)this.qdo.strategyIdentity, (Object)payload.getStrategyIdentity());
        }
        if (payload.getStrategyStatus() != null) {
            update.set((Path)this.qdo.strategyStatus, (Object)payload.getStrategyStatus());
        }
        if (payload.getStrategyPriority() != null) {
            update.set((Path)this.qdo.strategyPriority, (Object)payload.getStrategyPriority());
        }
        if (payload.getStrategyRange() != null) {
            update.set((Path)this.qdo.strategyRange, (Object)payload.getStrategyRange());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if (payload.getStrategyRangeDetail() != null) {
            update.set((Path)this.qdo.strategyRangeDetail, (Object)payload.getStrategyRangeDetail());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("strategyNo")) {
                update.setNull((Path)this.qdo.strategyNo);
            }
            if (nullFields.contains("strategyName")) {
                update.setNull((Path)this.qdo.strategyName);
            }
            if (nullFields.contains("strategyIdentity")) {
                update.setNull((Path)this.qdo.strategyIdentity);
            }
            if (nullFields.contains("strategyStatus")) {
                update.setNull((Path)this.qdo.strategyStatus);
            }
            if (nullFields.contains("strategyPriority")) {
                update.setNull((Path)this.qdo.strategyPriority);
            }
            if (nullFields.contains("strategyRange")) {
                update.setNull((Path)this.qdo.strategyRange);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
            if (nullFields.contains("strategyRangeDetail")) {
                update.setNull((Path)this.qdo.strategyRangeDetail);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BusinessStrategyVO> queryStraegyJobHandler() {
        JPAQuery<BusinessStrategyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.strategyStatus.eq((Object)BusinessStrategyStatusEnum.OPEN.getCode()));
        OrderItem strategyPriorityOrderItem = OrderItem.desc((String)"strategyPriority");
        ArrayList<OrderItem> OrderItemList = new ArrayList<OrderItem>();
        OrderItemList.add(strategyPriorityOrderItem);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, OrderItemList));
        return jpaQuery.fetch();
    }

    public BusinessStrategyDAO(JPAQueryFactory jpaQueryFactory, BusinessStrategyRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

