/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActPlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActPlanService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5e02\u573a\u8ba1\u5212\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/crm"})
public class CrmActPlanController {
    private static final Logger log = LoggerFactory.getLogger(CrmActPlanController.class);
    private final CrmActPlanService service;

    @PostMapping(value={"/plan/insert"})
    public TwOutputUtil insert(CrmActPlanPayload payload) {
        CrmActPlanVO vo = this.service.insert(payload);
        return TwOutputUtil.ok((Object)vo);
    }

    @GetMapping(value={"/plan/submitCheck/{id}"})
    public TwOutputUtil submitCheck(@PathVariable Long id) {
        this.service.submitCheck(id);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/plan/update"})
    public TwOutputUtil update(CrmActPlanPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/plan/deleteSoft"})
    public TwOutputUtil deleteSoft(Long key) {
        this.service.deleteSoft(key);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/plan/changeModeData/{planId}"})
    public TwOutputUtil getChangeModeData(@PathVariable Long planId) {
        return TwOutputUtil.ok((Object)this.service.changeLogDetailByPlanId(planId));
    }

    @GetMapping(value={"/plan/changeLogList/{planId}"})
    public TwOutputUtil changeLogList(@PathVariable Long planId) {
        return TwOutputUtil.ok((Object)this.service.changeLogList(planId));
    }

    @GetMapping(value={"/plan/paging"})
    public TwOutputUtil paging(CrmActPlanQuery query) {
        return TwOutputUtil.ok((Object)this.service.paging(query));
    }

    @GetMapping(value={"/plan/downloadPlans"})
    public void downloadPlans(HttpServletResponse response, CrmActPlanQuery query) {
        this.service.downloadPlans(response, query);
    }

    @GetMapping(value={"/plan/downloadPlanDetails"})
    public void downloadPlanDetails(HttpServletResponse response, Long planId) {
        this.service.downloadPlanDetails(response, planId);
    }

    @GetMapping(value={"/plan/queryPlans"})
    public TwOutputUtil queryPlans(@DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime newDate) {
        return TwOutputUtil.ok((Object)this.service.queryPlans(newDate));
    }

    @GetMapping(value={"/plan/queryByKey/{id}"})
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        CrmActPlanVO vo = this.service.queryByKey(id);
        return TwOutputUtil.ok((Object)vo);
    }

    @GetMapping(value={"/plan/closePlan"})
    public TwOutputUtil closePlan(Long key, String closeReson) {
        this.service.closePlan(key, closeReson);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/plan/insertDetail"})
    public TwOutputUtil insertDetail(CrmActPlanDetailPayload payload) {
        CrmActPlanDetailVO vo = this.service.insertDetail(payload);
        return TwOutputUtil.ok((Object)vo);
    }

    @PutMapping(value={"/plan/updateDetail"})
    public TwOutputUtil updateDetail(CrmActPlanDetailPayload payload) {
        this.service.updateDetail(payload);
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/plan/deleteDetailSoft"})
    public TwOutputUtil deleteDetailSoft(Long planId, Long key, Long changeLogId) {
        this.service.deleteDetailSoft(planId, key, changeLogId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/plan/queryDetails"})
    public TwOutputUtil queryDetails(Long planId, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime newDate) {
        return TwOutputUtil.ok((Object)this.service.queryDetails(planId, newDate));
    }

    @GetMapping(value={"/plan/queryWorkTypes"})
    public TwOutputUtil queryWorkTypes() {
        return TwOutputUtil.ok((Object)this.service.queryWorkTypes());
    }

    public CrmActPlanController(CrmActPlanService service) {
        this.service = service;
    }
}

