/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmFollowConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmFollowRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CrmFollowDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmFollowRepo repo;
    private final QCrmFollowDO qdo = QCrmFollowDO.crmFollowDO;

    public CrmFollowDO save(CrmFollowDO ado) {
        return (CrmFollowDO)((Object)this.repo.save((Object)ado));
    }

    public List<CrmFollowDO> saveAll(List<CrmFollowDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public List<CrmFollowDO> queryByObjectIdAndObjectType(Long objectId, String followObjectType) {
        return this.repo.findByObjectIdAndFollowObjectOrderByCreateTimeDesc(objectId, followObjectType);
    }

    public List<CrmFollowDO> queryByObjectIdsAndObjectType(List<Long> objectIds, String followObjectType) {
        return this.repo.findByObjectIdInAndFollowObjectOrderByCreateTimeDesc(objectIds, followObjectType);
    }

    public long countByObjectIdsAndObjectType(List<Long> objectIds, String followObjectType) {
        return this.repo.countByObjectIdInAndFollowObject(objectIds, followObjectType);
    }

    public PagingVO<CrmFollowVO> listPage(CrmFollowQuery query) {
        BooleanExpression expression = this.where(query);
        Page page = this.repo.findAll((Predicate)expression, (Pageable)query.getPageRequest());
        List content = page.getContent();
        List collect = content.stream().map(e -> CrmFollowConvert.INSTANCE.toVo((CrmFollowDO)((Object)e))).collect(Collectors.toList());
        PagingVO pagingVO = new PagingVO(page.getTotalElements(), collect);
        return pagingVO;
    }

    public List<CrmFollowVO> list(CrmFollowQuery query) {
        BooleanExpression expression = this.where(query);
        Iterable iterable = this.repo.findAll((Predicate)expression, query.getPageRequest().getSort());
        Iterator iterator = iterable.iterator();
        ArrayList<CrmFollowVO> list = new ArrayList<CrmFollowVO>();
        while (iterator.hasNext()) {
            list.add(CrmFollowConvert.INSTANCE.toVo((CrmFollowDO)((Object)iterator.next())));
        }
        return list;
    }

    private BooleanExpression where(CrmFollowQuery query) {
        QCrmFollowDO q = QCrmFollowDO.crmFollowDO;
        BooleanExpression expression = q.deleteFlag.eq((Object)0);
        if (StringUtils.hasText((String)query.getFollowType())) {
            expression = expression.and((Predicate)q.followType.eq((Object)query.getFollowType()));
        }
        if (StringUtils.hasText((String)query.getFollowObject())) {
            expression = expression.and((Predicate)q.followObject.eq((Object)query.getFollowObject()));
        }
        if (null != query.getObjectId()) {
            expression = expression.and((Predicate)q.objectId.eq((Object)query.getObjectId()));
        }
        if (null != query.getCreateTimeStart()) {
            expression = expression.and((Predicate)q.createTime.goe((Comparable)query.getCreateTimeStart()));
        }
        if (null != query.getCreateTimeEnd()) {
            expression = expression.and((Predicate)q.createTime.loe((Comparable)query.getCreateTimeEnd()));
        }
        return expression;
    }

    public void updateByKeyDynamic(CrmFollowPayload payload) {
        CrmFollowDO followDO = this.repo.findById(payload.getId()).orElse(null);
        if (followDO != null) {
            List nullFields;
            if (payload.getFollowType() != null) {
                followDO.setFollowType(payload.getFollowType());
            }
            if (payload.getFileCodes() != null) {
                followDO.setFileCodes(payload.getFileCodes());
            }
            if (payload.getFollowContent() != null) {
                followDO.setFollowContent(payload.getFollowContent());
            }
            if ((nullFields = payload.getNullFields()) == null || nullFields.size() > 0) {
                // empty if block
            }
            this.repo.save((Object)followDO);
        }
    }

    public CrmFollowDAO(JPAQueryFactory jpaQueryFactory, CrmFollowRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

