/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbOrCompanyPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.AddressBookEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerRepo;
import com.elitesland.tw.tw5.server.prd.crm.service.CrmFollowServiceImpl;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5crm.server.common.util.GeodesyUtil;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmCustomerServiceImpl
extends BaseServiceImpl
implements CrmCustomerService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmCustomerDAO dao;
    private final CrmCustomerOperationDAO customerOperationDAO;
    private final PrdAbService abService;
    private final PrdAbDAO abDAO;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final ExcelUtil excelUtil;
    private final CrmLeadsDAO leadsDAO;
    private final CrmOpportunityDAO opportunityDAO;
    private final CrmFollowDAO followDAO;
    private final CrmFollowServiceImpl followService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final CrmActActivityDAO actActivityDAO;
    private final CrmCustomerRepo repo;
    private final TaskExecutor taskExecutor;
    private final GeodesyUtil geodesyUtil;
    @Autowired
    private VisitTaskService visitTaskService;
    @Value(value="${tw4.customer.operation}")
    private String customer_operation;

    @Transactional(rollbackFor={Exception.class})
    public CrmCustomerVO insert(CrmCustomerPayload payload) {
        String code = this.generateSeqNum("ADDRESS_BOOK_NO", new String[0]);
        if (payload.getCustomerStatus() == null || payload.getCustomerStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            payload.setCustomerStatus("INACTIVE");
        }
        long bookIdV4 = 0L;
        PrdAbOrCompanyPayload companyPayload = CrmCustomerConvert.INSTANCE.toPayload(payload);
        companyPayload.setBookNo(code);
        companyPayload.setBookType(SystemDefaultEnum.DefaultAbType.getCode());
        companyPayload.setRelateType(AddressBookEnum.RelateCustomer.getCode());
        companyPayload.setCompanyName(payload.getCustomerName());
        companyPayload.setBookIdV4(Long.valueOf(bookIdV4));
        PrdAbVO abVO = this.abService.saveAbOrCompany(companyPayload);
        CrmCustomerDO customerDO = CrmCustomerConvert.INSTANCE.toDo(payload);
        customerDO.setBookId(abVO.getId());
        if (payload.getCustomerStatus() == null) {
            customerDO.setCustomerStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        } else if (payload.getCustomerStatus().equals("INACTIVE")) {
            customerDO.setCustomerStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        }
        customerDO = this.dao.save(customerDO);
        this.logService.saveNewLog(customerDO.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Customer.getDesc());
        if (StringUtils.hasText((String)payload.getFrom()) && payload.getFrom().equals(VisitTaskPlanTypeEnum.sell_visit_plan.getCode())) {
            Long visitTaskId = payload.getVisitTaskId();
            if (ObjectUtils.isEmpty((Object)visitTaskId)) {
                throw TwException.error((String)"", (String)"visitTaskId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            VisitTaskPayload visitTaskPayload = new VisitTaskPayload();
            visitTaskPayload.setId(visitTaskId);
            visitTaskPayload.setStatus(VisitTaskStatusEnum.OK.getCode());
            visitTaskPayload.setCustomerId(customerDO.getId());
            this.visitTaskService.update(visitTaskPayload);
        }
        return CrmCustomerConvert.INSTANCE.toVo(customerDO);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Long update(CrmCustomerPayload payload) {
        PrdAbVO abVO = this.dao.queryAbVOBykey(payload.getId());
        if (payload.getUpdateType() == 0) {
            PrdAbOrCompanyPayload companyPayload = CrmCustomerConvert.INSTANCE.toPayload(payload);
            companyPayload.setId(abVO.getId());
            companyPayload.setCompanyName(payload.getCustomerName());
            this.abService.updateAbOrCompany(companyPayload);
            this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Customer.getDesc());
        } else {
            this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.UPDATE_MANAGE.getDesc());
        }
        this.dao.updateByKeyDynamic(payload);
        return 0L;
    }

    public Long getBookIdByCustomerId(Long customerId) {
        PrdAbVO abVO = this.dao.queryAbVOBykey(customerId);
        if (null != abVO) {
            return abVO.getId();
        }
        log.error("\u6570\u636e\u5f02\u5e38\uff0c\u5ba2\u6237\u5bf9\u5e94\u5730\u5740\u7c3f\u6570\u636e\u4e0d\u5b58\u5728\uff1b\u5ba2\u6237\u4e3b\u952e\uff1a{}", (Object)customerId);
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Long updateProvinceCityDistrict(CrmCustomerPayload payload) {
        PrdAbVO abVO = this.dao.queryAbVOBykey(payload.getId());
        PrdAbOrCompanyPayload companyPayload = CrmCustomerConvert.INSTANCE.toPayload(payload);
        companyPayload.setId(abVO.getId());
        this.abDAO.setProvinceCityDistrictForCompany(companyPayload);
        this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Customer.getDesc());
        return 0L;
    }

    public void operPermissionFlag(CrmCustomerQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        Boolean marketAdminUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
        Boolean marketUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
        Boolean saleAdminUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
        Boolean saleUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode()));
        query.setCreateUserId(userId);
        if (saleUserIdsByRole.booleanValue() || saleAdminUserIdsByRole.booleanValue()) {
            query.setFilterType("sales");
        } else if (marketAdminUserIdsByRole.booleanValue() || marketUserIdsByRole.booleanValue()) {
            query.setFilterType("market");
            query.setCustomerGrades(Arrays.asList("important", "normal"));
        }
        if (marketAdminUserIdsByRole.booleanValue()) {
            List marketUserIdsByRole0 = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
            query.setCreateUserIds(marketUserIdsByRole0);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateLongitudeLatitude() {
        List<PrdOrgCompanyVO> prdOrgCompanyVOS = this.dao.queryCompanys();
        if (!ObjectUtils.isEmpty(prdOrgCompanyVOS)) {
            for (PrdOrgCompanyVO vo : prdOrgCompanyVOS) {
                String addressByLocation = this.geodesyUtil.getLongitudeAndLatitudeByAddress(vo.getCompanyAddress());
                this.dao.updateCompany(vo.getId(), addressByLocation);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void updata(PrdOrgCompanyVO vo) {
        String addressByLocation = this.geodesyUtil.getAddressByLocation(vo.getCompanyAddress());
        this.dao.updateCompany(vo.getId(), addressByLocation);
    }

    public PagingVO<CrmCustomerVO> paging(CrmCustomerQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode()));
        if (!rolePermission.booleanValue()) {
            this.operPermissionFlag(query);
        }
        PagingVO<CrmCustomerVO> customerVOPagingVO = this.dao.queryPaging(query);
        List crmCustomerVOS = customerVOPagingVO.getRecords();
        ArrayList<Long> userIds = new ArrayList<Long>();
        crmCustomerVOS.forEach(crmCustomerVO -> this.getUserIds((List<Long>)userIds, (CrmCustomerVO)crmCustomerVO));
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap employeeMap = new HashMap();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        crmCustomerVOS.forEach(crmCustomerVO -> this.transferCustomerDatas(employeeMap, (CrmCustomerVO)crmCustomerVO, query.getFilterType()));
        return customerVOPagingVO;
    }

    public CrmCustomerVO queryDetail(Long key) {
        CrmCustomerVO crmCustomerVO = this.dao.queryDetail(key);
        ArrayList<Long> userIds = new ArrayList<Long>();
        this.getUserIds(userIds, crmCustomerVO);
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap<Long, String> employeeMap = new HashMap<Long, String>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        this.transferCustomerDatas(employeeMap, crmCustomerVO, null);
        CrmCustomerOperationVO customerOperationVO = this.customerOperationDAO.queryCrmCustomerOperationVOByCustomerId(key);
        crmCustomerVO.setCustomerOperationVO(customerOperationVO);
        return crmCustomerVO;
    }

    public CrmCustomerVO queryDetailByBookId(Long bookId) {
        CrmCustomerVO crmCustomerVO = this.dao.queryDetailByBookId(bookId);
        ArrayList<Long> userIds = new ArrayList<Long>();
        this.getUserIds(userIds, crmCustomerVO);
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap<Long, String> employeeMap = new HashMap<Long, String>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        this.transferCustomerDatas(employeeMap, crmCustomerVO, null);
        return crmCustomerVO;
    }

    public List<CrmCustomerDataVO> queryList() {
        List<CrmCustomerDataVO> crmCustomerDataVOS = this.dao.queryList();
        crmCustomerDataVOS.forEach(vo -> vo.setCompanyIndustryName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCompanyIndustry())));
        return this.dao.queryList();
    }

    public boolean deleteSoft(List<Long> keys) {
        return false;
    }

    @Transactional
    public boolean updateStatus(Long key, String status) {
        PrdAbVO abVO = this.dao.queryAbVOBykey(key);
        this.dao.updateStatus(key, status);
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Customer.getCode(), this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Customer.getDesc());
        return true;
    }

    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Customer.getCode());
        return this.logService.pageLog(query);
    }

    void getUserIds(List<Long> userIds, CrmCustomerVO vo) {
        HashSet<Long> users = new HashSet<Long>();
        users.add(vo.getCreateUserId());
        users.add(vo.getServiceUserId());
        users.add(vo.getBusinessUserId());
        users.add(vo.getCareUserId());
        users.add(vo.getOperationUserId());
        userIds.addAll(users);
    }

    void transferCustomerDatas(Map<Long, String> employeeMap, CrmCustomerVO vo, String filterType) {
        vo.setCreateUserName(employeeMap.get(vo.getCreateUserId()));
        vo.setServiceUserName(employeeMap.get(vo.getServiceUserId()));
        vo.setBusinessUserName(employeeMap.get(vo.getBusinessUserId()));
        vo.setCareUserName(employeeMap.get(vo.getCareUserId()));
        vo.setOperationUserName(employeeMap.get(vo.getOperationUserId()));
        vo.setCustomerStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getCustomerStatus()));
        vo.setCustomerGradeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), vo.getCustomerGrade()));
        vo.setCustomerSourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerSource.getCode(), vo.getCustomerSource()));
        vo.setCompanyIndustryName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCompanyIndustry()));
        vo.setCompanyScaleName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerScale.getCode(), vo.getCompanyScale()));
        vo.setCurrencyName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrency()));
        vo.setLanguageName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemLANGUAGE.getCode(), vo.getLanguage()));
        vo.setCompanyNatureName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustProp.getCode(), vo.getCompanyNature()));
        if (filterType != null) {
            if (filterType.equals("market")) {
                vo.setCustomerGradeEditFlag(Boolean.valueOf(false));
            } else {
                vo.setCustomerGradeEditFlag(Boolean.valueOf(true));
            }
        }
    }

    public void downloadBatch(HttpServletResponse response, CrmCustomerQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmCustomerBatch.xlsx");
        PagingVO<CrmCustomerVO> paging = this.paging(query);
        List records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u5ba2\u6237\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)records) && batchProjectSheet != null) {
                int nextRow = 1;
                for (CrmCustomerVO dataPayload : records) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, (Object)nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, (Object)dataPayload.getBookNo());
                    this.excelUtil.setCellValue((Row)row, 2, (Object)dataPayload.getCustomerName());
                    this.excelUtil.setCellValue((Row)row, 3, (Object)dataPayload.getCustomerStatusName());
                    this.excelUtil.setCellValue((Row)row, 4, (Object)dataPayload.getCustomerGradeName());
                    this.excelUtil.setCellValue((Row)row, 5, (Object)dataPayload.getCustomerSourceName());
                    this.excelUtil.setCellValue((Row)row, 6, (Object)dataPayload.getCompanyIndustryName());
                    this.excelUtil.setCellValue((Row)row, 7, (Object)dataPayload.getCompanyPhone());
                    this.excelUtil.setCellValue((Row)row, 8, (Object)dataPayload.getCompanyEmail());
                    this.excelUtil.setCellValue((Row)row, 9, (Object)dataPayload.getCompanyFax());
                    this.excelUtil.setCellValue((Row)row, 10, (Object)dataPayload.getProvinceName());
                    this.excelUtil.setCellValue((Row)row, 11, (Object)dataPayload.getCityName());
                    this.excelUtil.setCellValue((Row)row, 12, (Object)dataPayload.getDistrictName());
                    this.excelUtil.setCellValue((Row)row, 13, (Object)dataPayload.getCompanyAddress());
                    this.excelUtil.setCellValue((Row)row, 14, (Object)dataPayload.getCompanyWebsite());
                    this.excelUtil.setCellValue((Row)row, 15, (Object)dataPayload.getCompanyScaleName());
                    this.excelUtil.setCellValue((Row)row, 16, (Object)dataPayload.getTaxNo());
                    this.excelUtil.setCellValue((Row)row, 17, (Object)dataPayload.getCurrencyName());
                    this.excelUtil.setCellValue((Row)row, 18, (Object)dataPayload.getLanguageName());
                    this.excelUtil.setCellValue((Row)row, 19, (Object)dataPayload.getCompanyNatureName());
                    this.excelUtil.setCellValue((Row)row, 20, (Object)dataPayload.getServiceUserName());
                    this.excelUtil.setCellValue((Row)row, 21, (Object)dataPayload.getBusinessUserName());
                    this.excelUtil.setCellValue((Row)row, 22, (Object)dataPayload.getCareUserName());
                    this.excelUtil.setCellValue((Row)row, 23, (Object)dataPayload.getOperationUserName());
                    this.excelUtil.setCellValue((Row)row, 24, (Object)dataPayload.getCreateUserName());
                    ++nextRow;
                }
            }
            String fileName = "\u5ba2\u6237\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse((HttpServletResponse)response, (String)fileName, (Workbook)workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<CrmFollowVO> queryFollowList(Long customerId, Boolean withAcitityFollows) {
        List<Long> activiyProjIds;
        List<Long> actIds;
        ArrayList<Object> followVOS = new ArrayList<Object>();
        List<Long> leadIds = this.leadsDAO.queryByFormalCustomerId(customerId);
        List<Long> oppoIds = this.opportunityDAO.queryByFormalCustomerId(customerId);
        List<CrmFollowDO> leadsFollowDos = this.followDAO.queryByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
        followVOS.addAll(this.followService.toListVo(CrmFollowObjectEnum.Leads, leadsFollowDos));
        List<CrmFollowDO> oppoFollowDos = this.followDAO.queryByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
        followVOS.addAll(this.followService.toListVo(CrmFollowObjectEnum.Opportunity, oppoFollowDos));
        if (withAcitityFollows != null && withAcitityFollows.booleanValue() && (actIds = this.actActivityDAO.queryByIds(activiyProjIds = this.actActivityDAO.queryByLeadsIds(leadIds))) != null && !actIds.isEmpty()) {
            ArrayList<CrmFollowVO> activityFollowVOS = new ArrayList<CrmFollowVO>();
            List<CrmActDynamicVO> dynamicVOS = this.actActivityDAO.queryActDynamicByPrjIds(actIds);
            for (CrmActDynamicVO dynamicVO : dynamicVOS) {
                CrmFollowVO followVO = new CrmFollowVO();
                followVO.setCreateTime(dynamicVO.getCreateTime());
                followVO.setCreateUserId(dynamicVO.getCreateUserId());
                followVO.setCreateUserName(dynamicVO.getEmployeeName());
                followVO.setFollowContent(dynamicVO.getDynamicContent());
                followVO.setFollowObject("activity");
                followVO.setFollowObjectDesc("\u5e02\u573a\u6d3b\u52a8");
                followVO.setFollowType(dynamicVO.getDynamicType());
                followVO.setFollowTypeDesc(dynamicVO.getDynamicTypeName());
                followVO.setId(dynamicVO.getId());
                followVO.setModifyTime(dynamicVO.getModifyTime());
                followVO.setModifyUserId(dynamicVO.getModifyUserId());
                activityFollowVOS.add(followVO);
            }
            followVOS.addAll(activityFollowVOS);
        }
        List<CrmFollowVO> collect = followVOS.stream().sorted((u1, u2) -> u1.getCreateTime().compareTo(u2.getCreateTime())).collect(Collectors.toList());
        return collect;
    }

    @Transactional
    public void changeCustomerGrade(Long customerId, String grade) {
        this.dao.updateCustomerGrade(customerId, grade);
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setFormalCustomerId(customerId);
        Specification<CrmLeadsDO> spec = this.leadsDAO.getSpec(leadsQuery);
        List<CrmLeadsDO> leadsDOS = this.leadsDAO.findAll(spec);
        List<Long> leadsIds = leadsDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        this.leadsDAO.updateCustomerGrade(leadsIds, grade);
        List collect = leadsDOS.stream().filter(e -> e.getPotentialCustomerId() != null).collect(Collectors.toList());
        List<Long> potentialCustomerIds = collect.stream().map(e -> e.getPotentialCustomerId()).collect(Collectors.toList());
        this.potentialCustomerDAO.updateCustomerGrade(potentialCustomerIds, grade);
    }

    public int checkCustNameUnique(String custName) {
        return this.repo.countByCustomerNameAndDeleteFlag(custName, 0);
    }

    public String queryCompanyAddress(Long key) {
        CrmCustomerVO crmCustomerVO = this.dao.queryDetail(key);
        return crmCustomerVO.getCompanyAddress();
    }

    public CrmCustomerSimpleVO querySimpleByKey(Long id) {
        CrmCustomerVO crmCustomerVO = this.dao.queryDetail(id);
        Assert.notNull((Object)crmCustomerVO, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        return CrmCustomerConvert.INSTANCE.voToSimple(crmCustomerVO);
    }

    public List<CrmCustomerDataVO> queryCustomer() {
        List<CrmCustomerDataVO> crmCustomerDataVOS = this.dao.queryList();
        return crmCustomerDataVOS;
    }

    public CrmCustomerServiceImpl(CacheUtil cacheUtil, CrmCustomerDAO dao, CrmCustomerOperationDAO customerOperationDAO, PrdAbService abService, PrdAbDAO abDAO, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, ExcelUtil excelUtil, CrmLeadsDAO leadsDAO, CrmOpportunityDAO opportunityDAO, CrmFollowDAO followDAO, CrmFollowServiceImpl followService, PrdSystemRoleDAO systemRoleDAO, CrmPotentialCustomerDAO potentialCustomerDAO, CrmActActivityDAO actActivityDAO, CrmCustomerRepo repo, TaskExecutor taskExecutor, GeodesyUtil geodesyUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.customerOperationDAO = customerOperationDAO;
        this.abService = abService;
        this.abDAO = abDAO;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.excelUtil = excelUtil;
        this.leadsDAO = leadsDAO;
        this.opportunityDAO = opportunityDAO;
        this.followDAO = followDAO;
        this.followService = followService;
        this.systemRoleDAO = systemRoleDAO;
        this.potentialCustomerDAO = potentialCustomerDAO;
        this.actActivityDAO = actActivityDAO;
        this.repo = repo;
        this.taskExecutor = taskExecutor;
        this.geodesyUtil = geodesyUtil;
    }
}

