/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractSignPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractSignQuery;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSignVO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractSignDO;
import com.elitesland.tw.tw5crm.server.contract.entity.QContractSignDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractSignRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ContractSignDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ContractSignRepo repo;
    private final QContractSignDO qdo = QContractSignDO.contractSignDO;

    private JPAQuery<ContractSignVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ContractSignVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.contractId, this.qdo.contractName, this.qdo.customerId, this.qdo.customerName, this.qdo.signcompanyId, this.qdo.signcompanyName, this.qdo.currency, this.qdo.contractAmount, this.qdo.signType, this.qdo.signDate, this.qdo.logisticsCompany, this.qdo.logisticsNumber, this.qdo.filecodes})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ContractSignVO> getJpaQueryWhere(ContractSignQuery query) {
        JPAQuery<ContractSignVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(ContractSignQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ContractSignQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getContractId()) {
            list.add(this.qdo.contractId.eq((Object)query.getContractId()));
        }
        if (null != query.getCustomerId()) {
            list.add(this.qdo.customerId.eq((Object)query.getCustomerId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ContractSignVO queryByKey(Long id) {
        JPAQuery<ContractSignVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ContractSignVO)jpaQuery.fetchFirst();
    }

    public List<ContractSignVO> queryListDynamic(ContractSignQuery query) {
        JPAQuery<ContractSignVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ContractSignVO> queryPaging(ContractSignQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ContractSignVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ContractSignDO save(ContractSignDO ado) {
        return (ContractSignDO)this.repo.save(ado);
    }

    public List<ContractSignDO> saveAll(List<ContractSignDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ContractSignPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        List nullFields = payload.getNullFields();
        if (nullFields == null || nullFields.size() > 0) {
            // empty if block
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public ContractSignDAO(JPAQueryFactory jpaQueryFactory, ContractSignRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

