/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdFsmFileRefPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitesland.tw.tw5crm.api.partner.business.payload.BusinessCustomerOperationPlanDetailPayload;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationPlanDetailMemberQuery;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationPlanDetailQuery;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationPlanDetailMemberService;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationPlanDetailService;
import com.elitesland.tw.tw5crm.api.partner.business.vo.BusinessCustomerOperationPlanDetailVO;
import com.elitesland.tw.tw5crm.server.partner.business.convert.BusinessCustomerOperationPlanDetailConvert;
import com.elitesland.tw.tw5crm.server.partner.business.dao.BusinessCustomerOperationPlanDetailDAO;
import com.elitesland.tw.tw5crm.server.partner.business.entity.BusinessCustomerOperationPlanDetailDO;
import com.elitesland.tw.tw5crm.server.partner.business.repo.BusinessCustomerOperationPlanDetailRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessCustomerOperationPlanDetailServiceImpl
extends BaseServiceImpl
implements BusinessCustomerOperationPlanDetailService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerOperationPlanDetailServiceImpl.class);
    private final BusinessCustomerOperationPlanDetailRepo businessCustomerOperationPlanDetailRepo;
    private final BusinessCustomerOperationPlanDetailDAO businessCustomerOperationPlanDetailDAO;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final BusinessCustomerOperationPlanDetailMemberService customerOperationPlanDetailMemberService;
    private final PrdSystemLogService logService;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final BusinessCustomerOperationPlanDetailMemberService planDetailMemberService;
    private final BookContactsService bookContactsService;

    public PagingVO<BusinessCustomerOperationPlanDetailVO> queryPaging(BusinessCustomerOperationPlanDetailQuery query) {
        return this.businessCustomerOperationPlanDetailDAO.queryPaging(query);
    }

    public PagingVO<BusinessCustomerOperationPlanDetailVO> queryPagingPro(BusinessCustomerOperationPlanDetailQuery query) {
        PagingVO<BusinessCustomerOperationPlanDetailVO> paging = this.businessCustomerOperationPlanDetailDAO.queryPaging(query);
        paging.getRecords().forEach(vo -> {
            this.translation((BusinessCustomerOperationPlanDetailVO)vo);
            vo.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.BUSINESS_OPER_PLAN.getCode(), vo.getId())));
            vo.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.BUSINESS_OPER_PLAN.getCode(), vo.getId())));
            BusinessCustomerOperationPlanDetailMemberQuery memberQuery = new BusinessCustomerOperationPlanDetailMemberQuery();
            memberQuery.setPlanDetailId(vo.getId());
            List memberList = this.planDetailMemberService.queryListDynamic(memberQuery);
            vo.setMemberList(memberList);
        });
        return paging;
    }

    public List<BusinessCustomerOperationPlanDetailVO> queryListDynamic(BusinessCustomerOperationPlanDetailQuery query) {
        List<BusinessCustomerOperationPlanDetailVO> businessCustomerOperationPlanDetailVOS = this.businessCustomerOperationPlanDetailDAO.queryListDynamic(query);
        businessCustomerOperationPlanDetailVOS.forEach(vo -> this.translation((BusinessCustomerOperationPlanDetailVO)vo));
        return businessCustomerOperationPlanDetailVOS;
    }

    public BusinessCustomerOperationPlanDetailVO queryByKey(Long key) {
        BusinessCustomerOperationPlanDetailDO entity = this.businessCustomerOperationPlanDetailRepo.findById(key).orElseGet(BusinessCustomerOperationPlanDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationPlanDetailVO vo = BusinessCustomerOperationPlanDetailConvert.INSTANCE.toVo(entity);
        this.translation(vo);
        return vo;
    }

    private void translation(BusinessCustomerOperationPlanDetailVO vo) {
        if (StringUtils.hasText((String)vo.getExt1())) {
            String[] split = vo.getExt1().split(",");
            ArrayList<String> contractNames = new ArrayList<String>();
            for (String s : split) {
                BookContactsVO bookContactsVO = this.bookContactsService.queryByKey(Long.valueOf(s));
                contractNames.add(bookContactsVO.getContactsName());
            }
            vo.setExt1Desc(contractNames.stream().collect(Collectors.joining(",")));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationPlanDetailVO insert(BusinessCustomerOperationPlanDetailPayload payload) {
        List memberList;
        if (null == payload.getReadFlag()) {
            payload.setReadFlag(Integer.valueOf(0));
        }
        BusinessCustomerOperationPlanDetailDO entityDo = BusinessCustomerOperationPlanDetailConvert.INSTANCE.toDo(payload);
        BusinessCustomerOperationPlanDetailDO save = (BusinessCustomerOperationPlanDetailDO)this.businessCustomerOperationPlanDetailRepo.save(entityDo);
        long id = save.getId();
        if (StringUtils.hasText((String)payload.getFileCodes())) {
            for (String fileCode : payload.getFileCodes().split(",")) {
                PrdFsmFileRefPayload fsmFileRefPayload = new PrdFsmFileRefPayload();
                fsmFileRefPayload.setFileCode(fileCode);
                fsmFileRefPayload.setObjId(Long.valueOf(id));
                fsmFileRefPayload.setObjType(PrdCommentObjTypeEnum.OPER_PLAN_MAIN.getCode());
                this.prdFsmFileRefService.insert(fsmFileRefPayload);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(memberList = payload.getMemberList()))) {
            memberList.stream().filter(member -> member.getUserId() != null).forEach(member -> {
                member.setPartnerId(save.getPartnerId());
                member.setBookId(save.getBookId());
                member.setPlanDetailId(Long.valueOf(id));
                this.customerOperationPlanDetailMemberService.insert(member);
            });
        }
        this.logService.saveNewLog(entityDo.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
        return BusinessCustomerOperationPlanDetailConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerOperationPlanDetailVO update(BusinessCustomerOperationPlanDetailPayload payload) {
        BusinessCustomerOperationPlanDetailDO entity = this.businessCustomerOperationPlanDetailRepo.findById(payload.getId()).orElseGet(BusinessCustomerOperationPlanDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerOperationPlanDetailDO entityLog = new BusinessCustomerOperationPlanDetailDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessCustomerOperationPlanDetailDO entityDo = BusinessCustomerOperationPlanDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        BusinessCustomerOperationPlanDetailDO save = (BusinessCustomerOperationPlanDetailDO)this.businessCustomerOperationPlanDetailRepo.save(entity);
        this.logService.saveNewLog(entityDo.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), fieldsUpdateLog.toString());
        }
        return BusinessCustomerOperationPlanDetailConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            AtomicReference partnerId = new AtomicReference();
            keys.stream().forEach(id -> {
                Optional optional = this.businessCustomerOperationPlanDetailRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessCustomerOperationPlanDetailDO entity = (BusinessCustomerOperationPlanDetailDO)optional.get();
                    partnerId.set(entity.getPartnerId());
                    entity.setDeleteFlag(1);
                    this.businessCustomerOperationPlanDetailRepo.save(entity);
                }
            });
            this.customerOperationPlanDetailMemberService.deleteSoftByPlanDetailIds(keys);
            this.logService.saveNewLog((Long)partnerId.get(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.BUSINESS_CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
        }
    }

    public void saveAll(List<BusinessCustomerOperationPlanDetailPayload> planDetailDOS) {
        List<BusinessCustomerOperationPlanDetailDO> list = BusinessCustomerOperationPlanDetailConvert.INSTANCE.toDoList(planDetailDOS);
        this.businessCustomerOperationPlanDetailRepo.saveAll(list);
    }

    public Long count(BusinessCustomerOperationPlanDetailQuery query) {
        return this.businessCustomerOperationPlanDetailDAO.count(query);
    }

    private void sendQwxMessage(BusinessCustomerOperationPlanDetailPayload payload) {
        if (null != payload.getPerformerId()) {
            String loginUserName = GlobalUtil.getLoginUserName();
            String planName = payload.getPlanName();
            this.qyWxCommunicationService.sendMessageToUser(payload.getPerformerId(), loginUserName + "\u5728\u201c" + planName + "\u201d\u5c06\u4f60\u8bbe\u4e3a\u6267\u884c\u8005");
        }
    }

    public BusinessCustomerOperationPlanDetailServiceImpl(BusinessCustomerOperationPlanDetailRepo businessCustomerOperationPlanDetailRepo, BusinessCustomerOperationPlanDetailDAO businessCustomerOperationPlanDetailDAO, PrdCommentService prdCommentService, PrdFsmFileRefService prdFsmFileRefService, BusinessCustomerOperationPlanDetailMemberService customerOperationPlanDetailMemberService, PrdSystemLogService logService, QyWxCommunicationService qyWxCommunicationService, ChangeFieldLogUtil changeFieldLogUtil, BusinessCustomerOperationPlanDetailMemberService planDetailMemberService, BookContactsService bookContactsService) {
        this.businessCustomerOperationPlanDetailRepo = businessCustomerOperationPlanDetailRepo;
        this.businessCustomerOperationPlanDetailDAO = businessCustomerOperationPlanDetailDAO;
        this.prdCommentService = prdCommentService;
        this.prdFsmFileRefService = prdFsmFileRefService;
        this.customerOperationPlanDetailMemberService = customerOperationPlanDetailMemberService;
        this.logService = logService;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.planDetailMemberService = planDetailMemberService;
        this.bookContactsService = bookContactsService;
    }
}

