/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5crm.api.product.service.ProductSkuService;
import com.elitesland.tw.tw5crm.api.product.service.ProductSpuService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSkuVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSpuVO;
import com.elitesland.tw.tw5crm.api.sale.payload.ExamInformationPayload;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleGoalPayload;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleTargetPayload;
import com.elitesland.tw.tw5crm.api.sale.query.ExamInformationQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleGoalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.service.ExamInformationService;
import com.elitesland.tw.tw5crm.api.sale.service.SaleGoalService;
import com.elitesland.tw.tw5crm.api.sale.service.SaleTargetService;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleGoalVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetDualRateVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetDualVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetStatisticalVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetVO;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetExamTargetEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetSaleGoalTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetStatisticalEnum;
import com.elitesland.tw.tw5crm.server.sale.convert.ExamInformationConvert;
import com.elitesland.tw.tw5crm.server.sale.convert.SaleGoalConvert;
import com.elitesland.tw.tw5crm.server.sale.convert.SaleTargetConvert;
import com.elitesland.tw.tw5crm.server.sale.dao.SaleGoalDAO;
import com.elitesland.tw.tw5crm.server.sale.entity.ExamInformationDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.repo.ExamInformationRepo;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleGoalRepo;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleTargetRepo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class SaleGoalServiceImpl
extends BaseServiceImpl
implements SaleGoalService {
    private static final Logger log = LoggerFactory.getLogger(SaleGoalServiceImpl.class);
    private final SaleGoalRepo saleGoalRepo;
    private final SaleGoalDAO saleGoalDAO;
    private final ExamInformationService examInformationService;
    private final SaleTargetRepo saleTargetRepo;
    private final SaleTargetService saleTargetService;
    private final ExamInformationRepo examInformationRepo;
    private final CacheUtil cacheUtil;
    private final ProductSpuService productSpuService;
    private final ProductSkuService productSkuService;
    private final CrmCustomerService crmCustomerService;
    private final BusinessPartnerService businessPartnerService;

    public SaleTargetStatisticalVO saleTargetStatistical(SaleTargetStatisticalQuery query) {
        SaleTargetStatisticalVO result = new SaleTargetStatisticalVO();
        Long goalId = query.getGoalId();
        ArrayList<SaleTargetDualVO> resultList = new ArrayList<SaleTargetDualVO>();
        if (null == goalId) {
            throw TwException.error((String)"", (String)"goalId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleGoalDO entity = this.saleGoalRepo.findById(goalId).orElseGet(SaleGoalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728");
        Integer fiscalYear = entity.getFiscalYear();
        if (query.getStartTime() == null) {
            query.setStartTime(LocalDateTime.of((int)fiscalYear, 1, 1, 0, 0, 0));
        }
        if (query.getEndTime() == null) {
            query.setEndTime(LocalDateTime.of((int)fiscalYear, 12, 31, 23, 59, 59));
        }
        List<SaleTargetVO> saleTargetVOList = this.saleGoalDAO.countSaleTarget(goalId, "true", query.getOrgId(), query.getUserId(), query.getCustIndustry(), query.getCustomerGrade());
        if (null == query.getUserId()) {
            Set userIds = saleTargetVOList.stream().map(saleTargetVO -> saleTargetVO.getDutyId()).collect(Collectors.toSet());
            query.setUserIds(userIds);
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        saleTargetVOList.forEach(saleTargetVO -> {
            SaleTargetDualVO saleTargetDualVO = new SaleTargetDualVO();
            saleTargetDualVO.setType(SaleTargetStatisticalEnum.TARGET.getDesc());
            if (query.getSearchType().equals(SaleTargetStatisticalEnum.MONTH.getCode())) {
                SaleGoalServiceImpl.monthDataConversion(map, saleTargetVO);
            } else if (query.getSearchType().equals(SaleTargetStatisticalEnum.QUARTER.getCode())) {
                SaleGoalServiceImpl.quarterDataConversion(map, saleTargetVO);
            }
        });
        for (Map.Entry next : map.entrySet()) {
            resultList.add(new SaleTargetDualVO((String)next.getKey(), (BigDecimal)next.getValue(), SaleTargetStatisticalEnum.TARGET.getDesc()));
        }
        Set userIdSet = saleTargetVOList.stream().map(saleTargetVO -> saleTargetVO.getDutyId()).collect(Collectors.toSet());
        query.setUserIds(userIdSet);
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOList = this.examInformationService.queryListDynamic(examInformationQuery);
        query.setExamInformationVOList(examInformationVOList);
        String goalType = entity.getGoalType();
        String examTarget = entity.getExamTarget();
        List<Object> saleTargetDualVOS = new ArrayList();
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_VISIT.getCode())) {
                saleTargetDualVOS = this.saleGoalDAO.countVisitTaskByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CLUE.getCode())) {
                saleTargetDualVOS = this.saleGoalDAO.countLeadsByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_BUSINESS.getCode())) {
                saleTargetDualVOS = this.saleGoalDAO.countOppoByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CONTRACT.getCode())) {
                // empty if block
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CUSTOMER.getCode())) {
                saleTargetDualVOS = this.saleGoalDAO.countCustomerByExamInformation(query);
            }
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
            if (examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_SALE.getCode())) {
                // empty if block
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_CONTRACT.getCode())) {
                // empty if block
            }
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_VISIT.getCode())) {
                saleTargetDualVOS = this.saleGoalDAO.countVisitTaskByExamInformation(query);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_CONTRACT.getCode())) {
                // empty if block
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_PAYMENT.getCode())) {
                // empty if block
            }
        }
        this.visitDataProcess(resultList, map, saleTargetDualVOS);
        result.setSaleTargetDualVOList(resultList);
        ArrayList saleTargetDualRateVOList = new ArrayList();
        resultList.stream().map(saleTargetDualVO -> saleTargetDualVO.getTime()).distinct().forEach(time -> {
            AtomicReference<BigDecimal> targetValue = new AtomicReference<BigDecimal>(BigDecimal.ONE);
            AtomicReference<BigDecimal> actualValue = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            resultList.forEach(saleTargetDualVO -> {
                String voTime = saleTargetDualVO.getTime();
                if (voTime.equals(time) && saleTargetDualVO.getType().equals(SaleTargetStatisticalEnum.TARGET.getDesc()) && saleTargetDualVO.getValue().compareTo(BigDecimal.ZERO) != 0) {
                    targetValue.set(saleTargetDualVO.getValue());
                }
                if (voTime.equals(time) && saleTargetDualVO.getType().equals(SaleTargetStatisticalEnum.COMPLETE.getDesc())) {
                    actualValue.set(saleTargetDualVO.getValue());
                }
            });
            BigDecimal rate = actualValue.get().divide(targetValue.get(), 4, RoundingMode.HALF_UP);
            saleTargetDualRateVOList.add(new SaleTargetDualRateVO(time, rate));
        });
        result.setSaleTargetDualRateVOList(saleTargetDualRateVOList);
        return result;
    }

    private void visitDataProcess(List<SaleTargetDualVO> resultList, Map<String, BigDecimal> map, List<SaleTargetDualVO> saleTargetDualVOS) {
        for (Map.Entry<String, BigDecimal> next : map.entrySet()) {
            String time = next.getKey();
            SaleTargetDualVO actual = new SaleTargetDualVO(time, BigDecimal.ZERO, SaleTargetStatisticalEnum.COMPLETE.getDesc());
            saleTargetDualVOS.forEach(saleTargetDualVO -> {
                if (saleTargetDualVO.getTime().equals(time)) {
                    actual.setValueLong(saleTargetDualVO.getValueLong());
                }
            });
            resultList.add(actual);
        }
    }

    public static void quarterDataConversion(Map<String, BigDecimal> map, SaleTargetVO saleTargetVO) {
        String suffix = "";
        BigDecimal firstQuarter = map.get("1" + suffix);
        firstQuarter = firstQuarter == null ? BigDecimal.ZERO : firstQuarter;
        map.put("1" + suffix, firstQuarter.add(saleTargetVO.getFirstQuarter()));
        BigDecimal secondQuarter = map.get("2" + suffix);
        secondQuarter = secondQuarter == null ? BigDecimal.ZERO : secondQuarter;
        map.put("2" + suffix, secondQuarter.add(saleTargetVO.getSecondQuarter()));
        BigDecimal thirdQuarter = map.get("3" + suffix);
        thirdQuarter = thirdQuarter == null ? BigDecimal.ZERO : thirdQuarter;
        map.put("3" + suffix, thirdQuarter.add(saleTargetVO.getThirdQuarter()));
        BigDecimal forthQuarter = map.get("4" + suffix);
        forthQuarter = forthQuarter == null ? BigDecimal.ZERO : forthQuarter;
        map.put("4" + suffix, forthQuarter.add(saleTargetVO.getForthQuarter()));
    }

    public static void monthDataConversion(Map<String, BigDecimal> map, SaleTargetVO saleTargetVO) {
        BigDecimal january = map.get("01\u6708");
        january = january == null ? BigDecimal.ZERO : january;
        map.put("01\u6708", january.add(saleTargetVO.getJanuary()));
        BigDecimal february = map.get("02\u6708");
        february = february == null ? BigDecimal.ZERO : february;
        map.put("02\u6708", february.add(saleTargetVO.getFebruary()));
        BigDecimal march = map.get("03\u6708");
        march = march == null ? BigDecimal.ZERO : march;
        map.put("03\u6708", march.add(saleTargetVO.getMarch()));
        BigDecimal april = map.get("04\u6708");
        april = april == null ? BigDecimal.ZERO : april;
        map.put("04\u6708", april.add(saleTargetVO.getApril()));
        BigDecimal may = map.get("05\u6708");
        may = may == null ? BigDecimal.ZERO : may;
        map.put("05\u6708", may.add(saleTargetVO.getMay()));
        BigDecimal june = map.get("06\u6708");
        june = june == null ? BigDecimal.ZERO : june;
        map.put("06\u6708", june.add(saleTargetVO.getJune()));
        BigDecimal july = map.get("07\u6708");
        july = july == null ? BigDecimal.ZERO : july;
        map.put("07\u6708", july.add(saleTargetVO.getJuly()));
        BigDecimal august = map.get("08\u6708");
        august = august == null ? BigDecimal.ZERO : august;
        map.put("08\u6708", august.add(saleTargetVO.getAugust()));
        BigDecimal september = map.get("09\u6708");
        september = september == null ? BigDecimal.ZERO : september;
        map.put("09\u6708", september.add(saleTargetVO.getSeptember()));
        BigDecimal october = map.get("10\u6708");
        october = october == null ? BigDecimal.ZERO : october;
        map.put("10\u6708", october.add(saleTargetVO.getOctober()));
        BigDecimal november = map.get("11\u6708");
        november = november == null ? BigDecimal.ZERO : november;
        map.put("11\u6708", november.add(saleTargetVO.getNovember()));
        BigDecimal december = map.get("12\u6708");
        december = december == null ? BigDecimal.ZERO : december;
        map.put("12\u6708", december.add(saleTargetVO.getDecember()));
    }

    public PagingVO<SaleGoalVO> queryPaging(SaleGoalQuery query) {
        this.dataPermissionFlag(query);
        PagingVO<SaleGoalVO> goalVOPagingVO = this.saleGoalDAO.queryPaging(query);
        List records = goalVOPagingVO.getRecords();
        records.forEach(saleGoalVO -> {
            this.getExamInformationList((SaleGoalVO)saleGoalVO, true);
            this.translate((SaleGoalVO)saleGoalVO);
        });
        return goalVOPagingVO;
    }

    void dataPermissionFlag(SaleGoalQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long userId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(userId);
        }
    }

    private void translate(SaleGoalVO saleGoalVO) {
        String goalType = saleGoalVO.getGoalType();
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
            saleGoalVO.setExamTargetDesc(this.cacheUtil.transferSystemSelection(SaleTargetSaleGoalTypeEnum.USER.getCode(), saleGoalVO.getExamTarget()));
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
            saleGoalVO.setExamTargetDesc(this.cacheUtil.transferSystemSelection(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode(), saleGoalVO.getExamTarget()));
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
            saleGoalVO.setExamTargetDesc(this.cacheUtil.transferSystemSelection(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode(), saleGoalVO.getExamTarget()));
        }
    }

    private void getSaleTargetList(SaleGoalVO saleGoalVO) {
        SaleTargetQuery saleTargetQuery = new SaleTargetQuery();
        saleTargetQuery.setGoalId(saleGoalVO.getId());
        List saleTargetVOS = this.saleTargetService.queryList(saleTargetQuery);
        saleGoalVO.setSaleTargetVOList(saleTargetVOS);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getExamInformationList(SaleGoalVO saleGoalVO, boolean isPaging) {
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        Long goalId = saleGoalVO.getId();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOS = this.examInformationService.queryListDynamic(examInformationQuery);
        if (isPaging) {
            String goalType = saleGoalVO.getGoalType();
            String examTarget = saleGoalVO.getExamTarget();
            HashSet<Long> userIds = new HashSet<Long>();
            userIds.add(111222L);
            List<SaleTargetVO> saleTargetVOList = this.saleGoalDAO.countSaleTarget(saleGoalVO.getId(), "true", null, null, null, null);
            Set userIdsTarget = saleTargetVOList.stream().map(saleTargetVO -> saleTargetVO.getDutyId()).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(userIdsTarget)) {
                userIds = userIdsTarget;
            }
            Integer fiscalYear = saleGoalVO.getFiscalYear();
            LocalDateTime startTime = LocalDateTime.of((int)fiscalYear, 1, 1, 0, 0, 0);
            LocalDateTime endTime = LocalDateTime.of((int)fiscalYear, 12, 31, 23, 59, 59);
            if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_VISIT.getCode())) {
                    long visitCount = this.saleGoalDAO.countVisitByExamInformation(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(new BigDecimal(visitCount));
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_CLUE.getCode())) {
                    long count = this.saleGoalDAO.countLeadsByExamInformationForPaging(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(new BigDecimal(count));
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_BUSINESS.getCode())) {
                    BigDecimal sum = this.saleGoalDAO.countOppoByExamInformationForPaging(userIds, examInformationVOS, startTime, endTime);
                    saleGoalVO.setActualCount(sum);
                }
                if (examTarget.equals(SaleTargetExamTargetEnum.USER_CONTRACT.getCode())) {
                    // empty if block
                }
                if (!examTarget.equals(SaleTargetExamTargetEnum.USER_CUSTOMER.getCode())) return;
                long count = this.saleGoalDAO.countCustomerByExamInformationForPaging(userIds, examInformationVOS, startTime, endTime);
                saleGoalVO.setActualCount(new BigDecimal(count));
                return;
            }
            if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
                if (examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_SALE.getCode())) {
                    // empty if block
                }
                if (!examTarget.equals(SaleTargetExamTargetEnum.PRODUCT_CONTRACT.getCode())) return;
                return;
            }
            if (!goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) return;
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_VISIT.getCode())) {
                long visitCount = this.saleGoalDAO.countVisitByExamInformation(userIds, examInformationVOS, startTime, endTime);
                saleGoalVO.setActualCount(new BigDecimal(visitCount));
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_CONTRACT.getCode())) {
                // empty if block
            }
            if (!examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_PAYMENT.getCode())) return;
            return;
        } else {
            this.translate(examInformationVOS, saleGoalVO);
            saleGoalVO.setExamInformationVOList(examInformationVOS);
        }
    }

    private void translate(List<ExamInformationVO> examInformationVOS, SaleGoalVO saleGoalVO) {
        if (null != saleGoalVO && !CollectionUtils.isEmpty(examInformationVOS)) {
            String goalType = saleGoalVO.getGoalType();
            examInformationVOS.forEach(examInformationVO -> {
                PrdSystemSelectionVO prdSystemSelectionVO;
                if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
                    prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.USER.getCode(), examInformationVO.getExamTarget());
                    key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationVO.setExamTargetDesc(desc);
                    examInformationVO.setFieldKeyDesc(this.cacheUtil.transferSystemSelection(key, examInformationVO.getFieldKey()));
                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
                    prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode(), examInformationVO.getExamTarget());
                    key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationVO.setExamTargetDesc(desc);
                    examInformationVO.setFieldKeyDesc(this.cacheUtil.transferSystemSelection(key, examInformationVO.getFieldKey()));
                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
                    prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode(), examInformationVO.getExamTarget());
                    key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    desc = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionValue() : "";
                    examInformationVO.setExamTargetDesc(desc);
                    examInformationVO.setFieldKeyDesc(this.cacheUtil.transferSystemSelection(key, examInformationVO.getFieldKey()));
                }
                if (ObjectUtils.isEmpty((Object)examInformationVO.getExt1()) && null != (prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj("crm:rule_map", examInformationVO.getFieldKey()))) {
                    String udcKey = prdSystemSelectionVO.getExtString2();
                    examInformationVO.setSettingKey(udcKey);
                    examInformationVO.setSettingName(prdSystemSelectionVO.getSelectionName());
                    if (StringUtils.hasText((String)udcKey)) {
                        String searchCondition = examInformationVO.getSearchCondition();
                        if (StringUtils.hasText((String)searchCondition)) {
                            String[] values = searchCondition.split(",");
                            ArrayList<String> udcNames = new ArrayList<String>();
                            for (String value : values) {
                                udcNames.add(this.cacheUtil.transferSystemSelection(udcKey, value));
                            }
                            String udcNamesStr = udcNames.stream().collect(Collectors.joining(","));
                            examInformationVO.setExt1(udcNamesStr);
                        } else {
                            log.warn("\u503c\u4e0d\u5b58\u5728");
                        }
                    } else {
                        log.warn("\u89c4\u683c\u6620\u5c04\u914d\u7f6e\u6709\u95ee\u9898\uff1bexamInformationDO.getFieldKey()\uff1a{}", (Object)examInformationVO.getFieldKey());
                    }
                }
            });
        }
    }

    public List<SaleGoalVO> queryListDynamic(SaleGoalQuery query) {
        return this.saleGoalDAO.queryListDynamic(query);
    }

    public SaleGoalVO queryByKey(Long key) {
        SaleGoalDO entity = this.saleGoalRepo.findById(key).orElseGet(SaleGoalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SaleGoalVO vo = SaleGoalConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        this.getExamInformationList(vo, false);
        this.getSaleTargetList(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleGoalVO insert(SaleGoalPayload payload) {
        SaleGoalDO saleGoalDO = SaleGoalConvert.INSTANCE.toDo(payload);
        SaleGoalDO save = (SaleGoalDO)this.saleGoalRepo.save(saleGoalDO);
        this.saveExamData(payload, saleGoalDO);
        this.saveTargetData(payload, saleGoalDO);
        return SaleGoalConvert.INSTANCE.toVo(save);
    }

    void saveTargetData(SaleGoalPayload payload, SaleGoalDO saleGoalDO) {
        Long goalId = saleGoalDO.getId();
        this.saleTargetService.deleteSoftByGoalId(goalId);
        List saleTargetPayloads = payload.getSaleTargetList();
        if (!ObjectUtils.isEmpty((Object)saleTargetPayloads)) {
            ArrayList<SaleTargetDO> saleTargetDOS = new ArrayList<SaleTargetDO>();
            ArrayList<SaleTargetDO> saleTargetDOSOneLevel = new ArrayList<SaleTargetDO>();
            saleTargetPayloads.forEach(saleTargetPayload -> {
                SaleTargetDO saleTargetDO = SaleTargetConvert.INSTANCE.toDo((SaleTargetPayload)saleTargetPayload);
                Long skuId = saleTargetDO.getSkuId();
                if (skuId != null) {
                    ProductSkuVO productSkuVO = this.productSkuService.queryByKey(skuId);
                    saleTargetDO.setSkuName(productSkuVO.getSkuName());
                    Long spuId = productSkuVO.getSpuId();
                    saleTargetDO.setSpuId(spuId);
                    ProductSpuVO productSpuVO = this.productSpuService.queryByKey(spuId);
                    saleTargetDO.setSpuName(productSpuVO.getSpuName());
                }
                if (saleTargetDO.getPartnerId() != null) {
                    BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(saleTargetDO.getPartnerId());
                    saleTargetDO.setCustomerName(businessPartnerVO.getPartnerName());
                    saleTargetDO.setCustomerId(saleTargetDO.getPartnerId());
                } else {
                    Long customerId = saleTargetDO.getCustomerId();
                    if (customerId != null) {
                        CrmCustomerSimpleVO crmCustomerSimpleVO = this.crmCustomerService.querySimpleByKey(customerId);
                        saleTargetDO.setCustomerName(crmCustomerSimpleVO.getCustomerName());
                    }
                }
                saleTargetDO.setGoalId(saleGoalDO.getId());
                saleTargetDO.setFiscalYear(saleGoalDO.getFiscalYear());
                saleTargetDO.setGoalType(saleGoalDO.getGoalType());
                saleTargetDO.setFirstQuarter(saleTargetDO.getJanuary().add(saleTargetDO.getFebruary().add(saleTargetDO.getMarch())));
                saleTargetDO.setSecondQuarter(saleTargetDO.getApril().add(saleTargetDO.getMay().add(saleTargetDO.getJune())));
                saleTargetDO.setThirdQuarter(saleTargetDO.getJuly().add(saleTargetDO.getAugust().add(saleTargetDO.getSeptember())));
                saleTargetDO.setForthQuarter(saleTargetDO.getOctober().add(saleTargetDO.getNovember().add(saleTargetDO.getDecember())));
                if (saleTargetPayload.getId().equals(0L) || saleTargetPayload.getParentId() == null) {
                    saleTargetDOSOneLevel.add(saleTargetDO);
                } else {
                    saleTargetDOS.add(saleTargetDO);
                }
            });
            this.cascadeSave(saleTargetDOS, saleTargetDOSOneLevel, 0L);
        }
    }

    private void cascadeSave(List<SaleTargetDO> saleTargetDOS, List<SaleTargetDO> saleTargetDOSOneLevel, Long parentDbId) {
        saleTargetDOSOneLevel.forEach(parent -> {
            if (parentDbId.equals(0L)) {
                parent.setParentId(null);
            } else {
                parent.setParentId(parentDbId);
            }
            SaleTargetDO save = (SaleTargetDO)this.saleTargetRepo.save(parent);
            Long parentId = save.getId();
            List<SaleTargetDO> childrenList = saleTargetDOS.stream().filter(saleTargetDO -> saleTargetDO.getParentId().equals(parent.getId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(childrenList)) {
                this.cascadeSave(saleTargetDOS, childrenList, parentId);
            }
        });
    }

    void saveExamData(SaleGoalPayload payload, SaleGoalDO saleGoalDO) {
        Long goalId = saleGoalDO.getId();
        String goalType = saleGoalDO.getGoalType();
        this.examInformationService.deleteSoftByGoalId(goalId);
        List examInformationPayloads = payload.getExamInformationList();
        if (!ObjectUtils.isEmpty((Object)examInformationPayloads)) {
            ArrayList examInformationDOS = new ArrayList();
            examInformationPayloads.forEach(examInformationPayload -> {
                PrdSystemSelectionVO prdSystemSelectionVO;
                ExamInformationDO examInformationDO = ExamInformationConvert.INSTANCE.toDo((ExamInformationPayload)examInformationPayload);
                examInformationDO.setGoalId(goalId);
                examInformationDO.setExamTarget(saleGoalDO.getExamTarget());
                if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
                    prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.USER.getCode(), examInformationDO.getExamTarget());
                    key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    examInformationDO.setFieldName(this.cacheUtil.transferSystemSelection(key, examInformationDO.getFieldKey()));
                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
                    prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode(), examInformationDO.getExamTarget());
                    key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    examInformationDO.setFieldName(this.cacheUtil.transferSystemSelection(key, examInformationDO.getFieldKey()));
                } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
                    prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode(), examInformationDO.getExamTarget());
                    key = null != prdSystemSelectionVO ? prdSystemSelectionVO.getSelectionKey() : "";
                    examInformationDO.setFieldName(this.cacheUtil.transferSystemSelection(key, examInformationDO.getFieldKey()));
                }
                prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj("crm:rule_map", examInformationDO.getFieldKey());
                if (null != prdSystemSelectionVO) {
                    String udcKey = prdSystemSelectionVO.getExtString2();
                    examInformationDO.setSettingKey(udcKey);
                    examInformationDO.setSettingName(prdSystemSelectionVO.getSelectionName());
                    if (StringUtils.hasText((String)udcKey)) {
                        String searchCondition = examInformationDO.getSearchCondition();
                        if (StringUtils.hasText((String)searchCondition)) {
                            String[] values = searchCondition.split(",");
                            ArrayList<String> udcNames = new ArrayList<String>();
                            for (String value : values) {
                                udcNames.add(this.cacheUtil.transferSystemSelection(udcKey, value));
                            }
                            String udcNamesStr = udcNames.stream().collect(Collectors.joining(","));
                            examInformationDO.setExt1(udcNamesStr);
                        } else {
                            log.warn("\u503c\u4e0d\u5b58\u5728");
                        }
                    } else {
                        log.warn("\u89c4\u683c\u6620\u5c04\u914d\u7f6e\u6709\u95ee\u9898\uff1bexamInformationDO.getFieldKey()\uff1a{}", (Object)examInformationDO.getFieldKey());
                    }
                }
                examInformationDOS.add(examInformationDO);
            });
            this.examInformationRepo.saveAll(examInformationDOS);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleGoalVO update(SaleGoalPayload payload) {
        SaleGoalVO saleGoalVO;
        SaleGoalDO entity = this.saleGoalRepo.findById(payload.getId()).orElseGet(SaleGoalDO::new);
        if (payload.getId() == null) {
            throw TwException.error((String)"1", (String)"\u9500\u552e\u76ee\u6807id\u4e0d\u5b58\u5728");
        }
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        Long userId = GlobalUtil.getLoginUserId();
        if (!rolePermission.booleanValue() && !userId.equals((saleGoalVO = this.saleGoalDAO.queryByKey(payload.getId())).getCreateUserId())) {
            throw TwException.error((String)"1", (String)"\u53ea\u6709\u521b\u5efa\u4eba\u53ef\u4ee5\u4fee\u6539\uff0c\u5f53\u524d\u767b\u9646\u7528\u6237\u4e0d\u662f\u521b\u5efa\u4eba");
        }
        SaleGoalDO entityDo = SaleGoalConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        SaleGoalDO saleGoalDO = (SaleGoalDO)this.saleGoalRepo.save(entity);
        this.saveTargetData(payload, saleGoalDO);
        this.saveExamData(payload, saleGoalDO);
        return SaleGoalConvert.INSTANCE.toVo(saleGoalDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.saleGoalRepo.findById(id);
                if (!optional.isEmpty()) {
                    SaleGoalDO entity = (SaleGoalDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.saleGoalRepo.save(entity);
                }
            });
        }
    }

    public SaleGoalServiceImpl(SaleGoalRepo saleGoalRepo, SaleGoalDAO saleGoalDAO, ExamInformationService examInformationService, SaleTargetRepo saleTargetRepo, SaleTargetService saleTargetService, ExamInformationRepo examInformationRepo, CacheUtil cacheUtil, ProductSpuService productSpuService, ProductSkuService productSkuService, CrmCustomerService crmCustomerService, BusinessPartnerService businessPartnerService) {
        this.saleGoalRepo = saleGoalRepo;
        this.saleGoalDAO = saleGoalDAO;
        this.examInformationService = examInformationService;
        this.saleTargetRepo = saleTargetRepo;
        this.saleTargetService = saleTargetService;
        this.examInformationRepo = examInformationRepo;
        this.cacheUtil = cacheUtil;
        this.productSpuService = productSpuService;
        this.productSkuService = productSkuService;
        this.crmCustomerService = crmCustomerService;
        this.businessPartnerService = businessPartnerService;
    }
}

